using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class XamarinAndroidNugetPackagesModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public ISource<List<XamarinAndroidProjectWithReferences>> NugetPackagesUpdated { get { return _NugetPackagesUpdated; }}
    
    //private fields
    [NotNull] private readonly RdSignal<List<XamarinAndroidProjectWithReferences>> _NugetPackagesUpdated;
    
    //primary constructor
    private XamarinAndroidNugetPackagesModel(
      [NotNull] RdSignal<List<XamarinAndroidProjectWithReferences>> nugetPackagesUpdated
    )
    {
      if (nugetPackagesUpdated == null) throw new ArgumentNullException("nugetPackagesUpdated");
      
      _NugetPackagesUpdated = nugetPackagesUpdated;
      _NugetPackagesUpdated.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("nugetPackagesUpdated", _NugetPackagesUpdated));
    }
    //secondary constructor
    internal XamarinAndroidNugetPackagesModel (
    ) : this (
      new RdSignal<List<XamarinAndroidProjectWithReferences>>(ReadXamarinAndroidProjectWithReferencesList, WriteXamarinAndroidProjectWithReferencesList)
    ) {}
    //statics
    
    public static CtxReadDelegate<List<XamarinAndroidProjectWithReferences>> ReadXamarinAndroidProjectWithReferencesList = XamarinAndroidProjectWithReferences.Read.List();
    
    public static CtxWriteDelegate<List<XamarinAndroidProjectWithReferences>> WriteXamarinAndroidProjectWithReferencesList = XamarinAndroidProjectWithReferences.Write.List();
    
    protected override long SerializationHash => -8143297334703234207L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(XamarinAndroidProjectWithReferences.Read, XamarinAndroidProjectWithReferences.Write);
      serializers.Register(XamarinAndroidReferenceModel.Read, XamarinAndroidReferenceModel.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinAndroidNugetPackagesModel (");
      using (printer.IndentCookie()) {
        printer.Print("nugetPackagesUpdated = "); _NugetPackagesUpdated.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionXamarinAndroidNugetPackagesModelEx
   {
    public static XamarinAndroidNugetPackagesModel GetXamarinAndroidNugetPackagesModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("xamarinAndroidNugetPackagesModel", () => new XamarinAndroidNugetPackagesModel());
    }
  }
  
  
  public class XamarinAndroidProjectWithReferences : IPrintable, IEquatable<XamarinAndroidProjectWithReferences>
  {
    //fields
    //public fields
    [NotNull] public string ProjectName {get; private set;}
    [NotNull] public string ProjectPath {get; private set;}
    [NotNull] public List<XamarinAndroidReferenceModel> XamarinPackageReferences {get; private set;}
    
    //private fields
    //primary constructor
    public XamarinAndroidProjectWithReferences(
      [NotNull] string projectName,
      [NotNull] string projectPath,
      [NotNull] List<XamarinAndroidReferenceModel> xamarinPackageReferences
    )
    {
      if (projectName == null) throw new ArgumentNullException("projectName");
      if (projectPath == null) throw new ArgumentNullException("projectPath");
      if (xamarinPackageReferences == null) throw new ArgumentNullException("xamarinPackageReferences");
      
      ProjectName = projectName;
      ProjectPath = projectPath;
      XamarinPackageReferences = xamarinPackageReferences;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<XamarinAndroidProjectWithReferences> Read = (ctx, reader) => 
    {
      var projectName = reader.ReadString();
      var projectPath = reader.ReadString();
      var xamarinPackageReferences = ReadXamarinAndroidReferenceModelList(ctx, reader);
      return new XamarinAndroidProjectWithReferences(projectName, projectPath, xamarinPackageReferences);
    };
    public static CtxReadDelegate<List<XamarinAndroidReferenceModel>> ReadXamarinAndroidReferenceModelList = XamarinAndroidReferenceModel.Read.List();
    
    public static CtxWriteDelegate<XamarinAndroidProjectWithReferences> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectName);
      writer.Write(value.ProjectPath);
      WriteXamarinAndroidReferenceModelList(ctx, writer, value.XamarinPackageReferences);
    };
    public static CtxWriteDelegate<List<XamarinAndroidReferenceModel>> WriteXamarinAndroidReferenceModelList = XamarinAndroidReferenceModel.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinAndroidProjectWithReferences) obj);
    }
    public bool Equals(XamarinAndroidProjectWithReferences other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectName == other.ProjectName && ProjectPath == other.ProjectPath && XamarinPackageReferences.SequenceEqual(other.XamarinPackageReferences);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectName.GetHashCode();
        hash = hash * 31 + ProjectPath.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(XamarinPackageReferences);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinAndroidProjectWithReferences (");
      using (printer.IndentCookie()) {
        printer.Print("projectName = "); ProjectName.PrintEx(printer); printer.Println();
        printer.Print("projectPath = "); ProjectPath.PrintEx(printer); printer.Println();
        printer.Print("xamarinPackageReferences = "); XamarinPackageReferences.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamarinAndroidReferenceModel : IPrintable, IEquatable<XamarinAndroidReferenceModel>
  {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Version {get; private set;}
    
    //private fields
    //primary constructor
    public XamarinAndroidReferenceModel(
      [NotNull] string id,
      [NotNull] string version
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (version == null) throw new ArgumentNullException("version");
      
      Id = id;
      Version = version;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<XamarinAndroidReferenceModel> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var version = reader.ReadString();
      return new XamarinAndroidReferenceModel(id, version);
    };
    
    public static CtxWriteDelegate<XamarinAndroidReferenceModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Version);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamarinAndroidReferenceModel) obj);
    }
    public bool Equals(XamarinAndroidReferenceModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Version == other.Version;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Version.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinAndroidReferenceModel (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("version = "); Version.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
