using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class XamarinSettingsHostModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> AndroidSdkPath { get { return _AndroidSdkPath; }}
    [NotNull] public IRdProperty<string> AndroidNdkPath { get { return _AndroidNdkPath; }}
    [NotNull] public IRdProperty<string> JavaDevelopmentKitPath { get { return _JavaDevelopmentKitPath; }}
    [NotNull] public IRdProperty<bool> AndroidPreserveDataCacheBetweenDeploys { get { return _AndroidPreserveDataCacheBetweenDeploys; }}
    [NotNull] public IRdProperty<bool> IOSAlwaysSuggestUpdateCodesignKey { get { return _IOSAlwaysSuggestUpdateCodesignKey; }}
    [NotNull] public IRdProperty<string> XcodePath { get { return _XcodePath; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _AndroidSdkPath;
    [NotNull] private readonly RdProperty<string> _AndroidNdkPath;
    [NotNull] private readonly RdProperty<string> _JavaDevelopmentKitPath;
    [NotNull] private readonly RdProperty<bool> _AndroidPreserveDataCacheBetweenDeploys;
    [NotNull] private readonly RdProperty<bool> _IOSAlwaysSuggestUpdateCodesignKey;
    [NotNull] private readonly RdProperty<string> _XcodePath;
    
    //primary constructor
    private XamarinSettingsHostModel(
      [NotNull] RdProperty<string> androidSdkPath,
      [NotNull] RdProperty<string> androidNdkPath,
      [NotNull] RdProperty<string> javaDevelopmentKitPath,
      [NotNull] RdProperty<bool> androidPreserveDataCacheBetweenDeploys,
      [NotNull] RdProperty<bool> iOSAlwaysSuggestUpdateCodesignKey,
      [NotNull] RdProperty<string> xcodePath
    )
    {
      if (androidSdkPath == null) throw new ArgumentNullException("androidSdkPath");
      if (androidNdkPath == null) throw new ArgumentNullException("androidNdkPath");
      if (javaDevelopmentKitPath == null) throw new ArgumentNullException("javaDevelopmentKitPath");
      if (androidPreserveDataCacheBetweenDeploys == null) throw new ArgumentNullException("androidPreserveDataCacheBetweenDeploys");
      if (iOSAlwaysSuggestUpdateCodesignKey == null) throw new ArgumentNullException("iOSAlwaysSuggestUpdateCodesignKey");
      if (xcodePath == null) throw new ArgumentNullException("xcodePath");
      
      _AndroidSdkPath = androidSdkPath;
      _AndroidNdkPath = androidNdkPath;
      _JavaDevelopmentKitPath = javaDevelopmentKitPath;
      _AndroidPreserveDataCacheBetweenDeploys = androidPreserveDataCacheBetweenDeploys;
      _IOSAlwaysSuggestUpdateCodesignKey = iOSAlwaysSuggestUpdateCodesignKey;
      _XcodePath = xcodePath;
      _AndroidSdkPath.OptimizeNested = true;
      _AndroidNdkPath.OptimizeNested = true;
      _JavaDevelopmentKitPath.OptimizeNested = true;
      _AndroidPreserveDataCacheBetweenDeploys.OptimizeNested = true;
      _IOSAlwaysSuggestUpdateCodesignKey.OptimizeNested = true;
      _XcodePath.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("androidSdkPath", _AndroidSdkPath));
      BindableChildren.Add(new KeyValuePair<string, object>("androidNdkPath", _AndroidNdkPath));
      BindableChildren.Add(new KeyValuePair<string, object>("javaDevelopmentKitPath", _JavaDevelopmentKitPath));
      BindableChildren.Add(new KeyValuePair<string, object>("androidPreserveDataCacheBetweenDeploys", _AndroidPreserveDataCacheBetweenDeploys));
      BindableChildren.Add(new KeyValuePair<string, object>("iOSAlwaysSuggestUpdateCodesignKey", _IOSAlwaysSuggestUpdateCodesignKey));
      BindableChildren.Add(new KeyValuePair<string, object>("xcodePath", _XcodePath));
    }
    //secondary constructor
    private XamarinSettingsHostModel (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 5206659679430363505L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public XamarinSettingsHostModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("XamarinSettingsHostModel (");
      using (printer.IndentCookie()) {
        printer.Print("androidSdkPath = "); _AndroidSdkPath.PrintEx(printer); printer.Println();
        printer.Print("androidNdkPath = "); _AndroidNdkPath.PrintEx(printer); printer.Println();
        printer.Print("javaDevelopmentKitPath = "); _JavaDevelopmentKitPath.PrintEx(printer); printer.Println();
        printer.Print("androidPreserveDataCacheBetweenDeploys = "); _AndroidPreserveDataCacheBetweenDeploys.PrintEx(printer); printer.Println();
        printer.Print("iOSAlwaysSuggestUpdateCodesignKey = "); _IOSAlwaysSuggestUpdateCodesignKey.PrintEx(printer); printer.Println();
        printer.Print("xcodePath = "); _XcodePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
