using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class XdtModel : RdExtBase
  {
    //fields
    //public fields
    [NotNull] public RdEndpoint<AddXdtTransformationCommand, ProjectModelTaskResult> AddXdtTransformation { get { return _AddXdtTransformation; }}
    [NotNull] public RdEndpoint<PreviewXdtTransformationCommand, XdtTransformationResult> PreviewXdtTransformation { get { return _PreviewXdtTransformation; }}
    [NotNull] public RdEndpoint<PerformXdtTransformationCommand, RdVoid> PerformXdtTransformation { get { return _PerformXdtTransformation; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<AddXdtTransformationCommand, ProjectModelTaskResult> _AddXdtTransformation;
    [NotNull] private readonly RdEndpoint<PreviewXdtTransformationCommand, XdtTransformationResult> _PreviewXdtTransformation;
    [NotNull] private readonly RdEndpoint<PerformXdtTransformationCommand, RdVoid> _PerformXdtTransformation;
    
    //primary constructor
    private XdtModel(
      [NotNull] RdEndpoint<AddXdtTransformationCommand, ProjectModelTaskResult> addXdtTransformation,
      [NotNull] RdEndpoint<PreviewXdtTransformationCommand, XdtTransformationResult> previewXdtTransformation,
      [NotNull] RdEndpoint<PerformXdtTransformationCommand, RdVoid> performXdtTransformation
    )
    {
      if (addXdtTransformation == null) throw new ArgumentNullException("addXdtTransformation");
      if (previewXdtTransformation == null) throw new ArgumentNullException("previewXdtTransformation");
      if (performXdtTransformation == null) throw new ArgumentNullException("performXdtTransformation");
      
      _AddXdtTransformation = addXdtTransformation;
      _PreviewXdtTransformation = previewXdtTransformation;
      _PerformXdtTransformation = performXdtTransformation;
      BindableChildren.Add(new KeyValuePair<string, object>("addXdtTransformation", _AddXdtTransformation));
      BindableChildren.Add(new KeyValuePair<string, object>("previewXdtTransformation", _PreviewXdtTransformation));
      BindableChildren.Add(new KeyValuePair<string, object>("performXdtTransformation", _PerformXdtTransformation));
    }
    //secondary constructor
    internal XdtModel (
    ) : this (
      new RdEndpoint<AddXdtTransformationCommand, ProjectModelTaskResult>(AddXdtTransformationCommand.Read, AddXdtTransformationCommand.Write, ProjectModelTaskResult.Read, ProjectModelTaskResult.Write),
      new RdEndpoint<PreviewXdtTransformationCommand, XdtTransformationResult>(PreviewXdtTransformationCommand.Read, PreviewXdtTransformationCommand.Write, XdtTransformationResult.Read, XdtTransformationResult.Write),
      new RdEndpoint<PerformXdtTransformationCommand, RdVoid>(PerformXdtTransformationCommand.Read, PerformXdtTransformationCommand.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 7300082707093107276L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(AddXdtTransformationCommand.Read, AddXdtTransformationCommand.Write);
      serializers.Register(PreviewXdtTransformationCommand.Read, PreviewXdtTransformationCommand.Write);
      serializers.Register(PerformXdtTransformationCommand.Read, PerformXdtTransformationCommand.Write);
      serializers.Register(XdtTransformationResult.Read, XdtTransformationResult.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("XdtModel (");
      using (printer.IndentCookie()) {
        printer.Print("addXdtTransformation = "); _AddXdtTransformation.PrintEx(printer); printer.Println();
        printer.Print("previewXdtTransformation = "); _PreviewXdtTransformation.PrintEx(printer); printer.Println();
        printer.Print("performXdtTransformation = "); _PerformXdtTransformation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionXdtModelEx
   {
    public static XdtModel GetXdtModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("xdtModel", () => new XdtModel());
    }
  }
  
  
  public class AddXdtTransformationCommand : IPrintable, IEquatable<AddXdtTransformationCommand>
  {
    //fields
    //public fields
    public int ConfigurationItemId {get; private set;}
    [NotNull] public string ItemName {get; private set;}
    [NotNull] public string Configuration {get; private set;}
    public bool MakeDependentUpon {get; private set;}
    
    //private fields
    //primary constructor
    public AddXdtTransformationCommand(
      int configurationItemId,
      [NotNull] string itemName,
      [NotNull] string configuration,
      bool makeDependentUpon
    )
    {
      if (itemName == null) throw new ArgumentNullException("itemName");
      if (configuration == null) throw new ArgumentNullException("configuration");
      
      ConfigurationItemId = configurationItemId;
      ItemName = itemName;
      Configuration = configuration;
      MakeDependentUpon = makeDependentUpon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AddXdtTransformationCommand> Read = (ctx, reader) => 
    {
      var configurationItemId = reader.ReadInt();
      var itemName = reader.ReadString();
      var configuration = reader.ReadString();
      var makeDependentUpon = reader.ReadBool();
      return new AddXdtTransformationCommand(configurationItemId, itemName, configuration, makeDependentUpon);
    };
    
    public static CtxWriteDelegate<AddXdtTransformationCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ConfigurationItemId);
      writer.Write(value.ItemName);
      writer.Write(value.Configuration);
      writer.Write(value.MakeDependentUpon);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddXdtTransformationCommand) obj);
    }
    public bool Equals(AddXdtTransformationCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ConfigurationItemId == other.ConfigurationItemId && ItemName == other.ItemName && Configuration == other.Configuration && MakeDependentUpon == other.MakeDependentUpon;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ConfigurationItemId.GetHashCode();
        hash = hash * 31 + ItemName.GetHashCode();
        hash = hash * 31 + Configuration.GetHashCode();
        hash = hash * 31 + MakeDependentUpon.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddXdtTransformationCommand (");
      using (printer.IndentCookie()) {
        printer.Print("configurationItemId = "); ConfigurationItemId.PrintEx(printer); printer.Println();
        printer.Print("itemName = "); ItemName.PrintEx(printer); printer.Println();
        printer.Print("configuration = "); Configuration.PrintEx(printer); printer.Println();
        printer.Print("makeDependentUpon = "); MakeDependentUpon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PerformXdtTransformationCommand : IPrintable, IEquatable<PerformXdtTransformationCommand>
  {
    //fields
    //public fields
    public int ConfigurationItemId {get; private set;}
    public int TransformItemId {get; private set;}
    
    //private fields
    //primary constructor
    public PerformXdtTransformationCommand(
      int configurationItemId,
      int transformItemId
    )
    {
      ConfigurationItemId = configurationItemId;
      TransformItemId = transformItemId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PerformXdtTransformationCommand> Read = (ctx, reader) => 
    {
      var configurationItemId = reader.ReadInt();
      var transformItemId = reader.ReadInt();
      return new PerformXdtTransformationCommand(configurationItemId, transformItemId);
    };
    
    public static CtxWriteDelegate<PerformXdtTransformationCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ConfigurationItemId);
      writer.Write(value.TransformItemId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((PerformXdtTransformationCommand) obj);
    }
    public bool Equals(PerformXdtTransformationCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ConfigurationItemId == other.ConfigurationItemId && TransformItemId == other.TransformItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ConfigurationItemId.GetHashCode();
        hash = hash * 31 + TransformItemId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("PerformXdtTransformationCommand (");
      using (printer.IndentCookie()) {
        printer.Print("configurationItemId = "); ConfigurationItemId.PrintEx(printer); printer.Println();
        printer.Print("transformItemId = "); TransformItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PreviewXdtTransformationCommand : IPrintable, IEquatable<PreviewXdtTransformationCommand>
  {
    //fields
    //public fields
    public int ConfigurationItemId {get; private set;}
    public int TransformItemId {get; private set;}
    
    //private fields
    //primary constructor
    public PreviewXdtTransformationCommand(
      int configurationItemId,
      int transformItemId
    )
    {
      ConfigurationItemId = configurationItemId;
      TransformItemId = transformItemId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PreviewXdtTransformationCommand> Read = (ctx, reader) => 
    {
      var configurationItemId = reader.ReadInt();
      var transformItemId = reader.ReadInt();
      return new PreviewXdtTransformationCommand(configurationItemId, transformItemId);
    };
    
    public static CtxWriteDelegate<PreviewXdtTransformationCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ConfigurationItemId);
      writer.Write(value.TransformItemId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((PreviewXdtTransformationCommand) obj);
    }
    public bool Equals(PreviewXdtTransformationCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ConfigurationItemId == other.ConfigurationItemId && TransformItemId == other.TransformItemId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ConfigurationItemId.GetHashCode();
        hash = hash * 31 + TransformItemId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("PreviewXdtTransformationCommand (");
      using (printer.IndentCookie()) {
        printer.Print("configurationItemId = "); ConfigurationItemId.PrintEx(printer); printer.Println();
        printer.Print("transformItemId = "); TransformItemId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XdtTransformationResult : IPrintable, IEquatable<XdtTransformationResult>
  {
    //fields
    //public fields
    [NotNull] public string Contents {get; private set;}
    
    //private fields
    //primary constructor
    public XdtTransformationResult(
      [NotNull] string contents
    )
    {
      if (contents == null) throw new ArgumentNullException("contents");
      
      Contents = contents;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<XdtTransformationResult> Read = (ctx, reader) => 
    {
      var contents = reader.ReadString();
      return new XdtTransformationResult(contents);
    };
    
    public static CtxWriteDelegate<XdtTransformationResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Contents);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XdtTransformationResult) obj);
    }
    public bool Equals(XdtTransformationResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Contents == other.Contents;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Contents.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XdtTransformationResult (");
      using (printer.IndentCookie()) {
        printer.Print("contents = "); Contents.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
