import gdb


def is_safe_thread(name):
    danger_threads_markers = ["SGen worker", "Debugger agent", "UsageDbManager", "Finalizer"]
    for m in danger_threads_markers:
        if name.find(m) >= 0:
            return False
    return True


def call_with_escaping(command):
    print("##### Execute command: |{0}|".format(command))
    return gdb.execute(command, to_string=True).replace("\n", "\\n").replace("\"", "\\\"").replace("`", "\\`")


print("##### Start thread dump creation")
gdb.execute("handle SIGXCPU SIG33 SIG35 SIG36 SIGPWR nostop noprint")
gdb.execute("call fprintf(stdout, \"\\nStart thread dump from debugger ====>\\n\")")

info_threads = call_with_escaping("info threads")
gdb.execute("call fprintf(stdout, \"Threads summary info:\\n" + info_threads + "-----------------------\\n\")")

ucp = str(gdb.parse_and_eval("malloc (sizeof (ucontext_t))"))
for i in gdb.inferiors():
    for t in i.threads():
        tid = str(t.num)
        tname = str(t.name)
        thandle = str(t)
        if is_safe_thread(tname):
            gdb.execute("thread " + tid)
            try:
                cmd = "call fprintf(stdout, \"##### Thread #" + tid + ": " + tname + " handle: " + thandle + "\\n\")"
                gdb.execute(cmd)
                native_stack = call_with_escaping("bt")
                gdb.execute("call fprintf(stdout, \"\\nNative stack:\\n" + native_stack + "\")")
                gdb.execute("call fprintf(stdout, \"\\nManaged stack:\")")
                thread_ptr = gdb.parse_and_eval("mono_thread_internal_current()")
                if thread_ptr != 0:
                    gdb.parse_and_eval("getcontext({0})".format(ucp))
                    gdb.parse_and_eval("mono_print_thread_dump({0})".format(ucp))
                else:
                    gdb.execute("call fprintf(stdout, \"No mono thread associated with this thread\\n\")")
            except Exception as e:
                print("##### Problem when dumping thread Id:" + tid + ", Name:" + tname + "\nProblem text:" + e)
gdb.parse_and_eval("free({0})".format(ucp))
gdb.execute("call fprintf(stdout, \"\\n<==== Finish thread dump from debugger\\n\")")
gdb.execute("call fflush(stdout)")
print("##### Managed thread dump into file backend-out.log finished")
