import lldb


def call_with_escaping(command):
    print("##### Execute command: |{0}|".format(command))
    return_obj = lldb.SBCommandReturnObject()
    lldb.debugger.GetCommandInterpreter().HandleCommand(command, return_obj)
    if return_obj.Succeeded():
        return str(return_obj.GetOutput()).replace("\n", "\\n").replace("\"", "\\\"").replace("`", "\\`")
    else:
        print("##### Command execution error: " + str(return_obj))


def is_safe_thread(thread, name):
    danger_threads_markers = ["SGen worker", "Debugger agent", "UsageDbManager", "Finalizer"]
    for m in danger_threads_markers:
        if name.find(m) >= 0:
            return False
    return True


# noinspection PyUnusedLocal
def __lldb_init_module(debugger, internal_dict):
    print("##### Start thread dump creation")
    call_with_escaping("process handle -p false -s false SIGXCPU")
    call_with_escaping("process handle -p false -s false SIGCONT")
    call_with_escaping("expr (void)fflush(0)")
    call_with_escaping("expr (void)printf(\"\\nStart thread dump from debugger ====>\\n\")")
    info_threads = call_with_escaping("thread list")
    call_with_escaping("expr (void)printf(\"Threads summary info:\\n" + info_threads + "-----------------------\\n\")")
    # Value 56 it is sizeof (ucontext_t) from mono
    call_with_escaping("expr void* $ucp=(void*)malloc(56)")
    tcount = debugger.GetSelectedTarget().GetProcess().GetNumThreads()
    for i in range(1, tcount + 1):
        call_with_escaping("thread select {0}".format(i))
        thread = debugger.GetSelectedTarget().GetProcess().GetSelectedThread()
        tid = str(thread.GetThreadID())
        tname = thread.GetName()
        if not tname:
            continue
        if is_safe_thread(thread, tname):
            call_with_escaping("expr (void)printf(\"\\n##### Thread #" + tid + ": " + tname + "\\n\")")
            native_stack = call_with_escaping("bt")
            call_with_escaping("expr (void)printf(\"\\nNative stack:\\n" + native_stack + "\")")
            call_with_escaping("expr (void)printf(\"\\nManaged stack:\")")
            call_with_escaping("expr (void)getcontext($ucp)")
            call_with_escaping("expr (void)mono_print_thread_dump($ucp)")
            call_with_escaping("expr (void)fflush(0)")
    call_with_escaping("thread select 1")
    call_with_escaping("expr (void)free($ucp)")
    call_with_escaping("expr printf(\"\\n<==== Finish thread dump from debugger\\n\")")
    call_with_escaping("expr (void)fflush(0)")



