/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.Constants;
import com.yourkit.util.Asserts;
import com.yourkit.util.Strings;
import com.yourkit.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class FileUtil {
    private static final File[] FILE_EMPTY_ARRAY = new File[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File source, @NotNull File destination) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        FileInputStream in = new FileInputStream(source);
        try {
            FileOutputStream out = new FileOutputStream(destination);
            try {
                FileUtil.copy(in, out);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int length;
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String normalize(@NotNull File file) {
        String string;
        String string2;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException ignored) {
            String absolutePath = file.getAbsolutePath();
            string = Constants.OS_WINDOWS ? absolutePath.toLowerCase() : absolutePath;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = string2;
        if (string2 == null) throw new IllegalStateException("Method must not return null");
        return string;
    }

    public static boolean hasExtension(@NotNull File file, @NotNull String extension) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String name = file.getName();
        if (Constants.OS_WINDOWS) {
            return name.toLowerCase().endsWith(extension);
        }
        return name.endsWith(extension);
    }

    public static boolean nameStartsWith(@NotNull File file, @NotNull String prefix) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String name = file.getName();
        if (Constants.OS_WINDOWS) {
            return name.toLowerCase().startsWith(prefix);
        }
        return name.startsWith(prefix);
    }

    public static String getNameWithoutExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int index = fileName.lastIndexOf(46);
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int index = fileName.lastIndexOf(46);
        return index == -1 ? "" : fileName.substring(index);
    }

    public static void setExecutableAttributeAsync(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            Asserts.fail();
        }
        try {
            Runtime.getRuntime().exec("chmod ugoa+x " + file.getName(), null, file.getParentFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasHPROFSnapshotExtension(File file) {
        return FileUtil.hasExtension(file, ".hprof") || FileUtil.hasExtension(file, ".bin");
    }

    public static boolean hasSnapshotExtension(File file) {
        return FileUtil.hasExtension(file, ".snapshot");
    }

    public static String getOwnJavaExecutablePath(boolean withJavaW) {
        return new File(System.getProperty("java.home"), Constants.OS_WINDOWS ? (withJavaW ? "bin\\javaw.exe" : "bin\\java.exe") : "bin/java").getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String expandUserHome(@NotNull String path) {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String homeDirPrefix = "~/";
        if (path.startsWith("~/")) {
            string = System.getProperty("user.home") + "/" + path.substring("~/".length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = path;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    public static void visitDirectory(File dir, DirectoryVisitor visitor) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                visitor.visitDirectoryBeforeVisitingContent(file);
                FileUtil.visitDirectory(file, visitor);
                visitor.visitDirectoryAfterVisitingContent(file);
                continue;
            }
            visitor.visitFile(file);
        }
    }

    public static void visitDirectoryAndPrintElapsedTime(File dir, DirectoryVisitor visitor) throws IOException {
        long startMs = System.currentTimeMillis();
        FileUtil.visitDirectory(dir, visitor);
        long stopMs = System.currentTimeMillis();
        System.out.println(Strings.getFirstToken(Strings.getLastToken(visitor.getClass().getName(), "."), "$") + ": elapsed " + (stopMs - startMs) / 1000L + " seconds");
    }

    @NotNull
    public static byte[] readFileContent(File file) throws IOException {
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new IOException("File is too big: " + file.getAbsolutePath());
        }
        byte[] byArray = FileUtil.readFileContent(file, (int)fileLength);
        if (byArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] readFileContent(@NotNull File file, int bytesToRead) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] result = new byte[bytesToRead];
        DataInputStream stream = new DataInputStream(new FileInputStream(file));
        try {
            stream.readFully(result);
        }
        finally {
            stream.close();
        }
        if (result == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return result;
    }

    @NotNull
    public static String readFileContentAsUtf8(File file) throws IOException {
        byte[] bytes = FileUtil.readFileContent(file);
        String string = new String(bytes, "utf-8");
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String readTextFileContentAsUtf8(File file) throws IOException {
        String result = FileUtil.readFileContentAsUtf8(file);
        String string = Constants.OS_WINDOWS ? Strings.replace(result, "\r\n", "\n") : result;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String readFileContentAsASCII(File file) throws IOException {
        byte[] bytes = FileUtil.readFileContent(file);
        StringBuilder builder = new StringBuilder(bytes.length);
        for (byte b : bytes) {
            builder.append((char)(b < 128 ? b : (byte)0));
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileContent(File file, byte[] content) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            stream.write(content);
        }
        finally {
            stream.close();
        }
    }

    public static void writeFileContentAsUtf8(File file, String content) throws IOException {
        FileUtil.writeFileContent(file, Strings.getUTF8Bytes(content));
    }

    public static void writeTextFileContentAsUtf8(File file, String content) throws IOException {
        FileUtil.writeFileContentAsUtf8(file, Constants.OS_WINDOWS ? Strings.replace(content, "\n", "\r\n") : content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readFileAsLines(File file) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                result.add(s);
            }
        }
        finally {
            reader.close();
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readStreamAsLines(InputStream stream) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                result.add(s);
            }
        }
        finally {
            reader.close();
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean equalPaths(@NotNull File file1, @NotNull File file2) {
        if (file1 == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            return FileUtil.normalize(file1).equalsIgnoreCase(FileUtil.normalize(file2));
        }
        return FileUtil.normalize(file1).equals(FileUtil.normalize(file2));
    }

    public static void deleteSafe(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        file.delete();
    }

    public static void mkdirsSafe(@NotNull File tempDir) {
        if (tempDir == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        tempDir.mkdirs();
    }

    public static void deleteTreeSafe(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            FileUtil.visitDirectory(file, new DirectoryVisitorAdapter(){

                @Override
                public void visitFile(@NotNull File f) {
                    if (f == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    FileUtil.deleteSafe(f);
                }

                @Override
                public void visitDirectoryAfterVisitingContent(File f) {
                    FileUtil.deleteSafe(f);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FileUtil.deleteSafe(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equalBinaryFiles(@NotNull String file1, @NotNull String file2) throws IOException {
        block15: {
            if (file1 == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            if (file2 == null) {
                throw new IllegalArgumentException("Parameter 2 must not be null");
            }
            byte[] buffer1 = new byte[131072];
            byte[] buffer2 = new byte[buffer1.length];
            if (new File(file1).length() != new File(file2).length()) {
                return false;
            }
            BufferedInputStream s1 = new BufferedInputStream(new FileInputStream(file1));
            try {
                DataInputStream s2 = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
                block8: while (true) {
                    int length = ((InputStream)s1).read(buffer1);
                    if (length != -1) {
                        s2.readFully(buffer2, 0, length);
                        int i = 0;
                        while (true) {
                            if (i >= length) continue block8;
                            if (buffer1[i] != buffer2[i]) {
                                boolean bl = false;
                                return bl;
                            }
                            ++i;
                        }
                    }
                    break block15;
                    break;
                }
                finally {
                    s2.close();
                }
            }
            finally {
                ((InputStream)s1).close();
            }
        }
        return true;
    }

    @NotNull
    public static File[] listFilesSafe(@NotNull File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        File[] fileArray = Util.notNull(directory.listFiles(), FILE_EMPTY_ARRAY);
        if (fileArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return fileArray;
    }

    public static class DirectoryVisitorAdapter
    implements DirectoryVisitor {
        @Override
        public void visitFile(@NotNull File file) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }

        @Override
        public void visitDirectoryBeforeVisitingContent(File directory) throws IOException {
        }

        @Override
        public void visitDirectoryAfterVisitingContent(File directory) throws IOException {
        }
    }

    public static interface DirectoryVisitor {
        public void visitFile(@NotNull File var1) throws IOException;

        public void visitDirectoryBeforeVisitingContent(File var1) throws IOException;

        public void visitDirectoryAfterVisitingContent(File var1) throws IOException;
    }
}

