/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.RootsCollection;

public class CheckoutAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        final RootsCollection.VirtualFileRootsCollection rootsCollection = new RootsCollection.VirtualFileRootsCollection(files);
        final Ref error = new Ref();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                    TFSVcs.getInstance(project).getEditFileProvider().editFiles(VfsUtil.toVirtualFileArray((Collection)((Object)rootsCollection)));
                }
                catch (VcsException ex) {
                    error.set((Object)ex);
                }
            }
        }, "Checking out files for edit...", false, project);
        if (!error.isNull()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(Collections.singletonList(error.get()), "TFS");
        }
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        e.getPresentation().setEnabled(CheckoutAction.isEnabled(project, files));
    }

    private static boolean isEnabled(Project project, VirtualFile[] files) {
        if (files.length == 0) {
            return false;
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            FileStatus fileStatus = fileStatusManager.getStatus(file);
            if (fileStatus == FileStatus.NOT_CHANGED || fileStatus == FileStatus.HIJACKED) continue;
            return false;
        }
        return true;
    }
}

