/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ResultWithFailures;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSEditFileProvider
implements EditFileProvider {
    private final Project myProject;

    public TFSEditFileProvider(Project project) {
        this.myProject = project;
    }

    public void editFiles(VirtualFile[] files) throws VcsException {
        final ArrayList<VcsException> errors = new ArrayList<VcsException>();
        try {
            List<FilePath> orphans = WorkstationHelper.processByWorkspaces(TfsFileUtil.getFilePaths(files), false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    ResultWithFailures<GetOperation> processResult = workspace.getServer().getVCS().checkoutForEdit(workspace.getName(), workspace.getOwnerName(), paths, TFSEditFileProvider.this.myProject, TFSBundle.message("checking.out", new Object[0]));
                    ArrayList<VirtualFile> makeWritable = new ArrayList<VirtualFile>();
                    for (GetOperation getOperation : processResult.getResult()) {
                        TFSVcs.assertTrue(getOperation.getSlocal().equals(getOperation.getTlocal()));
                        VirtualFile file = VersionControlPath.getVirtualFile(getOperation.getSlocal());
                        if (file == null || !file.isValid() || file.isDirectory()) continue;
                        makeWritable.add(file);
                    }
                    try {
                        TfsFileUtil.setReadOnly(makeWritable, false);
                    }
                    catch (IOException e) {
                        errors.add(new VcsException((Throwable)e));
                    }
                    errors.addAll(TfsUtil.getVcsExceptions(processResult.getFailures()));
                }
            });
            if (!orphans.isEmpty()) {
                StringBuilder s = new StringBuilder("Mappings not found for files:\n");
                for (FilePath path : orphans) {
                    s.append(path.getPresentableUrl()).append("\n");
                }
                throw new VcsException(s.toString());
            }
        }
        catch (TfsException e) {
            throw new VcsException((Throwable)e);
        }
        if (!errors.isEmpty()) {
            throw TfsUtil.collectExceptions(errors);
        }
    }

    public String getRequestText() {
        return "Perform a checkout?";
    }
}

