/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Conflict;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSProgressUtil;
import org.jetbrains.tfsIntegration.core.TFSProjectConfiguration;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.UpdateConfigurable;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.core.tfs.conflicts.ConflictsEnvironment;
import org.jetbrains.tfsIntegration.core.tfs.conflicts.ResolveConflictHelper;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyGetOperations;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.UpdateSettingsForm;

public class TFSUpdateEnvironment
implements UpdateEnvironment {
    @NotNull
    private final TFSVcs myVcs;

    TFSUpdateEnvironment(@NotNull TFSVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/tfsIntegration/core/TFSUpdateEnvironment", "<init>"));
        }
        this.myVcs = vcs;
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] contentRoots, final UpdatedFiles updatedFiles, final ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> context) throws ProcessCanceledException {
        if (contentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoots", "org/jetbrains/tfsIntegration/core/TFSUpdateEnvironment", "updateDirectories"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/tfsIntegration/core/TFSUpdateEnvironment", "updateDirectories"));
        }
        final ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        TFSProgressUtil.setProgressText(progressIndicator, "Request update information");
        try {
            final HashMap<WorkspaceInfo, Collection<Conflict>> workspace2Conflicts = new HashMap<WorkspaceInfo, Collection<Conflict>>();
            List<FilePath> orphanPaths = WorkstationHelper.processByWorkspaces(Arrays.asList(contentRoots), true, this.myVcs.getProject(), new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    VersionSpecBase version = LatestVersionSpec.INSTANCE;
                    RecursionType recursionType = RecursionType.Full;
                    TFSProjectConfiguration configuration = TFSProjectConfiguration.getInstance(TFSUpdateEnvironment.this.myVcs.getProject());
                    if (configuration != null) {
                        version = configuration.getUpdateWorkspaceInfo(workspace).getVersion();
                        recursionType = configuration.getState().UPDATE_RECURSIVELY ? RecursionType.Full : RecursionType.None;
                    }
                    ArrayList<VersionControlServer.GetRequestParams> requests = new ArrayList<VersionControlServer.GetRequestParams>(paths.size());
                    for (ItemPath path : paths) {
                        requests.add(new VersionControlServer.GetRequestParams(path.getServerPath(), recursionType, version));
                        TFSProgressUtil.checkCanceled(progressIndicator);
                    }
                    List<GetOperation> operations = workspace.getServer().getVCS().get(workspace.getName(), workspace.getOwnerName(), requests, TFSUpdateEnvironment.this.myVcs.getProject(), TFSBundle.message("preparing.for.download", new Object[0]));
                    Collection<VcsException> applyErrors = ApplyGetOperations.execute(TFSUpdateEnvironment.this.myVcs.getProject(), workspace, operations, new ApplyProgress.ProgressIndicatorWrapper(progressIndicator), updatedFiles, ApplyGetOperations.DownloadMode.ALLOW);
                    exceptions.addAll(applyErrors);
                    Collection<Conflict> conflicts = workspace.getServer().getVCS().queryConflicts(workspace.getName(), workspace.getOwnerName(), paths, RecursionType.Full, TFSUpdateEnvironment.this.myVcs.getProject(), TFSBundle.message("loading.conflicts", new Object[0]));
                    Collection<Conflict> unresolvedConflicts = ResolveConflictHelper.getUnresolvedConflicts(conflicts);
                    if (!unresolvedConflicts.isEmpty()) {
                        workspace2Conflicts.put(workspace, unresolvedConflicts);
                    }
                }
            });
            if (!workspace2Conflicts.isEmpty()) {
                ResolveConflictHelper resolveConflictHelper = new ResolveConflictHelper(this.myVcs.getProject(), workspace2Conflicts, updatedFiles);
                ConflictsEnvironment.getConflictsHandler().resolveConflicts(resolveConflictHelper);
            }
            for (FilePath orphanPath : orphanPaths) {
                updatedFiles.getGroupById("UNKNOWN").add(orphanPath.getPresentableUrl(), TFSVcs.getKey(), null);
            }
        }
        catch (TfsException e) {
            exceptions.add(new VcsException((Throwable)e));
        }
        TfsFileUtil.refreshAndInvalidate(this.myVcs.getProject(), contentRoots, false);
        UpdateSession updateSession = new UpdateSession(){

            @NotNull
            public List<VcsException> getExceptions() {
                List list = exceptions;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSUpdateEnvironment$2", "getExceptions"));
                }
                return list;
            }

            public void onRefreshFilesCompleted() {
                TFSUpdateEnvironment.this.myVcs.fireRevisionChanged();
            }

            public boolean isCanceled() {
                return false;
            }
        };
        if (updateSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSUpdateEnvironment", "updateDirectories"));
        }
        return updateSession;
    }

    @Nullable
    public Configurable createConfigurable(final Collection<FilePath> files) {
        final HashMap<WorkspaceInfo, UpdateSettingsForm.WorkspaceSettings> workspacesSettings = new HashMap<WorkspaceInfo, UpdateSettingsForm.WorkspaceSettings>();
        final Ref error = new Ref();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    WorkstationHelper.processByWorkspaces(files, true, TFSUpdateEnvironment.this.myVcs.getProject(), new WorkstationHelper.VoidProcessDelegate(){

                        @Override
                        public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                            Map<FilePath, ExtendedItem> result = workspace.getExtendedItems2(paths, TFSUpdateEnvironment.this.myVcs.getProject(), TFSBundle.message("loading.items", new Object[0]));
                            ArrayList<ExtendedItem> items = new ArrayList<ExtendedItem>(result.values());
                            Iterator i = items.iterator();
                            while (i.hasNext()) {
                                ExtendedItem extendedItem = (ExtendedItem)i.next();
                                if (extendedItem != null && extendedItem.getSitem() != null) continue;
                                i.remove();
                            }
                            if (items.isEmpty()) {
                                return;
                            }
                            ExtendedItem someExtendedItem = (ExtendedItem)items.iterator().next();
                            UpdateSettingsForm.WorkspaceSettings workspaceSettings = new UpdateSettingsForm.WorkspaceSettings(someExtendedItem.getSitem(), someExtendedItem.getType() == ItemType.Folder);
                            for (ExtendedItem extendedItem : items) {
                                String path1 = workspaceSettings.serverPath;
                                String path2 = extendedItem.getSitem();
                                if (VersionControlPath.isUnder(path2, path1)) {
                                    workspaceSettings = new UpdateSettingsForm.WorkspaceSettings(path2, extendedItem.getType() == ItemType.Folder);
                                    continue;
                                }
                                if (VersionControlPath.isUnder(path1, path2)) continue;
                                workspaceSettings = new UpdateSettingsForm.WorkspaceSettings(VersionControlPath.getCommonAncestor(path1, path2), true);
                            }
                            workspacesSettings.put(workspace, workspaceSettings);
                        }
                    });
                }
                catch (TfsException e) {
                    error.set((Object)e);
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(r, "TFS: preparing for update...", false, this.myVcs.getProject());
        if (!error.isNull()) {
            return null;
        }
        if (workspacesSettings.isEmpty()) {
            return null;
        }
        return new UpdateConfigurable(this.myVcs.getProject(), workspacesSettings);
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }
}

