/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.DistinctRootsCollection;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;

public abstract class RootsCollection<T> {

    public static class VirtualFileRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public VirtualFileRootsCollection() {
        }

        public VirtualFileRootsCollection(Collection<VirtualFile> items) {
            super(items);
        }

        public VirtualFileRootsCollection(VirtualFile[] items) {
            super((Object[])items);
        }

        protected boolean isAncestor(@NotNull VirtualFile parent, @NotNull VirtualFile child) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/tfsIntegration/core/tfs/RootsCollection$VirtualFileRootsCollection", "isAncestor"));
            }
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/tfsIntegration/core/tfs/RootsCollection$VirtualFileRootsCollection", "isAncestor"));
            }
            return VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false);
        }
    }

    public static class ItemPathRootsCollection
    extends DistinctRootsCollection<ItemPath> {
        public ItemPathRootsCollection() {
        }

        public ItemPathRootsCollection(Collection<ItemPath> items) {
            super(items);
        }

        protected boolean isAncestor(@NotNull ItemPath parent, @NotNull ItemPath child) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/tfsIntegration/core/tfs/RootsCollection$ItemPathRootsCollection", "isAncestor"));
            }
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/tfsIntegration/core/tfs/RootsCollection$ItemPathRootsCollection", "isAncestor"));
            }
            return child.getLocalPath().isUnder(parent.getLocalPath(), false);
        }
    }

    public static class FilePathRootsCollection
    extends DistinctRootsCollection<FilePath> {
        public FilePathRootsCollection() {
        }

        public FilePathRootsCollection(Collection<FilePath> items) {
            super(items);
        }

        protected boolean isAncestor(@NotNull FilePath parent, @NotNull FilePath child) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/tfsIntegration/core/tfs/RootsCollection$FilePathRootsCollection", "isAncestor"));
            }
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/tfsIntegration/core/tfs/RootsCollection$FilePathRootsCollection", "isAncestor"));
            }
            return child.isUnder(parent, false);
        }
    }
}

