/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.vcs.FilePath;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.PendingChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.StatusVisitor;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public abstract class ServerStatus {
    public final int localVer;
    public final int itemId;
    public final boolean isDirectory;
    @Nullable
    public final String sourceItem;
    @Nullable
    public final String targetItem;

    protected ServerStatus(int localVer, int itemId, boolean isDirectory, String sourceItem, String targetItem) {
        this.localVer = localVer;
        this.itemId = itemId;
        this.isDirectory = isDirectory;
        this.sourceItem = sourceItem;
        this.targetItem = targetItem;
    }

    protected ServerStatus(@NotNull PendingChange pendingChange) {
        if (pendingChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pendingChange", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus", "<init>"));
        }
        this(pendingChange.getVer(), pendingChange.getItemid(), pendingChange.getType() == ItemType.Folder, pendingChange.getSrcitem(), pendingChange.getItem());
    }

    protected ServerStatus(@NotNull ExtendedItem extendedItem) {
        if (extendedItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedItem", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus", "<init>"));
        }
        this(extendedItem.getLver(), extendedItem.getItemid(), extendedItem.getType() == ItemType.Folder, extendedItem.getSitem(), extendedItem.getTitem());
    }

    public abstract void visitBy(@NotNull FilePath var1, boolean var2, @NotNull StatusVisitor var3) throws TfsException;

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf("$") + 1);
    }

    public static class Undeleted
    extends ServerStatus {
        protected Undeleted(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pendingChange", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Undeleted", "<init>"));
            }
            super(pendingChange);
        }

        public Undeleted(@NotNull ExtendedItem item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Undeleted", "<init>"));
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Undeleted", "visitBy"));
            }
            if (statusVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusVisitor", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Undeleted", "visitBy"));
            }
            statusVisitor.undeleted(localPath, localItemExists, this);
        }
    }

    public static class RenamedCheckedOut
    extends ServerStatus {
        protected RenamedCheckedOut(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pendingChange", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$RenamedCheckedOut", "<init>"));
            }
            super(pendingChange);
        }

        public RenamedCheckedOut(@NotNull ExtendedItem item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$RenamedCheckedOut", "<init>"));
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$RenamedCheckedOut", "visitBy"));
            }
            if (statusVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusVisitor", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$RenamedCheckedOut", "visitBy"));
            }
            statusVisitor.renamedCheckedOut(localPath, localItemExists, this);
        }
    }

    public static class Renamed
    extends ServerStatus {
        protected Renamed(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pendingChange", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Renamed", "<init>"));
            }
            super(pendingChange);
        }

        public Renamed(@NotNull ExtendedItem item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Renamed", "<init>"));
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Renamed", "visitBy"));
            }
            if (statusVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusVisitor", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Renamed", "visitBy"));
            }
            statusVisitor.renamed(localPath, localItemExists, this);
        }
    }

    public static class UpToDate
    extends ServerStatus {
        protected UpToDate(@NotNull ExtendedItem extendedItem) {
            if (extendedItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedItem", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$UpToDate", "<init>"));
            }
            super(extendedItem);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$UpToDate", "visitBy"));
            }
            if (statusVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusVisitor", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$UpToDate", "visitBy"));
            }
            statusVisitor.upToDate(localPath, localItemExists, this);
        }
    }

    public static class OutOfDate
    extends ServerStatus {
        protected OutOfDate(@NotNull ExtendedItem extendedItem) {
            if (extendedItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedItem", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$OutOfDate", "<init>"));
            }
            super(extendedItem);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$OutOfDate", "visitBy"));
            }
            if (statusVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusVisitor", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$OutOfDate", "visitBy"));
            }
            statusVisitor.outOfDate(localPath, localItemExists, this);
        }
    }

    public static class ScheduledForDeletion
    extends ServerStatus {
        protected ScheduledForDeletion(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pendingChange", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForDeletion", "<init>"));
            }
            super(pendingChange);
        }

        public ScheduledForDeletion(@NotNull ExtendedItem item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForDeletion", "<init>"));
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForDeletion", "visitBy"));
            }
            if (statusVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusVisitor", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForDeletion", "visitBy"));
            }
            statusVisitor.scheduledForDeletion(localPath, localItemExists, this);
        }
    }

    public static class ScheduledForAddition
    extends ServerStatus {
        protected ScheduledForAddition(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pendingChange", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForAddition", "<init>"));
            }
            super(pendingChange);
        }

        protected ScheduledForAddition(@NotNull ExtendedItem extendedItem) {
            if (extendedItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedItem", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForAddition", "<init>"));
            }
            super(extendedItem);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForAddition", "visitBy"));
            }
            if (statusVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusVisitor", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForAddition", "visitBy"));
            }
            statusVisitor.scheduledForAddition(localPath, localItemExists, this);
        }
    }

    public static class CheckedOutForEdit
    extends ServerStatus {
        protected CheckedOutForEdit(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pendingChange", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$CheckedOutForEdit", "<init>"));
            }
            super(pendingChange);
        }

        public CheckedOutForEdit(@NotNull ExtendedItem item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$CheckedOutForEdit", "<init>"));
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$CheckedOutForEdit", "visitBy"));
            }
            if (statusVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusVisitor", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$CheckedOutForEdit", "visitBy"));
            }
            statusVisitor.checkedOutForEdit(localPath, localItemExists, this);
        }
    }

    public static class Unversioned
    extends ServerStatus {
        public static final ServerStatus INSTANCE = new Unversioned();

        private Unversioned() {
            super(0, 0, false, null, null);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Unversioned", "visitBy"));
            }
            if (statusVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusVisitor", "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Unversioned", "visitBy"));
            }
            statusVisitor.unversioned(localPath, localItemExists, this);
        }
    }
}

