/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionControlPath {
    public static final String SERVER_PATH_SEPARATOR = "/";
    public static final String ROOT_FOLDER = "$/";
    private static final String WINDOWS_PATH_SEPARATOR = "\\";
    private static final String FAKE_DRIVE_PREFIX = "U:";

    public static String toTfsRepresentation(@Nullable String localPath) {
        if (localPath == null) {
            return null;
        }
        localPath = localPath.replace(SERVER_PATH_SEPARATOR, WINDOWS_PATH_SEPARATOR);
        return SystemInfo.isWindows ? localPath : FAKE_DRIVE_PREFIX + localPath;
    }

    public static String toTfsRepresentation(@NotNull FilePath localPath) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/VersionControlPath", "toTfsRepresentation"));
        }
        return VersionControlPath.toTfsRepresentation(localPath.getPath());
    }

    @Nullable
    public static String localPathFromTfsRepresentation(@Nullable String localPath) {
        if (localPath == null) {
            return null;
        }
        String systemDependent = FileUtil.toSystemDependentName((String)localPath);
        if (!SystemInfo.isWindows && systemDependent.startsWith(FAKE_DRIVE_PREFIX)) {
            return systemDependent.substring(FAKE_DRIVE_PREFIX.length());
        }
        return systemDependent;
    }

    @Nullable
    public static FilePath getFilePath(@Nullable String localPath, boolean isDirectory) {
        return localPath != null ? VcsUtil.getFilePath((String)VersionControlPath.localPathFromTfsRepresentation(localPath), (boolean)isDirectory) : null;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull String localPath) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/VersionControlPath", "getVirtualFile"));
        }
        return VcsUtil.getVirtualFile((String)VersionControlPath.localPathFromTfsRepresentation(localPath));
    }

    public static File getFile(String localPath) {
        return new File(VersionControlPath.localPathFromTfsRepresentation(localPath));
    }

    public static String getPathToProject(String serverPath) {
        int secondSlashPos = serverPath.indexOf(SERVER_PATH_SEPARATOR, ROOT_FOLDER.length());
        return secondSlashPos == -1 ? serverPath : serverPath.substring(0, secondSlashPos);
    }

    public static String getTeamProject(String serverPath) {
        int secondSlashPos = serverPath.indexOf(SERVER_PATH_SEPARATOR, ROOT_FOLDER.length());
        return serverPath.substring(ROOT_FOLDER.length(), secondSlashPos != -1 ? secondSlashPos : serverPath.length());
    }

    public static boolean isUnder(String parent, String child) {
        parent = parent.toLowerCase();
        return parent.equals(VersionControlPath.getCommonAncestor(parent, child.toLowerCase()));
    }

    public static int compareParentToChild(String path1, String path2) {
        return path1.compareTo(path2);
    }

    public static int compareParentToChild(@NotNull String path1, boolean isDirectory1, @NotNull String path2, boolean isDrectory2) {
        if (path1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "org/jetbrains/tfsIntegration/core/tfs/VersionControlPath", "compareParentToChild"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "org/jetbrains/tfsIntegration/core/tfs/VersionControlPath", "compareParentToChild"));
        }
        String[] pathComponents1 = VersionControlPath.getPathComponents(path1);
        String[] pathComponents2 = VersionControlPath.getPathComponents(path2);
        int minLength = Math.min(pathComponents1.length, pathComponents2.length);
        for (int i = 0; i < minLength - 1; ++i) {
            String s1 = pathComponents1[i];
            String s2 = pathComponents2[i];
            if (s1.equals(s2)) continue;
            return s1.compareTo(s2);
        }
        if (pathComponents1.length == pathComponents2.length) {
            if (isDirectory1 == isDrectory2) {
                return pathComponents1[pathComponents1.length - 1].compareTo(pathComponents2[pathComponents2.length - 1]);
            }
            return isDirectory1 ? 1 : -1;
        }
        if (pathComponents1.length == minLength && !isDirectory1) {
            return -1;
        }
        if (pathComponents2.length == minLength && !isDrectory2) {
            return 1;
        }
        if (pathComponents1[minLength - 1].equals(pathComponents2[minLength - 1])) {
            return pathComponents1.length - pathComponents2.length;
        }
        return pathComponents1[minLength - 1].compareTo(pathComponents2[minLength - 1]);
    }

    public static String getCommonAncestor(@NotNull String path1, @NotNull String path2) {
        int i;
        if (path1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "org/jetbrains/tfsIntegration/core/tfs/VersionControlPath", "getCommonAncestor"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "org/jetbrains/tfsIntegration/core/tfs/VersionControlPath", "getCommonAncestor"));
        }
        String[] components1 = VersionControlPath.getPathComponents(path1);
        String[] components2 = VersionControlPath.getPathComponents(path2);
        for (i = 0; i < Math.min(components1.length, components2.length) && components1[i].equals(components2[i]); ++i) {
        }
        return i == 1 ? ROOT_FOLDER : StringUtil.join(Arrays.asList(components1).subList(0, i), (String)SERVER_PATH_SEPARATOR);
    }

    public static String getLastComponent(@NotNull String serverPath) {
        if (serverPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverPath", "org/jetbrains/tfsIntegration/core/tfs/VersionControlPath", "getLastComponent"));
        }
        return serverPath.substring(serverPath.lastIndexOf(SERVER_PATH_SEPARATOR) + 1);
    }

    public static String[] getPathComponents(@NotNull String serverPath) {
        if (serverPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverPath", "org/jetbrains/tfsIntegration/core/tfs/VersionControlPath", "getPathComponents"));
        }
        return serverPath.split(SERVER_PATH_SEPARATOR);
    }

    public static String getCombinedServerPath(FilePath localPathBase, String serverPathBase, FilePath localPath) {
        String localPathBaseString = FileUtil.toSystemIndependentName((String)localPathBase.getPath());
        String localPathString = FileUtil.toSystemIndependentName((String)localPath.getPath());
        String localPathRemainder = localPathString.substring(localPathBaseString.length());
        if (serverPathBase.endsWith(SERVER_PATH_SEPARATOR) && localPathRemainder.startsWith(SERVER_PATH_SEPARATOR)) {
            localPathRemainder = localPathRemainder.substring(1);
        }
        return serverPathBase + localPathRemainder;
    }

    public static FilePath getCombinedLocalPath(FilePath localPathBase, String serverPathBase, String serverPath, boolean isDirectory) {
        String serverPathBaseString = FileUtil.toSystemDependentName((String)serverPathBase);
        String serverPathString = FileUtil.toSystemDependentName((String)serverPath);
        File localFile = new File(localPathBase.getIOFile(), serverPathString.substring(serverPathBaseString.length()));
        return VcsUtil.getFilePath((File)localFile, (boolean)isDirectory);
    }

    public static String getCombinedServerPath(String path, String name) {
        return path + (path.endsWith(SERVER_PATH_SEPARATOR) ? "" : SERVER_PATH_SEPARATOR) + name;
    }
}

