/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LockLevel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.tfsIntegration.core.tfs.locks.LockItemModel;
import org.jetbrains.tfsIntegration.ui.LockItemsTableModel;
import org.jetbrains.tfsIntegration.ui.NoBackgroundBooleanTableCellRenderer;
import org.jetbrains.tfsIntegration.ui.UiConstants;

public class LockItemsForm {
    private JPanel myContentPane;
    private JTable myLockItemsTable;
    private JRadioButton myLockCheckOutRadioButton;
    private JRadioButton myLockCheckInRadioButton;
    private final LockItemsTableModel myLockItemsTableModel;

    public LockItemsForm(List<LockItemModel> items) {
        this.$$$setupUI$$$();
        this.myLockCheckOutRadioButton.setSelected(true);
        this.myLockItemsTableModel = new LockItemsTableModel(items);
        this.myLockItemsTable.setModel(this.myLockItemsTableModel);
        for (int i = 0; i < LockItemsTableModel.Column.values().length; ++i) {
            this.myLockItemsTable.getColumnModel().getColumn(i).setPreferredWidth(LockItemsTableModel.Column.values()[i].getWidth());
        }
        this.myLockItemsTable.setSelectionMode(0);
        this.myLockItemsTable.setDefaultRenderer(Boolean.class, new NoBackgroundBooleanTableCellRenderer());
        this.myLockItemsTable.setDefaultRenderer(ExtendedItem.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ExtendedItem item = (ExtendedItem)value;
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setIcon(item.getType() == ItemType.Folder ? UiConstants.ICON_FOLDER : UiConstants.ICON_FILE);
                this.setValue(item.getSitem());
                return this;
            }
        });
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public void setRadioButtonsEnabled(boolean isEnabled) {
        this.myLockCheckInRadioButton.setEnabled(isEnabled);
        this.myLockCheckOutRadioButton.setEnabled(isEnabled);
    }

    public List<LockItemModel> getSelectedItems() {
        return this.myLockItemsTableModel.getSelectedItems();
    }

    public LockLevel getLockLevel() {
        if (this.myLockCheckInRadioButton.isEnabled() && this.myLockCheckInRadioButton.isSelected()) {
            return LockLevel.Checkin;
        }
        if (this.myLockCheckOutRadioButton.isEnabled() && this.myLockCheckOutRadioButton.isSelected()) {
            return LockLevel.CheckOut;
        }
        return LockLevel.None;
    }

    public void addListener(LockItemsTableModel.Listener listener) {
        this.myLockItemsTableModel.addListener(listener);
    }

    public void removeListener(LockItemsTableModel.Listener listener) {
        this.myLockItemsTableModel.removeListener(listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, "South");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Lock", (int)0, (int)0, null, null));
        this.myLockCheckInRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Check In - Allow other users to check out but prevent them from checking in");
        jRadioButton2.setMnemonic('I');
        jRadioButton2.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLockCheckOutRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Check Out - Prevent other users from checking out and checking in");
        jRadioButton.setMnemonic('O');
        jRadioButton.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel3, "Center");
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Items", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, "Center");
        JBTable jBTable = new JBTable();
        this.myLockItemsTable = jBTable;
        jBTable.setPreferredScrollableViewportSize(new Dimension(500, 200));
        jBTable.setEnabled(true);
        jBScrollPane.setViewportView((Component)jBTable);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

