/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.ui.Messages;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Changeset;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.DateVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.ChangesetsTableModel;

public class SelectChangesetForm {
    private static final DateFormat DATE_FORMAT = SimpleDateFormat.getInstance();
    private JTable myChangesetsTable;
    private JTextField myPathField;
    private JTextField myUserField;
    private JRadioButton myAllChangesRadioButton;
    private JRadioButton myChangeNumberRadioButton;
    private JTextField myFromChangesetField;
    private JTextField myToChangesetField;
    private JRadioButton myCreatedDateRadioButton;
    private JTextField myFromDateField;
    private JTextField myToDateField;
    private JButton myFindButton;
    private JPanel panel;
    private final ChangesetsTableModel myChangesetsTableModel;
    private final WorkspaceInfo myWorkspace;
    private final String myServerPath;
    private final boolean myRecursive;
    private final EventDispatcher<Listener> myEventDispatcher;

    public SelectChangesetForm(WorkspaceInfo workspace, String serverPath, boolean recursive) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myWorkspace = workspace;
        this.myServerPath = serverPath;
        this.myRecursive = recursive;
        this.myChangesetsTableModel = new ChangesetsTableModel();
        this.myChangesetsTable.setModel(this.myChangesetsTableModel);
        this.myChangesetsTable.setSelectionMode(0);
        for (int i = 0; i < ChangesetsTableModel.Column.values().length; ++i) {
            this.myChangesetsTable.getColumnModel().getColumn(i).setPreferredWidth(ChangesetsTableModel.Column.values()[i].getWidth());
        }
        this.myPathField.setText(serverPath);
        this.myFindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectChangesetForm.this.search();
            }
        });
        ActionListener radioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectChangesetForm.this.updateControls();
            }
        };
        this.myAllChangesRadioButton.addActionListener(radioButtonListener);
        this.myChangeNumberRadioButton.addActionListener(radioButtonListener);
        this.myCreatedDateRadioButton.addActionListener(radioButtonListener);
        this.myChangesetsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ((Listener)SelectChangesetForm.this.myEventDispatcher.getMulticaster()).selectionChanged(SelectChangesetForm.this.getSelectedChangeset());
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                Integer changeset = SelectChangesetForm.this.getSelectedChangeset();
                if (changeset != null) {
                    ((Listener)SelectChangesetForm.this.myEventDispatcher.getMulticaster()).selected(changeset);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myChangesetsTable);
        this.myAllChangesRadioButton.setSelected(true);
        this.updateControls();
    }

    private void search() {
        VersionSpecBase versionFrom = null;
        VersionSpecBase versionTo = LatestVersionSpec.INSTANCE;
        try {
            List<Changeset> changesets;
            if (this.myChangeNumberRadioButton.isSelected()) {
                if (this.myFromChangesetField.getText() != null && this.myFromChangesetField.getText().length() > 0) {
                    versionFrom = new ChangesetVersionSpec(Integer.parseInt(this.myFromChangesetField.getText()));
                }
                if (this.myToChangesetField.getText() != null && this.myToChangesetField.getText().length() > 0) {
                    versionTo = new ChangesetVersionSpec(Integer.parseInt(this.myToChangesetField.getText()));
                }
            } else if (this.myCreatedDateRadioButton.isSelected()) {
                if (this.myFromDateField.getText() != null && this.myFromDateField.getText().length() > 0) {
                    versionFrom = new DateVersionSpec(SimpleDateFormat.getInstance().parse(this.myFromDateField.getText()));
                }
                if (this.myToDateField.getText() != null && this.myToDateField.getText().length() > 0) {
                    versionTo = new DateVersionSpec(SimpleDateFormat.getInstance().parse(this.myToDateField.getText()));
                }
            }
            if ((changesets = this.myWorkspace.getServer().getVCS().queryHistory(this.myWorkspace, this.myServerPath, this.myRecursive, this.myUserField.getText(), versionFrom, versionTo, this.getContentPane(), TFSBundle.message("loading.history", new Object[0]), Integer.MAX_VALUE)).isEmpty()) {
                Messages.showInfoMessage((Component)this.panel, (String)"No matching changesets found", (String)"Find Changeset");
            }
            this.myChangesetsTableModel.setChangesets(changesets);
        }
        catch (TfsException ex) {
            this.myChangesetsTableModel.setChangesets(Collections.emptyList());
            Messages.showErrorDialog((Component)this.panel, (String)ex.getMessage(), (String)"Find Changeset");
        }
        catch (NumberFormatException ex) {
            this.myChangesetsTableModel.setChangesets(Collections.emptyList());
            Messages.showErrorDialog((Component)this.panel, (String)"Invalid changeset number specified", (String)"Find Changeset");
        }
        catch (ParseException e1) {
            this.myChangesetsTableModel.setChangesets(Collections.emptyList());
            Messages.showErrorDialog((Component)this.panel, (String)"Invalid date specified", (String)"Find Changeset");
        }
    }

    private void updateControls() {
        this.myFromChangesetField.setEnabled(this.myChangeNumberRadioButton.isSelected());
        this.myToChangesetField.setEnabled(this.myChangeNumberRadioButton.isSelected());
        if (!this.myChangeNumberRadioButton.isSelected()) {
            this.myFromChangesetField.setText(null);
            this.myToChangesetField.setText(null);
        }
        this.myFromDateField.setEnabled(this.myCreatedDateRadioButton.isSelected());
        this.myToDateField.setEnabled(this.myCreatedDateRadioButton.isSelected());
        if (!this.myCreatedDateRadioButton.isSelected()) {
            this.myFromDateField.setText(null);
            this.myToDateField.setText(null);
        } else {
            String currentDate = DATE_FORMAT.format(new Date());
            this.myFromDateField.setText(currentDate);
            this.myToDateField.setText(currentDate);
        }
    }

    public JComponent getContentPane() {
        return this.panel;
    }

    @Nullable
    public Integer getSelectedChangeset() {
        if (this.myChangesetsTable.getSelectedRowCount() == 1) {
            return this.myChangesetsTableModel.getChangesets().get(this.myChangesetsTable.getSelectedRow()).getCset();
        }
        return null;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JButton jButton;
        JTextField jTextField2;
        JTextField jTextField3;
        JRadioButton jRadioButton;
        JTextField jTextField4;
        JTextField jTextField5;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JTextField jTextField6;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Options", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Item path:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("User name:");
        jLabel2.setDisplayedMnemonic('U');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUserField = jTextField6 = new JTextField();
        jPanel2.add((Component)jTextField6, new GridConstraints(3, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Range:");
        jPanel2.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAllChangesRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("All changes");
        jRadioButton3.setMnemonic('L');
        jRadioButton3.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myChangeNumberRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Change numbers");
        jRadioButton2.setMnemonic('N');
        jRadioButton2.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(7, 0, 1, 2, 0, 3, 7, 3, null, null, null, 1));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("From:");
        jLabel4.setDisplayedMnemonic('R');
        jLabel4.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFromChangesetField = jTextField5 = new JTextField();
        jPanel3.add((Component)jTextField5, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("To:");
        jLabel5.setDisplayedMnemonic('T');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myToChangesetField = jTextField4 = new JTextField();
        jPanel3.add((Component)jTextField4, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCreatedDateRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Date:");
        jRadioButton.setMnemonic('D');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(9, 0, 1, 2, 0, 3, 3, 3, null, null, null, 1));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("From:");
        jLabel6.setDisplayedMnemonic('R');
        jLabel6.setDisplayedMnemonicIndex(1);
        jPanel4.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFromDateField = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("To:");
        jLabel7.setDisplayedMnemonic('T');
        jLabel7.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel7, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myToDateField = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFindButton = jButton = new JButton();
        jButton.setText("Find");
        jButton.setMnemonic('F');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(10, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myPathField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, new GridConstraints(1, 0, 1, 2, 0, 1, 6, 0, new Dimension(150, -1), new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 2, 1, 7, 7, null, null, null));
        JBTable jBTable = new JBTable();
        this.myChangesetsTable = jBTable;
        jBTable.setAutoResizeMode(3);
        jBScrollPane.setViewportView((Component)jBTable);
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("R&esults");
        jPanel.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jTextField6);
        jLabel4.setLabelFor(jTextField5);
        jLabel5.setLabelFor(jTextField4);
        jLabel6.setLabelFor(jTextField3);
        jLabel7.setLabelFor(jTextField2);
        titledSeparator.setLabelFor((Component)jBScrollPane);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    static interface Listener
    extends EventListener {
        public void selectionChanged(Integer var1);

        public void selected(Integer var1);
    }
}

