/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.Disposable;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.checkin.CheckinParameters;
import org.jetbrains.tfsIntegration.core.TfsSdkManager;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.TfsExecutionUtil;
import org.jetbrains.tfsIntegration.ui.PredefinedQueriesGroupNode;
import org.jetbrains.tfsIntegration.ui.QueriesTreeContext;
import org.jetbrains.tfsIntegration.ui.SavedQueryFolderNode;
import org.jetbrains.tfsIntegration.ui.WorkItemQueriesTreeRootNode;
import org.jetbrains.tfsIntegration.ui.WorkItemsPanel;
import org.jetbrains.tfsIntegration.ui.WorkItemsQueryResult;

public class WorkItemQueriesTreeStructure
extends SimpleTreeStructure
implements QueriesTreeContext,
Disposable {
    @NotNull
    private final WorkItemQueriesTreeRootNode myRootNode;
    @NotNull
    private final TFSTeamProjectCollection myProjectCollection;
    @NotNull
    private final CheckinParameters myState;
    @NotNull
    private final ServerInfo myServer;
    @NotNull
    private final WorkItemsPanel myPanel;

    public WorkItemQueriesTreeStructure(@NotNull WorkItemsPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/jetbrains/tfsIntegration/ui/WorkItemQueriesTreeStructure", "<init>"));
        }
        this.myPanel = panel;
        this.myState = panel.getState();
        this.myServer = panel.getServer();
        this.myRootNode = new WorkItemQueriesTreeRootNode(this);
        this.myProjectCollection = new TFSTeamProjectCollection(this.myServer.getUri(), TfsSdkManager.getCredentials(this.myServer));
    }

    @NotNull
    public PredefinedQueriesGroupNode getPredefinedQueriesGroupNode() {
        PredefinedQueriesGroupNode predefinedQueriesGroupNode = this.myRootNode.getPredefinedQueriesGroupNode();
        if (predefinedQueriesGroupNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/WorkItemQueriesTreeStructure", "getPredefinedQueriesGroupNode"));
        }
        return predefinedQueriesGroupNode;
    }

    public Object getRootElement() {
        return this.myRootNode;
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        return element instanceof SavedQueryFolderNode && ((SavedQueryFolderNode)((Object)element)).isProject();
    }

    @Override
    @NotNull
    public CheckinParameters getState() {
        CheckinParameters checkinParameters = this.myState;
        if (checkinParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/WorkItemQueriesTreeStructure", "getState"));
        }
        return checkinParameters;
    }

    @Override
    @NotNull
    public ServerInfo getServer() {
        ServerInfo serverInfo = this.myServer;
        if (serverInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/WorkItemQueriesTreeStructure", "getServer"));
        }
        return serverInfo;
    }

    @Override
    @NotNull
    public TFSTeamProjectCollection getProjectCollection() {
        TFSTeamProjectCollection tFSTeamProjectCollection = this.myProjectCollection;
        if (tFSTeamProjectCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/WorkItemQueriesTreeStructure", "getProjectCollection"));
        }
        return tFSTeamProjectCollection;
    }

    @Override
    public void queryWorkItems(@NotNull TfsExecutionUtil.Process<WorkItemsQueryResult> query) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "org/jetbrains/tfsIntegration/ui/WorkItemQueriesTreeStructure", "queryWorkItems"));
        }
        this.myPanel.queryWorkItems(query);
    }

    public void dispose() {
        this.myProjectCollection.close();
    }
}

