/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.xmlutil;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThrowableRunnable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtil {
    private static final Logger LOG = Logger.getInstance(XmlUtil.class);

    private XmlUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFile(@NotNull File file, final @Nullable DefaultHandler handler) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/tfsIntegration/xmlutil/XmlUtil", "parseFile"));
        }
        boolean parsed = false;
        final BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        try {
            TfsUtil.forcePluginClassLoader(new ThrowableRunnable<Exception>(){

                public void run() throws Exception {
                    SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(stream), handler);
                }
            });
            parsed = true;
        }
        finally {
            if (!parsed) {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable t) {
                    LOG.info(t);
                }
            } else {
                ((InputStream)stream).close();
            }
        }
    }
}

