/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;

public class LoadRecentBranchRevisions
extends BaseMergeTask {
    public static final String PROP_BUNCH_SIZE = "idea.svn.quick.merge.bunch.size";
    private static final int BUNCH_SIZE = 100;
    private int myBunchSize;
    private long myFirst;
    private boolean myLastLoaded;
    private OneShotMergeInfoHelper myHelper;
    private List<CommittedChangeList> myCommittedChangeLists;

    public LoadRecentBranchRevisions(@NotNull QuickMerge mergeProcess, long first) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/LoadRecentBranchRevisions", "<init>"));
        }
        this(mergeProcess, first, -1);
    }

    public LoadRecentBranchRevisions(@NotNull QuickMerge mergeProcess, long first, int n) {
        int bunchSize;
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/LoadRecentBranchRevisions", "<init>"));
        }
        super(mergeProcess, "Loading recent " + mergeProcess.getMergeContext().getBranchName() + " revisions", Where.POOLED);
        this.myFirst = first;
        Integer testBunchSize = Integer.getInteger(PROP_BUNCH_SIZE);
        this.myBunchSize = testBunchSize != null ? testBunchSize : (bunchSize > 0 ? bunchSize : 100);
    }

    public boolean isLastLoaded() {
        return this.myLastLoaded;
    }

    @Override
    public void run() throws VcsException {
        this.initialize(this.getChangeListsBefore(this.myFirst));
    }

    @NotNull
    private List<Pair<SvnChangeList, LogHierarchyNode>> getChangeListsBefore(long revision) throws VcsException {
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        if (revision > 0L) {
            settings.CHANGE_BEFORE = String.valueOf(revision);
            settings.USE_CHANGE_BEFORE_FILTER = true;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ProgressManager.progress2((String)SvnBundle.message("progress.text2.collecting.history", this.myMergeContext.getSourceUrl() + (revision > 0L ? "@" + revision : "")));
        ArrayList result = ContainerUtil.newArrayList();
        ((SvnCommittedChangesProvider)this.myMergeContext.getVcs().getCommittedChangesProvider()).getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(this.myMergeContext.getSourceUrl()), this.myBunchSize + (revision > 0L ? 2 : 1), (PairConsumer<SvnChangeList, LogHierarchyNode>)((PairConsumer)(list, tree) -> {
            indicator.setText2(SvnBundle.message("progress.text2.processing.revision", list.getNumber()));
            result.add(Pair.create((Object)list, (Object)tree));
        }));
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LoadRecentBranchRevisions", "getChangeListsBefore"));
        }
        return arrayList;
    }

    @NotNull
    private List<CommittedChangeList> getNotMergedChangeLists(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/LoadRecentBranchRevisions", "getNotMergedChangeLists"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (Pair<SvnChangeList, LogHierarchyNode> pair : changeLists) {
            if (this.myFirst > 0L && this.myFirst == ((SvnChangeList)pair.getFirst()).getNumber()) continue;
            result.add(pair.getFirst());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LoadRecentBranchRevisions", "getNotMergedChangeLists"));
        }
        return arrayList;
    }

    private void initialize(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists) throws VcsException {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/LoadRecentBranchRevisions", "initialize"));
        }
        this.myCommittedChangeLists = this.getNotMergedChangeLists(changeLists);
        this.myHelper = new OneShotMergeInfoHelper(this.myMergeContext);
        ProgressManager.progress2((String)"Calculating not merged revisions");
        this.myHelper.prepare();
        boolean bl = this.myLastLoaded = this.myCommittedChangeLists.size() < this.myBunchSize + 1;
        if (this.myCommittedChangeLists.size() > this.myBunchSize) {
            this.myCommittedChangeLists = this.myCommittedChangeLists.subList(0, this.myBunchSize);
        }
    }

    public OneShotMergeInfoHelper getHelper() {
        return this.myHelper;
    }

    public List<CommittedChangeList> getCommittedChangeLists() {
        return this.myCommittedChangeLists;
    }
}

