/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.Where;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.Intersection;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.ShelveLocalChangesTask;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class LocalChangesPromptTask
extends BaseMergeTask {
    @Nullable
    private final List<CommittedChangeList> myChangeListsToMerge;

    public LocalChangesPromptTask(@NotNull QuickMerge mergeProcess) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "<init>"));
        }
        super(mergeProcess, "local changes intersection check", Where.AWT);
        this.myChangeListsToMerge = null;
    }

    public LocalChangesPromptTask(@NotNull QuickMerge mergeProcess, @NotNull List<CommittedChangeList> changeListsToMerge) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "<init>"));
        }
        if (changeListsToMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListsToMerge", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "<init>"));
        }
        super(mergeProcess, "local changes intersection check", Where.AWT);
        this.myChangeListsToMerge = changeListsToMerge;
    }

    @Nullable
    private File getLocalPath(String repositoryRelativePath) {
        String absoluteUrl = SVNPathUtil.append((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)repositoryRelativePath);
        String sourceRelativePath = SVNPathUtil.getRelativePath((String)this.myMergeContext.getSourceUrl(), (String)absoluteUrl);
        return !StringUtil.isEmptyOrSpaces((String)sourceRelativePath) ? new File(this.myMergeContext.getWcInfo().getPath(), sourceRelativePath) : null;
    }

    @Override
    public void run() {
        Intersection intersection;
        List localChangeLists = ChangeListManager.getInstance((Project)this.myMergeContext.getProject()).getChangeListsCopy();
        Intersection intersection2 = intersection = this.myChangeListsToMerge != null ? this.getChangesIntersection(localChangeLists, this.myChangeListsToMerge) : LocalChangesPromptTask.getAllChangesIntersection(localChangeLists);
        if (intersection != null && !intersection.getChangesSubset().isEmpty()) {
            this.processIntersection(intersection);
        }
    }

    private void processIntersection(@NotNull Intersection intersection) {
        if (intersection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intersection", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "processIntersection"));
        }
        switch (this.myInteraction.selectLocalChangesAction(this.myChangeListsToMerge == null)) {
            case shelve: {
                this.next(new ShelveLocalChangesTask(this.myMergeProcess, intersection));
                break;
            }
            case cancel: {
                this.end();
                break;
            }
            case inspect: {
                Collection changes = intersection.getChangesSubset().values();
                this.myInteraction.showIntersectedLocalPaths(ContainerUtil.sorted((Collection)ChangesUtil.getPaths((Collection)changes), (Comparator)FilePathByPathComparator.getInstance()));
                this.end();
            }
        }
    }

    @Nullable
    private Intersection getChangesIntersection(@NotNull List<LocalChangeList> localChangeLists, @NotNull List<CommittedChangeList> changeListsToMerge) {
        if (localChangeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localChangeLists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        if (changeListsToMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListsToMerge", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        Set<FilePath> pathsToMerge = this.collectPaths(changeListsToMerge);
        return !changeListsToMerge.isEmpty() ? LocalChangesPromptTask.getChangesIntersection(localChangeLists, (Condition<Change>)((Condition)change -> LocalChangesPromptTask.hasPathToMerge(change, pathsToMerge))) : null;
    }

    @NotNull
    private Set<FilePath> collectPaths(@NotNull List<CommittedChangeList> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "collectPaths"));
        }
        Set<FilePath> set = lists.stream().map(SvnChangeList.class::cast).flatMap(list -> list.getAffectedPaths().stream()).map(this::getLocalPath).filter(Objects::nonNull).map(localPath -> VcsUtil.getFilePath((File)localPath, (boolean)false)).collect(Collectors.toSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "collectPaths"));
        }
        return set;
    }

    @NotNull
    private static Intersection getAllChangesIntersection(@NotNull List<LocalChangeList> localChangeLists) {
        if (localChangeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localChangeLists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getAllChangesIntersection"));
        }
        Intersection intersection = LocalChangesPromptTask.getChangesIntersection(localChangeLists, (Condition<Change>)Conditions.alwaysTrue());
        if (intersection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getAllChangesIntersection"));
        }
        return intersection;
    }

    @NotNull
    private static Intersection getChangesIntersection(@NotNull List<LocalChangeList> changeLists, @NotNull Condition<Change> filter) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        Intersection result = new Intersection();
        for (LocalChangeList changeList : changeLists) {
            for (Change change : changeList.getChanges()) {
                if (!filter.value((Object)change)) continue;
                result.add(changeList.getName(), changeList.getComment(), change);
            }
        }
        Intersection intersection = result;
        if (intersection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        return intersection;
    }

    private static boolean hasPathToMerge(@NotNull Change change, @NotNull Set<FilePath> pathsToMerge) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "hasPathToMerge"));
        }
        if (pathsToMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathsToMerge", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "hasPathToMerge"));
        }
        FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
        FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
        return beforePath != null && pathsToMerge.contains(beforePath) || afterPath != null && pathsToMerge.contains(afterPath);
    }
}

