/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.continuation.Where;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;

public class MergeInitChecksTask
extends BaseMergeTask {
    public MergeInitChecksTask(@NotNull QuickMerge mergeProcess) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/MergeInitChecksTask", "<init>"));
        }
        super(mergeProcess, "initial checks", Where.AWT);
    }

    @Override
    public void run() {
        SVNURL url = this.parseSourceUrl();
        if (url != null) {
            if (MergeInitChecksTask.areInSameHierarchy(url, this.myMergeContext.getWcInfo().getUrl())) {
                this.end("Cannot merge from self", true);
            } else if (this.hasSwitchedRoots() && !this.myInteraction.shouldContinueSwitchedRootFound()) {
                this.end();
            }
        }
    }

    private boolean hasSwitchedRoots() {
        File currentRoot = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        return this.myMergeContext.getVcs().getAllWcInfos().stream().filter(info -> NestedCopyType.switched.equals((Object)info.getType())).anyMatch(info -> FileUtil.isAncestor((File)currentRoot, (File)info.getRootInfo().getIoFile(), (boolean)true));
    }

    private static boolean areInSameHierarchy(@NotNull SVNURL url1, @NotNull SVNURL url2) {
        if (url1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url1", "org/jetbrains/idea/svn/integrate/MergeInitChecksTask", "areInSameHierarchy"));
        }
        if (url2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url2", "org/jetbrains/idea/svn/integrate/MergeInitChecksTask", "areInSameHierarchy"));
        }
        return SVNURLUtil.isAncestor((SVNURL)url1, (SVNURL)url2) || SVNURLUtil.isAncestor((SVNURL)url2, (SVNURL)url1);
    }
}

