/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchSaveToFileExecutor
implements ApplyPatchExecutor<TextFilePatchInProgress> {
    private static final Logger LOG = Logger.getInstance(ApplyPatchSaveToFileExecutor.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFile myNewPatchBase;

    public ApplyPatchSaveToFileExecutor(@NotNull Project project, @Nullable VirtualFile newPatchBase) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "<init>"));
        }
        this.myProject = project;
        this.myNewPatchBase = newPatchBase;
    }

    public String getName() {
        return "Save Patch to File";
    }

    public void apply(@NotNull List<FilePatch> remaining, @NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroupsToApply, @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        if (remaining == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remaining", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "apply"));
        }
        if (patchGroupsToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchGroupsToApply", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "apply"));
        }
        FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Patch to", "", new String[0]), this.myProject);
        VirtualFileWrapper targetFile = dialog.save(this.myProject.getBaseDir(), "TheirsChanges.patch");
        if (targetFile != null) {
            this.savePatch(patchGroupsToApply, targetFile);
        }
    }

    private void savePatch(@NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroups, @NotNull VirtualFileWrapper targetFile) {
        if (patchGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchGroups", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "savePatch"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "savePatch"));
        }
        VirtualFile newPatchBase = (VirtualFile)ObjectUtils.notNull((Object)this.myNewPatchBase, (Object)this.myProject.getBaseDir());
        try {
            List<FilePatch> textPatches = ApplyPatchSaveToFileExecutor.toOnePatchGroup(patchGroups, newPatchBase);
            PatchWriter.writePatches((Project)this.myProject, (String)targetFile.getFile().getPath(), (String)newPatchBase.getPath(), textPatches, (CommitContext)new CommitContext(), (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{e.getMessage()}), (String)CommonBundle.getErrorTitle()), null, (Project)this.myProject);
        }
    }

    @NotNull
    public static List<FilePatch> toOnePatchGroup(@NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroups, @NotNull VirtualFile newPatchBase) throws IOException {
        if (patchGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchGroups", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "toOnePatchGroup"));
        }
        if (newPatchBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPatchBase", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "toOnePatchGroup"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (Map.Entry entry : patchGroups.entrySet()) {
            VirtualFile oldPatchBase = (VirtualFile)entry.getKey();
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)oldPatchBase, (VirtualFile)newPatchBase, (char)'/');
            boolean toConvert = !StringUtil.isEmptyOrSpaces((String)relativePath) && !".".equals(relativePath);
            for (TextFilePatchInProgress patchInProgress : (Collection)entry.getValue()) {
                TextFilePatch patch = (TextFilePatch)patchInProgress.getPatch();
                if (toConvert) {
                    patch.setBeforeName(ApplyPatchSaveToFileExecutor.getNewBaseRelativePath(newPatchBase, oldPatchBase, patch.getBeforeName()));
                    patch.setAfterName(ApplyPatchSaveToFileExecutor.getNewBaseRelativePath(newPatchBase, oldPatchBase, patch.getAfterName()));
                }
                result.add(patch);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "toOnePatchGroup"));
        }
        return arrayList;
    }

    @Nullable
    private static String getNewBaseRelativePath(@NotNull VirtualFile newBase, @NotNull VirtualFile oldBase, @Nullable String oldBaseRelativePath) throws IOException {
        if (newBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBase", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "getNewBaseRelativePath"));
        }
        if (oldBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBase", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "getNewBaseRelativePath"));
        }
        return !StringUtil.isEmptyOrSpaces((String)oldBaseRelativePath) ? FileUtil.getRelativePath((String)newBase.getPath(), (String)ApplyPatchSaveToFileExecutor.getCanonicalPath(oldBase, oldBaseRelativePath), (char)'/') : oldBaseRelativePath;
    }

    @NotNull
    private static String getCanonicalPath(@NotNull VirtualFile base, @NotNull String relativePath) throws IOException {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "getCanonicalPath"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "getCanonicalPath"));
        }
        String string = FileUtil.toSystemIndependentName((String)new File(base.getPath(), relativePath).getCanonicalPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "getCanonicalPath"));
        }
        return string;
    }
}

