/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DataType;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcUtil {
    private JdbcUtil() {
    }

    public static boolean setCatalogSafe(@NotNull Connection connection, @Nullable String catalog) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/util/JdbcUtil", "setCatalogSafe"));
        }
        try {
            if (catalog != null) {
                connection.setCatalog(catalog);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> List<T> resultSetToListSafe(@NotNull ResultSet rs, @NotNull String columnName, @Nullable ErrorHandler errorHandler) {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/util/JdbcUtil", "resultSetToListSafe"));
        }
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/database/util/JdbcUtil", "resultSetToListSafe"));
        }
        ArrayList<Object> retVal = new ArrayList<Object>();
        try {
            while (rs.next()) {
                retVal.add(rs.getObject(columnName));
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception e) {
            JdbcUtil.columnNotAvailable(columnName, errorHandler, e);
        }
        finally {
            JdbcUtil.closeResultSetSafe(rs);
        }
        ArrayList<Object> arrayList = retVal;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "resultSetToListSafe"));
        }
        return arrayList;
    }

    private static void columnNotAvailable(@NotNull String columnName, @Nullable ErrorHandler errorHandler, Exception e) {
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/database/util/JdbcUtil", "columnNotAvailable"));
        }
        String message = e.getMessage();
        if (errorHandler != null) {
            errorHandler.addError(message != null && message.contains(columnName) ? null : columnName + " unavailable", e);
        }
    }

    @NotNull
    public static String resultSetToStringSafe(@NotNull ResultSet rs) {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/util/JdbcUtil", "resultSetToStringSafe"));
        }
        String string = JdbcUtil.resultSetToStringSafe(rs, 100, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "resultSetToStringSafe"));
        }
        return string;
    }

    @NotNull
    public static String resultSetRowToStringSafe(@NotNull ResultSet rs) {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/util/JdbcUtil", "resultSetRowToStringSafe"));
        }
        String string = JdbcUtil.resultSetToStringSafe(rs, 0, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "resultSetRowToStringSafe"));
        }
        return string;
    }

    @NotNull
    public static String resultSetToStringSafe(@NotNull ResultSet rs, int maxRows, @Nullable ErrorHandler errorHandler) {
        StringBuilder sb;
        block11: {
            if (rs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/util/JdbcUtil", "resultSetToStringSafe"));
            }
            sb = new StringBuilder();
            try {
                int n;
                ResultSetMetaData metaData = rs.getMetaData();
                int count = metaData.getColumnCount();
                String[] columnNames = new String[count];
                for (int i = 1; i <= count; ++i) {
                    columnNames[i - 1] = metaData.getColumnName(i);
                    if (maxRows == 0) continue;
                    sb.append(i).append(".").append(columnNames[i - 1]).append("\n");
                }
                for (n = 0; n == 0 && maxRows == 0 || rs.next(); ++n) {
                    if (maxRows >= 0 && n > maxRows) continue;
                    if (n > 0) {
                        sb.append("\n");
                    }
                    sb.append("[").append(n + 1).append("] ");
                    for (int i = 1; i <= count; ++i) {
                        if (i > 1) {
                            sb.append(", ");
                        }
                        sb.append(maxRows == 0 ? columnNames[i - 1] : Integer.valueOf(i)).append(":").append(rs.getObject(i));
                    }
                }
                if (maxRows > 0) {
                    sb.insert(0, n > 0 ? n + " rows total\n" : "no data\n");
                }
            }
            catch (SQLException metaData) {
            }
            catch (Exception e) {
                if (errorHandler == null) break block11;
                errorHandler.addError("row unavailable", e);
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "resultSetToStringSafe"));
        }
        return string;
    }

    @NotNull
    public static Map<String, Object> resultSetRowToMapSafe(@NotNull ResultSet rs) {
        LinkedHashMap linkedHashMap;
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/util/JdbcUtil", "resultSetRowToMapSafe"));
        }
        try {
            LinkedHashMap result = ContainerUtil.newLinkedHashMap();
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                result.put(metaData.getColumnName(i), rs.getObject(i));
            }
            linkedHashMap = result;
        }
        catch (Exception exception) {
            Map<String, Object> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "resultSetRowToMapSafe"));
            }
            return map;
        }
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "resultSetRowToMapSafe"));
        }
        return linkedHashMap;
    }

    @Nullable
    public static String getStringSafe(ResultSet resultSet, String columnName, ErrorHandler errorHandler) throws SQLException {
        try {
            return resultSet.getString(columnName);
        }
        catch (SQLException sQLException) {
        }
        catch (Exception e) {
            JdbcUtil.columnNotAvailable(columnName, errorHandler, e);
        }
        return null;
    }

    public static int getIntSafe(ResultSet resultSet, String columnName, int defValue, ErrorHandler errorHandler) throws SQLException {
        try {
            return resultSet.getInt(columnName);
        }
        catch (SQLException sQLException) {
        }
        catch (Exception e) {
            JdbcUtil.columnNotAvailable(columnName, errorHandler, e);
        }
        return defValue;
    }

    public static void closeResultSetSafe(@Nullable ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeStatementSafe(@Nullable Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeConnectionSafe(@Nullable Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasScaleAndPrecision(int jdbcType) {
        switch (jdbcType) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasLength(int jdbcType) {
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getJdbcTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/util/JdbcUtil", "getJdbcTypeName"));
        }
        String string = JdbcUtil.getJdbcTypeName(dataType, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "getJdbcTypeName"));
        }
        return string;
    }

    @NotNull
    public static String getJdbcTypeName(@NotNull DataType dataType, boolean addLength) {
        String typeName;
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/util/JdbcUtil", "getJdbcTypeName"));
        }
        String sqlType = dataType.typeName;
        if (StringUtil.isNotEmpty((String)sqlType) && sqlType.indexOf(40) > -1) {
            String string = sqlType;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "getJdbcTypeName"));
            }
            return string;
        }
        int jdbcType = dataType.jdbcType;
        String string = typeName = StringUtil.isNotEmpty((String)sqlType) ? sqlType : JdbcUtil.getJdbcTypeName(jdbcType);
        if (addLength) {
            int scale;
            boolean hasLength = JdbcUtil.hasLength(jdbcType);
            boolean hasScaleAndPrecision = !hasLength && JdbcUtil.hasScaleAndPrecision(jdbcType);
            int length = hasLength || hasScaleAndPrecision ? dataType.getLength() : -1;
            int n = scale = hasScaleAndPrecision ? dataType.getScale() : -1;
            if (hasLength && length > 0) {
                String string2 = typeName + "(" + length + ")";
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "getJdbcTypeName"));
                }
                return string2;
            }
            if (hasScaleAndPrecision && length > 0 && scale >= 0) {
                String string3 = typeName + "(" + length + ", " + scale + ")";
                if (string3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "getJdbcTypeName"));
                }
                return string3;
            }
        }
        String string4 = typeName;
        if (string4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "getJdbcTypeName"));
        }
        return string4;
    }

    @NotNull
    public static String getJdbcTypeName(int jdbcType) {
        String result;
        switch (jdbcType) {
            case -7: {
                result = "BIT";
                break;
            }
            case -6: {
                result = "TINYINT";
                break;
            }
            case 5: {
                result = "SMALLINT";
                break;
            }
            case 4: {
                result = "INTEGER";
                break;
            }
            case -5: {
                result = "BIGINT";
                break;
            }
            case 6: {
                result = "FLOAT";
                break;
            }
            case 7: {
                result = "REAL";
                break;
            }
            case 8: {
                result = "DOUBLE";
                break;
            }
            case 2: {
                result = "NUMERIC";
                break;
            }
            case 3: {
                result = "DECIMAL";
                break;
            }
            case 1: {
                result = "CHAR";
                break;
            }
            case 12: {
                result = "VARCHAR";
                break;
            }
            case -1: {
                result = "LONGVARCHAR";
                break;
            }
            case 91: {
                result = "DATE";
                break;
            }
            case 92: {
                result = "TIME";
                break;
            }
            case 93: {
                result = "TIMESTAMP";
                break;
            }
            case -2: {
                result = "BINARY";
                break;
            }
            case -3: {
                result = "VARBINARY";
                break;
            }
            case -4: {
                result = "LONGVARBINARY";
                break;
            }
            case 0: {
                result = "NULL";
                break;
            }
            case 1111: {
                result = "OTHER";
                break;
            }
            case 2000: {
                result = "JAVA_OBJECT";
                break;
            }
            case 2001: {
                result = "DISTINCT";
                break;
            }
            case 2002: {
                result = "STRUCT";
                break;
            }
            case 2003: {
                result = "ARRAY";
                break;
            }
            case 2004: {
                result = "BLOB";
                break;
            }
            case 2005: {
                result = "CLOB";
                break;
            }
            case 2006: {
                result = "REF";
                break;
            }
            case 70: {
                result = "DATALINK";
                break;
            }
            case 16: {
                result = "BOOLEAN";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/JdbcUtil", "getJdbcTypeName"));
        }
        return string;
    }

    public static int guessJdbcTypeByName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return 1111;
        }
        String fixed = name.toUpperCase();
        if (fixed.contains("BINARY")) {
            return -3;
        }
        if (fixed.contains("BIT")) {
            return -7;
        }
        if (fixed.contains("BOOL")) {
            return 16;
        }
        if (fixed.contains("DATE")) {
            return 91;
        }
        if (fixed.contains("TIMESTAMP")) {
            return 93;
        }
        if (fixed.contains("TIME")) {
            return 92;
        }
        if (fixed.contains("REAL") || fixed.contains("NUMBER")) {
            return 7;
        }
        if (fixed.contains("FLOAT")) {
            return 6;
        }
        if (fixed.contains("DOUBLE")) {
            return 8;
        }
        if (fixed.equals("CHAR") && !fixed.contains("VAR")) {
            return 1;
        }
        if (fixed.contains("INT") && !fixed.contains("INTERVAL")) {
            return 4;
        }
        if (fixed.contains("DECIMAL")) {
            return 3;
        }
        if (fixed.contains("NUMERIC")) {
            return 2;
        }
        if (fixed.contains("CHAR") || fixed.contains("TEXT")) {
            return 12;
        }
        if (fixed.contains("BLOB")) {
            return 2004;
        }
        if (fixed.contains("CLOB")) {
            return 2005;
        }
        if (fixed.contains("REFERENCE")) {
            return 2006;
        }
        return 1111;
    }

    public static boolean isNumberType(int jdbcType) {
        boolean result;
        switch (jdbcType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static boolean isStringType(int jdbcType) {
        switch (jdbcType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateTimeType(int jdbcType) {
        switch (jdbcType) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static DasForeignKey.RuleAction getRuleAction(short value) {
        if (value == 0) {
            return DasForeignKey.RuleAction.CASCADE;
        }
        if (value == 1) {
            return DasForeignKey.RuleAction.RESTRICT;
        }
        if (value == 2) {
            return DasForeignKey.RuleAction.SET_NULL;
        }
        if (value == 3) {
            return DasForeignKey.RuleAction.NO_ACTION;
        }
        if (value == 4) {
            return DasForeignKey.RuleAction.SET_DEFAULT;
        }
        return null;
    }

    @Nullable
    public static DasForeignKey.Deferrability getDeferrability(short value) {
        if (value == 5) {
            return DasForeignKey.Deferrability.INITIALLY_DEFERRED;
        }
        if (value == 6) {
            return DasForeignKey.Deferrability.INITIALLY_IMMEDIATE;
        }
        if (value == 7) {
            return DasForeignKey.Deferrability.NOT_DEFERRABLE;
        }
        return null;
    }
}

