/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.database.util.Case;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class SqlCodeStyleSettings
extends CustomCodeStyleSettings {
    public static final int TO_UPPER = 0;
    public static final int TO_LOWER = 1;
    public static final int DO_NOT_CHANGE = 2;
    public static final int AS_KEYWORDS = 3;
    public static final int QUOTE = 0;
    public static final int UNQUOTE = 1;
    public static int[] TOKEN_CASE = new int[]{0, 1, 2};
    public static int[] TOKEN_CASE_EXT = ArrayUtil.mergeArrays((int[])new int[]{3}, (int[])TOKEN_CASE);
    public static String[] TOKEN_CASE_NAMES = new String[]{"To upper", "To lower", "Do not change"};
    public static String[] TOKEN_CASE_NAMES_EXT = ArrayUtil.mergeArrays((String[])new String[]{"As keywords"}, (String[])TOKEN_CASE_NAMES);
    public static int[] QUOTE_OPTIONS = new int[]{0, 1, 2};
    public static String[] QUOTE_OPTIONS_NAMES = new String[]{"Quote", "Unquote", "Do not change"};
    public boolean ALIGN_AS_IN_SELECT_STATEMENT = true;
    public boolean ALIGN_TYPE_IN_CREATE_STATEMENT = true;
    public boolean ALIGN_TYPE_IN_BLOCK_STATEMENT = true;
    public boolean ALIGN_TYPE_IN_ARGUMENT_DEFINITION = true;
    public boolean ALIGN_INSIDE_BINARY_EXPRESSION = true;
    public boolean ALIGN_INSIDE_QUERY_EXPRESSION = true;
    public boolean ALIGN_EQ_INSIDE_SET_CLAUSE = true;
    public boolean SPACES_AROUND_OPERATORS = true;
    public boolean NEW_LINE_BEFORE_FROM = true;
    public boolean NEW_LINE_BEFORE_JOIN = true;
    public boolean NEW_LINE_BEFORE_JOIN_CONDITION = false;
    public boolean NEW_LINE_BEFORE_WHERE = true;
    public boolean NEW_LINE_BEFORE_GROUP_BY = true;
    public boolean NEW_LINE_BEFORE_ORDER_BY = true;
    public boolean NEW_LINE_BEFORE_HAVING = true;
    public boolean NEW_LINE_BEFORE_THEN = true;
    public boolean NEW_LINE_BEFORE_ELSE = true;
    public boolean NEW_LINE_BEFORE_OTHER_CLAUSES = true;
    public boolean NEW_LINE_BEFORE_COMMA = false;
    public boolean NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS = false;
    public boolean NEW_LINE_BEFORE_QUERY_INSIDE_DML = false;
    public boolean NEW_LINE_AROUND_SEMICOLON = false;
    public boolean INDENT_JOIN = true;
    public boolean INDENT_JOIN_CONDITION = true;
    public boolean INDENT_SELECT_INTO_CLAUSE = false;
    public int WRAP_INSIDE_CREATE_TABLE = 2;
    public int WRAP_INSIDE_SELECT = 1;
    public int WRAP_INSIDE_JOIN_EXPRESSION = 1;
    public int WRAP_INSIDE_GROUP_BY = 1;
    public int WRAP_INSIDE_WHERE = 1;
    public int WRAP_INSIDE_ORDER_BY = 1;
    public int WRAP_INSIDE_SET = 1;
    public int WRAP_INSIDE_BINARY_EXPRESSION = 1;
    public int WRAP_INSIDE_ARGUMENT_DEFINITION = 1;
    public int WRAP_INSIDE_CALL_EXPRESSION = 1;
    public int WRAP_INSIDE_VALUES_EXPRESSION = 1;
    public int WRAP_VALUES_EXPRESSION = 1;
    public int WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES = 1;
    public static final int ALWAYS = 0;
    public static final int IF_MORE_THAN_ONE = 1;
    public static final int NEVER = 2;
    public boolean DISABLE_FORMATTING = false;
    public static int[] NEW_LINE_AFTER_SELECT_VALUES = new int[]{0, 1, 2};
    public static String[] NEW_LINE_AFTER_SELECT_NAMES = new String[]{"Always", "If more than one", "Never"};
    @Deprecated
    public boolean NEW_LINE_AFTER_SELECT = true;
    public int NEW_LINE_AFTER_SELECT_2 = !this.NEW_LINE_AFTER_SELECT ? 2 : 1;
    public boolean NEW_LINE_AFTER_SELECT_ITEM = true;
    public int QUOTE_IDENTIFIER = 2;
    @IdentifierCase
    public int KEYWORD_CASE = 0;
    @IdentifierCaseExt
    public int TYPE_CASE = 3;
    @IdentifierCase
    public int IDENTIFIER_CASE = 2;
    @IdentifierCase
    public int QUOTED_IDENTIFIER_CASE = 2;
    public String INDEX_NAME_TEMPLATE = "{table}_{columns}_{unique?u:}index";
    public String PRIMARY_KEY_NAME_TEMPLATE = "{table}_{columns}_pk";
    public String FOREIGN_KEY_NAME_TEMPLATE = "{table}_{ref_table}_{ref_columns}_fk";

    public SqlCodeStyleSettings(CodeStyleSettings container) {
        super("SqlCodeStyleSettings", container);
    }

    @NotNull
    public static Case getCaseMode(@IdentifierCase int codeStyleSetting) {
        Case case_ = codeStyleSetting == 0 ? Case.UPPER : (codeStyleSetting == 1 ? Case.LOWER : Case.MIXED);
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlCodeStyleSettings", "getCaseMode"));
        }
        return case_;
    }

    @NotNull
    public Case getCaseModeExt(@IdentifierCaseExt int codeStyleSetting) {
        if (codeStyleSetting == 3) {
            Case case_ = this.getCaseModeExt(this.KEYWORD_CASE);
            if (case_ == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlCodeStyleSettings", "getCaseModeExt"));
            }
            return case_;
        }
        Case case_ = SqlCodeStyleSettings.getCaseMode(codeStyleSetting);
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlCodeStyleSettings", "getCaseModeExt"));
        }
        return case_;
    }

    static @interface IdentifierCaseExt {
    }

    static @interface IdentifierCase {
    }
}

