/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.IOException;
import java.util.Locale;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.INTLMEngine;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngine;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMJCIFSEngine;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class HTTPApacheNTLMAuthentication
extends HTTPNTLMAuthentication {
    public static final String JCIFS_ENGINE = "JCIFS";
    public static final String APACHE_ENGINE = "APACHE";
    private final INTLMEngine myEngine;
    private String myLastToken = null;

    protected HTTPApacheNTLMAuthentication(String charset, String engine) {
        super(charset);
        if (JCIFS_ENGINE.equals(engine) && !NTLMJCIFSEngine.isAvailable()) {
            engine = APACHE_ENGINE;
        }
        this.myEngine = JCIFS_ENGINE.equals(engine) ? new NTLMJCIFSEngine() : new NTLMEngine();
    }

    public static HTTPNTLMAuthentication newInstance(String charset, String engine) {
        return new HTTPApacheNTLMAuthentication(charset, engine);
    }

    @Override
    public String authenticate() throws SVNException {
        String passwordOverride;
        char[] password;
        String userOverride;
        String userName;
        if (this.myState != 1 && this.myState != 3) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unsupported message type in HTTP NTLM authentication");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        String response = null;
        String domain = this.getDomain() == null ? "" : this.getDomain().toUpperCase(Locale.ENGLISH);
        String domainOverride = System.getProperty("svnkit.http.ntlm.domain");
        if (domainOverride != null) {
            domain = domainOverride.toUpperCase(Locale.ENGLISH);
        }
        String ws = "";
        String wsOverride = System.getProperty("svnkit.http.ntlm.workstation");
        if (wsOverride != null) {
            ws = wsOverride.toUpperCase(Locale.ENGLISH);
        }
        String string = userName = (userOverride = System.getProperty("svnkit.http.ntlm.user")) != null ? userOverride : this.getUserName();
        if (userName == null) {
            userName = System.getProperty("user.name", System.getenv("USERNAME"));
        }
        char[] cArray = password = (passwordOverride = System.getProperty("svnkit.http.ntlm.password")) != null ? passwordOverride.toCharArray() : this.getPassword();
        if (SVNFileUtil.isWindows) {
            boolean useDomainEnvironment = Boolean.parseBoolean(System.getProperty("svnkit.http.ntlm.domain.useEnv", "false"));
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Will try to use domain from environment: " + useDomainEnvironment);
            boolean useWsEnvironment = Boolean.parseBoolean(System.getProperty("svnkit.http.ntlm.workstation.useEnv", "true"));
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Will try to use workstation from environment: " + useWsEnvironment);
            if ("".equals(ws) && wsOverride == null && useWsEnvironment) {
                ws = System.getenv("COMPUTERNAME");
                if (ws == null) {
                    ws = "";
                }
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Workstation from environment: " + ws);
            }
            if ("".equals(domain) && domainOverride == null && useDomainEnvironment) {
                domain = System.getenv("USERDOMAIN");
                if (domain == null) {
                    domain = "";
                }
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Domain from environment: " + domain);
            }
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Domain: " + domain);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Workstation: " + ws);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "User: " + userName);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Password: " + (password != null && password.length > 0 ? "<not empty>" : "<empty or null>"));
        try {
            if (this.myState == 1) {
                response = this.myEngine.generateType1Msg(domain, ws);
            } else if (this.myState == 3) {
                response = this.myEngine.generateType3Msg(userName, password, domain, ws, this.myLastToken);
            }
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED), (Throwable)e);
        }
        if (this.isInType3State()) {
            this.setType1State();
            if (this.myLastToken != null) {
                this.myLastToken = null;
            }
        }
        return "NTLM " + response;
    }

    @Override
    public void parseChallenge(String challenge) throws SVNException {
        this.myLastToken = challenge;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public boolean allowPropmtForCredentials() {
        return true;
    }
}

