/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.base.Predicate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.RegionPainter;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyBasedArrayDataStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.JBTabbedTerminalWidget;
import org.jetbrains.plugins.terminal.JBTerminalPanel;
import org.jetbrains.plugins.terminal.JBTerminalStarter;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

public class JBTerminalWidget
extends JediTermWidget
implements Disposable {
    private final Project myProject;

    public JBTerminalWidget(Project project, JBTerminalSystemSettingsProvider settingsProvider, Disposable parent) {
        super((SettingsProvider)settingsProvider);
        this.myProject = project;
        this.setName("terminal");
        JBTabbedTerminalWidget.convertActions((JComponent)((Object)this), this.getActions());
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
        if (settingsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsProvider", "org/jetbrains/plugins/terminal/JBTerminalWidget", "createTerminalPanel"));
        }
        if (styleState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleState", "org/jetbrains/plugins/terminal/JBTerminalWidget", "createTerminalPanel"));
        }
        if (textBuffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textBuffer", "org/jetbrains/plugins/terminal/JBTerminalWidget", "createTerminalPanel"));
        }
        JBTerminalPanel panel = new JBTerminalPanel((JBTerminalSystemSettingsProvider)settingsProvider, textBuffer, styleState);
        Disposer.register((Disposable)this, (Disposable)panel);
        return panel;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(graphics));
    }

    protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
        return new JBTerminalStarter((Terminal)terminal, connector, (TerminalDataStream)new TtyBasedArrayDataStream(connector));
    }

    protected JScrollBar createScrollBar() {
        final JBScrollBar bar = new JBScrollBar();
        bar.putClientProperty(JBScrollPane.Alignment.class, (Object)JBScrollPane.Alignment.RIGHT);
        bar.putClientProperty((Object)JBScrollBar.TRACK, (Object)new RegionPainter<Object>(){

            public void paint(Graphics2D g, int x, int y, int width, int height, Object object) {
                SubstringFinder.FindResult result = JBTerminalWidget.this.myTerminalPanel.getFindResult();
                if (result != null) {
                    int modelHeight = bar.getModel().getMaximum() - bar.getModel().getMinimum();
                    int anchorHeight = Math.max(2, height / modelHeight);
                    Color color = JBTerminalWidget.this.mySettingsProvider.getTerminalColorPalette().getColor(JBTerminalWidget.this.mySettingsProvider.getFoundPatternColor().getBackground());
                    g.setColor(color);
                    for (SubstringFinder.FindResult.FindItem r : result.getItems()) {
                        int where = height * r.getStart().y / modelHeight;
                        g.fillRect(x, y + where, width, anchorHeight);
                    }
                }
            }
        });
        return bar;
    }

    public List<TerminalAction> getActions() {
        List actions = super.getActions();
        if (!TerminalOptionsProvider.getInstance().overrideIdeShortcuts()) {
            actions.add(new TerminalAction("EditorEscape", new KeyStroke[]{KeyStroke.getKeyStroke(27, 0)}, (Predicate)new Predicate<KeyEvent>(){

                public boolean apply(KeyEvent input) {
                    if (!JBTerminalWidget.this.myTerminalPanel.getTerminalTextBuffer().isUsingAlternateBuffer()) {
                        ToolWindowManager.getInstance((Project)JBTerminalWidget.this.myProject).activateEditorComponent();
                        return true;
                    }
                    return false;
                }
            }).withHidden(true));
        }
        return actions;
    }

    public void dispose() {
    }

    protected JediTermWidget.SearchComponent createSearchComponent() {
        return new JediTermWidget.SearchComponent(){
            private final SearchTextField myTextField = new SearchTextField(false);

            public String getText() {
                return this.myTextField.getText();
            }

            public JComponent getComponent() {
                this.myTextField.setOpaque(false);
                return this.myTextField;
            }

            public void addDocumentChangeListener(DocumentListener listener) {
                this.myTextField.addDocumentListener(listener);
            }

            public void addKeyListener(KeyListener listener) {
                this.myTextField.addKeyboardListener(listener);
            }

            public void onResultUpdated(SubstringFinder.FindResult result) {
            }

            public void nextFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }

            public void prevFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }
        };
    }
}

