/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider$shellPath$2;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider$startingDirectory$2;
import org.jetbrains.plugins.terminal.ValueWithDefault;

@com.intellij.openapi.components.State(name="TerminalProjectOptionsProvider", storages={@Storage(value="terminal.xml")})
@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001d\u001eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u0011R.\u0010\u0014\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0013\u001a\u0004\b\u0015\u0010\t\"\u0004\b\u0016\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$State;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultShellPath", "", "getDefaultShellPath", "()Ljava/lang/String;", "defaultStartingDirectory", "getDefaultStartingDirectory", "myState", "<set-?>", "shellPath", "getShellPath", "setShellPath", "(Ljava/lang/String;)V", "shellPath$delegate", "Lorg/jetbrains/plugins/terminal/ValueWithDefault;", "startingDirectory", "getStartingDirectory", "setStartingDirectory", "startingDirectory$delegate", "currentProjectFolder", "getState", "loadState", "", "state", "Companion", "State", "terminal"})
public final class TerminalProjectOptionsProvider
implements PersistentStateComponent<State> {
    private final State myState;
    @Nullable
    private final ValueWithDefault shellPath$delegate;
    @Nullable
    private final ValueWithDefault startingDirectory$delegate;
    private final Project myProject;
    private static final Logger LOG;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion;

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.myState.setMyShellPath(state.getMyShellPath());
        this.myState.setMyStartingDirectory(state.getMyStartingDirectory());
    }

    @Nullable
    public final String getShellPath() {
        return this.shellPath$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setShellPath(@Nullable String string) {
        this.shellPath$delegate.setValue(this, $$delegatedProperties[0], string);
    }

    @Nullable
    public final String getStartingDirectory() {
        return this.startingDirectory$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setStartingDirectory(@Nullable String string) {
        this.startingDirectory$delegate.setValue(this, $$delegatedProperties[1], string);
    }

    @Nullable
    public final String getDefaultStartingDirectory() {
        String directory = null;
        LocalTerminalCustomizer[] localTerminalCustomizerArray = (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions();
        for (int i = 0; i < localTerminalCustomizerArray.length; ++i) {
            LocalTerminalCustomizer customizer = localTerminalCustomizerArray[i];
            try {
                if (directory != null) continue;
                directory = customizer.getDefaultFolder();
                continue;
            }
            catch (Exception e) {
                TerminalProjectOptionsProvider.Companion.getLOG().error("Exception during getting default folder", (Throwable)e);
            }
        }
        String string = directory;
        if (string == null) {
            string = this.currentProjectFolder();
        }
        return string;
    }

    private final String currentProjectFolder() {
        VirtualFile baseDir;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        VirtualFile[] roots = projectRootManager.getContentRoots();
        if (((Object[])roots).length == 1) {
            roots[0].getCanonicalPath();
        }
        VirtualFile virtualFile = baseDir = this.myProject.getBaseDir();
        return virtualFile != null ? virtualFile.getCanonicalPath() : null;
    }

    @NotNull
    public final String getDefaultShellPath() {
        String shell = System.getenv("SHELL");
        if (shell != null && new File(shell).canExecute()) {
            return shell;
        }
        if (SystemInfo.isUnix) {
            if (new File("/bin/bash").exists()) {
                return "/bin/bash";
            }
            return "/bin/sh";
        }
        return "cmd.exe";
    }

    public TerminalProjectOptionsProvider(@NotNull Project myProject) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myState = new State();
        this.shellPath$delegate = new ValueWithDefault((KMutableProperty1<State, String>)TerminalProjectOptionsProvider$shellPath$2.INSTANCE, this.myState, (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ TerminalProjectOptionsProvider this$0;

            @NotNull
            public final String invoke() {
                return this.this$0.getDefaultShellPath();
            }
            {
                this.this$0 = terminalProjectOptionsProvider;
                super(0);
            }
        }));
        this.startingDirectory$delegate = new ValueWithDefault((KMutableProperty1<State, String>)TerminalProjectOptionsProvider$startingDirectory$2.INSTANCE, this.myState, (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ TerminalProjectOptionsProvider this$0;

            @Nullable
            public final String invoke() {
                return this.this$0.getDefaultStartingDirectory();
            }
            {
                this.this$0 = terminalProjectOptionsProvider;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(TerminalProjectOptionsProvider.class);
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TerminalProjectOptionsProvider.class), "shellPath", "getShellPath()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TerminalProjectOptionsProvider.class), "startingDirectory", "getStartingDirectory()Ljava/lang/String;"))};
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$State;", "", "()V", "myShellPath", "", "getMyShellPath", "()Ljava/lang/String;", "setMyShellPath", "(Ljava/lang/String;)V", "myStartingDirectory", "getMyStartingDirectory", "setMyStartingDirectory", "terminal"})
    public static final class State {
        @Nullable
        private String myShellPath;
        @Nullable
        private String myStartingDirectory;

        @Nullable
        public final String getMyShellPath() {
            return this.myShellPath;
        }

        public final void setMyShellPath(@Nullable String string) {
            this.myShellPath = string;
        }

        @Nullable
        public final String getMyStartingDirectory() {
            return this.myStartingDirectory;
        }

        public final void setMyStartingDirectory(@Nullable String string) {
            this.myStartingDirectory = string;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "terminal"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final TerminalProjectOptionsProvider getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            TerminalProjectOptionsProvider terminalProjectOptionsProvider = (TerminalProjectOptionsProvider)ServiceManager.getService((Project)project, TerminalProjectOptionsProvider.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)terminalProjectOptionsProvider, (String)"ServiceManager.getServic\u2026ionsProvider::class.java)");
            return terminalProjectOptionsProvider;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

