/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cloudconfig;

import com.jetbrains.cloudconfig.AbstractHttpClient;
import com.jetbrains.cloudconfig.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudConfigFileClient
extends AbstractHttpClient {
    public CloudConfigFileClient(String endpoint) {
        super(endpoint);
    }

    public CloudConfigFileClient(String endpoint, Configuration config) {
        super(endpoint, config);
    }

    public InputStream read(String file) throws IOException {
        return this.download("GET", this.url(file), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Content-Type", "application/octet-stream");
            }
        }, new AbstractHttpClient.StreamParser<InputStream>(){

            @Override
            public InputStream parse(InputStream stream) {
                return stream;
            }
        }, false);
    }

    public void write(String file, final InputStream content) throws IOException {
        this.upload("PUT", this.url(file), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Content-Type", "application/octet-stream");
            }
        }, new AbstractHttpClient.StreamWriter(){

            @Override
            public void write(OutputStream stream) throws IOException {
                int read;
                byte[] buf = new byte[8192];
                while ((read = content.read(buf)) != -1) {
                    stream.write(buf, 0, read);
                }
            }
        });
    }

    public void delete(String file) throws IOException {
        HttpURLConnection connection = this.config.openConnection(this.url(file));
        connection.setRequestMethod("DELETE");
        this.assertSuccess(connection);
    }

    public List<String> list(String file) throws IOException {
        return this.download("OPTIONS", this.url(file), Collections.emptyMap(), new AbstractHttpClient.StreamParser<List<String>>(){

            @Override
            public List<String> parse(InputStream stream) throws IOException {
                return (List)AbstractHttpClient.GSON.fromJson((Reader)new InputStreamReader(stream), List.class);
            }
        }, true);
    }

    private URL url(String path) throws IOException {
        return new URL(String.format("%s/%s", this.endpoint, path.replaceFirst("^/", "")));
    }
}

