/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.RestModel;

@RestModel
public class GithubErrorMessage {
    private String message;
    private List<Error> errors;

    @Nullable
    public String getMessage() {
        if (this.errors == null) {
            return this.message;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.message);
        for (Error e : this.errors) {
            s.append(String.format("<br/>[%s; %s]%s: %s", e.resource, e.field, e.code, e.message));
        }
        return s.toString();
    }

    public boolean containsReasonMessage(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/plugins/github/api/data/GithubErrorMessage", "containsReasonMessage"));
        }
        if (this.message == null) {
            return false;
        }
        return this.message.contains(reason);
    }

    public boolean containsErrorCode(@NotNull String code) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "org/jetbrains/plugins/github/api/data/GithubErrorMessage", "containsErrorCode"));
        }
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(code)) continue;
            return true;
        }
        return false;
    }

    public boolean containsErrorMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/api/data/GithubErrorMessage", "containsErrorMessage"));
        }
        if (this.errors == null) {
            return false;
        }
        for (Error error : this.errors) {
            if (error.code == null || !error.code.contains(message)) continue;
            return true;
        }
        return false;
    }

    @RestModel
    public static class Error {
        private String resource;
        private String field;
        private String code;
        private String message;
    }
}

