/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.util.ObjectUtils;
import git4idea.GitPlatformFacade;
import git4idea.GitVcs;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryManager
extends AbstractRepositoryManager<GitRepository> {
    @NotNull
    private final GitVcsSettings mySettings;
    @Nullable
    private volatile GitRebaseSpec myOngoingRebaseSpec;

    @Deprecated
    public GitRepositoryManager(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (vcsRepositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRepositoryManager", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        this(project, vcsRepositoryManager);
    }

    public GitRepositoryManager(@NotNull Project project, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        if (vcsRepositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRepositoryManager", "git4idea/repo/GitRepositoryManager", "<init>"));
        }
        super(vcsRepositoryManager, (AbstractVcs)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))), ".git");
        this.mySettings = GitVcsSettings.getInstance(project);
    }

    public boolean isSyncEnabled() {
        return this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC && !new GitMultiRootBranchConfig(this.getRepositories()).diverged();
    }

    @NotNull
    public List<GitRepository> getRepositories() {
        List list = this.getRepositories(GitRepository.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryManager", "getRepositories"));
        }
        return list;
    }

    @Nullable
    public GitRebaseSpec getOngoingRebaseSpec() {
        GitRebaseSpec rebaseSpec = this.myOngoingRebaseSpec;
        return rebaseSpec != null && rebaseSpec.isValid() ? rebaseSpec : null;
    }

    public boolean hasOngoingRebase() {
        return this.getOngoingRebaseSpec() != null;
    }

    public void setOngoingRebaseSpec(@Nullable GitRebaseSpec ongoingRebaseSpec) {
        this.myOngoingRebaseSpec = ongoingRebaseSpec != null && ongoingRebaseSpec.isValid() ? ongoingRebaseSpec : null;
    }
}

