/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.reset.GitNewResetDialog;
import git4idea.reset.GitOneCommitPerRepoLogAction;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GitResetAction
extends GitOneCommitPerRepoLogAction {
    protected void actionPerformed(final @NotNull Project project, final @NotNull Map<GitRepository, VcsFullCommitDetails> commits) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/reset/GitResetAction", "actionPerformed"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/reset/GitResetAction", "actionPerformed"));
        }
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        GitResetMode defaultMode = (GitResetMode)((Object)ObjectUtils.notNull((Object)((Object)settings.getResetMode()), (Object)((Object)GitResetMode.getDefault())));
        GitNewResetDialog dialog = new GitNewResetDialog(project, commits, defaultMode);
        if (dialog.showAndGet()) {
            final GitResetMode selectedMode = dialog.getResetMode();
            settings.setResetMode(selectedMode);
            new Task.Backgroundable(project, "Git reset", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/reset/GitResetAction$1", "run"));
                    }
                    Map<GitRepository, Hash> hashes = commits.keySet().stream().collect(Collectors.toMap(Function.identity(), repo -> {
                        if (commits == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/reset/GitResetAction$1", "lambda$run$0"));
                        }
                        return (Hash)((VcsFullCommitDetails)commits.get(repo)).getId();
                    }));
                    new GitResetOperation(project, hashes, selectedMode, indicator).execute();
                }
            }.queue();
        }
    }
}

