/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VisiblePack;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.config.GitSharedSettings;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUncommitAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(GitUncommitAction.class);
    private static final String FAILURE_TITLE = "Can't Undo Commit";
    private static final String COMMIT_NOT_IN_HEAD = "The commit is not in the current branch";
    private static final String COMMIT_PUSHED_TO_PROTECTED = "The commit is already pushed to protected branch ";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/reset/GitUncommitAction", "update"));
        }
        super.update(e);
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogData data = (VcsLogData)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || log == null || data == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        int selectedCommits = log.getSelectedShortDetails().size();
        if (selectedCommits != 1) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsShortCommitDetails commit = (VcsShortCommitDetails)log.getSelectedShortDetails().get(0);
        Hash hash = (Hash)commit.getId();
        VirtualFile root = commit.getRoot();
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(commit.getRoot());
        if (repository == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DataPack dataPack = (DataPack)((VisiblePack)ui.getDataPack()).getDataPack();
        List children = dataPack.getPermanentGraph().getChildren((Object)data.getCommitIndex(hash, root));
        if (!children.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        int parents = commit.getParents().size();
        if (parents != 1) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription("Selected commit has " + parents + " parents");
            return;
        }
        List branches = data.getContainingBranchesGetter().getContainingBranchesFromCache(root, hash);
        if (branches != null) {
            if (!branches.contains("HEAD")) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(COMMIT_NOT_IN_HEAD);
                return;
            }
            String protectedBranch = GitUncommitAction.findProtectedRemoteBranch(repository, branches);
            if (protectedBranch != null) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(COMMIT_PUSHED_TO_PROTECTED + protectedBranch);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogData data = (VcsLogData)e.getRequiredData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        VcsShortCommitDetails commit = (VcsShortCommitDetails)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((List)log.getSelectedShortDetails()));
        VirtualFile root = commit.getRoot();
        Hash hash = (Hash)commit.getId();
        GitRepository repository = (GitRepository)ObjectUtils.assertNotNull((Object)GitUtil.getRepositoryManager(project).getRepositoryForRoot(commit.getRoot()));
        List<String> branches = GitUncommitAction.findContainingBranches(data, root, hash);
        if (!branches.contains("HEAD")) {
            Messages.showErrorDialog((Project)project, (String)COMMIT_NOT_IN_HEAD, (String)FAILURE_TITLE);
            return;
        }
        String protectedBranch = GitUncommitAction.findProtectedRemoteBranch(repository, branches);
        if (protectedBranch != null) {
            Messages.showErrorDialog((Project)project, (String)(COMMIT_PUSHED_TO_PROTECTED + protectedBranch), (String)FAILURE_TITLE);
            return;
        }
        ChangeListChooser chooser = new ChangeListChooser(project, (Collection)ChangeListManager.getInstance((Project)project).getChangeListsCopy(), null, "Select Target Changelist", commit.getSubject());
        chooser.show();
        LocalChangeList selectedList = chooser.getSelectedList();
        if (selectedList != null) {
            GitUncommitAction.resetInBackground(data, repository, commit, selectedList);
        }
    }

    @NotNull
    private static List<String> findContainingBranches(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/reset/GitUncommitAction", "findContainingBranches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/reset/GitUncommitAction", "findContainingBranches"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/reset/GitUncommitAction", "findContainingBranches"));
        }
        ContainingBranchesGetter branchesGetter = data.getContainingBranchesGetter();
        List branches = branchesGetter.getContainingBranchesFromCache(root, hash);
        if (branches != null) {
            List list = branches;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitUncommitAction", "findContainingBranches"));
            }
            return list;
        }
        List list = branchesGetter.getContainingBranchesSynchronously(root, hash);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitUncommitAction", "findContainingBranches"));
        }
        return list;
    }

    @Nullable
    private static String findProtectedRemoteBranch(@NotNull GitRepository repository, @NotNull List<String> branches) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/reset/GitUncommitAction", "findProtectedRemoteBranch"));
        }
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "git4idea/reset/GitUncommitAction", "findProtectedRemoteBranch"));
        }
        GitSharedSettings settings = GitSharedSettings.getInstance(repository.getProject());
        return repository.getBranches().getRemoteBranches().stream().filter(it -> settings.isBranchProtected(it.getNameForRemoteOperations())).map(GitRemoteBranch::getNameForLocalOperations).filter(branches::contains).findAny().orElse(null);
    }

    private static void resetInBackground(final @NotNull VcsLogData data, final @NotNull GitRepository repository, final @NotNull VcsShortCommitDetails commit, final @NotNull LocalChangeList changeList) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/reset/GitUncommitAction", "resetInBackground"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/reset/GitUncommitAction", "resetInBackground"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/reset/GitUncommitAction", "resetInBackground"));
        }
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "git4idea/reset/GitUncommitAction", "resetInBackground"));
        }
        final Project project = repository.getProject();
        new Task.Backgroundable(project, "Undoing Last Commit...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection changesInCommit;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/reset/GitUncommitAction$1", "run"));
                }
                try {
                    changesInCommit = GitUncommitAction.getChangesInCommit(data, commit);
                }
                catch (VcsException e) {
                    String message = "Couldn't load changes of " + ((Hash)commit.getId()).asString();
                    LOG.warn(message, (Throwable)e);
                    Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, NotificationType.ERROR, null);
                    VcsNotifier.getInstance((Project)project).notify(notification);
                    return;
                }
                new GitResetOperation(project, Collections.singletonMap(repository, commit.getParents().get(0)), GitResetMode.SOFT, indicator).execute();
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl((Project)project);
                changeListManager.invokeAfterUpdate(() -> {
                    if (changeList == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "git4idea/reset/GitUncommitAction$1", "lambda$run$0"));
                    }
                    Collection changes = GitUncommitAction.findLocalChangesFromCommit((ChangeListManager)changeListManager, changesInCommit);
                    changeListManager.moveChangesTo(changeList, (Change[])ArrayUtil.toObjectArray((Collection)changes, Change.class));
                }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Refreshing Changes...", ModalityState.defaultModalityState());
            }
        }.queue();
    }

    @NotNull
    private static Collection<Change> getChangesInCommit(@NotNull VcsLogData data, @NotNull VcsShortCommitDetails commit) throws VcsException {
        VirtualFile root;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/reset/GitUncommitAction", "getChangesInCommit"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/reset/GitUncommitAction", "getChangesInCommit"));
        }
        Hash hash = (Hash)commit.getId();
        VcsFullCommitDetails details = GitUncommitAction.getChangesFromCache(data, hash, root = commit.getRoot());
        if (details == null) {
            details = (VcsFullCommitDetails)data.getLogProvider(root).readFullDetails(root, Collections.singletonList(hash.asString())).get(0);
        }
        Collection collection = details.getChanges();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitUncommitAction", "getChangesInCommit"));
        }
        return collection;
    }

    @Nullable
    private static VcsFullCommitDetails getChangesFromCache(@NotNull VcsLogData data, @NotNull Hash hash, @NotNull VirtualFile root) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/reset/GitUncommitAction", "getChangesFromCache"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/reset/GitUncommitAction", "getChangesFromCache"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/reset/GitUncommitAction", "getChangesFromCache"));
        }
        Ref details = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/reset/GitUncommitAction", "lambda$getChangesFromCache$1"));
            }
            if (hash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/reset/GitUncommitAction", "lambda$getChangesFromCache$1"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/reset/GitUncommitAction", "lambda$getChangesFromCache$1"));
            }
            details.set((Object)data.getCommitDetailsGetter().getCommitDataIfAvailable(data.getCommitIndex(hash, root)));
        });
        if (details.isNull() || details.get() instanceof LoadingDetails) {
            return null;
        }
        return (VcsFullCommitDetails)details.get();
    }

    @NotNull
    private static Collection<Change> findLocalChangesFromCommit(@NotNull ChangeListManager changeListManager, @NotNull Collection<Change> changesInCommit) {
        if (changeListManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListManager", "git4idea/reset/GitUncommitAction", "findLocalChangesFromCommit"));
        }
        if (changesInCommit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changesInCommit", "git4idea/reset/GitUncommitAction", "findLocalChangesFromCommit"));
        }
        OpenTHashSet allChanges = new OpenTHashSet(changeListManager.getAllChanges());
        List list = ContainerUtil.map(changesInCommit, arg_0 -> ((OpenTHashSet)allChanges).get(arg_0));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitUncommitAction", "findLocalChangesFromCommit"));
        }
        return list;
    }
}

