/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.win.WinAccessible;
import com.sun.glass.ui.win.WinChildWindow;
import com.sun.glass.ui.win.WinCommonDialogs;
import com.sun.glass.ui.win.WinCursor;
import com.sun.glass.ui.win.WinPixels;
import com.sun.glass.ui.win.WinRobot;
import com.sun.glass.ui.win.WinTimer;
import com.sun.glass.ui.win.WinView;
import com.sun.glass.ui.win.WinWindow;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.prism.impl.PrismSettings;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class WinApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    static float overrideUIScale;
    static float overrideRenderScale;
    static float minDPIScale;
    static boolean forceIntegerRenderScale;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private static boolean verbose;
    private static final int Process_DPI_Unaware = 0;
    private static final int Process_System_DPI_Aware = 1;
    private static final int Process_Per_Monitor_DPI_Aware = 2;

    private static boolean getBoolean(String propname, boolean defval, String description) {
        String str = System.getProperty(propname);
        if (str == null) {
            str = System.getenv(propname);
        }
        if (str == null) {
            return defval;
        }
        Boolean ret = Boolean.parseBoolean(str);
        if (PrismSettings.verbose) {
            System.out.println((ret != false ? "" : "not ") + description);
        }
        return ret;
    }

    private static float getFloat(String propname, float defval, String description) {
        String str = System.getProperty(propname);
        if (str == null) {
            str = System.getenv(propname);
        }
        if (str == null) {
            return defval;
        }
        float val = (str = str.trim()).endsWith("%") ? (float)Integer.parseInt(str.substring(0, str.length() - 1)) / 100.0f : (str.endsWith("DPI") || str.endsWith("dpi") ? (float)Integer.parseInt(str.substring(0, str.length() - 3)) / 96.0f : Float.parseFloat(str));
        if (PrismSettings.verbose) {
            System.out.println(description + val);
        }
        return val;
    }

    private static native void initIDs(float var0, float var1, float var2, boolean var3);

    WinApplication() {
        boolean isEventThread = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (!isEventThread) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
        } else {
            this.invokeLaterDispatcher = null;
        }
    }

    private native long _init(int var1);

    private native void _setClassLoader(ClassLoader var1);

    private native void _runLoop(Runnable var1);

    private native void _terminateLoop();

    private static int getDesiredAwarenesslevel() {
        if (!PrismSettings.allowHiDPIScaling) {
            return 0;
        }
        String awareRequested = AccessController.doPrivileged(() -> System.getProperty("javafx.glass.winDPIawareness"));
        if (awareRequested != null) {
            if ((awareRequested = awareRequested.toLowerCase()).equals("aware")) {
                return 1;
            }
            if (awareRequested.equals("permonitor")) {
                return 2;
            }
            if (!awareRequested.equals("unaware")) {
                System.err.println("unrecognized DPI awareness request, defaulting to unaware: " + awareRequested);
            }
            return 0;
        }
        return 2;
    }

    @Override
    protected void runLoop(Runnable launchable) {
        boolean isEventThread = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        int awareness = WinApplication.getDesiredAwarenesslevel();
        ClassLoader classLoader = WinApplication.class.getClassLoader();
        this._setClassLoader(classLoader);
        if (isEventThread) {
            this._init(awareness);
            WinApplication.setEventThread(Thread.currentThread());
            launchable.run();
            return;
        }
        Thread toolkitThread = AccessController.doPrivileged(() -> new Thread(() -> {
            this._init(awareness);
            this._runLoop(launchable);
        }, "WindowsNativeRunloopThread"));
        WinApplication.setEventThread(toolkitThread);
        toolkitThread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread toolkitThread = WinApplication.getEventThread();
        if (toolkitThread != null) {
            this._terminateLoop();
            WinApplication.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native Object _enterNestedEventLoopImpl();

    private native void _leaveNestedEventLoopImpl(Object var1);

    @Override
    protected Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            Object object = this._enterNestedEventLoopImpl();
            return object;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this._leaveNestedEventLoopImpl(retValue);
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new WinWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        return new WinChildWindow(parent);
    }

    @Override
    public View createView() {
        return new WinView();
    }

    @Override
    public Cursor createCursor(int type) {
        return new WinCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new WinCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
        WinCursor.setVisible_impl(visible);
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return WinCursor.getBestSize_impl(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new WinPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new WinPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data, float scale) {
        return new WinPixels(width, height, data, scale);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return WinPixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        return new WinRobot();
    }

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    public Timer createTimer(Runnable runnable) {
        return new WinTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return WinTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return WinTimer.getMaxPeriod_impl();
    }

    @Override
    public Accessible createAccessible() {
        return new WinAccessible();
    }

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window owner, String folder, String filename, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters, int defaultFilterIndex) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        return WinCommonDialogs.showFileChooser_impl(owner, folder, filename, title, type, multipleMode, extensionFilters, defaultFilterIndex);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        return WinCommonDialogs.showFolderChooser_impl(owner, folder, title);
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return WinView.getMultiClickTime_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return WinView.getMultiClickMaxX_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return WinView.getMultiClickMaxY_impl();
    }

    @Override
    protected native void _invokeAndWait(Runnable var1);

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable r) {
        this._submitForLaterInvocation(r);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
        } else {
            this.submitForLaterInvocation(runnable);
        }
    }

    private native String _getHighContrastTheme();

    @Override
    public String getHighContrastTheme() {
        WinApplication.checkEventThread();
        return this._getHighContrastTheme();
    }

    @Override
    protected boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected boolean _supportsTransparentWindows() {
        return true;
    }

    @Override
    protected native boolean _supportsUnifiedWindows();

    @Override
    public String getDataDirectory() {
        WinApplication.checkEventThread();
        String baseDirectory = AccessController.doPrivileged(() -> System.getenv("APPDATA"));
        if (baseDirectory == null || baseDirectory.length() == 0) {
            return super.getDataDirectory();
        }
        return baseDirectory + File.separator + this.name + File.separator;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                block7: {
                    block6: {
                        verbose = Boolean.getBoolean("javafx.verbose");
                        if (PrismSettings.allowHiDPIScaling) {
                            overrideUIScale = WinApplication.getFloat("glass.win.uiScale", -1.0f, "Forcing UI scaling factor: ");
                            overrideRenderScale = WinApplication.getFloat("glass.win.renderScale", -1.0f, "Forcing Rendering scaling factor: ");
                            minDPIScale = WinApplication.getFloat("glass.win.minHiDPI", 1.5f, "Threshold to enable UI scaling factor: ");
                            forceIntegerRenderScale = WinApplication.getBoolean("glass.win.forceIntegerRenderScale", true, "forcing integer rendering scale");
                        } else {
                            overrideRenderScale = 1.0f;
                            overrideUIScale = 1.0f;
                            minDPIScale = Float.MAX_VALUE;
                            forceIntegerRenderScale = false;
                        }
                        try {
                            NativeLibLoader.loadLibrary("msvcr120");
                        }
                        catch (Throwable t) {
                            if (!verbose) break block6;
                            System.err.println("Error: failed to load msvcr120.dll : " + t);
                        }
                    }
                    try {
                        NativeLibLoader.loadLibrary("msvcp120");
                    }
                    catch (Throwable t) {
                        if (!verbose) break block7;
                        System.err.println("Error: failed to load msvcp120.dll : " + t);
                    }
                }
                WinApplication.loadNativeLibrary();
                return null;
            }
        });
        WinApplication.initIDs(overrideUIScale, overrideRenderScale, minDPIScale, forceIntegerRenderScale);
    }
}

