/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml;

import com.sun.javafx.fxml.PropertyNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import sun.reflect.misc.FieldUtil;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public class BeanAdapter
extends AbstractMap<String, Object> {
    private final Object bean;
    private static final HashMap<Class<?>, MethodCache> globalMethodCache = new HashMap();
    private final MethodCache localCache;
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String SET_PREFIX = "set";
    public static final String PROPERTY_SUFFIX = "Property";
    public static final String VALUE_OF_METHOD_NAME = "valueOf";

    public BeanAdapter(Object bean) {
        this.bean = bean;
        this.localCache = BeanAdapter.getClassMethodCache(bean.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MethodCache getClassMethodCache(final Class<?> type) {
        if (type == Object.class) {
            return null;
        }
        HashMap<Class<?>, MethodCache> hashMap = globalMethodCache;
        synchronized (hashMap) {
            MethodCache classMethodCache = globalMethodCache.get(type);
            if (classMethodCache != null) {
                return classMethodCache;
            }
            HashMap<String, ArrayList<Method>> classMethods = new HashMap<String, ArrayList<Method>>();
            ReflectUtil.checkPackageAccess(type);
            if (Modifier.isPublic(type.getModifiers())) {
                Method[] declaredMethods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                    @Override
                    public Method[] run() {
                        return type.getDeclaredMethods();
                    }
                });
                for (int i = 0; i < declaredMethods.length; ++i) {
                    Method method = declaredMethods[i];
                    int modifiers = method.getModifiers();
                    if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
                    String name = method.getName();
                    ArrayList<Method> namedMethods = (ArrayList<Method>)classMethods.get(name);
                    if (namedMethods == null) {
                        namedMethods = new ArrayList<Method>();
                        classMethods.put(name, namedMethods);
                    }
                    namedMethods.add(method);
                }
            }
            MethodCache cache = new MethodCache(classMethods, BeanAdapter.getClassMethodCache(type.getSuperclass()));
            globalMethodCache.put(type, cache);
            return cache;
        }
    }

    public Object getBean() {
        return this.bean;
    }

    private Method getGetterMethod(String key) {
        Method getterMethod = this.localCache.getMethod(BeanAdapter.getMethodName(GET_PREFIX, key), new Class[0]);
        if (getterMethod == null) {
            getterMethod = this.localCache.getMethod(BeanAdapter.getMethodName(IS_PREFIX, key), new Class[0]);
        }
        return getterMethod;
    }

    private Method getSetterMethod(String key) {
        Class<?> type = this.getType(key);
        if (type == null) {
            throw new UnsupportedOperationException("Cannot determine type for property.");
        }
        return this.localCache.getMethod(BeanAdapter.getMethodName(SET_PREFIX, key), new Class[]{type});
    }

    private static String getMethodName(String prefix, String key) {
        return prefix + Character.toUpperCase(key.charAt(0)) + key.substring(1);
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.get(key.toString());
    }

    private Object get(String key) {
        Object value;
        Method getterMethod;
        Method method = getterMethod = key.endsWith(PROPERTY_SUFFIX) ? this.localCache.getMethod(key, new Class[0]) : this.getGetterMethod(key);
        if (getterMethod != null) {
            try {
                value = MethodUtil.invoke(getterMethod, this.bean, null);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        Method setterMethod = this.getSetterMethod(key);
        if (setterMethod == null) {
            throw new PropertyNotFoundException("Property \"" + key + "\" does not exist" + " or is read-only.");
        }
        try {
            MethodUtil.invoke(setterMethod, this.bean, new Object[]{BeanAdapter.coerce(value, this.getType(key))});
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
        catch (InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.getType(key.toString()) != null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.getSetterMethod(key) == null;
    }

    public <T> ObservableValue<T> getPropertyModel(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (ObservableValue)this.get(key + PROPERTY_SUFFIX);
    }

    public Class<?> getType(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Method getterMethod = this.getGetterMethod(key);
        return getterMethod == null ? null : getterMethod.getReturnType();
    }

    public Type getGenericType(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Method getterMethod = this.getGetterMethod(key);
        return getterMethod == null ? null : getterMethod.getGenericReturnType();
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof BeanAdapter) {
            BeanAdapter beanAdapter = (BeanAdapter)object;
            equals = this.bean == beanAdapter.bean;
        }
        return equals;
    }

    @Override
    public int hashCode() {
        return this.bean == null ? -1 : this.bean.hashCode();
    }

    public static <T> T coerce(Object value, Class<? extends T> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        Object coercedValue = null;
        if (value == null) {
            coercedValue = null;
        } else if (type.isAssignableFrom(value.getClass())) {
            coercedValue = value;
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            coercedValue = Boolean.valueOf(value.toString());
        } else if (type == Character.class || type == Character.TYPE) {
            coercedValue = Character.valueOf(value.toString().charAt(0));
        } else if (type == Byte.class || type == Byte.TYPE) {
            coercedValue = value instanceof Number ? Byte.valueOf(((Number)value).byteValue()) : Byte.valueOf(value.toString());
        } else if (type == Short.class || type == Short.TYPE) {
            coercedValue = value instanceof Number ? Short.valueOf(((Number)value).shortValue()) : Short.valueOf(value.toString());
        } else if (type == Integer.class || type == Integer.TYPE) {
            coercedValue = value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : Integer.valueOf(value.toString());
        } else if (type == Long.class || type == Long.TYPE) {
            coercedValue = value instanceof Number ? Long.valueOf(((Number)value).longValue()) : Long.valueOf(value.toString());
        } else if (type == BigInteger.class) {
            coercedValue = value instanceof Number ? BigInteger.valueOf(((Number)value).longValue()) : new BigInteger(value.toString());
        } else if (type == Float.class || type == Float.TYPE) {
            coercedValue = value instanceof Number ? Float.valueOf(((Number)value).floatValue()) : Float.valueOf(value.toString());
        } else if (type == Double.class || type == Double.TYPE) {
            coercedValue = value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : Double.valueOf(value.toString());
        } else if (type == Number.class) {
            String number = value.toString();
            coercedValue = number.contains(".") ? (Number)Double.valueOf(number) : (Number)Long.valueOf(number);
        } else if (type == BigDecimal.class) {
            coercedValue = value instanceof Number ? BigDecimal.valueOf(((Number)value).doubleValue()) : new BigDecimal(value.toString());
        } else {
            if (type == Class.class) {
                try {
                    String className = value.toString();
                    ReflectUtil.checkPackageAccess(className);
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    coercedValue = Class.forName(className, false, cl);
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalArgumentException(exception);
                }
            }
            Class<?> valueType = value.getClass();
            Method valueOfMethod = null;
            while (valueOfMethod == null && valueType != null) {
                try {
                    ReflectUtil.checkPackageAccess(type);
                    valueOfMethod = type.getDeclaredMethod(VALUE_OF_METHOD_NAME, valueType);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (valueOfMethod != null) continue;
                valueType = valueType.getSuperclass();
            }
            if (valueOfMethod == null) {
                throw new IllegalArgumentException("Unable to coerce " + value + " to " + type + ".");
            }
            if (type.isEnum() && value instanceof String && Character.isLowerCase(((String)value).charAt(0))) {
                value = BeanAdapter.toAllCaps((String)value);
            }
            try {
                coercedValue = MethodUtil.invoke(valueOfMethod, null, new Object[]{value});
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
            catch (SecurityException exception) {
                throw new RuntimeException(exception);
            }
        }
        return (T)coercedValue;
    }

    public static <T> T get(Object target, Class<?> sourceType, String key) {
        Object value = null;
        Class<?> targetType = target.getClass();
        Method getterMethod = BeanAdapter.getStaticGetterMethod(sourceType, key, targetType);
        if (getterMethod != null) {
            try {
                value = MethodUtil.invoke(getterMethod, null, new Object[]{target});
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
        return (T)value;
    }

    public static void put(Object target, Class<?> sourceType, String key, Object value) {
        Class<?> propertyType;
        Class<?> targetType = target.getClass();
        Method setterMethod = null;
        if (value != null) {
            setterMethod = BeanAdapter.getStaticSetterMethod(sourceType, key, value.getClass(), targetType);
        }
        if (setterMethod == null && (propertyType = BeanAdapter.getType(sourceType, key, targetType)) != null) {
            setterMethod = BeanAdapter.getStaticSetterMethod(sourceType, key, propertyType, targetType);
            value = BeanAdapter.coerce(value, propertyType);
        }
        if (setterMethod == null) {
            throw new PropertyNotFoundException("Static property \"" + key + "\" does not exist" + " or is read-only.");
        }
        try {
            MethodUtil.invoke(setterMethod, null, new Object[]{target, value});
        }
        catch (InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean isDefined(Class<?> sourceType, String key, Class<?> targetType) {
        return BeanAdapter.getStaticGetterMethod(sourceType, key, targetType) != null;
    }

    public static Class<?> getType(Class<?> sourceType, String key, Class<?> targetType) {
        Method getterMethod = BeanAdapter.getStaticGetterMethod(sourceType, key, targetType);
        return getterMethod == null ? null : getterMethod.getReturnType();
    }

    public static Type getGenericType(Class<?> sourceType, String key, Class<?> targetType) {
        Method getterMethod = BeanAdapter.getStaticGetterMethod(sourceType, key, targetType);
        return getterMethod == null ? null : getterMethod.getGenericReturnType();
    }

    public static Class<?> getListItemType(Type listType) {
        Type itemType = BeanAdapter.getGenericListItemType(listType);
        if (itemType instanceof ParameterizedType) {
            itemType = ((ParameterizedType)itemType).getRawType();
        }
        return (Class)itemType;
    }

    public static Class<?> getMapValueType(Type mapType) {
        Type valueType = BeanAdapter.getGenericMapValueType(mapType);
        if (valueType instanceof ParameterizedType) {
            valueType = ((ParameterizedType)valueType).getRawType();
        }
        return (Class)valueType;
    }

    public static Type getGenericListItemType(Type listType) {
        Object itemType = null;
        Type parentType = listType;
        while (parentType != null) {
            if (parentType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)parentType;
                Class rawType = (Class)parameterizedType.getRawType();
                if (!List.class.isAssignableFrom(rawType)) break;
                itemType = parameterizedType.getActualTypeArguments()[0];
                break;
            }
            Class classType = (Class)parentType;
            Type[] genericInterfaces = classType.getGenericInterfaces();
            for (int i = 0; i < genericInterfaces.length; ++i) {
                ParameterizedType parameterizedType;
                Class interfaceType;
                Type genericInterface = genericInterfaces[i];
                if (!(genericInterface instanceof ParameterizedType) || !List.class.isAssignableFrom(interfaceType = (Class)(parameterizedType = (ParameterizedType)genericInterface).getRawType())) continue;
                itemType = parameterizedType.getActualTypeArguments()[0];
                break;
            }
            if (itemType != null) break;
            parentType = classType.getGenericSuperclass();
        }
        if (itemType != null && itemType instanceof TypeVariable) {
            itemType = Object.class;
        }
        return itemType;
    }

    public static Type getGenericMapValueType(Type mapType) {
        Object valueType = null;
        Type parentType = mapType;
        while (parentType != null) {
            if (parentType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)parentType;
                Class rawType = (Class)parameterizedType.getRawType();
                if (!Map.class.isAssignableFrom(rawType)) break;
                valueType = parameterizedType.getActualTypeArguments()[1];
                break;
            }
            Class classType = (Class)parentType;
            Type[] genericInterfaces = classType.getGenericInterfaces();
            for (int i = 0; i < genericInterfaces.length; ++i) {
                ParameterizedType parameterizedType;
                Class interfaceType;
                Type genericInterface = genericInterfaces[i];
                if (!(genericInterface instanceof ParameterizedType) || !Map.class.isAssignableFrom(interfaceType = (Class)(parameterizedType = (ParameterizedType)genericInterface).getRawType())) continue;
                valueType = parameterizedType.getActualTypeArguments()[1];
                break;
            }
            if (valueType != null) break;
            parentType = classType.getGenericSuperclass();
        }
        if (valueType != null && valueType instanceof TypeVariable) {
            valueType = Object.class;
        }
        return valueType;
    }

    public static Object getConstantValue(Class<?> type, String name) {
        Object value;
        Field field;
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        try {
            field = FieldUtil.getField(type, name);
        }
        catch (NoSuchFieldException exception) {
            throw new IllegalArgumentException(exception);
        }
        int fieldModifiers = field.getModifiers();
        if ((fieldModifiers & 8) == 0 || (fieldModifiers & 0x10) == 0) {
            throw new IllegalArgumentException("Field is not a constant.");
        }
        try {
            value = field.get(null);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalArgumentException(exception);
        }
        return value;
    }

    private static Method getStaticGetterMethod(Class<?> sourceType, String key, Class<?> targetType) {
        if (sourceType == null) {
            throw new NullPointerException();
        }
        if (key == null) {
            throw new NullPointerException();
        }
        Method method = null;
        if (targetType != null) {
            key = Character.toUpperCase(key.charAt(0)) + key.substring(1);
            String getMethodName = GET_PREFIX + key;
            String isMethodName = IS_PREFIX + key;
            try {
                method = MethodUtil.getMethod(sourceType, getMethodName, new Class[]{targetType});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                try {
                    method = MethodUtil.getMethod(sourceType, isMethodName, new Class[]{targetType});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (method == null) {
                Class<?>[] interfaces = targetType.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    try {
                        method = MethodUtil.getMethod(sourceType, getMethodName, new Class[]{interfaces[i]});
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method == null) {
                        try {
                            method = MethodUtil.getMethod(sourceType, isMethodName, new Class[]{interfaces[i]});
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (method != null) break;
                }
            }
            if (method == null) {
                method = BeanAdapter.getStaticGetterMethod(sourceType, key, targetType.getSuperclass());
            }
        }
        return method;
    }

    private static Method getStaticSetterMethod(Class<?> sourceType, String key, Class<?> valueType, Class<?> targetType) {
        if (sourceType == null) {
            throw new NullPointerException();
        }
        if (key == null) {
            throw new NullPointerException();
        }
        if (valueType == null) {
            throw new NullPointerException();
        }
        Method method = null;
        if (targetType != null) {
            key = Character.toUpperCase(key.charAt(0)) + key.substring(1);
            String setMethodName = SET_PREFIX + key;
            try {
                method = MethodUtil.getMethod(sourceType, setMethodName, new Class[]{targetType, valueType});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                Class<?>[] interfaces = targetType.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    try {
                        method = MethodUtil.getMethod(sourceType, setMethodName, new Class[]{interfaces[i], valueType});
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null) break;
                }
            }
            if (method == null) {
                method = BeanAdapter.getStaticSetterMethod(sourceType, key, valueType, targetType.getSuperclass());
            }
        }
        return method;
    }

    private static String toAllCaps(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        StringBuilder allCapsBuilder = new StringBuilder();
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                allCapsBuilder.append('_');
            }
            allCapsBuilder.append(Character.toUpperCase(c));
        }
        return allCapsBuilder.toString();
    }

    private static class MethodCache {
        private final Map<String, List<Method>> methods;
        private final MethodCache nextClassCache;

        private MethodCache(Map<String, List<Method>> methods, MethodCache nextClassCache) {
            this.methods = methods;
            this.nextClassCache = nextClassCache;
        }

        private Method getMethod(String name, Class<?> ... parameterTypes) {
            List<Method> namedMethods = this.methods.get(name);
            if (namedMethods != null) {
                for (int i = 0; i < namedMethods.size(); ++i) {
                    Method namedMethod = namedMethods.get(i);
                    if (!namedMethod.getName().equals(name) || !Arrays.equals(namedMethod.getParameterTypes(), parameterTypes)) continue;
                    return namedMethod;
                }
            }
            return this.nextClassCache != null ? this.nextClassCache.getMethod(name, parameterTypes) : null;
        }
    }
}

