/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.events.ViewEvent;
import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.scene.input.KeyCodeMap;
import com.sun.javafx.tk.quantum.GestureRecognizers;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.RotateGestureRecognizer;
import com.sun.javafx.tk.quantum.ScrollGestureRecognizer;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.javafx.tk.quantum.ZoomGestureRecognizer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchPoint;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;

class GlassViewEventHandler
extends View.EventHandler {
    static boolean zoomGestureEnabled;
    static boolean rotateGestureEnabled;
    static boolean scrollGestureEnabled;
    private ViewScene scene;
    private final GlassSceneDnDEventHandler dndHandler;
    private final GestureRecognizers gestures;
    private final PaintCollector collector = PaintCollector.getInstance();
    private final KeyEventNotification keyNotification = new KeyEventNotification();
    private int mouseButtonPressedMask = 0;
    private final MouseEventNotification mouseNotification = new MouseEventNotification();
    private ClipboardAssistance dropSourceAssistant;
    private final ViewEventNotification viewNotification = new ViewEventNotification();

    public GlassViewEventHandler(ViewScene scene) {
        this.scene = scene;
        this.dndHandler = new GlassSceneDnDEventHandler(scene);
        this.gestures = new GestureRecognizers();
        if (PlatformUtil.isWindows() || PlatformUtil.isIOS() || PlatformUtil.isEmbedded()) {
            this.gestures.add(new SwipeGestureRecognizer(scene));
        }
        if (zoomGestureEnabled) {
            this.gestures.add(new ZoomGestureRecognizer(scene));
        }
        if (rotateGestureEnabled) {
            this.gestures.add(new RotateGestureRecognizer(scene));
        }
        if (scrollGestureEnabled) {
            this.gestures.add(new ScrollGestureRecognizer(scene));
        }
    }

    private static boolean allowableFullScreenKeys(int key) {
        switch (key) {
            case 9: 
            case 10: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private boolean checkFullScreenKeyEvent(int type, int key, char[] chars, int modifiers) {
        return this.scene.getWindowStage().isTrustedFullScreen() || GlassViewEventHandler.allowableFullScreenKeys(key);
    }

    private static EventType<KeyEvent> keyEventType(int glassType) {
        switch (glassType) {
            case 111: {
                return KeyEvent.KEY_PRESSED;
            }
            case 112: {
                return KeyEvent.KEY_RELEASED;
            }
            case 113: {
                return KeyEvent.KEY_TYPED;
            }
        }
        if (QuantumToolkit.verbose) {
            System.err.println("Unknown Glass key event type: " + glassType);
        }
        return null;
    }

    @Override
    public void handleKeyEvent(View view, long time, int type, int key, char[] chars, int modifiers) {
        this.keyNotification.view = view;
        this.keyNotification.time = time;
        this.keyNotification.type = type;
        this.keyNotification.key = key;
        this.keyNotification.chars = chars;
        this.keyNotification.modifiers = modifiers;
        QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(this.keyNotification, this.scene.getAccessControlContext()));
    }

    private static EventType<MouseEvent> mouseEventType(int glassType) {
        switch (glassType) {
            case 221: {
                return MouseEvent.MOUSE_PRESSED;
            }
            case 222: {
                return MouseEvent.MOUSE_RELEASED;
            }
            case 225: {
                return MouseEvent.MOUSE_ENTERED;
            }
            case 226: {
                return MouseEvent.MOUSE_EXITED;
            }
            case 224: {
                return MouseEvent.MOUSE_MOVED;
            }
            case 223: {
                return MouseEvent.MOUSE_DRAGGED;
            }
            case 228: {
                throw new IllegalArgumentException("WHEEL event cannot be translated to MouseEvent, must be translated to ScrollEvent");
            }
        }
        if (QuantumToolkit.verbose) {
            System.err.println("Unknown Glass mouse event type: " + glassType);
        }
        return null;
    }

    private static MouseButton mouseEventButton(int glassButton) {
        switch (glassButton) {
            case 212: {
                return MouseButton.PRIMARY;
            }
            case 213: {
                return MouseButton.SECONDARY;
            }
            case 214: {
                return MouseButton.MIDDLE;
            }
        }
        return MouseButton.NONE;
    }

    @Override
    public void handleMouseEvent(View view, long time, int type, int button, int x, int y, int xAbs, int yAbs, int modifiers, boolean isPopupTrigger, boolean isSynthesized) {
        this.mouseNotification.view = view;
        this.mouseNotification.time = time;
        this.mouseNotification.type = type;
        this.mouseNotification.button = button;
        this.mouseNotification.x = x;
        this.mouseNotification.y = y;
        this.mouseNotification.xAbs = xAbs;
        this.mouseNotification.yAbs = yAbs;
        this.mouseNotification.modifiers = modifiers;
        this.mouseNotification.isPopupTrigger = isPopupTrigger;
        this.mouseNotification.isSynthesized = isSynthesized;
        QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(this.mouseNotification, this.scene.getAccessControlContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMenuEvent(View view, int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("MENU_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double sy;
                    double sx;
                    double pScale;
                    Window w = view.getWindow();
                    if (w != null) {
                        pScale = w.getPlatformScale();
                        Screen scr = w.getScreen();
                        if (scr != null) {
                            sx = scr.getX();
                            sy = scr.getY();
                        } else {
                            sy = 0.0;
                            sx = 0.0;
                        }
                    } else {
                        pScale = 1.0;
                        sy = 0.0;
                        sx = 0.0;
                    }
                    this.scene.sceneListener.menuEvent((double)x / pScale, (double)y / pScale, sx + ((double)xAbs - sx) / pScale, sy + ((double)yAbs - sy) / pScale, isKeyboardTrigger);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleScrollEvent(View view, long time, int x, int y, int xAbs, int yAbs, double deltaX, double deltaY, int modifiers, int lines, int chars, int defaultLines, int defaultChars, double xMultiplier, double yMultiplier) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("SCROLL_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    Window w = view.getWindow();
                    double pScale = w == null ? 1.0 : (double)w.getPlatformScale();
                    this.scene.sceneListener.scrollEvent(ScrollEvent.SCROLL, deltaX / pScale, deltaY / pScale, 0.0, 0.0, xMultiplier, yMultiplier, 0, chars, lines, defaultChars, defaultLines, (double)x / pScale, (double)y / pScale, (double)xAbs / pScale, (double)yAbs / pScale, (modifiers & 1) != 0, (modifiers & 4) != 0, (modifiers & 8) != 0, (modifiers & 0x10) != 0, false, false);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    private static byte inputMethodEventAttrValue(int pos, int[] attrBoundary, byte[] attrValue) {
        if (attrBoundary != null) {
            for (int current = 0; current < attrBoundary.length - 1; ++current) {
                if (pos < attrBoundary[current] || pos >= attrBoundary[current + 1]) continue;
                return attrValue[current];
            }
        }
        return 4;
    }

    private static ObservableList<InputMethodTextRun> inputMethodEventComposed(String text, int commitCount, int[] clauseBoundary, int[] attrBoundary, byte[] attrValue) {
        TrackableObservableList<InputMethodTextRun> composed = new TrackableObservableList<InputMethodTextRun>(){

            @Override
            protected void onChanged(ListChangeListener.Change<InputMethodTextRun> c) {
            }
        };
        if (commitCount < text.length()) {
            if (clauseBoundary == null) {
                composed.add(new InputMethodTextRun(text.substring(commitCount), InputMethodHighlight.UNSELECTED_RAW));
            } else {
                for (int current = 0; current < clauseBoundary.length - 1; ++current) {
                    InputMethodHighlight highlight;
                    if (clauseBoundary[current] < commitCount) continue;
                    switch (GlassViewEventHandler.inputMethodEventAttrValue(clauseBoundary[current], attrBoundary, attrValue)) {
                        case 1: {
                            highlight = InputMethodHighlight.SELECTED_CONVERTED;
                            break;
                        }
                        case 2: {
                            highlight = InputMethodHighlight.UNSELECTED_CONVERTED;
                            break;
                        }
                        case 3: {
                            highlight = InputMethodHighlight.SELECTED_RAW;
                            break;
                        }
                        default: {
                            highlight = InputMethodHighlight.UNSELECTED_RAW;
                        }
                    }
                    composed.add(new InputMethodTextRun(text.substring(clauseBoundary[current], clauseBoundary[current + 1]), highlight));
                }
            }
        }
        return composed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInputMethodEvent(long time, String text, int[] clauseBoundary, int[] attrBoundary, byte[] attrValue, int commitCount, int cursorPos) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("INPUT_METHOD_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    String t = text != null ? text : "";
                    EventType<InputMethodEvent> eventType = InputMethodEvent.INPUT_METHOD_TEXT_CHANGED;
                    ObservableList<InputMethodTextRun> composed = GlassViewEventHandler.inputMethodEventComposed(t, commitCount, clauseBoundary, attrBoundary, attrValue);
                    String committed = t.substring(0, commitCount);
                    this.scene.sceneListener.inputMethodEvent(eventType, composed, committed, cursorPos);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    @Override
    public double[] getInputMethodCandidatePos(int offset) {
        Point2D p2d = this.scene.inputMethodRequests.getTextLocation(offset);
        double[] ret = new double[]{p2d.getX(), p2d.getY()};
        return ret;
    }

    private static TransferMode actionToTransferMode(int dropActions) {
        if (dropActions == 0) {
            return null;
        }
        if (dropActions == 1 || dropActions == 0x40000001) {
            return TransferMode.COPY;
        }
        if (dropActions == 2 || dropActions == 0x40000002) {
            return TransferMode.MOVE;
        }
        if (dropActions == 0x40000000) {
            return TransferMode.LINK;
        }
        if (dropActions == 3) {
            if (QuantumToolkit.verbose) {
                System.err.println("Ambiguous drop action: " + Integer.toHexString(dropActions));
            }
        } else if (QuantumToolkit.verbose) {
            System.err.println("Unknown drop action: " + Integer.toHexString(dropActions));
        }
        return null;
    }

    private static int transferModeToAction(TransferMode tm) {
        if (tm == null) {
            return 0;
        }
        switch (tm) {
            case COPY: {
                return 1;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 0x40000000;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleDragEnter(View view, int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
        TransferMode action;
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_ENTER");
        }
        try {
            action = QuantumToolkit.runWithoutRenderLock(() -> this.dndHandler.handleDragEnter(x, y, xAbs, yAbs, GlassViewEventHandler.actionToTransferMode(recommendedDropAction), dropTargetAssistant));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        return GlassViewEventHandler.transferModeToAction(action);
    }

    @Override
    public void handleDragLeave(View view, ClipboardAssistance dropTargetAssistant) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_LEAVE");
        }
        try {
            QuantumToolkit.runWithoutRenderLock(() -> {
                this.dndHandler.handleDragLeave(dropTargetAssistant);
                return null;
            });
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleDragDrop(View view, int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
        TransferMode action;
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_DROP");
        }
        try {
            action = QuantumToolkit.runWithoutRenderLock(() -> this.dndHandler.handleDragDrop(x, y, xAbs, yAbs, GlassViewEventHandler.actionToTransferMode(recommendedDropAction), dropTargetAssistant));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        return GlassViewEventHandler.transferModeToAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleDragOver(View view, int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
        TransferMode action;
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_OVER");
        }
        try {
            action = QuantumToolkit.runWithoutRenderLock(() -> this.dndHandler.handleDragOver(x, y, xAbs, yAbs, GlassViewEventHandler.actionToTransferMode(recommendedDropAction), dropTargetAssistant));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        return GlassViewEventHandler.transferModeToAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDragStart(View view, int button, int x, int y, int xAbs, int yAbs, ClipboardAssistance assistant) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_START");
        }
        this.dropSourceAssistant = assistant;
        try {
            QuantumToolkit.runWithoutRenderLock(() -> {
                this.dndHandler.handleDragStart(button, x, y, xAbs, yAbs, assistant);
                return null;
            });
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    @Override
    public void handleDragEnd(View view, int performedAction) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_END");
        }
        try {
            QuantumToolkit.runWithoutRenderLock(() -> {
                this.dndHandler.handleDragEnd(GlassViewEventHandler.actionToTransferMode(performedAction), this.dropSourceAssistant);
                return null;
            });
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleViewEvent(View view, long time, int type) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("VIEW_EVENT: " + ViewEvent.getTypeString(type));
        }
        this.viewNotification.view = view;
        this.viewNotification.time = time;
        this.viewNotification.type = type;
        try {
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(this.viewNotification, this.scene.getAccessControlContext()));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleScrollGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int x, int y, int xAbs, int yAbs, double dx, double dy, double totaldx, double totaldy, double multiplierX, double multiplierY) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("SCROLL_GESTURE_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    EventType<ScrollEvent> eventType;
                    switch (type) {
                        case 1: {
                            eventType = ScrollEvent.SCROLL_STARTED;
                            break;
                        }
                        case 2: {
                            eventType = ScrollEvent.SCROLL;
                            break;
                        }
                        case 3: {
                            eventType = ScrollEvent.SCROLL_FINISHED;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown scroll event type: " + type);
                        }
                    }
                    Window w = view.getWindow();
                    double pScale = w == null ? 1.0 : (double)w.getPlatformScale();
                    this.scene.sceneListener.scrollEvent(eventType, dx / pScale, dy / pScale, totaldx / pScale, totaldy / pScale, multiplierX, multiplierY, touchCount, 0, 0, 0, 0, x == Integer.MAX_VALUE ? Double.NaN : (double)x / pScale, y == Integer.MAX_VALUE ? Double.NaN : (double)y / pScale, xAbs == Integer.MAX_VALUE ? Double.NaN : (double)xAbs / pScale, yAbs == Integer.MAX_VALUE ? Double.NaN : (double)yAbs / pScale, (modifiers & 1) != 0, (modifiers & 4) != 0, (modifiers & 8) != 0, (modifiers & 0x10) != 0, isDirect, isInertia);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleZoomGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int originx, int originy, int originxAbs, int originyAbs, double scale, double expansion, double totalscale, double totalexpansion) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("ZOOM_GESTURE_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    EventType<ZoomEvent> eventType;
                    switch (type) {
                        case 1: {
                            eventType = ZoomEvent.ZOOM_STARTED;
                            break;
                        }
                        case 2: {
                            eventType = ZoomEvent.ZOOM;
                            break;
                        }
                        case 3: {
                            eventType = ZoomEvent.ZOOM_FINISHED;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown scroll event type: " + type);
                        }
                    }
                    Window w = view.getWindow();
                    double pScale = w == null ? 1.0 : (double)w.getPlatformScale();
                    this.scene.sceneListener.zoomEvent(eventType, scale, totalscale, originx == Integer.MAX_VALUE ? Double.NaN : (double)originx / pScale, originy == Integer.MAX_VALUE ? Double.NaN : (double)originy / pScale, originxAbs == Integer.MAX_VALUE ? Double.NaN : (double)originxAbs / pScale, originyAbs == Integer.MAX_VALUE ? Double.NaN : (double)originyAbs / pScale, (modifiers & 1) != 0, (modifiers & 4) != 0, (modifiers & 8) != 0, (modifiers & 0x10) != 0, isDirect, isInertia);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRotateGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int originx, int originy, int originxAbs, int originyAbs, double dangle, double totalangle) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("ROTATE_GESTURE_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    EventType<RotateEvent> eventType;
                    switch (type) {
                        case 1: {
                            eventType = RotateEvent.ROTATION_STARTED;
                            break;
                        }
                        case 2: {
                            eventType = RotateEvent.ROTATE;
                            break;
                        }
                        case 3: {
                            eventType = RotateEvent.ROTATION_FINISHED;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown scroll event type: " + type);
                        }
                    }
                    Window w = view.getWindow();
                    double pScale = w == null ? 1.0 : (double)w.getPlatformScale();
                    this.scene.sceneListener.rotateEvent(eventType, dangle, totalangle, originx == Integer.MAX_VALUE ? Double.NaN : (double)originx / pScale, originy == Integer.MAX_VALUE ? Double.NaN : (double)originy / pScale, originxAbs == Integer.MAX_VALUE ? Double.NaN : (double)originxAbs / pScale, originyAbs == Integer.MAX_VALUE ? Double.NaN : (double)originyAbs / pScale, (modifiers & 1) != 0, (modifiers & 4) != 0, (modifiers & 8) != 0, (modifiers & 0x10) != 0, isDirect, isInertia);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSwipeGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int dir, int x, int y, int xAbs, int yAbs) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("SWIPE_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    EventType<SwipeEvent> eventType;
                    switch (dir) {
                        case 1: {
                            eventType = SwipeEvent.SWIPE_UP;
                            break;
                        }
                        case 2: {
                            eventType = SwipeEvent.SWIPE_DOWN;
                            break;
                        }
                        case 3: {
                            eventType = SwipeEvent.SWIPE_LEFT;
                            break;
                        }
                        case 4: {
                            eventType = SwipeEvent.SWIPE_RIGHT;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown swipe event direction: " + dir);
                        }
                    }
                    Window w = view.getWindow();
                    double pScale = w == null ? 1.0 : (double)w.getPlatformScale();
                    this.scene.sceneListener.swipeEvent(eventType, touchCount, x == Integer.MAX_VALUE ? Double.NaN : (double)x / pScale, y == Integer.MAX_VALUE ? Double.NaN : (double)y / pScale, xAbs == Integer.MAX_VALUE ? Double.NaN : (double)xAbs / pScale, yAbs == Integer.MAX_VALUE ? Double.NaN : (double)yAbs / pScale, (modifiers & 1) != 0, (modifiers & 4) != 0, (modifiers & 8) != 0, (modifiers & 0x10) != 0, isDirect);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBeginTouchEvent(View view, long time, int modifiers, boolean isDirect, int touchEventCount) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("BEGIN_TOUCH_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    this.scene.sceneListener.touchEventBegin(time, touchEventCount, isDirect, (modifiers & 1) != 0, (modifiers & 4) != 0, (modifiers & 8) != 0, (modifiers & 0x10) != 0);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        this.gestures.notifyBeginTouchEvent(time, modifiers, isDirect, touchEventCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNextTouchEvent(View view, long time, int type, long touchId, int x, int y, int xAbs, int yAbs) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("NEXT_TOUCH_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    TouchPoint.State state;
                    switch (type) {
                        case 811: {
                            state = TouchPoint.State.PRESSED;
                            break;
                        }
                        case 812: {
                            state = TouchPoint.State.MOVED;
                            break;
                        }
                        case 814: {
                            state = TouchPoint.State.STATIONARY;
                            break;
                        }
                        case 813: {
                            state = TouchPoint.State.RELEASED;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown touch state: " + type);
                        }
                    }
                    Window w = view.getWindow();
                    double pScale = w == null ? 1.0 : (double)w.getPlatformScale();
                    this.scene.sceneListener.touchEventNext(state, touchId, (double)x / pScale, (double)y / pScale, (double)xAbs / pScale, (double)yAbs / pScale);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        this.gestures.notifyNextTouchEvent(time, type, touchId, x, y, xAbs, yAbs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEndTouchEvent(View view, long time) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("END_TOUCH_EVENT");
        }
        WindowStage stage = this.scene.getWindowStage();
        try {
            if (stage != null) {
                stage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    this.scene.sceneListener.touchEventEnd();
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (stage != null) {
                stage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        this.gestures.notifyEndTouchEvent(time);
    }

    @Override
    public Accessible getSceneAccessible() {
        if (this.scene != null && this.scene.sceneListener != null) {
            return this.scene.sceneListener.getSceneAccessible();
        }
        return null;
    }

    static {
        AccessController.doPrivileged(() -> {
            zoomGestureEnabled = Boolean.valueOf(System.getProperty("com.sun.javafx.gestures.zoom", "false"));
            rotateGestureEnabled = Boolean.valueOf(System.getProperty("com.sun.javafx.gestures.rotate", "false"));
            scrollGestureEnabled = Boolean.valueOf(System.getProperty("com.sun.javafx.gestures.scroll", "false"));
            return null;
        });
    }

    private class ViewEventNotification
    implements PrivilegedAction<Void> {
        View view;
        long time;
        int type;

        private ViewEventNotification() {
        }

        @Override
        public Void run() {
            if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener == null) {
                return null;
            }
            switch (this.type) {
                case 421: {
                    WindowStage stage;
                    Window w = this.view.getWindow();
                    if (w != null && w.getMinimumWidth() == this.view.getWidth() && !w.isVisible()) break;
                    if (QuantumToolkit.drawInPaint && w != null && w.isVisible() && (stage = GlassViewEventHandler.this.scene.getWindowStage()) != null && !stage.isApplet()) {
                        GlassViewEventHandler.this.collector.liveRepaintRenderJob(GlassViewEventHandler.this.scene);
                    }
                    GlassViewEventHandler.this.scene.entireSceneNeedsRepaint();
                    break;
                }
                case 422: {
                    WindowStage stage;
                    Window w = this.view.getWindow();
                    float pScale = w == null ? 1.0f : w.getPlatformScale();
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.changedSize((float)this.view.getWidth() / pScale, (float)this.view.getHeight() / pScale);
                    GlassViewEventHandler.this.scene.entireSceneNeedsRepaint();
                    QuantumToolkit.runWithRenderLock(() -> {
                        GlassViewEventHandler.this.scene.updateSceneState();
                        return null;
                    });
                    if (!QuantumToolkit.liveResize || w == null || !w.isVisible() || (stage = GlassViewEventHandler.this.scene.getWindowStage()) == null || stage.isApplet()) break;
                    GlassViewEventHandler.this.collector.liveRepaintRenderJob(GlassViewEventHandler.this.scene);
                    break;
                }
                case 423: {
                    Window w = this.view.getWindow();
                    float pScale = w == null ? 1.0f : w.getPlatformScale();
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.changedLocation((float)this.view.getX() / pScale, (float)this.view.getY() / pScale);
                    break;
                }
                case 431: 
                case 432: {
                    if (GlassViewEventHandler.this.scene.getWindowStage() == null) break;
                    GlassViewEventHandler.this.scene.getWindowStage().fullscreenChanged(this.type == 431);
                    break;
                }
                case 411: 
                case 412: {
                    break;
                }
                default: {
                    throw new RuntimeException("handleViewEvent: unhandled type: " + this.type);
                }
            }
            return null;
        }
    }

    private class MouseEventNotification
    implements PrivilegedAction<Void> {
        View view;
        long time;
        int type;
        int button;
        int x;
        int y;
        int xAbs;
        int yAbs;
        int modifiers;
        boolean isPopupTrigger;
        boolean isSynthesized;

        private MouseEventNotification() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() {
            int buttonMask;
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(GlassViewEventHandler.mouseEventType(this.type).toString());
            }
            switch (this.button) {
                case 212: {
                    buttonMask = 32;
                    break;
                }
                case 214: {
                    buttonMask = 128;
                    break;
                }
                case 213: {
                    buttonMask = 64;
                    break;
                }
                default: {
                    buttonMask = 0;
                }
            }
            switch (this.type) {
                case 224: {
                    if (this.button == 211) break;
                    return null;
                }
                case 222: {
                    if ((GlassViewEventHandler.this.mouseButtonPressedMask & buttonMask) == 0) {
                        return null;
                    }
                    GlassViewEventHandler.this.mouseButtonPressedMask = GlassViewEventHandler.this.mouseButtonPressedMask & ~buttonMask;
                    break;
                }
                case 221: {
                    GlassViewEventHandler.this.mouseButtonPressedMask = GlassViewEventHandler.this.mouseButtonPressedMask | buttonMask;
                    break;
                }
                case 225: 
                case 226: {
                    break;
                }
                case 227: {
                    return null;
                }
                default: {
                    if (!QuantumToolkit.verbose) break;
                    System.out.println("handleMouseEvent: unhandled type: " + this.type);
                }
            }
            WindowStage stage = GlassViewEventHandler.this.scene.getWindowStage();
            try {
                if (stage != null) {
                    switch (this.type) {
                        case 221: 
                        case 222: {
                            stage.setInAllowedEventHandler(true);
                            break;
                        }
                        default: {
                            stage.setInAllowedEventHandler(false);
                        }
                    }
                }
                if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                    boolean shiftDown = (this.modifiers & 1) != 0;
                    boolean controlDown = (this.modifiers & 4) != 0;
                    boolean altDown = (this.modifiers & 8) != 0;
                    boolean metaDown = (this.modifiers & 0x10) != 0;
                    boolean primaryButtonDown = (this.modifiers & 0x20) != 0;
                    boolean middleButtonDown = (this.modifiers & 0x80) != 0;
                    boolean secondaryButtonDown = (this.modifiers & 0x40) != 0;
                    Window w = this.view.getWindow();
                    double pScale = w == null ? 1.0 : (double)w.getPlatformScale();
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.mouseEvent(GlassViewEventHandler.mouseEventType(this.type), (double)this.x / pScale, (double)this.y / pScale, (double)this.xAbs / pScale, (double)this.yAbs / pScale, GlassViewEventHandler.mouseEventButton(this.button), this.isPopupTrigger, this.isSynthesized, shiftDown, controlDown, altDown, metaDown, primaryButtonDown, middleButtonDown, secondaryButtonDown);
                }
            }
            finally {
                if (stage != null) {
                    stage.setInAllowedEventHandler(false);
                }
                if (PulseLogger.PULSE_LOGGING_ENABLED) {
                    PulseLogger.newInput(null);
                }
            }
            return null;
        }
    }

    private class KeyEventNotification
    implements PrivilegedAction<Void> {
        View view;
        long time;
        int type;
        int key;
        char[] chars;
        int modifiers;
        private KeyCode lastKeyCode;

        private KeyEventNotification() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void run() {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(GlassViewEventHandler.keyEventType(this.type).toString());
            }
            WindowStage stage = GlassViewEventHandler.this.scene.getWindowStage();
            try {
                String str;
                boolean shiftDown = (this.modifiers & 1) != 0;
                boolean controlDown = (this.modifiers & 4) != 0;
                boolean altDown = (this.modifiers & 8) != 0;
                boolean metaDown = (this.modifiers & 0x10) != 0;
                String text = str = new String(this.chars);
                KeyEvent keyEvent = new KeyEvent(GlassViewEventHandler.keyEventType(this.type), str, text, KeyCodeMap.valueOf(this.key), shiftDown, controlDown, altDown, metaDown);
                KeyCode keyCode = KeyCodeMap.valueOf(this.key);
                switch (this.type) {
                    case 111: 
                    case 112: {
                        this.lastKeyCode = keyCode;
                        break;
                    }
                    case 113: {
                        keyCode = this.lastKeyCode;
                    }
                }
                if (stage != null) {
                    if (keyCode == KeyCode.ESCAPE) {
                        stage.setInAllowedEventHandler(false);
                    } else {
                        stage.setInAllowedEventHandler(true);
                    }
                }
                switch (this.type) {
                    case 111: {
                        if (this.view.isInFullscreen() && stage != null && stage.getSavedFullScreenExitKey() != null && stage.getSavedFullScreenExitKey().match(keyEvent)) {
                            stage.exitFullScreen();
                        }
                    }
                    case 112: 
                    case 113: {
                        if (this.view.isInFullscreen() && !GlassViewEventHandler.this.checkFullScreenKeyEvent(this.type, this.key, this.chars, this.modifiers)) {
                            return null;
                        } else {
                            if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener == null) return null;
                            ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.keyEvent(keyEvent);
                            return null;
                        }
                    }
                    default: {
                        if (!QuantumToolkit.verbose) return null;
                        System.out.println("handleKeyEvent: unhandled type: " + this.type);
                        return null;
                    }
                }
            }
            finally {
                if (stage != null) {
                    stage.setInAllowedEventHandler(false);
                }
                if (PulseLogger.PULSE_LOGGING_ENABLED) {
                    PulseLogger.newInput(null);
                }
            }
        }
    }
}

