/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.theme;

import com.sun.javafx.webkit.theme.ContextMenuImpl;
import com.sun.webkit.Invoker;
import com.sun.webkit.PopupMenu;
import com.sun.webkit.WebPage;
import com.sun.webkit.WebPageClient;
import com.sun.webkit.graphics.WCFont;
import com.sun.webkit.graphics.WCPoint;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.web.WebView;

public final class PopupMenuImpl
extends PopupMenu {
    private static final Logger log = Logger.getLogger(PopupMenuImpl.class.getName());
    private final ContextMenu popupMenu = new ContextMenu();

    public PopupMenuImpl() {
        this.popupMenu.setOnHidden(t1 -> {
            log.finer("onHidden");
            Invoker.getInvoker().postOnEventThread(() -> {
                log.finer("onHidden: notifying");
                this.notifyPopupClosed();
            });
        });
        this.popupMenu.setOnAction(t -> {
            MenuItem item = (MenuItem)t.getTarget();
            log.log(Level.FINE, "onAction: item={0}", item);
            this.notifySelectionCommited(this.popupMenu.getItems().indexOf(item));
        });
    }

    @Override
    protected void show(WebPage page, int x, int y, int width) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "show at [{0}, {1}], width={2}", new Object[]{x, y, width});
        }
        this.popupMenu.setPrefWidth(width);
        this.popupMenu.setPrefHeight(this.popupMenu.getHeight());
        PopupMenuImpl.doShow(this.popupMenu, page, x, y);
    }

    @Override
    protected void hide() {
        log.fine("hiding");
        this.popupMenu.hide();
    }

    @Override
    protected void appendItem(String itemText, boolean isLabel, boolean isSeparator, boolean isEnabled, int bgColor, int fgColor, WCFont font) {
        MenuItem item;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "itemText={0}, isLabel={1}, isSeparator={2}, isEnabled={3}, bgColor={4}, fgColor={5}, font={6}", new Object[]{itemText, isLabel, isSeparator, isEnabled, bgColor, fgColor, font});
        }
        if (isSeparator) {
            item = new ContextMenuImpl.SeparatorImpl(null);
        } else {
            item = new MenuItem(itemText);
            item.setDisable(!isEnabled);
        }
        this.popupMenu.getItems().add(item);
    }

    @Override
    protected void setSelectedItem(int index) {
        log.log(Level.FINEST, "index={0}", index);
    }

    static void doShow(ContextMenu popup, WebPage page, int anchorX, int anchorY) {
        WebPageClient client = page.getPageClient();
        assert (client != null);
        WCPoint pt = client.windowToScreen(new WCPoint(anchorX, anchorY));
        popup.show(((WebView)client.getContainer()).getScene().getWindow(), (double)pt.getX(), (double)pt.getY());
    }
}

