/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.UnmodifiableListSet;
import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.CursorConverter;
import com.sun.javafx.css.converters.EffectConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.geometry.BoundsUtils;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.scene.CameraHelper;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.EventHandlerProperties;
import com.sun.javafx.scene.LayoutFlags;
import com.sun.javafx.scene.NodeEventDispatcher;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.SceneUtils;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.transform.TransformUtils;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.TempState;
import com.sun.javafx.util.Utils;
import com.sun.prism.impl.PrismSettings;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.CacheHint;
import javafx.scene.Camera;
import javafx.scene.CssStyleHelper;
import javafx.scene.Cursor;
import javafx.scene.DepthTest;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.SnapshotResult;
import javafx.scene.SubScene;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;
import javafx.scene.shape.Shape3D;
import javafx.scene.text.Font;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.stage.Window;
import javafx.util.Callback;
import sun.util.logging.PlatformLogger;

@IDProperty(value="id")
public abstract class Node
implements EventTarget,
Styleable {
    private int dirtyBits;
    private BaseBounds _geomBounds = new RectBounds(0.0f, 0.0f, -1.0f, -1.0f);
    private BaseBounds _txBounds = new RectBounds(0.0f, 0.0f, -1.0f, -1.0f);
    private boolean pendingUpdateBounds = false;
    private static final Object USER_DATA_KEY;
    private ObservableMap<Object, Object> properties;
    private ReadOnlyObjectWrapper<Parent> parent;
    private final InvalidationListener parentDisabledChangedListener = valueModel -> this.updateDisabled();
    private final InvalidationListener parentTreeVisibleChangedListener = valueModel -> this.updateTreeVisible(true);
    private SubScene subScene = null;
    private ReadOnlyObjectWrapperManualFire<Scene> scene = new ReadOnlyObjectWrapperManualFire();
    private StringProperty id;
    private ObservableList<String> styleClass = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> c) {
            Node.this.impl_reapplyCSS();
        }

        @Override
        public String toString() {
            if (this.size() == 0) {
                return "";
            }
            if (this.size() == 1) {
                return (String)this.get(0);
            }
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                buf.append((String)this.get(i));
                if (i + 1 >= this.size()) continue;
                buf.append(' ');
            }
            return buf.toString();
        }
    };
    private StringProperty style;
    private BooleanProperty visible;
    private DoubleProperty opacity;
    private ObjectProperty<BlendMode> blendMode;
    private boolean derivedDepthTest = true;
    private BooleanProperty pickOnBounds;
    private ReadOnlyBooleanWrapper disabled;
    private Node clipParent;
    private NGNode peer;
    private BooleanProperty managed;
    private DoubleProperty layoutX;
    private DoubleProperty layoutY;
    public static final double BASELINE_OFFSET_SAME_AS_HEIGHT = Double.NEGATIVE_INFINITY;
    private LazyBoundsProperty layoutBounds = new LazyBoundsProperty(){

        @Override
        protected Bounds computeBounds() {
            return Node.this.impl_computeLayoutBounds();
        }

        @Override
        public Object getBean() {
            return Node.this;
        }

        @Override
        public String getName() {
            return "layoutBounds";
        }
    };
    private BaseTransform localToParentTx = BaseTransform.IDENTITY_TRANSFORM;
    private boolean transformDirty = true;
    private BaseBounds txBounds = new RectBounds();
    private BaseBounds geomBounds = new RectBounds();
    private BaseBounds localBounds = null;
    boolean boundsChanged;
    private boolean geomBoundsInvalid = true;
    private boolean localBoundsInvalid = true;
    private boolean txBoundsInvalid = true;
    private static final double EPSILON_ABSOLUTE = 1.0E-5;
    private NodeTransformation nodeTransformation;
    private static final double DEFAULT_TRANSLATE_X = 0.0;
    private static final double DEFAULT_TRANSLATE_Y = 0.0;
    private static final double DEFAULT_TRANSLATE_Z = 0.0;
    private static final double DEFAULT_SCALE_X = 1.0;
    private static final double DEFAULT_SCALE_Y = 1.0;
    private static final double DEFAULT_SCALE_Z = 1.0;
    private static final double DEFAULT_ROTATE = 0.0;
    private static final Point3D DEFAULT_ROTATION_AXIS;
    private EventHandlerProperties eventHandlerProperties;
    private ObjectProperty<NodeOrientation> nodeOrientation;
    private EffectiveOrientationProperty effectiveNodeOrientationProperty;
    private static final byte EFFECTIVE_ORIENTATION_LTR = 0;
    private static final byte EFFECTIVE_ORIENTATION_RTL = 1;
    private static final byte EFFECTIVE_ORIENTATION_MASK = 1;
    private static final byte AUTOMATIC_ORIENTATION_LTR = 0;
    private static final byte AUTOMATIC_ORIENTATION_RTL = 2;
    private static final byte AUTOMATIC_ORIENTATION_MASK = 2;
    private byte resolvedNodeOrientation = 0;
    private MiscProperties miscProperties;
    private static final boolean DEFAULT_CACHE = false;
    private static final CacheHint DEFAULT_CACHE_HINT;
    private static final Node DEFAULT_CLIP;
    private static final Cursor DEFAULT_CURSOR;
    private static final DepthTest DEFAULT_DEPTH_TEST;
    private static final boolean DEFAULT_DISABLE = false;
    private static final Effect DEFAULT_EFFECT;
    private static final InputMethodRequests DEFAULT_INPUT_METHOD_REQUESTS;
    private static final boolean DEFAULT_MOUSE_TRANSPARENT = false;
    private ReadOnlyBooleanWrapper hover;
    private ReadOnlyBooleanWrapper pressed;
    private FocusedProperty focused;
    private BooleanProperty focusTraversable;
    private boolean treeVisible;
    private TreeVisiblePropertyReadOnly treeVisibleRO;
    private boolean canReceiveFocus = false;
    @Deprecated
    private BooleanProperty impl_showMnemonics;
    private Node labeledBy = null;
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private NodeEventDispatcher internalEventDispatcher;
    private EventDispatcher preprocessMouseEventDispatcher;
    CssFlags cssFlag = CssFlags.CLEAN;
    final ObservableSet<PseudoClass> pseudoClassStates = new PseudoClassState();
    CssStyleHelper styleHelper;
    private static final PseudoClass HOVER_PSEUDOCLASS_STATE;
    private static final PseudoClass PRESSED_PSEUDOCLASS_STATE;
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE;
    private static final PseudoClass FOCUSED_PSEUDOCLASS_STATE;
    private static final PseudoClass SHOW_MNEMONICS_PSEUDOCLASS_STATE;
    private static final BoundsAccessor boundsAccessor;
    private ObjectProperty<AccessibleRole> accessibleRole;
    AccessibilityProperties accessibilityProperties;
    Accessible accessible;

    @Deprecated
    protected void impl_markDirty(DirtyBits dirtyBit) {
        if (this.impl_isDirtyEmpty()) {
            this.addToSceneDirtyList();
        }
        this.dirtyBits = (int)((long)this.dirtyBits | dirtyBit.getMask());
    }

    private void addToSceneDirtyList() {
        Scene s = this.getScene();
        if (s != null) {
            s.addToDirtyList(this);
            if (this.getSubScene() != null) {
                this.getSubScene().setDirty(this);
            }
        }
    }

    @Deprecated
    protected final boolean impl_isDirty(DirtyBits dirtyBit) {
        return ((long)this.dirtyBits & dirtyBit.getMask()) != 0L;
    }

    @Deprecated
    protected final void impl_clearDirty(DirtyBits dirtyBit) {
        this.dirtyBits = (int)((long)this.dirtyBits & (dirtyBit.getMask() ^ 0xFFFFFFFFFFFFFFFFL));
    }

    private void setDirty() {
        this.dirtyBits = -1;
    }

    private void clearDirty() {
        this.dirtyBits = 0;
    }

    @Deprecated
    protected final boolean impl_isDirtyEmpty() {
        return this.dirtyBits == 0;
    }

    @Deprecated
    public final void impl_syncPeer() {
        if (!this.impl_isDirtyEmpty() && (this.treeVisible || this.impl_isDirty(DirtyBits.NODE_VISIBLE) || this.impl_isDirty(DirtyBits.NODE_FORCE_SYNC))) {
            this.impl_updatePeer();
            this.clearDirty();
        }
    }

    void updateBounds() {
        Node n = this.getClip();
        if (n != null) {
            n.updateBounds();
        }
        if (!this.treeVisible && !this.impl_isDirty(DirtyBits.NODE_VISIBLE)) {
            if (this.impl_isDirty(DirtyBits.NODE_TRANSFORM) || this.impl_isDirty(DirtyBits.NODE_TRANSFORMED_BOUNDS) || this.impl_isDirty(DirtyBits.NODE_BOUNDS)) {
                this.pendingUpdateBounds = true;
            }
            return;
        }
        if (this.pendingUpdateBounds) {
            this.impl_markDirty(DirtyBits.NODE_TRANSFORM);
            this.impl_markDirty(DirtyBits.NODE_TRANSFORMED_BOUNDS);
            this.impl_markDirty(DirtyBits.NODE_BOUNDS);
            this.pendingUpdateBounds = false;
        }
        if (this.impl_isDirty(DirtyBits.NODE_TRANSFORM) || this.impl_isDirty(DirtyBits.NODE_TRANSFORMED_BOUNDS)) {
            if (this.impl_isDirty(DirtyBits.NODE_TRANSFORM)) {
                this.updateLocalToParentTransform();
            }
            this._txBounds = this.getTransformedBounds(this._txBounds, BaseTransform.IDENTITY_TRANSFORM);
        }
        if (this.impl_isDirty(DirtyBits.NODE_BOUNDS)) {
            this._geomBounds = this.getGeomBounds(this._geomBounds, BaseTransform.IDENTITY_TRANSFORM);
        }
    }

    @Deprecated
    public void impl_updatePeer() {
        Object peer = this.impl_getPeer();
        if (PrismSettings.printRenderGraph && this.impl_isDirty(DirtyBits.DEBUG)) {
            String id = this.getId();
            String className = this.getClass().getSimpleName();
            if (className.isEmpty()) {
                className = this.getClass().getName();
            }
            ((NGNode)peer).setName(id == null ? className : id + "(" + className + ")");
        }
        if (this.impl_isDirty(DirtyBits.NODE_TRANSFORM)) {
            ((NGNode)peer).setTransformMatrix(this.localToParentTx);
        }
        if (this.impl_isDirty(DirtyBits.NODE_BOUNDS)) {
            ((NGNode)peer).setContentBounds(this._geomBounds);
        }
        if (this.impl_isDirty(DirtyBits.NODE_TRANSFORMED_BOUNDS)) {
            ((NGNode)peer).setTransformedBounds(this._txBounds, !this.impl_isDirty(DirtyBits.NODE_BOUNDS));
        }
        if (this.impl_isDirty(DirtyBits.NODE_OPACITY)) {
            ((NGNode)peer).setOpacity((float)Utils.clamp(0.0, this.getOpacity(), 1.0));
        }
        if (this.impl_isDirty(DirtyBits.NODE_CACHE)) {
            ((NGNode)peer).setCachedAsBitmap(this.isCache(), this.getCacheHint());
        }
        if (this.impl_isDirty(DirtyBits.NODE_CLIP)) {
            ((NGNode)peer).setClipNode(this.getClip() != null ? (NGNode)this.getClip().impl_getPeer() : null);
        }
        if (this.impl_isDirty(DirtyBits.EFFECT_EFFECT) && this.getEffect() != null) {
            this.getEffect().impl_sync();
            ((NGNode)peer).effectChanged();
        }
        if (this.impl_isDirty(DirtyBits.NODE_EFFECT)) {
            ((NGNode)peer).setEffect(this.getEffect() != null ? this.getEffect().impl_getImpl() : null);
        }
        if (this.impl_isDirty(DirtyBits.NODE_VISIBLE)) {
            ((NGNode)peer).setVisible(this.isVisible());
        }
        if (this.impl_isDirty(DirtyBits.NODE_DEPTH_TEST)) {
            ((NGNode)peer).setDepthTest(this.isDerivedDepthTest());
        }
        if (this.impl_isDirty(DirtyBits.NODE_BLENDMODE)) {
            BlendMode mode = this.getBlendMode();
            ((NGNode)peer).setNodeBlendMode(mode == null ? null : Blend.impl_getToolkitMode(mode));
        }
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object value) {
        this.getProperties().put(USER_DATA_KEY, value);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    final void setParent(Parent value) {
        this.parentPropertyImpl().set(value);
    }

    public final Parent getParent() {
        return this.parent == null ? null : (Parent)this.parent.get();
    }

    public final ReadOnlyObjectProperty<Parent> parentProperty() {
        return this.parentPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Parent> parentPropertyImpl() {
        if (this.parent == null) {
            this.parent = new ReadOnlyObjectWrapper<Parent>(){
                private Parent oldParent;

                @Override
                protected void invalidated() {
                    if (this.oldParent != null) {
                        this.oldParent.disabledProperty().removeListener(Node.this.parentDisabledChangedListener);
                        this.oldParent.impl_treeVisibleProperty().removeListener(Node.this.parentTreeVisibleChangedListener);
                        if (Node.this.nodeTransformation != null && Node.this.nodeTransformation.listenerReasons > 0) {
                            this.oldParent.localToSceneTransformProperty().removeListener(Node.this.nodeTransformation.getLocalToSceneInvalidationListener());
                        }
                    }
                    Node.this.updateDisabled();
                    Node.this.computeDerivedDepthTest();
                    Parent newParent = (Parent)this.get();
                    if (newParent != null) {
                        newParent.disabledProperty().addListener(Node.this.parentDisabledChangedListener);
                        newParent.impl_treeVisibleProperty().addListener(Node.this.parentTreeVisibleChangedListener);
                        if (Node.this.nodeTransformation != null && Node.this.nodeTransformation.listenerReasons > 0) {
                            newParent.localToSceneTransformProperty().addListener(Node.this.nodeTransformation.getLocalToSceneInvalidationListener());
                        }
                        Node.this.impl_reapplyCSS();
                    } else {
                        Node.this.cssFlag = CssFlags.CLEAN;
                    }
                    Node.this.updateTreeVisible(true);
                    this.oldParent = newParent;
                    Node.this.invalidateLocalToSceneTransform();
                    Node.this.parentResolvedOrientationInvalidated();
                    Node.this.notifyAccessibleAttributeChanged(AccessibleAttribute.PARENT);
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "parent";
                }
            };
        }
        return this.parent;
    }

    private void invalidatedScenes(Scene oldScene, SubScene oldSubScene, boolean reapplyCSS) {
        Scene newScene = (Scene)this.sceneProperty().get();
        boolean sceneChanged = oldScene != newScene;
        SubScene newSubScene = this.subScene;
        if (this.getClip() != null) {
            this.getClip().setScenes(newScene, newSubScene, reapplyCSS);
        }
        if (sceneChanged) {
            this.updateCanReceiveFocus();
            if (this.isFocusTraversable() && newScene != null) {
                newScene.initializeInternalEventDispatcher();
            }
            this.focusSetDirty(oldScene);
            this.focusSetDirty(newScene);
        }
        this.scenesChanged(newScene, newSubScene, oldScene, oldSubScene);
        if (sceneChanged && reapplyCSS) {
            this.impl_reapplyCSS();
        }
        if (sceneChanged && !this.impl_isDirtyEmpty()) {
            this.addToSceneDirtyList();
        }
        if (newScene == null && this.peer != null) {
            this.peer.release();
        }
        if (oldScene != null) {
            oldScene.clearNodeMnemonics(this);
        }
        if (this.getParent() == null) {
            this.parentResolvedOrientationInvalidated();
        }
        if (sceneChanged) {
            this.scene.fireSuperValueChangedEvent();
        }
        if (this.accessible != null) {
            if (oldScene != null && oldScene != newScene && newScene == null) {
                oldScene.addAccessible(this, this.accessible);
            } else {
                this.accessible.dispose();
            }
            this.accessible = null;
        }
    }

    final void setScenes(Scene newScene, SubScene newSubScene, boolean reapplyCSS) {
        Scene oldScene = (Scene)this.sceneProperty().get();
        if (newScene != oldScene || newSubScene != this.subScene) {
            this.scene.set(newScene);
            SubScene oldSubScene = this.subScene;
            this.subScene = newSubScene;
            this.invalidatedScenes(oldScene, oldSubScene, reapplyCSS);
            if (this instanceof SubScene) {
                SubScene thisSubScene = (SubScene)this;
                thisSubScene.getRoot().setScenes(newScene, thisSubScene, reapplyCSS);
            }
        }
    }

    final SubScene getSubScene() {
        return this.subScene;
    }

    public final Scene getScene() {
        return (Scene)this.scene.get();
    }

    public final ReadOnlyObjectProperty<Scene> sceneProperty() {
        return this.scene.getReadOnlyProperty();
    }

    void scenesChanged(Scene newScene, SubScene newSubScene, Scene oldScene, SubScene oldSubScene) {
    }

    public final void setId(String value) {
        this.idProperty().set(value);
    }

    @Override
    public final String getId() {
        return this.id == null ? null : (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new StringPropertyBase(){

                @Override
                protected void invalidated() {
                    Node.this.impl_reapplyCSS();
                    if (PrismSettings.printRenderGraph) {
                        Node.this.impl_markDirty(DirtyBits.DEBUG);
                    }
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "id";
                }
            };
        }
        return this.id;
    }

    @Override
    public final ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final void setStyle(String value) {
        this.styleProperty().set(value);
    }

    @Override
    public final String getStyle() {
        return this.style == null ? "" : (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new StringPropertyBase(""){

                @Override
                public void set(String value) {
                    super.set(value != null ? value : "");
                }

                @Override
                protected void invalidated() {
                    Node.this.impl_reapplyCSS();
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "style";
                }
            };
        }
        return this.style;
    }

    public final void setVisible(boolean value) {
        this.visibleProperty().set(value);
    }

    public final boolean isVisible() {
        return this.visible == null ? true : this.visible.get();
    }

    public final BooleanProperty visibleProperty() {
        if (this.visible == null) {
            this.visible = new StyleableBooleanProperty(true){
                boolean oldValue;
                {
                    this.oldValue = true;
                }

                @Override
                protected void invalidated() {
                    if (this.oldValue != this.get()) {
                        Node.this.impl_markDirty(DirtyBits.NODE_VISIBLE);
                        Node.this.impl_geomChanged();
                        Node.this.updateTreeVisible(false);
                        if (Node.this.getParent() != null) {
                            Node.this.getParent().childVisibilityChanged(Node.this);
                        }
                        this.oldValue = this.get();
                    }
                }

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.VISIBILITY;
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "visible";
                }
            };
        }
        return this.visible;
    }

    public final void setCursor(Cursor value) {
        this.cursorProperty().set(value);
    }

    public final Cursor getCursor() {
        return this.miscProperties == null ? DEFAULT_CURSOR : this.miscProperties.getCursor();
    }

    public final ObjectProperty<Cursor> cursorProperty() {
        return this.getMiscProperties().cursorProperty();
    }

    public final void setOpacity(double value) {
        this.opacityProperty().set(value);
    }

    public final double getOpacity() {
        return this.opacity == null ? 1.0 : this.opacity.get();
    }

    public final DoubleProperty opacityProperty() {
        if (this.opacity == null) {
            this.opacity = new StyleableDoubleProperty(1.0){

                @Override
                public void invalidated() {
                    Node.this.impl_markDirty(DirtyBits.NODE_OPACITY);
                }

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.OPACITY;
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "opacity";
                }
            };
        }
        return this.opacity;
    }

    public final void setBlendMode(BlendMode value) {
        this.blendModeProperty().set(value);
    }

    public final BlendMode getBlendMode() {
        return this.blendMode == null ? null : (BlendMode)((Object)this.blendMode.get());
    }

    public final ObjectProperty<BlendMode> blendModeProperty() {
        if (this.blendMode == null) {
            this.blendMode = new StyleableObjectProperty<BlendMode>(null){

                @Override
                public void invalidated() {
                    Node.this.impl_markDirty(DirtyBits.NODE_BLENDMODE);
                }

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.BLEND_MODE;
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "blendMode";
                }
            };
        }
        return this.blendMode;
    }

    public final void setClip(Node value) {
        this.clipProperty().set(value);
    }

    public final Node getClip() {
        return this.miscProperties == null ? DEFAULT_CLIP : this.miscProperties.getClip();
    }

    public final ObjectProperty<Node> clipProperty() {
        return this.getMiscProperties().clipProperty();
    }

    public final void setCache(boolean value) {
        this.cacheProperty().set(value);
    }

    public final boolean isCache() {
        return this.miscProperties == null ? false : this.miscProperties.isCache();
    }

    public final BooleanProperty cacheProperty() {
        return this.getMiscProperties().cacheProperty();
    }

    public final void setCacheHint(CacheHint value) {
        this.cacheHintProperty().set(value);
    }

    public final CacheHint getCacheHint() {
        return this.miscProperties == null ? DEFAULT_CACHE_HINT : this.miscProperties.getCacheHint();
    }

    public final ObjectProperty<CacheHint> cacheHintProperty() {
        return this.getMiscProperties().cacheHintProperty();
    }

    public final void setEffect(Effect value) {
        this.effectProperty().set(value);
    }

    public final Effect getEffect() {
        return this.miscProperties == null ? DEFAULT_EFFECT : this.miscProperties.getEffect();
    }

    public final ObjectProperty<Effect> effectProperty() {
        return this.getMiscProperties().effectProperty();
    }

    public final void setDepthTest(DepthTest value) {
        this.depthTestProperty().set(value);
    }

    public final DepthTest getDepthTest() {
        return this.miscProperties == null ? DEFAULT_DEPTH_TEST : this.miscProperties.getDepthTest();
    }

    public final ObjectProperty<DepthTest> depthTestProperty() {
        return this.getMiscProperties().depthTestProperty();
    }

    void computeDerivedDepthTest() {
        boolean newDDT = this.getDepthTest() == DepthTest.INHERIT ? (this.getParent() != null ? this.getParent().isDerivedDepthTest() : true) : this.getDepthTest() == DepthTest.ENABLE;
        if (this.isDerivedDepthTest() != newDDT) {
            this.impl_markDirty(DirtyBits.NODE_DEPTH_TEST);
            this.setDerivedDepthTest(newDDT);
        }
    }

    void setDerivedDepthTest(boolean value) {
        this.derivedDepthTest = value;
    }

    boolean isDerivedDepthTest() {
        return this.derivedDepthTest;
    }

    public final void setDisable(boolean value) {
        this.disableProperty().set(value);
    }

    public final boolean isDisable() {
        return this.miscProperties == null ? false : this.miscProperties.isDisable();
    }

    public final BooleanProperty disableProperty() {
        return this.getMiscProperties().disableProperty();
    }

    public final void setPickOnBounds(boolean value) {
        this.pickOnBoundsProperty().set(value);
    }

    public final boolean isPickOnBounds() {
        return this.pickOnBounds == null ? false : this.pickOnBounds.get();
    }

    public final BooleanProperty pickOnBoundsProperty() {
        if (this.pickOnBounds == null) {
            this.pickOnBounds = new SimpleBooleanProperty(this, "pickOnBounds");
        }
        return this.pickOnBounds;
    }

    protected final void setDisabled(boolean value) {
        this.disabledPropertyImpl().set(value);
    }

    public final boolean isDisabled() {
        return this.disabled == null ? false : this.disabled.get();
    }

    public final ReadOnlyBooleanProperty disabledProperty() {
        return this.disabledPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper disabledPropertyImpl() {
        if (this.disabled == null) {
            this.disabled = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    Node.this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, this.get());
                    Node.this.updateCanReceiveFocus();
                    Node.this.focusSetDirty(Node.this.getScene());
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "disabled";
                }
            };
        }
        return this.disabled;
    }

    private void updateDisabled() {
        boolean isDisabled = this.isDisable();
        if (!isDisabled) {
            isDisabled = this.getParent() != null ? this.getParent().isDisabled() : this.getSubScene() != null && this.getSubScene().isDisabled();
        }
        this.setDisabled(isDisabled);
        if (this instanceof SubScene) {
            ((SubScene)this).getRoot().setDisabled(isDisabled);
        }
    }

    public Node lookup(String selector) {
        if (selector == null) {
            return null;
        }
        Selector s = Selector.createSelector(selector);
        return s != null && s.applies(this) ? this : null;
    }

    public Set<Node> lookupAll(String selector) {
        Selector s = Selector.createSelector(selector);
        UnmodifiableListSet<Node> empty = Collections.emptySet();
        if (s == null) {
            return empty;
        }
        List<Node> results = this.lookupAll(s, null);
        return results == null ? empty : new UnmodifiableListSet<Node>(results);
    }

    List<Node> lookupAll(Selector selector, List<Node> results) {
        if (selector.applies(this)) {
            if (results == null) {
                results = new LinkedList<Node>();
            }
            results.add(this);
        }
        return results;
    }

    public void toBack() {
        if (this.getParent() != null) {
            this.getParent().impl_toBack(this);
        }
    }

    public void toFront() {
        if (this.getParent() != null) {
            this.getParent().impl_toFront(this);
        }
    }

    private void doCSSPass() {
        if (this.cssFlag != CssFlags.CLEAN) {
            this.processCSS();
        }
    }

    private static void syncAll(Node node) {
        node.impl_syncPeer();
        if (node instanceof Parent) {
            Parent p = (Parent)node;
            int childrenCount = p.getChildren().size();
            for (int i = 0; i < childrenCount; ++i) {
                Node n = (Node)p.getChildren().get(i);
                if (n == null) continue;
                Node.syncAll(n);
            }
        }
        if (node.getClip() != null) {
            Node.syncAll(node.getClip());
        }
    }

    private void doLayoutPass() {
        if (this instanceof Parent) {
            Parent p = (Parent)this;
            for (int i = 0; i < 3; ++i) {
                p.layout();
            }
        }
    }

    private void doCSSLayoutSyncForSnapshot() {
        this.doCSSPass();
        this.doLayoutPass();
        this.updateBounds();
        Scene.impl_setAllowPGAccess(true);
        Node.syncAll(this);
        Scene.impl_setAllowPGAccess(false);
    }

    private WritableImage doSnapshot(SnapshotParameters params, WritableImage img) {
        double h;
        double w;
        double y;
        double x;
        Rectangle2D viewport;
        if (this.getScene() != null) {
            this.getScene().doCSSLayoutSyncForSnapshot(this);
        } else {
            this.doCSSLayoutSyncForSnapshot();
        }
        BaseTransform transform = BaseTransform.IDENTITY_TRANSFORM;
        if (params.getTransform() != null) {
            Affine3D tempTx = new Affine3D();
            params.getTransform().impl_apply(tempTx);
            transform = tempTx;
        }
        if ((viewport = params.getViewport()) != null) {
            x = viewport.getMinX();
            y = viewport.getMinY();
            w = viewport.getWidth();
            h = viewport.getHeight();
        } else {
            BaseBounds tempBounds = TempState.getInstance().bounds;
            tempBounds = this.getTransformedBounds(tempBounds, transform);
            x = tempBounds.getMinX();
            y = tempBounds.getMinY();
            w = tempBounds.getWidth();
            h = tempBounds.getHeight();
        }
        WritableImage result = Scene.doSnapshot(this.getScene(), x, y, w, h, this, transform, params.isDepthBufferInternal(), params.getFill(), params.getEffectiveCamera(), img);
        return result;
    }

    public WritableImage snapshot(SnapshotParameters params, WritableImage image) {
        Toolkit.getToolkit().checkFxUserThread();
        if (params == null) {
            params = new SnapshotParameters();
            Scene s = this.getScene();
            if (s != null) {
                params.setCamera(s.getEffectiveCamera());
                params.setDepthBuffer(s.isDepthBufferInternal());
                params.setFill(s.getFill());
            }
        }
        return this.doSnapshot(params, image);
    }

    public void snapshot(Callback<SnapshotResult, Void> callback, SnapshotParameters params, WritableImage image) {
        Toolkit.getToolkit().checkFxUserThread();
        if (callback == null) {
            throw new NullPointerException("The callback must not be null");
        }
        if (params == null) {
            params = new SnapshotParameters();
            Scene s = this.getScene();
            if (s != null) {
                params.setCamera(s.getEffectiveCamera());
                params.setDepthBuffer(s.isDepthBufferInternal());
                params.setFill(s.getFill());
            }
        } else {
            params = params.copy();
        }
        SnapshotParameters theParams = params;
        Callback<SnapshotResult, Void> theCallback = callback;
        WritableImage theImage = image;
        Runnable snapshotRunnable = () -> {
            WritableImage img = this.doSnapshot(theParams, theImage);
            SnapshotResult result = new SnapshotResult(img, this, theParams);
            try {
                Void void_ = (Void)theCallback.call(result);
            }
            catch (Throwable th) {
                System.err.println("Exception in snapshot callback");
                th.printStackTrace(System.err);
            }
        };
        Scene.addSnapshotRunnable(snapshotRunnable);
    }

    public final void setOnDragEntered(EventHandler<? super DragEvent> value) {
        this.onDragEnteredProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragEntered() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragEntered();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragEnteredProperty() {
        return this.getEventHandlerProperties().onDragEnteredProperty();
    }

    public final void setOnDragExited(EventHandler<? super DragEvent> value) {
        this.onDragExitedProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragExited() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragExited();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragExitedProperty() {
        return this.getEventHandlerProperties().onDragExitedProperty();
    }

    public final void setOnDragOver(EventHandler<? super DragEvent> value) {
        this.onDragOverProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragOver() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragOver();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragOverProperty() {
        return this.getEventHandlerProperties().onDragOverProperty();
    }

    public final void setOnDragDropped(EventHandler<? super DragEvent> value) {
        this.onDragDroppedProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragDropped() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragDropped();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDroppedProperty() {
        return this.getEventHandlerProperties().onDragDroppedProperty();
    }

    public final void setOnDragDone(EventHandler<? super DragEvent> value) {
        this.onDragDoneProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragDone() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragDone();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDoneProperty() {
        return this.getEventHandlerProperties().onDragDoneProperty();
    }

    public Dragboard startDragAndDrop(TransferMode ... transferModes) {
        if (this.getScene() != null) {
            return this.getScene().startDragAndDrop(this, transferModes);
        }
        throw new IllegalStateException("Cannot start drag and drop on node that is not in scene");
    }

    public void startFullDrag() {
        if (this.getScene() != null) {
            this.getScene().startFullDrag(this);
            return;
        }
        throw new IllegalStateException("Cannot start full drag on node that is not in scene");
    }

    final Node getClipParent() {
        return this.clipParent;
    }

    boolean isConnected() {
        return this.getParent() != null || this.clipParent != null;
    }

    boolean wouldCreateCycle(Node parent, Node child) {
        if (child != null && child.getClip() == null && !(child instanceof Parent)) {
            return false;
        }
        Node n = parent;
        while (n != child) {
            if (n.getParent() != null) {
                n = n.getParent();
                continue;
            }
            if (n.getSubScene() != null) {
                n = n.getSubScene();
                continue;
            }
            if (n.clipParent != null) {
                n = n.clipParent;
                continue;
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public <P extends NGNode> P impl_getPeer() {
        if (Utils.assertionEnabled() && this.getScene() != null && !Scene.isPGAccessAllowed()) {
            System.err.println();
            System.err.println("*** unexpected PG access");
            Thread.dumpStack();
        }
        if (this.peer == null) {
            this.peer = this.impl_createPeer();
        }
        return (P)this.peer;
    }

    @Deprecated
    protected abstract NGNode impl_createPeer();

    protected Node() {
        this.setDirty();
        this.updateTreeVisible(false);
    }

    public final void setManaged(boolean value) {
        this.managedProperty().set(value);
    }

    public final boolean isManaged() {
        return this.managed == null ? true : this.managed.get();
    }

    public final BooleanProperty managedProperty() {
        if (this.managed == null) {
            this.managed = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    Parent parent = Node.this.getParent();
                    if (parent != null) {
                        parent.managedChildChanged();
                    }
                    Node.this.notifyManagedChanged();
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "managed";
                }
            };
        }
        return this.managed;
    }

    void notifyManagedChanged() {
    }

    public final void setLayoutX(double value) {
        this.layoutXProperty().set(value);
    }

    public final double getLayoutX() {
        return this.layoutX == null ? 0.0 : this.layoutX.get();
    }

    public final DoubleProperty layoutXProperty() {
        if (this.layoutX == null) {
            this.layoutX = new DoublePropertyBase(0.0){

                @Override
                protected void invalidated() {
                    Node.this.impl_transformsChanged();
                    Parent p = Node.this.getParent();
                    if (p != null && !p.performingLayout) {
                        if (Node.this.isManaged()) {
                            p.requestLayout();
                        } else {
                            p.clearSizeCache();
                            p.requestParentLayout();
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "layoutX";
                }
            };
        }
        return this.layoutX;
    }

    public final void setLayoutY(double value) {
        this.layoutYProperty().set(value);
    }

    public final double getLayoutY() {
        return this.layoutY == null ? 0.0 : this.layoutY.get();
    }

    public final DoubleProperty layoutYProperty() {
        if (this.layoutY == null) {
            this.layoutY = new DoublePropertyBase(0.0){

                @Override
                protected void invalidated() {
                    Node.this.impl_transformsChanged();
                    Parent p = Node.this.getParent();
                    if (p != null && !p.performingLayout) {
                        if (Node.this.isManaged()) {
                            p.requestLayout();
                        } else {
                            p.clearSizeCache();
                            p.requestParentLayout();
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "layoutY";
                }
            };
        }
        return this.layoutY;
    }

    public void relocate(double x, double y) {
        this.setLayoutX(x - this.getLayoutBounds().getMinX());
        this.setLayoutY(y - this.getLayoutBounds().getMinY());
        PlatformLogger logger = Logging.getLayoutLogger();
        if (logger.isLoggable(PlatformLogger.Level.FINER)) {
            logger.finer(this.toString() + " moved to (" + x + "," + y + ")");
        }
    }

    public boolean isResizable() {
        return false;
    }

    public Orientation getContentBias() {
        return null;
    }

    public double minWidth(double height) {
        return this.prefWidth(height);
    }

    public double minHeight(double width) {
        return this.prefHeight(width);
    }

    public double prefWidth(double height) {
        double result = this.getLayoutBounds().getWidth();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public double prefHeight(double width) {
        double result = this.getLayoutBounds().getHeight();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public double maxWidth(double height) {
        return this.prefWidth(height);
    }

    public double maxHeight(double width) {
        return this.prefHeight(width);
    }

    public void resize(double width, double height) {
    }

    public final void autosize() {
        if (this.isResizable()) {
            double h;
            double w;
            Orientation contentBias = this.getContentBias();
            if (contentBias == null) {
                w = this.boundedSize(this.prefWidth(-1.0), this.minWidth(-1.0), this.maxWidth(-1.0));
                h = this.boundedSize(this.prefHeight(-1.0), this.minHeight(-1.0), this.maxHeight(-1.0));
            } else if (contentBias == Orientation.HORIZONTAL) {
                w = this.boundedSize(this.prefWidth(-1.0), this.minWidth(-1.0), this.maxWidth(-1.0));
                h = this.boundedSize(this.prefHeight(w), this.minHeight(w), this.maxHeight(w));
            } else {
                h = this.boundedSize(this.prefHeight(-1.0), this.minHeight(-1.0), this.maxHeight(-1.0));
                w = this.boundedSize(this.prefWidth(h), this.minWidth(h), this.maxWidth(h));
            }
            this.resize(w, h);
        }
    }

    double boundedSize(double value, double min, double max) {
        return Math.min(Math.max(value, min), Math.max(min, max));
    }

    public void resizeRelocate(double x, double y, double width, double height) {
        this.resize(width, height);
        this.relocate(x, y);
    }

    public double getBaselineOffset() {
        if (this.isResizable()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.getLayoutBounds().getHeight();
    }

    public double computeAreaInScreen() {
        return this.impl_computeAreaInScreen();
    }

    private double impl_computeAreaInScreen() {
        Scene tmpScene = this.getScene();
        if (tmpScene != null) {
            Bounds bounds = this.getBoundsInLocal();
            Camera camera = tmpScene.getEffectiveCamera();
            boolean isPerspective = camera instanceof PerspectiveCamera;
            Transform localToSceneTx = this.getLocalToSceneTransform();
            Affine3D tempTx = TempState.getInstance().tempTx;
            BaseBounds localBounds = new BoxBounds((float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getMinZ(), (float)bounds.getMaxX(), (float)bounds.getMaxY(), (float)bounds.getMaxZ());
            if (isPerspective) {
                Transform cameraL2STx = camera.getLocalToSceneTransform();
                if (cameraL2STx.getMxx() == 1.0 && cameraL2STx.getMxy() == 0.0 && cameraL2STx.getMxz() == 0.0 && cameraL2STx.getMyx() == 0.0 && cameraL2STx.getMyy() == 1.0 && cameraL2STx.getMyz() == 0.0 && cameraL2STx.getMzx() == 0.0 && cameraL2STx.getMzy() == 0.0 && cameraL2STx.getMzz() == 1.0) {
                    double maxZ;
                    double minZ;
                    if (localToSceneTx.getMxx() == 1.0 && localToSceneTx.getMxy() == 0.0 && localToSceneTx.getMxz() == 0.0 && localToSceneTx.getMyx() == 0.0 && localToSceneTx.getMyy() == 1.0 && localToSceneTx.getMyz() == 0.0 && localToSceneTx.getMzx() == 0.0 && localToSceneTx.getMzy() == 0.0 && localToSceneTx.getMzz() == 1.0) {
                        Vec3d tempV3D = TempState.getInstance().vec3d;
                        tempV3D.set(0.0, 0.0, bounds.getMinZ());
                        this.localToScene(tempV3D);
                        minZ = tempV3D.z;
                        tempV3D.set(0.0, 0.0, bounds.getMaxZ());
                        this.localToScene(tempV3D);
                        maxZ = tempV3D.z;
                    } else {
                        Bounds nodeInSceneBounds = this.localToScene(bounds);
                        minZ = nodeInSceneBounds.getMinZ();
                        maxZ = nodeInSceneBounds.getMaxZ();
                    }
                    if (minZ > camera.getFarClipInScene() || maxZ < camera.getNearClipInScene()) {
                        return 0.0;
                    }
                } else {
                    BoxBounds nodeInCameraBounds = new BoxBounds();
                    tempTx.setToIdentity();
                    localToSceneTx.impl_apply(tempTx);
                    tempTx.preConcatenate(camera.getSceneToLocalTransform());
                    tempTx.transform(localBounds, nodeInCameraBounds);
                    if ((double)((BaseBounds)nodeInCameraBounds).getMinZ() > camera.getFarClip() || (double)((BaseBounds)nodeInCameraBounds).getMaxZ() < camera.getNearClip()) {
                        return 0.0;
                    }
                }
            }
            GeneralTransform3D projViewTx = TempState.getInstance().projViewTx;
            projViewTx.set(camera.getProjViewTransform());
            tempTx.setToIdentity();
            localToSceneTx.impl_apply(tempTx);
            GeneralTransform3D tx = projViewTx.mul(tempTx);
            localBounds = tx.transform(localBounds, localBounds);
            double area = localBounds.getWidth() * localBounds.getHeight();
            if (isPerspective) {
                localBounds.intersectWith(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                area = localBounds.getWidth() < 0.0f || localBounds.getHeight() < 0.0f ? 0.0 : area;
            }
            return area * (camera.getViewWidth() / 2.0 * camera.getViewHeight() / 2.0);
        }
        return 0.0;
    }

    public final Bounds getBoundsInParent() {
        return (Bounds)this.boundsInParentProperty().get();
    }

    public final ReadOnlyObjectProperty<Bounds> boundsInParentProperty() {
        return this.getMiscProperties().boundsInParentProperty();
    }

    private void invalidateBoundsInParent() {
        if (this.miscProperties != null) {
            this.miscProperties.invalidateBoundsInParent();
        }
    }

    public final Bounds getBoundsInLocal() {
        return (Bounds)this.boundsInLocalProperty().get();
    }

    public final ReadOnlyObjectProperty<Bounds> boundsInLocalProperty() {
        return this.getMiscProperties().boundsInLocalProperty();
    }

    private void invalidateBoundsInLocal() {
        if (this.miscProperties != null) {
            this.miscProperties.invalidateBoundsInLocal();
        }
    }

    public final Bounds getLayoutBounds() {
        return (Bounds)this.layoutBoundsProperty().get();
    }

    public final ReadOnlyObjectProperty<Bounds> layoutBoundsProperty() {
        return this.layoutBounds;
    }

    @Deprecated
    protected Bounds impl_computeLayoutBounds() {
        BaseBounds tempBounds = TempState.getInstance().bounds;
        tempBounds = this.getGeomBounds(tempBounds, BaseTransform.IDENTITY_TRANSFORM);
        return new BoundingBox(tempBounds.getMinX(), tempBounds.getMinY(), tempBounds.getMinZ(), tempBounds.getWidth(), tempBounds.getHeight(), tempBounds.getDepth());
    }

    @Deprecated
    protected final void impl_layoutBoundsChanged() {
        if (!this.layoutBounds.valid) {
            return;
        }
        this.layoutBounds.invalidate();
        if (this.nodeTransformation != null && this.nodeTransformation.hasScaleOrRotate() || this.hasMirroring()) {
            this.impl_transformsChanged();
        }
    }

    BaseBounds getTransformedBounds(BaseBounds bounds, BaseTransform tx) {
        this.updateLocalToParentTransform();
        if (tx.isTranslateOrIdentity()) {
            this.updateTxBounds();
            bounds = bounds.deriveWithNewBounds(this.txBounds);
            if (!tx.isIdentity()) {
                double translateX = tx.getMxt();
                double translateY = tx.getMyt();
                double translateZ = tx.getMzt();
                bounds = bounds.deriveWithNewBounds((float)((double)bounds.getMinX() + translateX), (float)((double)bounds.getMinY() + translateY), (float)((double)bounds.getMinZ() + translateZ), (float)((double)bounds.getMaxX() + translateX), (float)((double)bounds.getMaxY() + translateY), (float)((double)bounds.getMaxZ() + translateZ));
            }
            return bounds;
        }
        if (this.localToParentTx.isIdentity()) {
            return this.getLocalBounds(bounds, tx);
        }
        double mxx = tx.getMxx();
        double mxy = tx.getMxy();
        double mxz = tx.getMxz();
        double mxt = tx.getMxt();
        double myx = tx.getMyx();
        double myy = tx.getMyy();
        double myz = tx.getMyz();
        double myt = tx.getMyt();
        double mzx = tx.getMzx();
        double mzy = tx.getMzy();
        double mzz = tx.getMzz();
        double mzt = tx.getMzt();
        BaseTransform boundsTx = tx.deriveWithConcatenation(this.localToParentTx);
        bounds = this.getLocalBounds(bounds, boundsTx);
        if (boundsTx == tx) {
            tx.restoreTransform(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
        }
        return bounds;
    }

    BaseBounds getLocalBounds(BaseBounds bounds, BaseTransform tx) {
        if (this.getEffect() == null && this.getClip() == null) {
            return this.getGeomBounds(bounds, tx);
        }
        if (tx.isTranslateOrIdentity()) {
            this.updateLocalBounds();
            bounds = bounds.deriveWithNewBounds(this.localBounds);
            if (!tx.isIdentity()) {
                double translateX = tx.getMxt();
                double translateY = tx.getMyt();
                double translateZ = tx.getMzt();
                bounds = bounds.deriveWithNewBounds((float)((double)bounds.getMinX() + translateX), (float)((double)bounds.getMinY() + translateY), (float)((double)bounds.getMinZ() + translateZ), (float)((double)bounds.getMaxX() + translateX), (float)((double)bounds.getMaxY() + translateY), (float)((double)bounds.getMaxZ() + translateZ));
            }
            return bounds;
        }
        if (tx.is2D() && (tx.getType() & 0xFFFFFFB4) != 0) {
            return this.computeLocalBounds(bounds, tx);
        }
        this.updateLocalBounds();
        return tx.transform(this.localBounds, bounds);
    }

    BaseBounds getGeomBounds(BaseBounds bounds, BaseTransform tx) {
        if (tx.isTranslateOrIdentity()) {
            this.updateGeomBounds();
            bounds = bounds.deriveWithNewBounds(this.geomBounds);
            if (!tx.isIdentity()) {
                double translateX = tx.getMxt();
                double translateY = tx.getMyt();
                double translateZ = tx.getMzt();
                bounds = bounds.deriveWithNewBounds((float)((double)bounds.getMinX() + translateX), (float)((double)bounds.getMinY() + translateY), (float)((double)bounds.getMinZ() + translateZ), (float)((double)bounds.getMaxX() + translateX), (float)((double)bounds.getMaxY() + translateY), (float)((double)bounds.getMaxZ() + translateZ));
            }
            return bounds;
        }
        if (tx.is2D() && (tx.getType() & 0xFFFFFFB4) != 0) {
            return this.impl_computeGeomBounds(bounds, tx);
        }
        this.updateGeomBounds();
        return tx.transform(this.geomBounds, bounds);
    }

    @Deprecated
    public abstract BaseBounds impl_computeGeomBounds(BaseBounds var1, BaseTransform var2);

    void updateGeomBounds() {
        if (this.geomBoundsInvalid) {
            this.geomBounds = this.impl_computeGeomBounds(this.geomBounds, BaseTransform.IDENTITY_TRANSFORM);
            this.geomBoundsInvalid = false;
        }
    }

    private BaseBounds computeLocalBounds(BaseBounds bounds, BaseTransform tx) {
        if (this.getEffect() != null) {
            BaseBounds b = this.getEffect().impl_getBounds(bounds, tx, this, boundsAccessor);
            bounds = bounds.deriveWithNewBounds(b);
        } else {
            bounds = this.getGeomBounds(bounds, tx);
        }
        if (this.getClip() != null && !(this instanceof Shape3D) && !(this.getClip() instanceof Shape3D)) {
            double x1 = bounds.getMinX();
            double y1 = bounds.getMinY();
            double x2 = bounds.getMaxX();
            double y2 = bounds.getMaxY();
            double z1 = bounds.getMinZ();
            double z2 = bounds.getMaxZ();
            bounds = this.getClip().getTransformedBounds(bounds, tx);
            bounds.intersectWith((float)x1, (float)y1, (float)z1, (float)x2, (float)y2, (float)z2);
        }
        return bounds;
    }

    private void updateLocalBounds() {
        if (this.localBoundsInvalid) {
            this.localBounds = this.getClip() != null || this.getEffect() != null ? this.computeLocalBounds(this.localBounds == null ? new RectBounds() : this.localBounds, BaseTransform.IDENTITY_TRANSFORM) : null;
            this.localBoundsInvalid = false;
        }
    }

    void updateTxBounds() {
        if (this.txBoundsInvalid) {
            this.updateLocalToParentTransform();
            this.txBounds = this.getLocalBounds(this.txBounds, this.localToParentTx);
            this.txBoundsInvalid = false;
        }
    }

    @Deprecated
    protected abstract boolean impl_computeContains(double var1, double var3);

    @Deprecated
    protected void impl_geomChanged() {
        if (this.geomBoundsInvalid) {
            this.impl_notifyLayoutBoundsChanged();
            this.transformedBoundsChanged();
            return;
        }
        this.geomBounds.makeEmpty();
        this.geomBoundsInvalid = true;
        this.impl_markDirty(DirtyBits.NODE_BOUNDS);
        this.impl_notifyLayoutBoundsChanged();
        this.localBoundsChanged();
    }

    void localBoundsChanged() {
        this.localBoundsInvalid = true;
        this.invalidateBoundsInLocal();
        this.transformedBoundsChanged();
    }

    void transformedBoundsChanged() {
        if (!this.txBoundsInvalid) {
            this.txBounds.makeEmpty();
            this.txBoundsInvalid = true;
            this.invalidateBoundsInParent();
            this.impl_markDirty(DirtyBits.NODE_TRANSFORMED_BOUNDS);
        }
        if (this.isVisible()) {
            this.notifyParentOfBoundsChange();
        }
    }

    @Deprecated
    protected void impl_notifyLayoutBoundsChanged() {
        this.impl_layoutBoundsChanged();
        Parent p = this.getParent();
        if (this.isManaged() && p != null && (!(p instanceof Group) || this.isResizable()) && !p.performingLayout) {
            p.requestLayout();
        }
    }

    void notifyParentOfBoundsChange() {
        Parent p = this.getParent();
        if (p != null) {
            p.childBoundsChanged(this);
        }
        if (this.clipParent != null) {
            this.clipParent.localBoundsChanged();
        }
    }

    public boolean contains(double localX, double localY) {
        if (this.containsBounds(localX, localY)) {
            return this.isPickOnBounds() || this.impl_computeContains(localX, localY);
        }
        return false;
    }

    @Deprecated
    protected boolean containsBounds(double localX, double localY) {
        TempState tempState = TempState.getInstance();
        BaseBounds tempBounds = tempState.bounds;
        if ((tempBounds = this.getLocalBounds(tempBounds, BaseTransform.IDENTITY_TRANSFORM)).contains((float)localX, (float)localY)) {
            if (this.getClip() != null) {
                tempState.point.x = (float)localX;
                tempState.point.y = (float)localY;
                try {
                    this.getClip().parentToLocal(tempState.point);
                }
                catch (NoninvertibleTransformException e) {
                    return false;
                }
                if (!this.getClip().contains(tempState.point.x, tempState.point.y)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean contains(Point2D localPoint) {
        return this.contains(localPoint.getX(), localPoint.getY());
    }

    public boolean intersects(double localX, double localY, double localWidth, double localHeight) {
        BaseBounds tempBounds = TempState.getInstance().bounds;
        tempBounds = this.getLocalBounds(tempBounds, BaseTransform.IDENTITY_TRANSFORM);
        return tempBounds.intersects((float)localX, (float)localY, (float)localWidth, (float)localHeight);
    }

    public boolean intersects(Bounds localBounds) {
        return this.intersects(localBounds.getMinX(), localBounds.getMinY(), localBounds.getWidth(), localBounds.getHeight());
    }

    public Point2D screenToLocal(double screenX, double screenY) {
        Scene scene = this.getScene();
        if (scene == null) {
            return null;
        }
        Window window = scene.getWindow();
        if (window == null) {
            return null;
        }
        com.sun.javafx.geom.Point2D tempPt = TempState.getInstance().point;
        tempPt.setLocation((float)(screenX - scene.getX() - window.getX()), (float)(screenY - scene.getY() - window.getY()));
        SubScene subScene = this.getSubScene();
        if (subScene != null) {
            Point2D ssCoord = SceneUtils.sceneToSubScenePlane(subScene, new Point2D(tempPt.x, tempPt.y));
            if (ssCoord == null) {
                return null;
            }
            tempPt.setLocation((float)ssCoord.getX(), (float)ssCoord.getY());
        }
        Point3D ppIntersect = scene.getEffectiveCamera().pickProjectPlane(tempPt.x, tempPt.y);
        tempPt.setLocation((float)ppIntersect.getX(), (float)ppIntersect.getY());
        try {
            this.sceneToLocal(tempPt);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
        return new Point2D(tempPt.x, tempPt.y);
    }

    public Point2D screenToLocal(Point2D screenPoint) {
        return this.screenToLocal(screenPoint.getX(), screenPoint.getY());
    }

    public Bounds screenToLocal(Bounds screenBounds) {
        Point2D p1 = this.screenToLocal(screenBounds.getMinX(), screenBounds.getMinY());
        Point2D p2 = this.screenToLocal(screenBounds.getMinX(), screenBounds.getMaxY());
        Point2D p3 = this.screenToLocal(screenBounds.getMaxX(), screenBounds.getMinY());
        Point2D p4 = this.screenToLocal(screenBounds.getMaxX(), screenBounds.getMaxY());
        return BoundsUtils.createBoundingBox(p1, p2, p3, p4);
    }

    public Point2D sceneToLocal(double x, double y, boolean rootScene) {
        if (!rootScene) {
            return this.sceneToLocal(x, y);
        }
        com.sun.javafx.geom.Point2D tempPt = TempState.getInstance().point;
        tempPt.setLocation((float)x, (float)y);
        SubScene subScene = this.getSubScene();
        if (subScene != null) {
            Point2D ssCoord = SceneUtils.sceneToSubScenePlane(subScene, new Point2D(tempPt.x, tempPt.y));
            if (ssCoord == null) {
                return null;
            }
            tempPt.setLocation((float)ssCoord.getX(), (float)ssCoord.getY());
        }
        try {
            this.sceneToLocal(tempPt);
            return new Point2D(tempPt.x, tempPt.y);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    public Point2D sceneToLocal(Point2D point, boolean rootScene) {
        return this.sceneToLocal(point.getX(), point.getY(), rootScene);
    }

    public Bounds sceneToLocal(Bounds bounds, boolean rootScene) {
        if (!rootScene) {
            return this.sceneToLocal(bounds);
        }
        if (bounds.getMinZ() != 0.0 || bounds.getMaxZ() != 0.0) {
            return null;
        }
        Point2D p1 = this.sceneToLocal(bounds.getMinX(), bounds.getMinY(), true);
        Point2D p2 = this.sceneToLocal(bounds.getMinX(), bounds.getMaxY(), true);
        Point2D p3 = this.sceneToLocal(bounds.getMaxX(), bounds.getMinY(), true);
        Point2D p4 = this.sceneToLocal(bounds.getMaxX(), bounds.getMaxY(), true);
        return BoundsUtils.createBoundingBox(p1, p2, p3, p4);
    }

    public Point2D sceneToLocal(double sceneX, double sceneY) {
        com.sun.javafx.geom.Point2D tempPt = TempState.getInstance().point;
        tempPt.setLocation((float)sceneX, (float)sceneY);
        try {
            this.sceneToLocal(tempPt);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
        return new Point2D(tempPt.x, tempPt.y);
    }

    public Point2D sceneToLocal(Point2D scenePoint) {
        return this.sceneToLocal(scenePoint.getX(), scenePoint.getY());
    }

    public Point3D sceneToLocal(Point3D scenePoint) {
        return this.sceneToLocal(scenePoint.getX(), scenePoint.getY(), scenePoint.getZ());
    }

    public Point3D sceneToLocal(double sceneX, double sceneY, double sceneZ) {
        try {
            return this.sceneToLocal0(sceneX, sceneY, sceneZ);
        }
        catch (NoninvertibleTransformException ex) {
            return null;
        }
    }

    private Point3D sceneToLocal0(double x, double y, double z) throws NoninvertibleTransformException {
        Vec3d tempV3D = TempState.getInstance().vec3d;
        tempV3D.set(x, y, z);
        this.sceneToLocal(tempV3D);
        return new Point3D(tempV3D.x, tempV3D.y, tempV3D.z);
    }

    public Bounds sceneToLocal(Bounds sceneBounds) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && sceneBounds.getMinZ() == 0.0 && sceneBounds.getMaxZ() == 0.0) {
            Point2D p1 = this.sceneToLocal(sceneBounds.getMinX(), sceneBounds.getMinY());
            Point2D p2 = this.sceneToLocal(sceneBounds.getMaxX(), sceneBounds.getMinY());
            Point2D p3 = this.sceneToLocal(sceneBounds.getMaxX(), sceneBounds.getMaxY());
            Point2D p4 = this.sceneToLocal(sceneBounds.getMinX(), sceneBounds.getMaxY());
            return BoundsUtils.createBoundingBox(p1, p2, p3, p4);
        }
        try {
            Point3D p1 = this.sceneToLocal0(sceneBounds.getMinX(), sceneBounds.getMinY(), sceneBounds.getMinZ());
            Point3D p2 = this.sceneToLocal0(sceneBounds.getMinX(), sceneBounds.getMinY(), sceneBounds.getMaxZ());
            Point3D p3 = this.sceneToLocal0(sceneBounds.getMinX(), sceneBounds.getMaxY(), sceneBounds.getMinZ());
            Point3D p4 = this.sceneToLocal0(sceneBounds.getMinX(), sceneBounds.getMaxY(), sceneBounds.getMaxZ());
            Point3D p5 = this.sceneToLocal0(sceneBounds.getMaxX(), sceneBounds.getMaxY(), sceneBounds.getMinZ());
            Point3D p6 = this.sceneToLocal0(sceneBounds.getMaxX(), sceneBounds.getMaxY(), sceneBounds.getMaxZ());
            Point3D p7 = this.sceneToLocal0(sceneBounds.getMaxX(), sceneBounds.getMinY(), sceneBounds.getMinZ());
            Point3D p8 = this.sceneToLocal0(sceneBounds.getMaxX(), sceneBounds.getMinY(), sceneBounds.getMaxZ());
            return BoundsUtils.createBoundingBox(p1, p2, p3, p4, p5, p6, p7, p8);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    public Point2D localToScreen(double localX, double localY) {
        return this.localToScreen(localX, localY, 0.0);
    }

    public Point2D localToScreen(Point2D localPoint) {
        return this.localToScreen(localPoint.getX(), localPoint.getY());
    }

    public Point2D localToScreen(double localX, double localY, double localZ) {
        Scene scene = this.getScene();
        if (scene == null) {
            return null;
        }
        Window window = scene.getWindow();
        if (window == null) {
            return null;
        }
        Point3D pt = this.localToScene(localX, localY, localZ);
        SubScene subScene = this.getSubScene();
        if (subScene != null) {
            pt = SceneUtils.subSceneToScene(subScene, pt);
        }
        Point2D projection = CameraHelper.project(SceneHelper.getEffectiveCamera(this.getScene()), pt);
        return new Point2D(projection.getX() + scene.getX() + window.getX(), projection.getY() + scene.getY() + window.getY());
    }

    public Point2D localToScreen(Point3D localPoint) {
        return this.localToScreen(localPoint.getX(), localPoint.getY(), localPoint.getZ());
    }

    public Bounds localToScreen(Bounds localBounds) {
        Point2D p1 = this.localToScreen(localBounds.getMinX(), localBounds.getMinY(), localBounds.getMinZ());
        Point2D p2 = this.localToScreen(localBounds.getMinX(), localBounds.getMinY(), localBounds.getMaxZ());
        Point2D p3 = this.localToScreen(localBounds.getMinX(), localBounds.getMaxY(), localBounds.getMinZ());
        Point2D p4 = this.localToScreen(localBounds.getMinX(), localBounds.getMaxY(), localBounds.getMaxZ());
        Point2D p5 = this.localToScreen(localBounds.getMaxX(), localBounds.getMaxY(), localBounds.getMinZ());
        Point2D p6 = this.localToScreen(localBounds.getMaxX(), localBounds.getMaxY(), localBounds.getMaxZ());
        Point2D p7 = this.localToScreen(localBounds.getMaxX(), localBounds.getMinY(), localBounds.getMinZ());
        Point2D p8 = this.localToScreen(localBounds.getMaxX(), localBounds.getMinY(), localBounds.getMaxZ());
        return BoundsUtils.createBoundingBox(p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public Point2D localToScene(double localX, double localY) {
        com.sun.javafx.geom.Point2D tempPt = TempState.getInstance().point;
        tempPt.setLocation((float)localX, (float)localY);
        this.localToScene(tempPt);
        return new Point2D(tempPt.x, tempPt.y);
    }

    public Point2D localToScene(Point2D localPoint) {
        return this.localToScene(localPoint.getX(), localPoint.getY());
    }

    public Point3D localToScene(Point3D localPoint) {
        return this.localToScene(localPoint.getX(), localPoint.getY(), localPoint.getZ());
    }

    public Point3D localToScene(double x, double y, double z) {
        Vec3d tempV3D = TempState.getInstance().vec3d;
        tempV3D.set(x, y, z);
        this.localToScene(tempV3D);
        return new Point3D(tempV3D.x, tempV3D.y, tempV3D.z);
    }

    public Point3D localToScene(Point3D localPoint, boolean rootScene) {
        SubScene subScene;
        Point3D pt = this.localToScene(localPoint);
        if (rootScene && (subScene = this.getSubScene()) != null) {
            pt = SceneUtils.subSceneToScene(subScene, pt);
        }
        return pt;
    }

    public Point3D localToScene(double x, double y, double z, boolean rootScene) {
        return this.localToScene(new Point3D(x, y, z), rootScene);
    }

    public Point2D localToScene(Point2D localPoint, boolean rootScene) {
        if (!rootScene) {
            return this.localToScene(localPoint);
        }
        Point3D pt = this.localToScene(localPoint.getX(), localPoint.getY(), 0.0, rootScene);
        return new Point2D(pt.getX(), pt.getY());
    }

    public Point2D localToScene(double x, double y, boolean rootScene) {
        return this.localToScene(new Point2D(x, y), rootScene);
    }

    public Bounds localToScene(Bounds localBounds, boolean rootScene) {
        if (!rootScene) {
            return this.localToScene(localBounds);
        }
        Point3D p1 = this.localToScene(localBounds.getMinX(), localBounds.getMinY(), localBounds.getMinZ(), true);
        Point3D p2 = this.localToScene(localBounds.getMinX(), localBounds.getMinY(), localBounds.getMaxZ(), true);
        Point3D p3 = this.localToScene(localBounds.getMinX(), localBounds.getMaxY(), localBounds.getMinZ(), true);
        Point3D p4 = this.localToScene(localBounds.getMinX(), localBounds.getMaxY(), localBounds.getMaxZ(), true);
        Point3D p5 = this.localToScene(localBounds.getMaxX(), localBounds.getMaxY(), localBounds.getMinZ(), true);
        Point3D p6 = this.localToScene(localBounds.getMaxX(), localBounds.getMaxY(), localBounds.getMaxZ(), true);
        Point3D p7 = this.localToScene(localBounds.getMaxX(), localBounds.getMinY(), localBounds.getMinZ(), true);
        Point3D p8 = this.localToScene(localBounds.getMaxX(), localBounds.getMinY(), localBounds.getMaxZ(), true);
        return BoundsUtils.createBoundingBox(p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public Bounds localToScene(Bounds localBounds) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && localBounds.getMinZ() == 0.0 && localBounds.getMaxZ() == 0.0) {
            Point2D p1 = this.localToScene(localBounds.getMinX(), localBounds.getMinY());
            Point2D p2 = this.localToScene(localBounds.getMaxX(), localBounds.getMinY());
            Point2D p3 = this.localToScene(localBounds.getMaxX(), localBounds.getMaxY());
            Point2D p4 = this.localToScene(localBounds.getMinX(), localBounds.getMaxY());
            return BoundsUtils.createBoundingBox(p1, p2, p3, p4);
        }
        Point3D p1 = this.localToScene(localBounds.getMinX(), localBounds.getMinY(), localBounds.getMinZ());
        Point3D p2 = this.localToScene(localBounds.getMinX(), localBounds.getMinY(), localBounds.getMaxZ());
        Point3D p3 = this.localToScene(localBounds.getMinX(), localBounds.getMaxY(), localBounds.getMinZ());
        Point3D p4 = this.localToScene(localBounds.getMinX(), localBounds.getMaxY(), localBounds.getMaxZ());
        Point3D p5 = this.localToScene(localBounds.getMaxX(), localBounds.getMaxY(), localBounds.getMinZ());
        Point3D p6 = this.localToScene(localBounds.getMaxX(), localBounds.getMaxY(), localBounds.getMaxZ());
        Point3D p7 = this.localToScene(localBounds.getMaxX(), localBounds.getMinY(), localBounds.getMinZ());
        Point3D p8 = this.localToScene(localBounds.getMaxX(), localBounds.getMinY(), localBounds.getMaxZ());
        return BoundsUtils.createBoundingBox(p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public Point2D parentToLocal(double parentX, double parentY) {
        com.sun.javafx.geom.Point2D tempPt = TempState.getInstance().point;
        tempPt.setLocation((float)parentX, (float)parentY);
        try {
            this.parentToLocal(tempPt);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
        return new Point2D(tempPt.x, tempPt.y);
    }

    public Point2D parentToLocal(Point2D parentPoint) {
        return this.parentToLocal(parentPoint.getX(), parentPoint.getY());
    }

    public Point3D parentToLocal(Point3D parentPoint) {
        return this.parentToLocal(parentPoint.getX(), parentPoint.getY(), parentPoint.getZ());
    }

    public Point3D parentToLocal(double parentX, double parentY, double parentZ) {
        Vec3d tempV3D = TempState.getInstance().vec3d;
        tempV3D.set(parentX, parentY, parentZ);
        try {
            this.parentToLocal(tempV3D);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
        return new Point3D(tempV3D.x, tempV3D.y, tempV3D.z);
    }

    public Bounds parentToLocal(Bounds parentBounds) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && parentBounds.getMinZ() == 0.0 && parentBounds.getMaxZ() == 0.0) {
            Point2D p1 = this.parentToLocal(parentBounds.getMinX(), parentBounds.getMinY());
            Point2D p2 = this.parentToLocal(parentBounds.getMaxX(), parentBounds.getMinY());
            Point2D p3 = this.parentToLocal(parentBounds.getMaxX(), parentBounds.getMaxY());
            Point2D p4 = this.parentToLocal(parentBounds.getMinX(), parentBounds.getMaxY());
            return BoundsUtils.createBoundingBox(p1, p2, p3, p4);
        }
        Point3D p1 = this.parentToLocal(parentBounds.getMinX(), parentBounds.getMinY(), parentBounds.getMinZ());
        Point3D p2 = this.parentToLocal(parentBounds.getMinX(), parentBounds.getMinY(), parentBounds.getMaxZ());
        Point3D p3 = this.parentToLocal(parentBounds.getMinX(), parentBounds.getMaxY(), parentBounds.getMinZ());
        Point3D p4 = this.parentToLocal(parentBounds.getMinX(), parentBounds.getMaxY(), parentBounds.getMaxZ());
        Point3D p5 = this.parentToLocal(parentBounds.getMaxX(), parentBounds.getMaxY(), parentBounds.getMinZ());
        Point3D p6 = this.parentToLocal(parentBounds.getMaxX(), parentBounds.getMaxY(), parentBounds.getMaxZ());
        Point3D p7 = this.parentToLocal(parentBounds.getMaxX(), parentBounds.getMinY(), parentBounds.getMinZ());
        Point3D p8 = this.parentToLocal(parentBounds.getMaxX(), parentBounds.getMinY(), parentBounds.getMaxZ());
        return BoundsUtils.createBoundingBox(p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public Point2D localToParent(double localX, double localY) {
        com.sun.javafx.geom.Point2D tempPt = TempState.getInstance().point;
        tempPt.setLocation((float)localX, (float)localY);
        this.localToParent(tempPt);
        return new Point2D(tempPt.x, tempPt.y);
    }

    public Point2D localToParent(Point2D localPoint) {
        return this.localToParent(localPoint.getX(), localPoint.getY());
    }

    public Point3D localToParent(Point3D localPoint) {
        return this.localToParent(localPoint.getX(), localPoint.getY(), localPoint.getZ());
    }

    public Point3D localToParent(double x, double y, double z) {
        Vec3d tempV3D = TempState.getInstance().vec3d;
        tempV3D.set(x, y, z);
        this.localToParent(tempV3D);
        return new Point3D(tempV3D.x, tempV3D.y, tempV3D.z);
    }

    public Bounds localToParent(Bounds localBounds) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && localBounds.getMinZ() == 0.0 && localBounds.getMaxZ() == 0.0) {
            Point2D p1 = this.localToParent(localBounds.getMinX(), localBounds.getMinY());
            Point2D p2 = this.localToParent(localBounds.getMaxX(), localBounds.getMinY());
            Point2D p3 = this.localToParent(localBounds.getMaxX(), localBounds.getMaxY());
            Point2D p4 = this.localToParent(localBounds.getMinX(), localBounds.getMaxY());
            return BoundsUtils.createBoundingBox(p1, p2, p3, p4);
        }
        Point3D p1 = this.localToParent(localBounds.getMinX(), localBounds.getMinY(), localBounds.getMinZ());
        Point3D p2 = this.localToParent(localBounds.getMinX(), localBounds.getMinY(), localBounds.getMaxZ());
        Point3D p3 = this.localToParent(localBounds.getMinX(), localBounds.getMaxY(), localBounds.getMinZ());
        Point3D p4 = this.localToParent(localBounds.getMinX(), localBounds.getMaxY(), localBounds.getMaxZ());
        Point3D p5 = this.localToParent(localBounds.getMaxX(), localBounds.getMaxY(), localBounds.getMinZ());
        Point3D p6 = this.localToParent(localBounds.getMaxX(), localBounds.getMaxY(), localBounds.getMaxZ());
        Point3D p7 = this.localToParent(localBounds.getMaxX(), localBounds.getMinY(), localBounds.getMinZ());
        Point3D p8 = this.localToParent(localBounds.getMaxX(), localBounds.getMinY(), localBounds.getMaxZ());
        return BoundsUtils.createBoundingBox(p1, p2, p3, p4, p5, p6, p7, p8);
    }

    BaseTransform getLocalToParentTransform(BaseTransform tx) {
        this.updateLocalToParentTransform();
        tx.setTransform(this.localToParentTx);
        return tx;
    }

    @Deprecated
    public final BaseTransform impl_getLeafTransform() {
        return this.getLocalToParentTransform(TempState.getInstance().leafTx);
    }

    @Deprecated
    public void impl_transformsChanged() {
        if (!this.transformDirty) {
            this.impl_markDirty(DirtyBits.NODE_TRANSFORM);
            this.transformDirty = true;
            this.transformedBoundsChanged();
        }
        this.invalidateLocalToParentTransform();
        this.invalidateLocalToSceneTransform();
    }

    @Deprecated
    public final double impl_getPivotX() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getMinX() + bounds.getWidth() / 2.0;
    }

    @Deprecated
    public final double impl_getPivotY() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getMinY() + bounds.getHeight() / 2.0;
    }

    @Deprecated
    public final double impl_getPivotZ() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getMinZ() + bounds.getDepth() / 2.0;
    }

    void updateLocalToParentTransform() {
        if (this.transformDirty) {
            this.localToParentTx.setToIdentity();
            boolean mirror = false;
            double mirroringCenter = 0.0;
            if (this.hasMirroring()) {
                Scene sceneValue = this.getScene();
                if (sceneValue != null && sceneValue.getRoot() == this) {
                    mirroringCenter = sceneValue.getWidth() / 2.0;
                    if (mirroringCenter == 0.0) {
                        mirroringCenter = this.impl_getPivotX();
                    }
                    this.localToParentTx = this.localToParentTx.deriveWithTranslation(mirroringCenter, 0.0);
                    this.localToParentTx = this.localToParentTx.deriveWithScale(-1.0, 1.0, 1.0);
                    this.localToParentTx = this.localToParentTx.deriveWithTranslation(-mirroringCenter, 0.0);
                } else {
                    mirror = true;
                    mirroringCenter = this.impl_getPivotX();
                }
            }
            if (this.getScaleX() != 1.0 || this.getScaleY() != 1.0 || this.getScaleZ() != 1.0 || this.getRotate() != 0.0) {
                double pivotX = this.impl_getPivotX();
                double pivotY = this.impl_getPivotY();
                double pivotZ = this.impl_getPivotZ();
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(this.getTranslateX() + this.getLayoutX() + pivotX, this.getTranslateY() + this.getLayoutY() + pivotY, this.getTranslateZ() + pivotZ);
                this.localToParentTx = this.localToParentTx.deriveWithRotation(Math.toRadians(this.getRotate()), this.getRotationAxis().getX(), this.getRotationAxis().getY(), this.getRotationAxis().getZ());
                this.localToParentTx = this.localToParentTx.deriveWithScale(this.getScaleX(), this.getScaleY(), this.getScaleZ());
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(-pivotX, -pivotY, -pivotZ);
            } else {
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(this.getTranslateX() + this.getLayoutX(), this.getTranslateY() + this.getLayoutY(), this.getTranslateZ());
            }
            if (this.impl_hasTransforms()) {
                for (Transform t : this.getTransforms()) {
                    this.localToParentTx = t.impl_derive(this.localToParentTx);
                }
            }
            if (mirror) {
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(mirroringCenter, 0.0);
                this.localToParentTx = this.localToParentTx.deriveWithScale(-1.0, 1.0, 1.0);
                this.localToParentTx = this.localToParentTx.deriveWithTranslation(-mirroringCenter, 0.0);
            }
            this.transformDirty = false;
        }
    }

    void parentToLocal(com.sun.javafx.geom.Point2D pt) throws NoninvertibleTransformException {
        this.updateLocalToParentTransform();
        this.localToParentTx.inverseTransform(pt, pt);
    }

    void parentToLocal(Vec3d pt) throws NoninvertibleTransformException {
        this.updateLocalToParentTransform();
        this.localToParentTx.inverseTransform(pt, pt);
    }

    void sceneToLocal(com.sun.javafx.geom.Point2D pt) throws NoninvertibleTransformException {
        if (this.getParent() != null) {
            this.getParent().sceneToLocal(pt);
        }
        this.parentToLocal(pt);
    }

    void sceneToLocal(Vec3d pt) throws NoninvertibleTransformException {
        if (this.getParent() != null) {
            this.getParent().sceneToLocal(pt);
        }
        this.parentToLocal(pt);
    }

    void localToScene(com.sun.javafx.geom.Point2D pt) {
        this.localToParent(pt);
        if (this.getParent() != null) {
            this.getParent().localToScene(pt);
        }
    }

    void localToScene(Vec3d pt) {
        this.localToParent(pt);
        if (this.getParent() != null) {
            this.getParent().localToScene(pt);
        }
    }

    void localToParent(com.sun.javafx.geom.Point2D pt) {
        this.updateLocalToParentTransform();
        this.localToParentTx.transform(pt, pt);
    }

    void localToParent(Vec3d pt) {
        this.updateLocalToParentTransform();
        this.localToParentTx.transform(pt, pt);
    }

    @Deprecated
    protected void impl_pickNodeLocal(PickRay localPickRay, PickResultChooser result) {
        this.impl_intersects(localPickRay, result);
    }

    @Deprecated
    public final void impl_pickNode(PickRay pickRay, PickResultChooser result) {
        if (!this.isVisible() || this.isDisable() || this.isMouseTransparent()) {
            return;
        }
        Vec3d o = pickRay.getOriginNoClone();
        double ox = o.x;
        double oy = o.y;
        double oz = o.z;
        Vec3d d = pickRay.getDirectionNoClone();
        double dx = d.x;
        double dy = d.y;
        double dz = d.z;
        this.updateLocalToParentTransform();
        try {
            this.localToParentTx.inverseTransform(o, o);
            this.localToParentTx.inverseDeltaTransform(d, d);
            this.impl_pickNodeLocal(pickRay, result);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        pickRay.setOrigin(ox, oy, oz);
        pickRay.setDirection(dx, dy, dz);
    }

    @Deprecated
    protected final boolean impl_intersects(PickRay pickRay, PickResultChooser pickResult) {
        double boundsDistance = this.impl_intersectsBounds(pickRay);
        if (!Double.isNaN(boundsDistance)) {
            if (this.isPickOnBounds()) {
                if (pickResult != null) {
                    pickResult.offer(this, boundsDistance, PickResultChooser.computePoint(pickRay, boundsDistance));
                }
                return true;
            }
            return this.impl_computeIntersects(pickRay, pickResult);
        }
        return false;
    }

    @Deprecated
    protected boolean impl_computeIntersects(PickRay pickRay, PickResultChooser pickResult) {
        double origZ = pickRay.getOriginNoClone().z;
        double dirZ = pickRay.getDirectionNoClone().z;
        if (Node.almostZero(dirZ)) {
            return false;
        }
        double t = -origZ / dirZ;
        if (t < pickRay.getNearClip() || t > pickRay.getFarClip()) {
            return false;
        }
        double x = pickRay.getOriginNoClone().x + pickRay.getDirectionNoClone().x * t;
        double y = pickRay.getOriginNoClone().y + pickRay.getDirectionNoClone().y * t;
        if (this.contains((float)x, (float)y)) {
            if (pickResult != null) {
                pickResult.offer(this, t, PickResultChooser.computePoint(pickRay, t));
            }
            return true;
        }
        return false;
    }

    @Deprecated
    protected final double impl_intersectsBounds(PickRay pickRay) {
        double tmax;
        double tmin;
        Vec3d dir = pickRay.getDirectionNoClone();
        Vec3d origin = pickRay.getOriginNoClone();
        double originX = origin.x;
        double originY = origin.y;
        double originZ = origin.z;
        TempState tempState = TempState.getInstance();
        BaseBounds tempBounds = tempState.bounds;
        tempBounds = this.getLocalBounds(tempBounds, BaseTransform.IDENTITY_TRANSFORM);
        if (dir.x == 0.0 && dir.y == 0.0) {
            if (dir.z == 0.0) {
                return Double.NaN;
            }
            if (originX < (double)tempBounds.getMinX() || originX > (double)tempBounds.getMaxX() || originY < (double)tempBounds.getMinY() || originY > (double)tempBounds.getMaxY()) {
                return Double.NaN;
            }
            double invDirZ = 1.0 / dir.z;
            boolean signZ = invDirZ < 0.0;
            double minZ = tempBounds.getMinZ();
            double maxZ = tempBounds.getMaxZ();
            tmin = ((signZ ? maxZ : minZ) - originZ) * invDirZ;
            tmax = ((signZ ? minZ : maxZ) - originZ) * invDirZ;
        } else if ((double)tempBounds.getDepth() == 0.0) {
            if (Node.almostZero(dir.z)) {
                return Double.NaN;
            }
            double t = ((double)tempBounds.getMinZ() - originZ) / dir.z;
            double x = originX + dir.x * t;
            double y = originY + dir.y * t;
            if (x < (double)tempBounds.getMinX() || x > (double)tempBounds.getMaxX() || y < (double)tempBounds.getMinY() || y > (double)tempBounds.getMaxY()) {
                return Double.NaN;
            }
            tmin = tmax = t;
        } else {
            double invDirX = dir.x == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.x;
            double invDirY = dir.y == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.y;
            double invDirZ = dir.z == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.z;
            boolean signX = invDirX < 0.0;
            boolean signY = invDirY < 0.0;
            boolean signZ = invDirZ < 0.0;
            double minX = tempBounds.getMinX();
            double minY = tempBounds.getMinY();
            double maxX = tempBounds.getMaxX();
            double maxY = tempBounds.getMaxY();
            tmin = Double.NEGATIVE_INFINITY;
            tmax = Double.POSITIVE_INFINITY;
            if (Double.isInfinite(invDirX)) {
                if (!(minX <= originX) || !(maxX >= originX)) {
                    return Double.NaN;
                }
            } else {
                tmin = ((signX ? maxX : minX) - originX) * invDirX;
                tmax = ((signX ? minX : maxX) - originX) * invDirX;
            }
            if (Double.isInfinite(invDirY)) {
                if (!(minY <= originY) || !(maxY >= originY)) {
                    return Double.NaN;
                }
            } else {
                double tymin = ((signY ? maxY : minY) - originY) * invDirY;
                double tymax = ((signY ? minY : maxY) - originY) * invDirY;
                if (tmin > tymax || tymin > tmax) {
                    return Double.NaN;
                }
                if (tymin > tmin) {
                    tmin = tymin;
                }
                if (tymax < tmax) {
                    tmax = tymax;
                }
            }
            double minZ = tempBounds.getMinZ();
            double maxZ = tempBounds.getMaxZ();
            if (Double.isInfinite(invDirZ)) {
                if (!(minZ <= originZ) || !(maxZ >= originZ)) {
                    return Double.NaN;
                }
            } else {
                double tzmin = ((signZ ? maxZ : minZ) - originZ) * invDirZ;
                double tzmax = ((signZ ? minZ : maxZ) - originZ) * invDirZ;
                if (tmin > tzmax || tzmin > tmax) {
                    return Double.NaN;
                }
                if (tzmin > tmin) {
                    tmin = tzmin;
                }
                if (tzmax < tmax) {
                    tmax = tzmax;
                }
            }
        }
        Node clip = this.getClip();
        if (clip != null && !(this instanceof Shape3D) && !(clip instanceof Shape3D)) {
            double dirX = dir.x;
            double dirY = dir.y;
            double dirZ = dir.z;
            clip.updateLocalToParentTransform();
            boolean hitClip = true;
            try {
                clip.localToParentTx.inverseTransform(origin, origin);
                clip.localToParentTx.inverseDeltaTransform(dir, dir);
            }
            catch (NoninvertibleTransformException e) {
                hitClip = false;
            }
            hitClip = hitClip && clip.impl_intersects(pickRay, null);
            pickRay.setOrigin(originX, originY, originZ);
            pickRay.setDirection(dirX, dirY, dirZ);
            if (!hitClip) {
                return Double.NaN;
            }
        }
        if (Double.isInfinite(tmin) || Double.isNaN(tmin)) {
            return Double.NaN;
        }
        double minDistance = pickRay.getNearClip();
        double maxDistance = pickRay.getFarClip();
        if (tmin < minDistance) {
            if (tmax >= minDistance) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (tmin > maxDistance) {
            return Double.NaN;
        }
        return tmin;
    }

    static boolean almostZero(double a) {
        return a < 1.0E-5 && a > -1.0E-5;
    }

    public final ObservableList<Transform> getTransforms() {
        return this.transformsProperty();
    }

    private ObservableList<Transform> transformsProperty() {
        return this.getNodeTransformation().getTransforms();
    }

    public final void setTranslateX(double value) {
        this.translateXProperty().set(value);
    }

    public final double getTranslateX() {
        return this.nodeTransformation == null ? 0.0 : this.nodeTransformation.getTranslateX();
    }

    public final DoubleProperty translateXProperty() {
        return this.getNodeTransformation().translateXProperty();
    }

    public final void setTranslateY(double value) {
        this.translateYProperty().set(value);
    }

    public final double getTranslateY() {
        return this.nodeTransformation == null ? 0.0 : this.nodeTransformation.getTranslateY();
    }

    public final DoubleProperty translateYProperty() {
        return this.getNodeTransformation().translateYProperty();
    }

    public final void setTranslateZ(double value) {
        this.translateZProperty().set(value);
    }

    public final double getTranslateZ() {
        return this.nodeTransformation == null ? 0.0 : this.nodeTransformation.getTranslateZ();
    }

    public final DoubleProperty translateZProperty() {
        return this.getNodeTransformation().translateZProperty();
    }

    public final void setScaleX(double value) {
        this.scaleXProperty().set(value);
    }

    public final double getScaleX() {
        return this.nodeTransformation == null ? 1.0 : this.nodeTransformation.getScaleX();
    }

    public final DoubleProperty scaleXProperty() {
        return this.getNodeTransformation().scaleXProperty();
    }

    public final void setScaleY(double value) {
        this.scaleYProperty().set(value);
    }

    public final double getScaleY() {
        return this.nodeTransformation == null ? 1.0 : this.nodeTransformation.getScaleY();
    }

    public final DoubleProperty scaleYProperty() {
        return this.getNodeTransformation().scaleYProperty();
    }

    public final void setScaleZ(double value) {
        this.scaleZProperty().set(value);
    }

    public final double getScaleZ() {
        return this.nodeTransformation == null ? 1.0 : this.nodeTransformation.getScaleZ();
    }

    public final DoubleProperty scaleZProperty() {
        return this.getNodeTransformation().scaleZProperty();
    }

    public final void setRotate(double value) {
        this.rotateProperty().set(value);
    }

    public final double getRotate() {
        return this.nodeTransformation == null ? 0.0 : this.nodeTransformation.getRotate();
    }

    public final DoubleProperty rotateProperty() {
        return this.getNodeTransformation().rotateProperty();
    }

    public final void setRotationAxis(Point3D value) {
        this.rotationAxisProperty().set(value);
    }

    public final Point3D getRotationAxis() {
        return this.nodeTransformation == null ? DEFAULT_ROTATION_AXIS : this.nodeTransformation.getRotationAxis();
    }

    public final ObjectProperty<Point3D> rotationAxisProperty() {
        return this.getNodeTransformation().rotationAxisProperty();
    }

    public final ReadOnlyObjectProperty<Transform> localToParentTransformProperty() {
        return this.getNodeTransformation().localToParentTransformProperty();
    }

    private void invalidateLocalToParentTransform() {
        if (this.nodeTransformation != null) {
            this.nodeTransformation.invalidateLocalToParentTransform();
        }
    }

    public final Transform getLocalToParentTransform() {
        return (Transform)this.localToParentTransformProperty().get();
    }

    public final ReadOnlyObjectProperty<Transform> localToSceneTransformProperty() {
        return this.getNodeTransformation().localToSceneTransformProperty();
    }

    private void invalidateLocalToSceneTransform() {
        if (this.nodeTransformation != null) {
            this.nodeTransformation.invalidateLocalToSceneTransform();
        }
    }

    public final Transform getLocalToSceneTransform() {
        return (Transform)this.localToSceneTransformProperty().get();
    }

    private NodeTransformation getNodeTransformation() {
        if (this.nodeTransformation == null) {
            this.nodeTransformation = new NodeTransformation();
        }
        return this.nodeTransformation;
    }

    @Deprecated
    public boolean impl_hasTransforms() {
        return this.nodeTransformation != null && this.nodeTransformation.hasTransforms();
    }

    Transform getCurrentLocalToSceneTransformState() {
        if (this.nodeTransformation == null || this.nodeTransformation.localToSceneTransform == null) {
            return null;
        }
        return this.nodeTransformation.localToSceneTransform.transform;
    }

    private EventHandlerProperties getEventHandlerProperties() {
        if (this.eventHandlerProperties == null) {
            this.eventHandlerProperties = new EventHandlerProperties(this.getInternalEventDispatcher().getEventHandlerManager(), this);
        }
        return this.eventHandlerProperties;
    }

    public final void setNodeOrientation(NodeOrientation orientation) {
        this.nodeOrientationProperty().set(orientation);
    }

    public final NodeOrientation getNodeOrientation() {
        return this.nodeOrientation == null ? NodeOrientation.INHERIT : (NodeOrientation)((Object)this.nodeOrientation.get());
    }

    public final ObjectProperty<NodeOrientation> nodeOrientationProperty() {
        if (this.nodeOrientation == null) {
            this.nodeOrientation = new StyleableObjectProperty<NodeOrientation>(NodeOrientation.INHERIT){

                @Override
                protected void invalidated() {
                    Node.this.nodeResolvedOrientationInvalidated();
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "nodeOrientation";
                }

                @Override
                public CssMetaData getCssMetaData() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
        return this.nodeOrientation;
    }

    public final NodeOrientation getEffectiveNodeOrientation() {
        return Node.getEffectiveOrientation(this.resolvedNodeOrientation) == 0 ? NodeOrientation.LEFT_TO_RIGHT : NodeOrientation.RIGHT_TO_LEFT;
    }

    public final ReadOnlyObjectProperty<NodeOrientation> effectiveNodeOrientationProperty() {
        if (this.effectiveNodeOrientationProperty == null) {
            this.effectiveNodeOrientationProperty = new EffectiveOrientationProperty();
        }
        return this.effectiveNodeOrientationProperty;
    }

    public boolean usesMirroring() {
        return true;
    }

    final void parentResolvedOrientationInvalidated() {
        if (this.getNodeOrientation() == NodeOrientation.INHERIT) {
            this.nodeResolvedOrientationInvalidated();
        } else {
            this.impl_transformsChanged();
        }
    }

    final void nodeResolvedOrientationInvalidated() {
        byte oldResolvedNodeOrientation = this.resolvedNodeOrientation;
        this.resolvedNodeOrientation = (byte)(this.calcEffectiveNodeOrientation() | this.calcAutomaticNodeOrientation());
        if (this.effectiveNodeOrientationProperty != null && Node.getEffectiveOrientation(this.resolvedNodeOrientation) != Node.getEffectiveOrientation(oldResolvedNodeOrientation)) {
            this.effectiveNodeOrientationProperty.invalidate();
        }
        this.impl_transformsChanged();
        if (this.resolvedNodeOrientation != oldResolvedNodeOrientation) {
            this.nodeResolvedOrientationChanged();
        }
    }

    void nodeResolvedOrientationChanged() {
    }

    private Node getMirroringOrientationParent() {
        for (Parent parentValue = this.getParent(); parentValue != null; parentValue = parentValue.getParent()) {
            if (!parentValue.usesMirroring()) continue;
            return parentValue;
        }
        SubScene subSceneValue = this.getSubScene();
        if (subSceneValue != null) {
            return subSceneValue;
        }
        return null;
    }

    private Node getOrientationParent() {
        Parent parentValue = this.getParent();
        if (parentValue != null) {
            return parentValue;
        }
        SubScene subSceneValue = this.getSubScene();
        if (subSceneValue != null) {
            return subSceneValue;
        }
        return null;
    }

    private byte calcEffectiveNodeOrientation() {
        NodeOrientation nodeOrientationValue = this.getNodeOrientation();
        if (nodeOrientationValue != NodeOrientation.INHERIT) {
            return nodeOrientationValue == NodeOrientation.LEFT_TO_RIGHT ? (byte)0 : 1;
        }
        Node parentValue = this.getOrientationParent();
        if (parentValue != null) {
            return Node.getEffectiveOrientation(parentValue.resolvedNodeOrientation);
        }
        Scene sceneValue = this.getScene();
        if (sceneValue != null) {
            return sceneValue.getEffectiveNodeOrientation() == NodeOrientation.LEFT_TO_RIGHT ? (byte)0 : 1;
        }
        return 0;
    }

    private byte calcAutomaticNodeOrientation() {
        if (!this.usesMirroring()) {
            return 0;
        }
        NodeOrientation nodeOrientationValue = this.getNodeOrientation();
        if (nodeOrientationValue != NodeOrientation.INHERIT) {
            return nodeOrientationValue == NodeOrientation.LEFT_TO_RIGHT ? (byte)0 : 2;
        }
        Node parentValue = this.getMirroringOrientationParent();
        if (parentValue != null) {
            return Node.getAutomaticOrientation(parentValue.resolvedNodeOrientation);
        }
        Scene sceneValue = this.getScene();
        if (sceneValue != null) {
            return sceneValue.getEffectiveNodeOrientation() == NodeOrientation.LEFT_TO_RIGHT ? (byte)0 : 2;
        }
        return 0;
    }

    final boolean hasMirroring() {
        Node parentValue = this.getOrientationParent();
        byte thisOrientation = Node.getAutomaticOrientation(this.resolvedNodeOrientation);
        byte parentOrientation = parentValue != null ? Node.getAutomaticOrientation(parentValue.resolvedNodeOrientation) : (byte)0;
        return thisOrientation != parentOrientation;
    }

    private static byte getEffectiveOrientation(byte resolvedNodeOrientation) {
        return (byte)(resolvedNodeOrientation & 1);
    }

    private static byte getAutomaticOrientation(byte resolvedNodeOrientation) {
        return (byte)(resolvedNodeOrientation & 2);
    }

    private MiscProperties getMiscProperties() {
        if (this.miscProperties == null) {
            this.miscProperties = new MiscProperties();
        }
        return this.miscProperties;
    }

    public final void setMouseTransparent(boolean value) {
        this.mouseTransparentProperty().set(value);
    }

    public final boolean isMouseTransparent() {
        return this.miscProperties == null ? false : this.miscProperties.isMouseTransparent();
    }

    public final BooleanProperty mouseTransparentProperty() {
        return this.getMiscProperties().mouseTransparentProperty();
    }

    protected final void setHover(boolean value) {
        this.hoverPropertyImpl().set(value);
    }

    public final boolean isHover() {
        return this.hover == null ? false : this.hover.get();
    }

    public final ReadOnlyBooleanProperty hoverProperty() {
        return this.hoverPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper hoverPropertyImpl() {
        if (this.hover == null) {
            this.hover = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    PlatformLogger logger = Logging.getInputLogger();
                    if (logger.isLoggable(PlatformLogger.Level.FINER)) {
                        logger.finer(this + " hover=" + this.get());
                    }
                    Node.this.pseudoClassStateChanged(HOVER_PSEUDOCLASS_STATE, this.get());
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "hover";
                }
            };
        }
        return this.hover;
    }

    protected final void setPressed(boolean value) {
        this.pressedPropertyImpl().set(value);
    }

    public final boolean isPressed() {
        return this.pressed == null ? false : this.pressed.get();
    }

    public final ReadOnlyBooleanProperty pressedProperty() {
        return this.pressedPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper pressedPropertyImpl() {
        if (this.pressed == null) {
            this.pressed = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    PlatformLogger logger = Logging.getInputLogger();
                    if (logger.isLoggable(PlatformLogger.Level.FINER)) {
                        logger.finer(this + " pressed=" + this.get());
                    }
                    Node.this.pseudoClassStateChanged(PRESSED_PSEUDOCLASS_STATE, this.get());
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "pressed";
                }
            };
        }
        return this.pressed;
    }

    public final void setOnContextMenuRequested(EventHandler<? super ContextMenuEvent> value) {
        this.onContextMenuRequestedProperty().set(value);
    }

    public final EventHandler<? super ContextMenuEvent> getOnContextMenuRequested() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.onContextMenuRequested();
    }

    public final ObjectProperty<EventHandler<? super ContextMenuEvent>> onContextMenuRequestedProperty() {
        return this.getEventHandlerProperties().onContextMenuRequestedProperty();
    }

    public final void setOnMouseClicked(EventHandler<? super MouseEvent> value) {
        this.onMouseClickedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseClicked() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseClicked();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseClickedProperty() {
        return this.getEventHandlerProperties().onMouseClickedProperty();
    }

    public final void setOnMouseDragged(EventHandler<? super MouseEvent> value) {
        this.onMouseDraggedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseDragged() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseDragged();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseDraggedProperty() {
        return this.getEventHandlerProperties().onMouseDraggedProperty();
    }

    public final void setOnMouseEntered(EventHandler<? super MouseEvent> value) {
        this.onMouseEnteredProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseEntered() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseEntered();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseEnteredProperty() {
        return this.getEventHandlerProperties().onMouseEnteredProperty();
    }

    public final void setOnMouseExited(EventHandler<? super MouseEvent> value) {
        this.onMouseExitedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseExited() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseExited();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseExitedProperty() {
        return this.getEventHandlerProperties().onMouseExitedProperty();
    }

    public final void setOnMouseMoved(EventHandler<? super MouseEvent> value) {
        this.onMouseMovedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseMoved() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseMoved();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseMovedProperty() {
        return this.getEventHandlerProperties().onMouseMovedProperty();
    }

    public final void setOnMousePressed(EventHandler<? super MouseEvent> value) {
        this.onMousePressedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMousePressed() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMousePressed();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMousePressedProperty() {
        return this.getEventHandlerProperties().onMousePressedProperty();
    }

    public final void setOnMouseReleased(EventHandler<? super MouseEvent> value) {
        this.onMouseReleasedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseReleased() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseReleased();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleasedProperty() {
        return this.getEventHandlerProperties().onMouseReleasedProperty();
    }

    public final void setOnDragDetected(EventHandler<? super MouseEvent> value) {
        this.onDragDetectedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnDragDetected() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragDetected();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onDragDetectedProperty() {
        return this.getEventHandlerProperties().onDragDetectedProperty();
    }

    public final void setOnMouseDragOver(EventHandler<? super MouseDragEvent> value) {
        this.onMouseDragOverProperty().set(value);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragOver() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseDragOver();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragOverProperty() {
        return this.getEventHandlerProperties().onMouseDragOverProperty();
    }

    public final void setOnMouseDragReleased(EventHandler<? super MouseDragEvent> value) {
        this.onMouseDragReleasedProperty().set(value);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragReleased() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseDragReleased();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragReleasedProperty() {
        return this.getEventHandlerProperties().onMouseDragReleasedProperty();
    }

    public final void setOnMouseDragEntered(EventHandler<? super MouseDragEvent> value) {
        this.onMouseDragEnteredProperty().set(value);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragEntered() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseDragEntered();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragEnteredProperty() {
        return this.getEventHandlerProperties().onMouseDragEnteredProperty();
    }

    public final void setOnMouseDragExited(EventHandler<? super MouseDragEvent> value) {
        this.onMouseDragExitedProperty().set(value);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragExited() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseDragExited();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragExitedProperty() {
        return this.getEventHandlerProperties().onMouseDragExitedProperty();
    }

    public final void setOnScrollStarted(EventHandler<? super ScrollEvent> value) {
        this.onScrollStartedProperty().set(value);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollStarted() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnScrollStarted();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollStartedProperty() {
        return this.getEventHandlerProperties().onScrollStartedProperty();
    }

    public final void setOnScroll(EventHandler<? super ScrollEvent> value) {
        this.onScrollProperty().set(value);
    }

    public final EventHandler<? super ScrollEvent> getOnScroll() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnScroll();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollProperty() {
        return this.getEventHandlerProperties().onScrollProperty();
    }

    public final void setOnScrollFinished(EventHandler<? super ScrollEvent> value) {
        this.onScrollFinishedProperty().set(value);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollFinished() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnScrollFinished();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollFinishedProperty() {
        return this.getEventHandlerProperties().onScrollFinishedProperty();
    }

    public final void setOnRotationStarted(EventHandler<? super RotateEvent> value) {
        this.onRotationStartedProperty().set(value);
    }

    public final EventHandler<? super RotateEvent> getOnRotationStarted() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnRotationStarted();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationStartedProperty() {
        return this.getEventHandlerProperties().onRotationStartedProperty();
    }

    public final void setOnRotate(EventHandler<? super RotateEvent> value) {
        this.onRotateProperty().set(value);
    }

    public final EventHandler<? super RotateEvent> getOnRotate() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnRotate();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotateProperty() {
        return this.getEventHandlerProperties().onRotateProperty();
    }

    public final void setOnRotationFinished(EventHandler<? super RotateEvent> value) {
        this.onRotationFinishedProperty().set(value);
    }

    public final EventHandler<? super RotateEvent> getOnRotationFinished() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnRotationFinished();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationFinishedProperty() {
        return this.getEventHandlerProperties().onRotationFinishedProperty();
    }

    public final void setOnZoomStarted(EventHandler<? super ZoomEvent> value) {
        this.onZoomStartedProperty().set(value);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomStarted() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnZoomStarted();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomStartedProperty() {
        return this.getEventHandlerProperties().onZoomStartedProperty();
    }

    public final void setOnZoom(EventHandler<? super ZoomEvent> value) {
        this.onZoomProperty().set(value);
    }

    public final EventHandler<? super ZoomEvent> getOnZoom() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnZoom();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomProperty() {
        return this.getEventHandlerProperties().onZoomProperty();
    }

    public final void setOnZoomFinished(EventHandler<? super ZoomEvent> value) {
        this.onZoomFinishedProperty().set(value);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomFinished() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnZoomFinished();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomFinishedProperty() {
        return this.getEventHandlerProperties().onZoomFinishedProperty();
    }

    public final void setOnSwipeUp(EventHandler<? super SwipeEvent> value) {
        this.onSwipeUpProperty().set(value);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeUp() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnSwipeUp();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeUpProperty() {
        return this.getEventHandlerProperties().onSwipeUpProperty();
    }

    public final void setOnSwipeDown(EventHandler<? super SwipeEvent> value) {
        this.onSwipeDownProperty().set(value);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeDown() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnSwipeDown();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeDownProperty() {
        return this.getEventHandlerProperties().onSwipeDownProperty();
    }

    public final void setOnSwipeLeft(EventHandler<? super SwipeEvent> value) {
        this.onSwipeLeftProperty().set(value);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeLeft() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnSwipeLeft();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeLeftProperty() {
        return this.getEventHandlerProperties().onSwipeLeftProperty();
    }

    public final void setOnSwipeRight(EventHandler<? super SwipeEvent> value) {
        this.onSwipeRightProperty().set(value);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeRight() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnSwipeRight();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeRightProperty() {
        return this.getEventHandlerProperties().onSwipeRightProperty();
    }

    public final void setOnTouchPressed(EventHandler<? super TouchEvent> value) {
        this.onTouchPressedProperty().set(value);
    }

    public final EventHandler<? super TouchEvent> getOnTouchPressed() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnTouchPressed();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchPressedProperty() {
        return this.getEventHandlerProperties().onTouchPressedProperty();
    }

    public final void setOnTouchMoved(EventHandler<? super TouchEvent> value) {
        this.onTouchMovedProperty().set(value);
    }

    public final EventHandler<? super TouchEvent> getOnTouchMoved() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnTouchMoved();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchMovedProperty() {
        return this.getEventHandlerProperties().onTouchMovedProperty();
    }

    public final void setOnTouchReleased(EventHandler<? super TouchEvent> value) {
        this.onTouchReleasedProperty().set(value);
    }

    public final EventHandler<? super TouchEvent> getOnTouchReleased() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnTouchReleased();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchReleasedProperty() {
        return this.getEventHandlerProperties().onTouchReleasedProperty();
    }

    public final void setOnTouchStationary(EventHandler<? super TouchEvent> value) {
        this.onTouchStationaryProperty().set(value);
    }

    public final EventHandler<? super TouchEvent> getOnTouchStationary() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnTouchStationary();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchStationaryProperty() {
        return this.getEventHandlerProperties().onTouchStationaryProperty();
    }

    public final void setOnKeyPressed(EventHandler<? super KeyEvent> value) {
        this.onKeyPressedProperty().set(value);
    }

    public final EventHandler<? super KeyEvent> getOnKeyPressed() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnKeyPressed();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressedProperty() {
        return this.getEventHandlerProperties().onKeyPressedProperty();
    }

    public final void setOnKeyReleased(EventHandler<? super KeyEvent> value) {
        this.onKeyReleasedProperty().set(value);
    }

    public final EventHandler<? super KeyEvent> getOnKeyReleased() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnKeyReleased();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleasedProperty() {
        return this.getEventHandlerProperties().onKeyReleasedProperty();
    }

    public final void setOnKeyTyped(EventHandler<? super KeyEvent> value) {
        this.onKeyTypedProperty().set(value);
    }

    public final EventHandler<? super KeyEvent> getOnKeyTyped() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnKeyTyped();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyTypedProperty() {
        return this.getEventHandlerProperties().onKeyTypedProperty();
    }

    public final void setOnInputMethodTextChanged(EventHandler<? super InputMethodEvent> value) {
        this.onInputMethodTextChangedProperty().set(value);
    }

    public final EventHandler<? super InputMethodEvent> getOnInputMethodTextChanged() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnInputMethodTextChanged();
    }

    public final ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChangedProperty() {
        return this.getEventHandlerProperties().onInputMethodTextChangedProperty();
    }

    public final void setInputMethodRequests(InputMethodRequests value) {
        this.inputMethodRequestsProperty().set(value);
    }

    public final InputMethodRequests getInputMethodRequests() {
        return this.miscProperties == null ? DEFAULT_INPUT_METHOD_REQUESTS : this.miscProperties.getInputMethodRequests();
    }

    public final ObjectProperty<InputMethodRequests> inputMethodRequestsProperty() {
        return this.getMiscProperties().inputMethodRequestsProperty();
    }

    protected final void setFocused(boolean value) {
        FocusedProperty fp = this.focusedPropertyImpl();
        if (fp.value != value) {
            fp.store(value);
            fp.notifyListeners();
        }
    }

    public final boolean isFocused() {
        return this.focused == null ? false : this.focused.get();
    }

    public final ReadOnlyBooleanProperty focusedProperty() {
        return this.focusedPropertyImpl();
    }

    private FocusedProperty focusedPropertyImpl() {
        if (this.focused == null) {
            this.focused = new FocusedProperty();
        }
        return this.focused;
    }

    public final void setFocusTraversable(boolean value) {
        this.focusTraversableProperty().set(value);
    }

    public final boolean isFocusTraversable() {
        return this.focusTraversable == null ? false : this.focusTraversable.get();
    }

    public final BooleanProperty focusTraversableProperty() {
        if (this.focusTraversable == null) {
            this.focusTraversable = new StyleableBooleanProperty(false){

                @Override
                public void invalidated() {
                    Scene _scene = Node.this.getScene();
                    if (_scene != null) {
                        if (this.get()) {
                            _scene.initializeInternalEventDispatcher();
                        }
                        Node.this.focusSetDirty(_scene);
                    }
                }

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.FOCUS_TRAVERSABLE;
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "focusTraversable";
                }
            };
        }
        return this.focusTraversable;
    }

    private void focusSetDirty(Scene s) {
        if (s != null && (this == s.getFocusOwner() || this.isFocusTraversable())) {
            s.setFocusDirty(true);
        }
    }

    public void requestFocus() {
        if (this.getScene() != null) {
            this.getScene().requestFocus(this);
        }
    }

    @Deprecated
    public final boolean impl_traverse(Direction dir) {
        if (this.getScene() == null) {
            return false;
        }
        return this.getScene().traverse(this, dir);
    }

    public String toString() {
        boolean hasStyleClass;
        String klassName = this.getClass().getName();
        String simpleName = klassName.substring(klassName.lastIndexOf(46) + 1);
        StringBuilder sbuf = new StringBuilder(simpleName);
        boolean hasId = this.id != null && !"".equals(this.getId());
        boolean bl = hasStyleClass = !this.getStyleClass().isEmpty();
        if (!hasId) {
            sbuf.append('@');
            sbuf.append(Integer.toHexString(this.hashCode()));
        } else {
            sbuf.append("[id=");
            sbuf.append(this.getId());
            if (!hasStyleClass) {
                sbuf.append("]");
            }
        }
        if (hasStyleClass) {
            if (!hasId) {
                sbuf.append('[');
            } else {
                sbuf.append(", ");
            }
            sbuf.append("styleClass=");
            sbuf.append(this.getStyleClass());
            sbuf.append("]");
        }
        return sbuf.toString();
    }

    private void preprocessMouseEvent(MouseEvent e) {
        EventType<? extends MouseEvent> eventType = e.getEventType();
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            for (Node n = this; n != null; n = n.getParent()) {
                n.setPressed(e.isPrimaryButtonDown());
            }
            return;
        }
        if (eventType == MouseEvent.MOUSE_RELEASED) {
            for (Node n = this; n != null; n = n.getParent()) {
                n.setPressed(e.isPrimaryButtonDown());
            }
            return;
        }
        if (e.getTarget() == this) {
            if (eventType == MouseEvent.MOUSE_ENTERED || eventType == MouseEvent.MOUSE_ENTERED_TARGET) {
                this.setHover(true);
                return;
            }
            if (eventType == MouseEvent.MOUSE_EXITED || eventType == MouseEvent.MOUSE_EXITED_TARGET) {
                this.setHover(false);
                return;
            }
        }
    }

    void markDirtyLayoutBranch() {
        for (Parent p = this.getParent(); p != null && p.layoutFlag == LayoutFlags.CLEAN; p = p.getParent()) {
            p.setLayoutFlag(LayoutFlags.DIRTY_BRANCH);
            if (!p.isSceneRoot()) continue;
            Toolkit.getToolkit().requestNextPulse();
            if (this.getSubScene() == null) continue;
            this.getSubScene().setDirtyLayout(p);
        }
    }

    private void updateTreeVisible(boolean parentChanged) {
        Parent parentNode;
        boolean isTreeVisible = this.isVisible();
        Node node = this.getParent() != null ? this.getParent() : (this.clipParent != null ? this.clipParent : (parentNode = this.getSubScene() != null ? this.getSubScene() : null));
        if (isTreeVisible) {
            boolean bl = isTreeVisible = parentNode == null || parentNode.impl_isTreeVisible();
        }
        if (parentChanged && parentNode != null && parentNode.impl_isTreeVisible() && this.impl_isDirty(DirtyBits.NODE_VISIBLE)) {
            this.addToSceneDirtyList();
        }
        this.setTreeVisible(isTreeVisible);
    }

    final void setTreeVisible(boolean value) {
        if (this.treeVisible != value) {
            Parent subSceneRoot;
            this.treeVisible = value;
            this.updateCanReceiveFocus();
            this.focusSetDirty(this.getScene());
            if (this.getClip() != null) {
                this.getClip().updateTreeVisible(true);
            }
            if (this.treeVisible && !this.impl_isDirtyEmpty()) {
                this.addToSceneDirtyList();
            }
            ((TreeVisiblePropertyReadOnly)this.impl_treeVisibleProperty()).invalidate();
            if (this instanceof SubScene && (subSceneRoot = ((SubScene)this).getRoot()) != null) {
                subSceneRoot.setTreeVisible(value && subSceneRoot.isVisible());
            }
        }
    }

    @Deprecated
    public final boolean impl_isTreeVisible() {
        return this.impl_treeVisibleProperty().get();
    }

    @Deprecated
    protected final BooleanExpression impl_treeVisibleProperty() {
        if (this.treeVisibleRO == null) {
            this.treeVisibleRO = new TreeVisiblePropertyReadOnly();
        }
        return this.treeVisibleRO;
    }

    private void setCanReceiveFocus(boolean value) {
        this.canReceiveFocus = value;
    }

    final boolean isCanReceiveFocus() {
        return this.canReceiveFocus;
    }

    private void updateCanReceiveFocus() {
        this.setCanReceiveFocus(this.getScene() != null && !this.isDisabled() && this.impl_isTreeVisible());
    }

    String indent() {
        String indent = "";
        for (Parent p = this.getParent(); p != null; p = p.getParent()) {
            indent = indent + "  ";
        }
        return indent;
    }

    @Deprecated
    public final void impl_setShowMnemonics(boolean value) {
        this.impl_showMnemonicsProperty().set(value);
    }

    @Deprecated
    public final boolean impl_isShowMnemonics() {
        return this.impl_showMnemonics == null ? false : this.impl_showMnemonics.get();
    }

    @Deprecated
    public final BooleanProperty impl_showMnemonicsProperty() {
        if (this.impl_showMnemonics == null) {
            this.impl_showMnemonics = new BooleanPropertyBase(false){

                @Override
                protected void invalidated() {
                    Node.this.pseudoClassStateChanged(SHOW_MNEMONICS_PSEUDOCLASS_STATE, this.get());
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "showMnemonics";
                }
            };
        }
        return this.impl_showMnemonics;
    }

    public final void setEventDispatcher(EventDispatcher value) {
        this.eventDispatcherProperty().set(value);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventFilter);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventFilter);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    private NodeEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    private void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty<NodeEventDispatcher>(this, "eventDispatcher", this.internalEventDispatcher);
        }
    }

    private NodeEventDispatcher createInternalEventDispatcher() {
        return new NodeEventDispatcher(this);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        Parent curParent;
        if (this.preprocessMouseEventDispatcher == null) {
            this.preprocessMouseEventDispatcher = (event, tail1) -> {
                if ((event = tail1.dispatchEvent(event)) instanceof MouseEvent) {
                    this.preprocessMouseEvent((MouseEvent)event);
                }
                return event;
            };
        }
        tail = tail.prepend(this.preprocessMouseEventDispatcher);
        Node curNode = this;
        do {
            EventDispatcher eventDispatcherValue;
            if (curNode.eventDispatcher == null || (eventDispatcherValue = (EventDispatcher)curNode.eventDispatcher.get()) == null) continue;
            tail = tail.prepend(eventDispatcherValue);
        } while ((curNode = (curParent = curNode.getParent()) != null ? curParent : curNode.getSubScene()) != null);
        if (this.getScene() != null) {
            tail = this.getScene().buildEventDispatchChain(tail);
        }
        return tail;
    }

    public final void fireEvent(Event event) {
        PlatformLogger logger;
        if (event instanceof InputEvent && (logger = Logging.getInputLogger()).isLoggable(PlatformLogger.Level.FINE)) {
            EventType<? extends Event> eventType = event.getEventType();
            if (eventType == MouseEvent.MOUSE_ENTERED || eventType == MouseEvent.MOUSE_EXITED) {
                logger.finer(event.toString());
            } else if (eventType == MouseEvent.MOUSE_MOVED || eventType == MouseEvent.MOUSE_DRAGGED) {
                logger.finest(event.toString());
            } else {
                logger.fine(event.toString());
            }
        }
        Event.fireEvent(this, event);
    }

    @Override
    public String getTypeSelector() {
        Class<?> clazz = this.getClass();
        Package pkg = clazz.getPackage();
        int plen = 0;
        if (pkg != null) {
            plen = pkg.getName().length();
        }
        int clen = clazz.getName().length();
        int pos = 0 < plen && plen < clen ? plen + 1 : 0;
        return clazz.getName().substring(pos);
    }

    @Override
    public Styleable getStyleableParent() {
        return this.getParent();
    }

    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }

    @Deprecated
    protected Cursor impl_cssGetCursorInitialValue() {
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Node.getClassCssMetaData();
    }

    @Deprecated
    public static List<Style> impl_getMatchingStyles(CssMetaData cssMetaData, Styleable styleable) {
        return CssStyleHelper.getMatchingStyles(styleable, cssMetaData);
    }

    @Deprecated
    public final ObservableMap<StyleableProperty<?>, List<Style>> impl_getStyleMap() {
        ObservableMap map = (ObservableMap)this.getProperties().get("STYLEMAP");
        Map<StyleableProperty<?>, List<Style>> ret = CssStyleHelper.getMatchingStyles(map, this);
        if (ret != null) {
            if (ret instanceof ObservableMap) {
                return (ObservableMap)ret;
            }
            return FXCollections.observableMap(ret);
        }
        return FXCollections.emptyObservableMap();
    }

    @Deprecated
    public final void impl_setStyleMap(ObservableMap<StyleableProperty<?>, List<Style>> styleMap) {
        if (styleMap != null) {
            this.getProperties().put("STYLEMAP", styleMap);
        } else {
            this.getProperties().remove("STYLEMAP");
        }
    }

    @Deprecated
    public Map<StyleableProperty<?>, List<Style>> impl_findStyles(Map<StyleableProperty<?>, List<Style>> styleMap) {
        Map<StyleableProperty<?>, List<Style>> ret = CssStyleHelper.getMatchingStyles(styleMap, this);
        return ret != null ? ret : Collections.emptyMap();
    }

    final CssFlags getCSSFlags() {
        return this.cssFlag;
    }

    private void requestCssStateTransition() {
        if (this.getScene() == null) {
            return;
        }
        if (this.cssFlag == CssFlags.CLEAN || this.cssFlag == CssFlags.DIRTY_BRANCH) {
            this.cssFlag = CssFlags.UPDATE;
            this.notifyParentsOfInvalidatedCSS();
        }
    }

    public final void pseudoClassStateChanged(PseudoClass pseudoClass, boolean active) {
        boolean isTransition;
        boolean modified;
        boolean bl = modified = active ? this.pseudoClassStates.add(pseudoClass) : this.pseudoClassStates.remove(pseudoClass);
        if (modified && this.styleHelper != null && (isTransition = this.styleHelper.pseudoClassStateChanged(pseudoClass))) {
            this.requestCssStateTransition();
        }
    }

    @Override
    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.unmodifiableObservableSet(this.pseudoClassStates);
    }

    final void notifyParentsOfInvalidatedCSS() {
        Parent root;
        SubScene subScene = this.getSubScene();
        Parent parent = root = subScene != null ? subScene.getRoot() : this.getScene().getRoot();
        if (!root.impl_isDirty(DirtyBits.NODE_CSS)) {
            root.impl_markDirty(DirtyBits.NODE_CSS);
            if (subScene != null) {
                subScene.cssFlag = CssFlags.UPDATE;
                subScene.notifyParentsOfInvalidatedCSS();
            }
        }
        Parent _parent = this.getParent();
        while (_parent != null) {
            if (_parent.cssFlag == CssFlags.CLEAN) {
                _parent.cssFlag = CssFlags.DIRTY_BRANCH;
                _parent = _parent.getParent();
                continue;
            }
            _parent = null;
        }
    }

    @Deprecated
    public final void impl_reapplyCSS() {
        if (this.getScene() == null) {
            return;
        }
        if (this.cssFlag == CssFlags.REAPPLY) {
            return;
        }
        if (this.cssFlag == CssFlags.UPDATE) {
            this.cssFlag = CssFlags.REAPPLY;
            this.notifyParentsOfInvalidatedCSS();
            return;
        }
        this.reapplyCss();
        if (this.getParent() != null && this.getParent().performingLayout) {
            this.impl_processCSS(null);
        } else {
            this.notifyParentsOfInvalidatedCSS();
        }
    }

    private void reapplyCss() {
        CssStyleHelper oldStyleHelper = this.styleHelper;
        this.cssFlag = CssFlags.REAPPLY;
        this.styleHelper = CssStyleHelper.createStyleHelper(this);
        if (this instanceof Parent) {
            boolean visitChildren;
            boolean bl = visitChildren = this.styleHelper == null || oldStyleHelper != this.styleHelper || this.getParent() == null || this.getParent().cssFlag != CssFlags.CLEAN;
            if (visitChildren) {
                ObservableList<Node> children = ((Parent)this).getChildren();
                int nMax = children.size();
                for (int n = 0; n < nMax; ++n) {
                    Node child = (Node)children.get(n);
                    child.reapplyCss();
                }
            }
        } else if (this instanceof SubScene) {
            Parent subSceneRoot = ((SubScene)this).getRoot();
            if (subSceneRoot != null) {
                super.reapplyCss();
            }
        } else if (this.styleHelper == null) {
            this.cssFlag = CssFlags.CLEAN;
            return;
        }
        this.cssFlag = CssFlags.UPDATE;
    }

    void processCSS() {
        switch (this.cssFlag) {
            case CLEAN: {
                break;
            }
            case DIRTY_BRANCH: {
                Parent me = (Parent)this;
                me.cssFlag = CssFlags.CLEAN;
                ObservableList<Node> children = me.getChildren();
                int max = children.size();
                for (int i = 0; i < max; ++i) {
                    ((Node)children.get(i)).processCSS();
                }
                break;
            }
            default: {
                this.impl_processCSS(null);
            }
        }
    }

    @Deprecated
    public final void impl_processCSS(boolean reapply) {
        this.applyCss();
    }

    public final void applyCss() {
        if (this.getScene() == null) {
            return;
        }
        if (this.cssFlag != CssFlags.REAPPLY) {
            this.cssFlag = CssFlags.UPDATE;
        }
        Node topMost = this;
        boolean dirtyRoot = this.getScene().getRoot().impl_isDirty(DirtyBits.NODE_CSS);
        if (dirtyRoot) {
            for (Parent _parent = this.getParent(); _parent != null; _parent = _parent.getParent()) {
                if (_parent.cssFlag != CssFlags.UPDATE && _parent.cssFlag != CssFlags.REAPPLY) continue;
                topMost = _parent;
            }
            if (topMost == this.getScene().getRoot()) {
                this.getScene().getRoot().impl_clearDirty(DirtyBits.NODE_CSS);
            }
        }
        topMost.processCSS();
    }

    @Deprecated
    protected void impl_processCSS(WritableValue<Boolean> unused) {
        if (this.cssFlag == CssFlags.CLEAN) {
            return;
        }
        if (this.cssFlag == CssFlags.REAPPLY) {
            this.reapplyCss();
        }
        this.cssFlag = CssFlags.CLEAN;
        if (this.styleHelper != null && this.getScene() != null) {
            this.styleHelper.transitionToState(this);
        }
    }

    @Deprecated
    public abstract Object impl_processMXNode(MXNodeAlgorithm var1, MXNodeAlgorithmContext var2);

    public final void setAccessibleRole(AccessibleRole value) {
        if (value == null) {
            value = AccessibleRole.NODE;
        }
        this.accessibleRoleProperty().set(value);
    }

    public final AccessibleRole getAccessibleRole() {
        if (this.accessibleRole == null) {
            return AccessibleRole.NODE;
        }
        return (AccessibleRole)((Object)this.accessibleRoleProperty().get());
    }

    public final ObjectProperty<AccessibleRole> accessibleRoleProperty() {
        if (this.accessibleRole == null) {
            this.accessibleRole = new SimpleObjectProperty<AccessibleRole>(this, "accessibleRole", AccessibleRole.NODE);
        }
        return this.accessibleRole;
    }

    public final void setAccessibleRoleDescription(String value) {
        this.accessibleRoleDescriptionProperty().set(value);
    }

    public final String getAccessibleRoleDescription() {
        if (this.accessibilityProperties == null) {
            return null;
        }
        if (this.accessibilityProperties.accessibleRoleDescription == null) {
            return null;
        }
        return (String)this.accessibleRoleDescriptionProperty().get();
    }

    public final ObjectProperty<String> accessibleRoleDescriptionProperty() {
        return this.getAccessibilityProperties().getAccessibleRoleDescription();
    }

    public final void setAccessibleText(String value) {
        this.accessibleTextProperty().set(value);
    }

    public final String getAccessibleText() {
        if (this.accessibilityProperties == null) {
            return null;
        }
        if (this.accessibilityProperties.accessibleText == null) {
            return null;
        }
        return (String)this.accessibleTextProperty().get();
    }

    public final ObjectProperty<String> accessibleTextProperty() {
        return this.getAccessibilityProperties().getAccessibleText();
    }

    public final void setAccessibleHelp(String value) {
        this.accessibleHelpProperty().set(value);
    }

    public final String getAccessibleHelp() {
        if (this.accessibilityProperties == null) {
            return null;
        }
        if (this.accessibilityProperties.accessibleHelp == null) {
            return null;
        }
        return (String)this.accessibleHelpProperty().get();
    }

    public final ObjectProperty<String> accessibleHelpProperty() {
        return this.getAccessibilityProperties().getAccessibleHelp();
    }

    private AccessibilityProperties getAccessibilityProperties() {
        if (this.accessibilityProperties == null) {
            this.accessibilityProperties = new AccessibilityProperties();
        }
        return this.accessibilityProperties;
    }

    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case ROLE: {
                return this.getAccessibleRole();
            }
            case ROLE_DESCRIPTION: {
                return this.getAccessibleRoleDescription();
            }
            case TEXT: {
                return this.getAccessibleText();
            }
            case HELP: {
                return this.getAccessibleHelp();
            }
            case PARENT: {
                return this.getParent();
            }
            case SCENE: {
                return this.getScene();
            }
            case BOUNDS: {
                return this.localToScreen(this.getBoundsInLocal());
            }
            case DISABLED: {
                return this.isDisabled();
            }
            case FOCUSED: {
                return this.isFocused();
            }
            case VISIBLE: {
                return this.isVisible();
            }
            case LABELED_BY: {
                return this.labeledBy;
            }
        }
        return null;
    }

    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case REQUEST_FOCUS: {
                if (!this.isFocusTraversable()) break;
                this.requestFocus();
                break;
            }
            case SHOW_MENU: {
                Bounds b = this.getBoundsInLocal();
                Point2D pt = this.localToScreen(b.getMaxX(), b.getMaxY());
                ContextMenuEvent event = new ContextMenuEvent(ContextMenuEvent.CONTEXT_MENU_REQUESTED, b.getMaxX(), b.getMaxY(), pt.getX(), pt.getY(), false, new PickResult((EventTarget)this, b.getMaxX(), b.getMaxY()));
                Event.fireEvent(this, event);
                break;
            }
        }
    }

    public final void notifyAccessibleAttributeChanged(AccessibleAttribute attributes) {
        Scene scene;
        if (this.accessible == null && (scene = this.getScene()) != null) {
            this.accessible = scene.removeAccessible(this);
        }
        if (this.accessible != null) {
            this.accessible.sendNotification(attributes);
        }
    }

    Accessible getAccessible() {
        Scene scene;
        if (this.accessible == null && (scene = this.getScene()) != null) {
            this.accessible = scene.removeAccessible(this);
        }
        if (this.accessible == null) {
            this.accessible = Application.GetApplication().createAccessible();
            this.accessible.setEventHandler(new Accessible.EventHandler(){

                @Override
                public AccessControlContext getAccessControlContext() {
                    Scene scene = Node.this.getScene();
                    if (scene == null) {
                        throw new RuntimeException("Accessbility requested for node not on a scene");
                    }
                    if (scene.impl_getPeer() != null) {
                        return scene.impl_getPeer().getAccessControlContext();
                    }
                    return scene.acc;
                }

                @Override
                public Object getAttribute(AccessibleAttribute attribute, Object ... parameters) {
                    return Node.this.queryAccessibleAttribute(attribute, parameters);
                }

                @Override
                public void executeAction(AccessibleAction action, Object ... parameters) {
                    Node.this.executeAccessibleAction(action, parameters);
                }

                public String toString() {
                    String klassName = Node.this.getClass().getName();
                    return klassName.substring(klassName.lastIndexOf(46) + 1);
                }
            });
        }
        return this.accessible;
    }

    void releaseAccessible() {
        Accessible acc = this.accessible;
        if (acc != null) {
            this.accessible = null;
            acc.dispose();
        }
    }

    static {
        PerformanceTracker.logEvent("Node class loaded");
        USER_DATA_KEY = new Object();
        DEFAULT_ROTATION_AXIS = Rotate.Z_AXIS;
        DEFAULT_CACHE_HINT = CacheHint.DEFAULT;
        DEFAULT_CLIP = null;
        DEFAULT_CURSOR = null;
        DEFAULT_DEPTH_TEST = DepthTest.INHERIT;
        DEFAULT_EFFECT = null;
        DEFAULT_INPUT_METHOD_REQUESTS = null;
        HOVER_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("hover");
        PRESSED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("pressed");
        DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("disabled");
        FOCUSED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("focused");
        SHOW_MNEMONICS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("show-mnemonics");
        boundsAccessor = (bounds, tx, node) -> node.getGeomBounds(bounds, tx);
        NodeHelper.setNodeAccessor(new NodeHelper.NodeAccessor(){

            @Override
            public void layoutNodeForPrinting(Node node) {
                node.doCSSLayoutSyncForSnapshot();
            }

            @Override
            public boolean isDerivedDepthTest(Node node) {
                return node.isDerivedDepthTest();
            }

            @Override
            public SubScene getSubScene(Node node) {
                return node.getSubScene();
            }

            @Override
            public void setLabeledBy(Node node, Node labeledBy) {
                node.labeledBy = labeledBy;
            }

            @Override
            public Accessible getAccessible(Node node) {
                return node.getAccessible();
            }
        });
    }

    private class AccessibilityProperties {
        ObjectProperty<String> accessibleRoleDescription;
        ObjectProperty<String> accessibleText;
        ObjectProperty<String> accessibleHelp;

        private AccessibilityProperties() {
        }

        ObjectProperty<String> getAccessibleRoleDescription() {
            if (this.accessibleRoleDescription == null) {
                this.accessibleRoleDescription = new SimpleObjectProperty<Object>(Node.this, "accessibleRoleDescription", null);
            }
            return this.accessibleRoleDescription;
        }

        ObjectProperty<String> getAccessibleText() {
            if (this.accessibleText == null) {
                this.accessibleText = new SimpleObjectProperty<Object>(Node.this, "accessibleText", null);
            }
            return this.accessibleText;
        }

        ObjectProperty<String> getAccessibleHelp() {
            if (this.accessibleHelp == null) {
                this.accessibleHelp = new SimpleObjectProperty<Object>(Node.this, "accessibleHelp", null);
            }
            return this.accessibleHelp;
        }
    }

    private static abstract class LazyBoundsProperty
    extends ReadOnlyObjectProperty<Bounds> {
        private ExpressionHelper<Bounds> helper;
        private boolean valid;
        private Bounds bounds;

        private LazyBoundsProperty() {
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super Bounds> listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super Bounds> listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public Bounds get() {
            if (!this.valid) {
                this.bounds = this.computeBounds();
                this.valid = true;
            }
            return this.bounds;
        }

        public void invalidate() {
            if (this.valid) {
                this.valid = false;
                ExpressionHelper.fireValueChangedEvent(this.helper);
            }
        }

        protected abstract Bounds computeBounds();
    }

    private static abstract class LazyTransformProperty
    extends ReadOnlyObjectProperty<Transform> {
        protected static final int VALID = 0;
        protected static final int INVALID = 1;
        protected static final int VALIDITY_UNKNOWN = 2;
        protected int valid = 1;
        private ExpressionHelper<Transform> helper;
        private Transform transform;
        private boolean canReuse = false;

        private LazyTransformProperty() {
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super Transform> listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super Transform> listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        protected Transform getInternalValue() {
            if (this.valid == 1 || this.valid == 2 && this.computeValidity() == 1) {
                this.transform = this.computeTransform(this.canReuse ? this.transform : null);
                this.canReuse = true;
                this.valid = this.validityKnown() ? 0 : 2;
            }
            return this.transform;
        }

        @Override
        public Transform get() {
            this.transform = this.getInternalValue();
            this.canReuse = false;
            return this.transform;
        }

        public void validityUnknown() {
            if (this.valid == 0) {
                this.valid = 2;
            }
        }

        public void invalidate() {
            if (this.valid != 1) {
                this.valid = 1;
                ExpressionHelper.fireValueChangedEvent(this.helper);
            }
        }

        protected abstract boolean validityKnown();

        protected abstract int computeValidity();

        protected abstract Transform computeTransform(Transform var1);
    }

    private static class StyleableProperties {
        private static final CssMetaData<Node, Cursor> CURSOR = new CssMetaData<Node, Cursor>("-fx-cursor", CursorConverter.getInstance()){

            @Override
            public boolean isSettable(Node node) {
                return node.miscProperties == null || node.miscProperties.canSetCursor();
            }

            @Override
            public StyleableProperty<Cursor> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.cursorProperty());
            }

            @Override
            public Cursor getInitialValue(Node node) {
                return node.impl_cssGetCursorInitialValue();
            }
        };
        private static final CssMetaData<Node, Effect> EFFECT = new CssMetaData<Node, Effect>("-fx-effect", EffectConverter.getInstance()){

            @Override
            public boolean isSettable(Node node) {
                return node.miscProperties == null || node.miscProperties.canSetEffect();
            }

            @Override
            public StyleableProperty<Effect> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.effectProperty());
            }
        };
        private static final CssMetaData<Node, Boolean> FOCUS_TRAVERSABLE = new CssMetaData<Node, Boolean>("-fx-focus-traversable", BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Node node) {
                return node.focusTraversable == null || !node.focusTraversable.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.focusTraversableProperty());
            }

            @Override
            public Boolean getInitialValue(Node node) {
                return node.impl_cssGetFocusTraversableInitialValue();
            }
        };
        private static final CssMetaData<Node, Number> OPACITY = new CssMetaData<Node, Number>("-fx-opacity", SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(Node node) {
                return node.opacity == null || !node.opacity.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.opacityProperty());
            }
        };
        private static final CssMetaData<Node, BlendMode> BLEND_MODE = new CssMetaData<Node, BlendMode>("-fx-blend-mode", new EnumConverter<BlendMode>(BlendMode.class)){

            @Override
            public boolean isSettable(Node node) {
                return node.blendMode == null || !node.blendMode.isBound();
            }

            @Override
            public StyleableProperty<BlendMode> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.blendModeProperty());
            }
        };
        private static final CssMetaData<Node, Number> ROTATE = new CssMetaData<Node, Number>("-fx-rotate", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Node node) {
                return node.nodeTransformation == null || node.nodeTransformation.rotate == null || node.nodeTransformation.canSetRotate();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.rotateProperty());
            }
        };
        private static final CssMetaData<Node, Number> SCALE_X = new CssMetaData<Node, Number>("-fx-scale-x", SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(Node node) {
                return node.nodeTransformation == null || node.nodeTransformation.scaleX == null || node.nodeTransformation.canSetScaleX();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.scaleXProperty());
            }
        };
        private static final CssMetaData<Node, Number> SCALE_Y = new CssMetaData<Node, Number>("-fx-scale-y", SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(Node node) {
                return node.nodeTransformation == null || node.nodeTransformation.scaleY == null || node.nodeTransformation.canSetScaleY();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.scaleYProperty());
            }
        };
        private static final CssMetaData<Node, Number> SCALE_Z = new CssMetaData<Node, Number>("-fx-scale-z", SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(Node node) {
                return node.nodeTransformation == null || node.nodeTransformation.scaleZ == null || node.nodeTransformation.canSetScaleZ();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.scaleZProperty());
            }
        };
        private static final CssMetaData<Node, Number> TRANSLATE_X = new CssMetaData<Node, Number>("-fx-translate-x", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Node node) {
                return node.nodeTransformation == null || node.nodeTransformation.translateX == null || node.nodeTransformation.canSetTranslateX();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.translateXProperty());
            }
        };
        private static final CssMetaData<Node, Number> TRANSLATE_Y = new CssMetaData<Node, Number>("-fx-translate-y", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Node node) {
                return node.nodeTransformation == null || node.nodeTransformation.translateY == null || node.nodeTransformation.canSetTranslateY();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.translateYProperty());
            }
        };
        private static final CssMetaData<Node, Number> TRANSLATE_Z = new CssMetaData<Node, Number>("-fx-translate-z", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(Node node) {
                return node.nodeTransformation == null || node.nodeTransformation.translateZ == null || node.nodeTransformation.canSetTranslateZ();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.translateZProperty());
            }
        };
        private static final CssMetaData<Node, Boolean> VISIBILITY = new CssMetaData<Node, Boolean>("visibility", (StyleConverter)new StyleConverter<String, Boolean>(){

            @Override
            public Boolean convert(ParsedValue<String, Boolean> value, Font font) {
                String sval = value != null ? value.getValue() : null;
                return "visible".equalsIgnoreCase(sval);
            }
        }, Boolean.TRUE){

            @Override
            public boolean isSettable(Node node) {
                return node.visible == null || !node.visible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Node node) {
                return (StyleableProperty)((Object)node.visibleProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<Node, Object>> styleables = new ArrayList<CssMetaData<Node, Object>>();
            styleables.add(CURSOR);
            styleables.add(EFFECT);
            styleables.add(FOCUS_TRAVERSABLE);
            styleables.add(OPACITY);
            styleables.add(BLEND_MODE);
            styleables.add(ROTATE);
            styleables.add(SCALE_X);
            styleables.add(SCALE_Y);
            styleables.add(SCALE_Z);
            styleables.add(TRANSLATE_X);
            styleables.add(TRANSLATE_Y);
            styleables.add(TRANSLATE_Z);
            styleables.add(VISIBILITY);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    class TreeVisiblePropertyReadOnly
    extends BooleanExpression {
        private ExpressionHelper<Boolean> helper;
        private boolean valid;

        TreeVisiblePropertyReadOnly() {
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super Boolean> listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super Boolean> listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        protected void invalidate() {
            if (this.valid) {
                this.valid = false;
                ExpressionHelper.fireValueChangedEvent(this.helper);
            }
        }

        @Override
        public boolean get() {
            this.valid = true;
            return Node.this.treeVisible;
        }
    }

    final class FocusedProperty
    extends ReadOnlyBooleanPropertyBase {
        private boolean value;
        private boolean valid = true;
        private boolean needsChangeEvent = false;

        FocusedProperty() {
        }

        public void store(boolean value) {
            if (value != this.value) {
                this.value = value;
                this.markInvalid();
            }
        }

        public void notifyListeners() {
            if (this.needsChangeEvent) {
                this.fireValueChangedEvent();
                this.needsChangeEvent = false;
            }
        }

        private void markInvalid() {
            if (this.valid) {
                this.valid = false;
                Node.this.pseudoClassStateChanged(FOCUSED_PSEUDOCLASS_STATE, this.get());
                PlatformLogger logger = Logging.getFocusLogger();
                if (logger.isLoggable(PlatformLogger.Level.FINE)) {
                    logger.fine(this + " focused=" + this.get());
                }
                this.needsChangeEvent = true;
                Node.this.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUSED);
            }
        }

        @Override
        public boolean get() {
            this.valid = true;
            return this.value;
        }

        @Override
        public Object getBean() {
            return Node.this;
        }

        @Override
        public String getName() {
            return "focused";
        }
    }

    private final class MiscProperties {
        private LazyBoundsProperty boundsInParent;
        private LazyBoundsProperty boundsInLocal;
        private BooleanProperty cache;
        private ObjectProperty<CacheHint> cacheHint;
        private ObjectProperty<Node> clip;
        private ObjectProperty<Cursor> cursor;
        private ObjectProperty<DepthTest> depthTest;
        private BooleanProperty disable;
        private ObjectProperty<Effect> effect;
        private ObjectProperty<InputMethodRequests> inputMethodRequests;
        private BooleanProperty mouseTransparent;

        private MiscProperties() {
        }

        public final Bounds getBoundsInParent() {
            return (Bounds)this.boundsInParentProperty().get();
        }

        public final ReadOnlyObjectProperty<Bounds> boundsInParentProperty() {
            if (this.boundsInParent == null) {
                this.boundsInParent = new LazyBoundsProperty(){

                    @Override
                    protected Bounds computeBounds() {
                        BaseBounds tempBounds = TempState.getInstance().bounds;
                        tempBounds = Node.this.getTransformedBounds(tempBounds, BaseTransform.IDENTITY_TRANSFORM);
                        return new BoundingBox(tempBounds.getMinX(), tempBounds.getMinY(), tempBounds.getMinZ(), tempBounds.getWidth(), tempBounds.getHeight(), tempBounds.getDepth());
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "boundsInParent";
                    }
                };
            }
            return this.boundsInParent;
        }

        public void invalidateBoundsInParent() {
            if (this.boundsInParent != null) {
                this.boundsInParent.invalidate();
            }
        }

        public final Bounds getBoundsInLocal() {
            return (Bounds)this.boundsInLocalProperty().get();
        }

        public final ReadOnlyObjectProperty<Bounds> boundsInLocalProperty() {
            if (this.boundsInLocal == null) {
                this.boundsInLocal = new LazyBoundsProperty(){

                    @Override
                    protected Bounds computeBounds() {
                        BaseBounds tempBounds = TempState.getInstance().bounds;
                        tempBounds = Node.this.getLocalBounds(tempBounds, BaseTransform.IDENTITY_TRANSFORM);
                        return new BoundingBox(tempBounds.getMinX(), tempBounds.getMinY(), tempBounds.getMinZ(), tempBounds.getWidth(), tempBounds.getHeight(), tempBounds.getDepth());
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "boundsInLocal";
                    }
                };
            }
            return this.boundsInLocal;
        }

        public void invalidateBoundsInLocal() {
            if (this.boundsInLocal != null) {
                this.boundsInLocal.invalidate();
            }
        }

        public final boolean isCache() {
            return this.cache == null ? false : this.cache.get();
        }

        public final BooleanProperty cacheProperty() {
            if (this.cache == null) {
                this.cache = new BooleanPropertyBase(false){

                    @Override
                    protected void invalidated() {
                        Node.this.impl_markDirty(DirtyBits.NODE_CACHE);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "cache";
                    }
                };
            }
            return this.cache;
        }

        public final CacheHint getCacheHint() {
            return this.cacheHint == null ? DEFAULT_CACHE_HINT : (CacheHint)((Object)this.cacheHint.get());
        }

        public final ObjectProperty<CacheHint> cacheHintProperty() {
            if (this.cacheHint == null) {
                this.cacheHint = new ObjectPropertyBase<CacheHint>(DEFAULT_CACHE_HINT){

                    @Override
                    protected void invalidated() {
                        Node.this.impl_markDirty(DirtyBits.NODE_CACHE);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "cacheHint";
                    }
                };
            }
            return this.cacheHint;
        }

        public final Node getClip() {
            return this.clip == null ? DEFAULT_CLIP : (Node)this.clip.get();
        }

        public final ObjectProperty<Node> clipProperty() {
            if (this.clip == null) {
                this.clip = new ObjectPropertyBase<Node>(DEFAULT_CLIP){
                    private Node oldClip;

                    @Override
                    protected void invalidated() {
                        Node newClip = (Node)this.get();
                        if (newClip != null && (newClip.isConnected() && newClip.clipParent != Node.this || Node.this.wouldCreateCycle(Node.this, newClip))) {
                            String cause;
                            String string = cause = newClip.isConnected() && newClip.clipParent != Node.this ? "node already connected" : "cycle detected";
                            if (this.isBound()) {
                                this.unbind();
                                this.set(this.oldClip);
                                throw new IllegalArgumentException("Node's clip set to incorrect value  through binding (" + cause + ", node  = " + Node.this + ", clip = " + MiscProperties.this.clip + ")." + " Binding has been removed.");
                            }
                            this.set(this.oldClip);
                            throw new IllegalArgumentException("Node's clip set to incorrect value (" + cause + ", node  = " + Node.this + ", clip = " + MiscProperties.this.clip + ").");
                        }
                        if (this.oldClip != null) {
                            this.oldClip.clipParent = null;
                            this.oldClip.setScenes(null, null, false);
                            this.oldClip.updateTreeVisible(false);
                        }
                        if (newClip != null) {
                            newClip.clipParent = Node.this;
                            newClip.setScenes(Node.this.getScene(), Node.this.getSubScene(), false);
                            newClip.updateTreeVisible(true);
                        }
                        Node.this.impl_markDirty(DirtyBits.NODE_CLIP);
                        Node.this.localBoundsChanged();
                        this.oldClip = newClip;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "clip";
                    }
                };
            }
            return this.clip;
        }

        public final Cursor getCursor() {
            return this.cursor == null ? DEFAULT_CURSOR : (Cursor)this.cursor.get();
        }

        public final ObjectProperty<Cursor> cursorProperty() {
            if (this.cursor == null) {
                this.cursor = new StyleableObjectProperty<Cursor>(DEFAULT_CURSOR){

                    @Override
                    protected void invalidated() {
                        Scene sceneValue = Node.this.getScene();
                        if (sceneValue != null) {
                            sceneValue.markCursorDirty();
                        }
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.CURSOR;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "cursor";
                    }
                };
            }
            return this.cursor;
        }

        public final DepthTest getDepthTest() {
            return this.depthTest == null ? DEFAULT_DEPTH_TEST : (DepthTest)((Object)this.depthTest.get());
        }

        public final ObjectProperty<DepthTest> depthTestProperty() {
            if (this.depthTest == null) {
                this.depthTest = new ObjectPropertyBase<DepthTest>(DEFAULT_DEPTH_TEST){

                    @Override
                    protected void invalidated() {
                        Node.this.computeDerivedDepthTest();
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "depthTest";
                    }
                };
            }
            return this.depthTest;
        }

        public final boolean isDisable() {
            return this.disable == null ? false : this.disable.get();
        }

        public final BooleanProperty disableProperty() {
            if (this.disable == null) {
                this.disable = new BooleanPropertyBase(false){

                    @Override
                    protected void invalidated() {
                        Node.this.updateDisabled();
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "disable";
                    }
                };
            }
            return this.disable;
        }

        public final Effect getEffect() {
            return this.effect == null ? DEFAULT_EFFECT : (Effect)this.effect.get();
        }

        public final ObjectProperty<Effect> effectProperty() {
            if (this.effect == null) {
                this.effect = new StyleableObjectProperty<Effect>(DEFAULT_EFFECT){
                    private Effect oldEffect;
                    private int oldBits;
                    private final AbstractNotifyListener effectChangeListener;
                    {
                        this.oldEffect = null;
                        this.effectChangeListener = new AbstractNotifyListener(){

                            @Override
                            public void invalidated(Observable valueModel) {
                                int newBits = ((IntegerProperty)valueModel).get();
                                int changedBits = newBits ^ oldBits;
                                oldBits = newBits;
                                if (EffectDirtyBits.isSet(changedBits, EffectDirtyBits.EFFECT_DIRTY) && EffectDirtyBits.isSet(newBits, EffectDirtyBits.EFFECT_DIRTY)) {
                                    Node.this.impl_markDirty(DirtyBits.EFFECT_EFFECT);
                                }
                                if (EffectDirtyBits.isSet(changedBits, EffectDirtyBits.BOUNDS_CHANGED)) {
                                    Node.this.localBoundsChanged();
                                }
                            }
                        };
                    }

                    @Override
                    protected void invalidated() {
                        Effect _effect = (Effect)this.get();
                        if (this.oldEffect != null) {
                            this.oldEffect.impl_effectDirtyProperty().removeListener(this.effectChangeListener.getWeakListener());
                        }
                        this.oldEffect = _effect;
                        if (_effect != null) {
                            _effect.impl_effectDirtyProperty().addListener(this.effectChangeListener.getWeakListener());
                            if (_effect.impl_isEffectDirty()) {
                                Node.this.impl_markDirty(DirtyBits.EFFECT_EFFECT);
                            }
                            this.oldBits = _effect.impl_effectDirtyProperty().get();
                        }
                        Node.this.impl_markDirty(DirtyBits.NODE_EFFECT);
                        Node.this.localBoundsChanged();
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.EFFECT;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "effect";
                    }
                };
            }
            return this.effect;
        }

        public final InputMethodRequests getInputMethodRequests() {
            return this.inputMethodRequests == null ? DEFAULT_INPUT_METHOD_REQUESTS : (InputMethodRequests)this.inputMethodRequests.get();
        }

        public ObjectProperty<InputMethodRequests> inputMethodRequestsProperty() {
            if (this.inputMethodRequests == null) {
                this.inputMethodRequests = new SimpleObjectProperty<InputMethodRequests>(Node.this, "inputMethodRequests", DEFAULT_INPUT_METHOD_REQUESTS);
            }
            return this.inputMethodRequests;
        }

        public final boolean isMouseTransparent() {
            return this.mouseTransparent == null ? false : this.mouseTransparent.get();
        }

        public final BooleanProperty mouseTransparentProperty() {
            if (this.mouseTransparent == null) {
                this.mouseTransparent = new SimpleBooleanProperty(Node.this, "mouseTransparent", false);
            }
            return this.mouseTransparent;
        }

        public boolean canSetCursor() {
            return this.cursor == null || !this.cursor.isBound();
        }

        public boolean canSetEffect() {
            return this.effect == null || !this.effect.isBound();
        }
    }

    private final class EffectiveOrientationProperty
    extends ReadOnlyObjectPropertyBase<NodeOrientation> {
        private EffectiveOrientationProperty() {
        }

        @Override
        public NodeOrientation get() {
            return Node.this.getEffectiveNodeOrientation();
        }

        @Override
        public Object getBean() {
            return Node.this;
        }

        @Override
        public String getName() {
            return "effectiveNodeOrientation";
        }

        public void invalidate() {
            this.fireValueChangedEvent();
        }
    }

    private final class NodeTransformation {
        private DoubleProperty translateX;
        private DoubleProperty translateY;
        private DoubleProperty translateZ;
        private DoubleProperty scaleX;
        private DoubleProperty scaleY;
        private DoubleProperty scaleZ;
        private DoubleProperty rotate;
        private ObjectProperty<Point3D> rotationAxis;
        private ObservableList<Transform> transforms;
        private LazyTransformProperty localToParentTransform;
        private LazyTransformProperty localToSceneTransform;
        private int listenerReasons = 0;
        private InvalidationListener localToSceneInvLstnr;

        private NodeTransformation() {
        }

        private InvalidationListener getLocalToSceneInvalidationListener() {
            if (this.localToSceneInvLstnr == null) {
                this.localToSceneInvLstnr = observable -> this.invalidateLocalToSceneTransform();
            }
            return this.localToSceneInvLstnr;
        }

        public void incListenerReasons() {
            Parent n;
            if (this.listenerReasons == 0 && (n = Node.this.getParent()) != null) {
                n.localToSceneTransformProperty().addListener(this.getLocalToSceneInvalidationListener());
            }
            ++this.listenerReasons;
        }

        public void decListenerReasons() {
            --this.listenerReasons;
            if (this.listenerReasons == 0) {
                Parent n = Node.this.getParent();
                if (n != null) {
                    n.localToSceneTransformProperty().removeListener(this.getLocalToSceneInvalidationListener());
                }
                if (this.localToSceneTransform != null) {
                    this.localToSceneTransform.validityUnknown();
                }
            }
        }

        public final Transform getLocalToParentTransform() {
            return (Transform)this.localToParentTransformProperty().get();
        }

        public final ReadOnlyObjectProperty<Transform> localToParentTransformProperty() {
            if (this.localToParentTransform == null) {
                this.localToParentTransform = new LazyTransformProperty(){

                    @Override
                    protected Transform computeTransform(Transform reuse) {
                        Node.this.updateLocalToParentTransform();
                        return TransformUtils.immutableTransform(reuse, Node.this.localToParentTx.getMxx(), Node.this.localToParentTx.getMxy(), Node.this.localToParentTx.getMxz(), Node.this.localToParentTx.getMxt(), Node.this.localToParentTx.getMyx(), Node.this.localToParentTx.getMyy(), Node.this.localToParentTx.getMyz(), Node.this.localToParentTx.getMyt(), Node.this.localToParentTx.getMzx(), Node.this.localToParentTx.getMzy(), Node.this.localToParentTx.getMzz(), Node.this.localToParentTx.getMzt());
                    }

                    @Override
                    protected boolean validityKnown() {
                        return true;
                    }

                    @Override
                    protected int computeValidity() {
                        return this.valid;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "localToParentTransform";
                    }
                };
            }
            return this.localToParentTransform;
        }

        public void invalidateLocalToParentTransform() {
            if (this.localToParentTransform != null) {
                this.localToParentTransform.invalidate();
            }
        }

        public final Transform getLocalToSceneTransform() {
            return (Transform)this.localToSceneTransformProperty().get();
        }

        public final ReadOnlyObjectProperty<Transform> localToSceneTransformProperty() {
            if (this.localToSceneTransform == null) {
                this.localToSceneTransform = new LocalToSceneTransformProperty();
            }
            return this.localToSceneTransform;
        }

        public void invalidateLocalToSceneTransform() {
            if (this.localToSceneTransform != null) {
                this.localToSceneTransform.invalidate();
            }
        }

        public double getTranslateX() {
            return this.translateX == null ? 0.0 : this.translateX.get();
        }

        public final DoubleProperty translateXProperty() {
            if (this.translateX == null) {
                this.translateX = new StyleableDoubleProperty(0.0){

                    @Override
                    public void invalidated() {
                        Node.this.impl_transformsChanged();
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.TRANSLATE_X;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "translateX";
                    }
                };
            }
            return this.translateX;
        }

        public double getTranslateY() {
            return this.translateY == null ? 0.0 : this.translateY.get();
        }

        public final DoubleProperty translateYProperty() {
            if (this.translateY == null) {
                this.translateY = new StyleableDoubleProperty(0.0){

                    @Override
                    public void invalidated() {
                        Node.this.impl_transformsChanged();
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.TRANSLATE_Y;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "translateY";
                    }
                };
            }
            return this.translateY;
        }

        public double getTranslateZ() {
            return this.translateZ == null ? 0.0 : this.translateZ.get();
        }

        public final DoubleProperty translateZProperty() {
            if (this.translateZ == null) {
                this.translateZ = new StyleableDoubleProperty(0.0){

                    @Override
                    public void invalidated() {
                        Node.this.impl_transformsChanged();
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.TRANSLATE_Z;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "translateZ";
                    }
                };
            }
            return this.translateZ;
        }

        public double getScaleX() {
            return this.scaleX == null ? 1.0 : this.scaleX.get();
        }

        public final DoubleProperty scaleXProperty() {
            if (this.scaleX == null) {
                this.scaleX = new StyleableDoubleProperty(1.0){

                    @Override
                    public void invalidated() {
                        Node.this.impl_transformsChanged();
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.SCALE_X;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "scaleX";
                    }
                };
            }
            return this.scaleX;
        }

        public double getScaleY() {
            return this.scaleY == null ? 1.0 : this.scaleY.get();
        }

        public final DoubleProperty scaleYProperty() {
            if (this.scaleY == null) {
                this.scaleY = new StyleableDoubleProperty(1.0){

                    @Override
                    public void invalidated() {
                        Node.this.impl_transformsChanged();
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.SCALE_Y;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "scaleY";
                    }
                };
            }
            return this.scaleY;
        }

        public double getScaleZ() {
            return this.scaleZ == null ? 1.0 : this.scaleZ.get();
        }

        public final DoubleProperty scaleZProperty() {
            if (this.scaleZ == null) {
                this.scaleZ = new StyleableDoubleProperty(1.0){

                    @Override
                    public void invalidated() {
                        Node.this.impl_transformsChanged();
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.SCALE_Z;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "scaleZ";
                    }
                };
            }
            return this.scaleZ;
        }

        public double getRotate() {
            return this.rotate == null ? 0.0 : this.rotate.get();
        }

        public final DoubleProperty rotateProperty() {
            if (this.rotate == null) {
                this.rotate = new StyleableDoubleProperty(0.0){

                    @Override
                    public void invalidated() {
                        Node.this.impl_transformsChanged();
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.ROTATE;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "rotate";
                    }
                };
            }
            return this.rotate;
        }

        public Point3D getRotationAxis() {
            return this.rotationAxis == null ? DEFAULT_ROTATION_AXIS : (Point3D)this.rotationAxis.get();
        }

        public final ObjectProperty<Point3D> rotationAxisProperty() {
            if (this.rotationAxis == null) {
                this.rotationAxis = new ObjectPropertyBase<Point3D>(DEFAULT_ROTATION_AXIS){

                    @Override
                    protected void invalidated() {
                        Node.this.impl_transformsChanged();
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "rotationAxis";
                    }
                };
            }
            return this.rotationAxis;
        }

        public ObservableList<Transform> getTransforms() {
            if (this.transforms == null) {
                this.transforms = new TrackableObservableList<Transform>(){

                    @Override
                    protected void onChanged(ListChangeListener.Change<Transform> c) {
                        while (c.next()) {
                            for (Transform t : c.getRemoved()) {
                                t.impl_remove(Node.this);
                            }
                            for (Transform t : c.getAddedSubList()) {
                                t.impl_add(Node.this);
                            }
                        }
                        Node.this.impl_transformsChanged();
                    }
                };
            }
            return this.transforms;
        }

        public boolean canSetTranslateX() {
            return this.translateX == null || !this.translateX.isBound();
        }

        public boolean canSetTranslateY() {
            return this.translateY == null || !this.translateY.isBound();
        }

        public boolean canSetTranslateZ() {
            return this.translateZ == null || !this.translateZ.isBound();
        }

        public boolean canSetScaleX() {
            return this.scaleX == null || !this.scaleX.isBound();
        }

        public boolean canSetScaleY() {
            return this.scaleY == null || !this.scaleY.isBound();
        }

        public boolean canSetScaleZ() {
            return this.scaleZ == null || !this.scaleZ.isBound();
        }

        public boolean canSetRotate() {
            return this.rotate == null || !this.rotate.isBound();
        }

        public boolean hasTransforms() {
            return this.transforms != null && !this.transforms.isEmpty();
        }

        public boolean hasScaleOrRotate() {
            if (this.scaleX != null && this.scaleX.get() != 1.0) {
                return true;
            }
            if (this.scaleY != null && this.scaleY.get() != 1.0) {
                return true;
            }
            if (this.scaleZ != null && this.scaleZ.get() != 1.0) {
                return true;
            }
            return this.rotate != null && this.rotate.get() != 0.0;
        }

        class LocalToSceneTransformProperty
        extends LazyTransformProperty {
            private List localToSceneListeners;
            private long stamp;
            private long parentStamp;

            LocalToSceneTransformProperty() {
            }

            @Override
            protected Transform computeTransform(Transform reuse) {
                ++this.stamp;
                Node.this.updateLocalToParentTransform();
                Parent parentNode = Node.this.getParent();
                if (parentNode != null) {
                    LocalToSceneTransformProperty parentProperty = (LocalToSceneTransformProperty)parentNode.localToSceneTransformProperty();
                    Transform parentTransform = parentProperty.getInternalValue();
                    this.parentStamp = parentProperty.stamp;
                    return TransformUtils.immutableTransform(reuse, parentTransform, ((LazyTransformProperty)NodeTransformation.this.localToParentTransformProperty()).getInternalValue());
                }
                return TransformUtils.immutableTransform(reuse, ((LazyTransformProperty)NodeTransformation.this.localToParentTransformProperty()).getInternalValue());
            }

            @Override
            public Object getBean() {
                return Node.this;
            }

            @Override
            public String getName() {
                return "localToSceneTransform";
            }

            @Override
            protected boolean validityKnown() {
                return NodeTransformation.this.listenerReasons > 0;
            }

            @Override
            protected int computeValidity() {
                if (this.valid != 2) {
                    return this.valid;
                }
                Node n = (Node)this.getBean();
                Parent parent = n.getParent();
                if (parent != null) {
                    LocalToSceneTransformProperty parentProperty = (LocalToSceneTransformProperty)parent.localToSceneTransformProperty();
                    if (this.parentStamp != parentProperty.stamp) {
                        this.valid = 1;
                        return 1;
                    }
                    int parentValid = parentProperty.computeValidity();
                    if (parentValid == 1) {
                        this.valid = 1;
                    }
                    return parentValid;
                }
                return 0;
            }

            @Override
            public void addListener(InvalidationListener listener) {
                NodeTransformation.this.incListenerReasons();
                if (this.localToSceneListeners == null) {
                    this.localToSceneListeners = new LinkedList();
                }
                this.localToSceneListeners.add(listener);
                super.addListener(listener);
            }

            @Override
            public void addListener(ChangeListener<? super Transform> listener) {
                NodeTransformation.this.incListenerReasons();
                if (this.localToSceneListeners == null) {
                    this.localToSceneListeners = new LinkedList();
                }
                this.localToSceneListeners.add(listener);
                super.addListener(listener);
            }

            @Override
            public void removeListener(InvalidationListener listener) {
                if (this.localToSceneListeners != null && this.localToSceneListeners.remove(listener)) {
                    NodeTransformation.this.decListenerReasons();
                }
                super.removeListener(listener);
            }

            @Override
            public void removeListener(ChangeListener<? super Transform> listener) {
                if (this.localToSceneListeners != null && this.localToSceneListeners.remove(listener)) {
                    NodeTransformation.this.decListenerReasons();
                }
                super.removeListener(listener);
            }
        }
    }

    private class ReadOnlyObjectWrapperManualFire<T>
    extends ReadOnlyObjectWrapper<T> {
        private ReadOnlyObjectWrapperManualFire() {
        }

        @Override
        public Object getBean() {
            return Node.this;
        }

        @Override
        public String getName() {
            return "scene";
        }

        @Override
        protected void fireValueChangedEvent() {
        }

        public void fireSuperValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }
}

