/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.org.apache.xerces.internal.impl.XMLEntityScanner;
import com.sun.org.apache.xerces.internal.util.XML11Char;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLStringBuffer;
import com.sun.org.apache.xerces.internal.utils.XMLSecurityManager;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import java.io.IOException;

public class XML11EntityScanner
extends XMLEntityScanner {
    @Override
    public int peekChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        }
        int c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
        if (this.fCurrentEntity.isExternal()) {
            return c != 13 && c != 133 && c != 8232 ? c : 10;
        }
        return c;
    }

    @Override
    public int scanChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        }
        int c = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
        boolean external = false;
        if (c == 10 || (c == 13 || c == 133 || c == 8232) && (external = this.fCurrentEntity.isExternal())) {
            char cc;
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = (char)c;
                this.load(1, false, false);
            }
            if (c == 13 && external && (cc = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != '\n' && cc != '\u0085') {
                --this.fCurrentEntity.position;
            }
            c = 10;
        }
        ++this.fCurrentEntity.columnNumber;
        return c;
    }

    @Override
    public String scanNmtoken() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        }
        int offset = this.fCurrentEntity.position;
        while (true) {
            char ch2;
            int length;
            char ch;
            if (XML11Char.isXML11Name(ch = this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                length = this.fCurrentEntity.position - offset;
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.ch.length) {
                    char[] tmp = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                offset = 0;
                if (!this.load(length, false, false)) continue;
                break;
            }
            if (!XML11Char.isXML11NameHighSurrogate(ch)) break;
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                length = this.fCurrentEntity.position - offset;
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.ch.length) {
                    char[] tmp = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                offset = 0;
                if (this.load(length, false, false)) {
                    --this.fCurrentEntity.startPosition;
                    --this.fCurrentEntity.position;
                    break;
                }
            }
            if (!XMLChar.isLowSurrogate(ch2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) || !XML11Char.isXML11Name(XMLChar.supplemental(ch, ch2))) {
                --this.fCurrentEntity.position;
                break;
            }
            if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            int length2 = this.fCurrentEntity.position - offset;
            this.invokeListeners(length2);
            if (length2 == this.fCurrentEntity.ch.length) {
                char[] tmp = new char[this.fCurrentEntity.ch.length << 1];
                System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length2);
                this.fCurrentEntity.ch = tmp;
            } else {
                System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length2);
            }
            offset = 0;
            if (this.load(length2, false, false)) break;
        }
        int length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length;
        String symbol = null;
        if (length > 0) {
            symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
        }
        return symbol;
    }

    @Override
    public String scanName() throws IOException {
        int length;
        char ch2;
        int offset;
        char ch;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        }
        if (XML11Char.isXML11NameStart(ch = this.fCurrentEntity.ch[offset = this.fCurrentEntity.position++])) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = ch;
                offset = 0;
                if (this.load(1, false, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    return symbol;
                }
            }
        } else if (XML11Char.isXML11NameHighSurrogate(ch)) {
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = ch;
                offset = 0;
                if (this.load(1, false, false)) {
                    --this.fCurrentEntity.position;
                    --this.fCurrentEntity.startPosition;
                    return null;
                }
            }
            if (!XMLChar.isLowSurrogate(ch2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) || !XML11Char.isXML11NameStart(XMLChar.supplemental(ch, ch2))) {
                --this.fCurrentEntity.position;
                return null;
            }
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(2);
                this.fCurrentEntity.ch[0] = ch;
                this.fCurrentEntity.ch[1] = ch2;
                offset = 0;
                if (this.load(2, false, false)) {
                    this.fCurrentEntity.columnNumber += 2;
                    String symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 2);
                    return symbol;
                }
            }
        } else {
            return null;
        }
        while (true) {
            if (XML11Char.isXML11Name(ch = this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                length = this.fCurrentEntity.position - offset;
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.ch.length) {
                    char[] tmp = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                offset = 0;
                if (!this.load(length, false, false)) continue;
                break;
            }
            if (!XML11Char.isXML11NameHighSurrogate(ch)) break;
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                length = this.fCurrentEntity.position - offset;
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.ch.length) {
                    char[] tmp = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                offset = 0;
                if (this.load(length, false, false)) {
                    --this.fCurrentEntity.position;
                    --this.fCurrentEntity.startPosition;
                    break;
                }
            }
            if (!XMLChar.isLowSurrogate(ch2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) || !XML11Char.isXML11Name(XMLChar.supplemental(ch, ch2))) {
                --this.fCurrentEntity.position;
                break;
            }
            if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            int length2 = this.fCurrentEntity.position - offset;
            this.invokeListeners(length2);
            if (length2 == this.fCurrentEntity.ch.length) {
                char[] tmp = new char[this.fCurrentEntity.ch.length << 1];
                System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length2);
                this.fCurrentEntity.ch = tmp;
            } else {
                System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length2);
            }
            offset = 0;
            if (this.load(length2, false, false)) break;
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length;
        String symbol = null;
        if (length > 0) {
            symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
        }
        return symbol;
    }

    public String scanNCName() throws IOException {
        int length;
        char ch2;
        int offset;
        char ch;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        }
        if (XML11Char.isXML11NCNameStart(ch = this.fCurrentEntity.ch[offset = this.fCurrentEntity.position++])) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = ch;
                offset = 0;
                if (this.load(1, false, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    return symbol;
                }
            }
        } else if (XML11Char.isXML11NameHighSurrogate(ch)) {
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = ch;
                offset = 0;
                if (this.load(1, false, false)) {
                    --this.fCurrentEntity.position;
                    --this.fCurrentEntity.startPosition;
                    return null;
                }
            }
            if (!XMLChar.isLowSurrogate(ch2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) || !XML11Char.isXML11NCNameStart(XMLChar.supplemental(ch, ch2))) {
                --this.fCurrentEntity.position;
                return null;
            }
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(2);
                this.fCurrentEntity.ch[0] = ch;
                this.fCurrentEntity.ch[1] = ch2;
                offset = 0;
                if (this.load(2, false, false)) {
                    this.fCurrentEntity.columnNumber += 2;
                    String symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 2);
                    return symbol;
                }
            }
        } else {
            return null;
        }
        while (true) {
            if (XML11Char.isXML11NCName(ch = this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                length = this.fCurrentEntity.position - offset;
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.ch.length) {
                    char[] tmp = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                offset = 0;
                if (!this.load(length, false, false)) continue;
                break;
            }
            if (!XML11Char.isXML11NameHighSurrogate(ch)) break;
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                length = this.fCurrentEntity.position - offset;
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.ch.length) {
                    char[] tmp = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                offset = 0;
                if (this.load(length, false, false)) {
                    --this.fCurrentEntity.startPosition;
                    --this.fCurrentEntity.position;
                    break;
                }
            }
            if (!XMLChar.isLowSurrogate(ch2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) || !XML11Char.isXML11NCName(XMLChar.supplemental(ch, ch2))) {
                --this.fCurrentEntity.position;
                break;
            }
            if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            int length2 = this.fCurrentEntity.position - offset;
            this.invokeListeners(length2);
            if (length2 == this.fCurrentEntity.ch.length) {
                char[] tmp = new char[this.fCurrentEntity.ch.length << 1];
                System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length2);
                this.fCurrentEntity.ch = tmp;
            } else {
                System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length2);
            }
            offset = 0;
            if (this.load(length2, false, false)) break;
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length;
        String symbol = null;
        if (length > 0) {
            symbol = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
        }
        return symbol;
    }

    @Override
    public boolean scanQName(QName qname) throws IOException {
        int length;
        int offset;
        char ch;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        }
        if (XML11Char.isXML11NCNameStart(ch = this.fCurrentEntity.ch[offset = this.fCurrentEntity.position++])) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = ch;
                offset = 0;
                if (this.load(1, false, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String name = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    qname.setValues(null, name, name, null);
                    return true;
                }
            }
        } else if (XML11Char.isXML11NameHighSurrogate(ch)) {
            char ch2;
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = ch;
                offset = 0;
                if (this.load(1, false, false)) {
                    --this.fCurrentEntity.startPosition;
                    --this.fCurrentEntity.position;
                    return false;
                }
            }
            if (!XMLChar.isLowSurrogate(ch2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) || !XML11Char.isXML11NCNameStart(XMLChar.supplemental(ch, ch2))) {
                --this.fCurrentEntity.position;
                return false;
            }
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(2);
                this.fCurrentEntity.ch[0] = ch;
                this.fCurrentEntity.ch[1] = ch2;
                offset = 0;
                if (this.load(2, false, false)) {
                    this.fCurrentEntity.columnNumber += 2;
                    String name = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 2);
                    qname.setValues(null, name, name, null);
                    return true;
                }
            }
        } else {
            return false;
        }
        int index = -1;
        boolean sawIncompleteSurrogatePair = false;
        while (true) {
            char ch2;
            char[] tmp;
            if (XML11Char.isXML11Name(ch = this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
                if (ch == ':') {
                    if (index != -1) break;
                    index = this.fCurrentEntity.position;
                    this.checkLimit(XMLSecurityManager.Limit.MAX_NAME_LIMIT, this.fCurrentEntity, offset, index - offset);
                }
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                length = this.fCurrentEntity.position - offset;
                this.checkLimit(XMLSecurityManager.Limit.MAX_NAME_LIMIT, this.fCurrentEntity, offset, length - index - 1);
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.ch.length) {
                    tmp = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                if (index != -1) {
                    index -= offset;
                }
                offset = 0;
                if (!this.load(length, false, false)) continue;
                break;
            }
            if (!XML11Char.isXML11NameHighSurrogate(ch)) break;
            if (++this.fCurrentEntity.position == this.fCurrentEntity.count) {
                length = this.fCurrentEntity.position - offset;
                this.invokeListeners(length);
                if (length == this.fCurrentEntity.ch.length) {
                    tmp = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, offset, tmp, 0, length);
                    this.fCurrentEntity.ch = tmp;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length);
                }
                if (index != -1) {
                    index -= offset;
                }
                offset = 0;
                if (this.load(length, false, false)) {
                    sawIncompleteSurrogatePair = true;
                    --this.fCurrentEntity.startPosition;
                    --this.fCurrentEntity.position;
                    break;
                }
            }
            if (!XMLChar.isLowSurrogate(ch2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) || !XML11Char.isXML11Name(XMLChar.supplemental(ch, ch2))) {
                sawIncompleteSurrogatePair = true;
                --this.fCurrentEntity.position;
                break;
            }
            if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            int length2 = this.fCurrentEntity.position - offset;
            this.invokeListeners(length2);
            if (length2 == this.fCurrentEntity.ch.length) {
                char[] tmp2 = new char[this.fCurrentEntity.ch.length << 1];
                System.arraycopy(this.fCurrentEntity.ch, offset, tmp2, 0, length2);
                this.fCurrentEntity.ch = tmp2;
            } else {
                System.arraycopy(this.fCurrentEntity.ch, offset, this.fCurrentEntity.ch, 0, length2);
            }
            if (index != -1) {
                index -= offset;
            }
            offset = 0;
            if (this.load(length2, false, false)) break;
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length;
        if (length > 0) {
            String prefix = null;
            String localpart = null;
            String rawname = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, length);
            if (index != -1) {
                int prefixLength = index - offset;
                this.checkLimit(XMLSecurityManager.Limit.MAX_NAME_LIMIT, this.fCurrentEntity, offset, prefixLength);
                prefix = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, offset, prefixLength);
                int len = length - prefixLength - 1;
                int startLocal = index + 1;
                if (!(XML11Char.isXML11NCNameStart(this.fCurrentEntity.ch[startLocal]) || XML11Char.isXML11NameHighSurrogate(this.fCurrentEntity.ch[startLocal]) && !sawIncompleteSurrogatePair)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "IllegalQName", null, (short)2);
                }
                this.checkLimit(XMLSecurityManager.Limit.MAX_NAME_LIMIT, this.fCurrentEntity, index + 1, len);
                localpart = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, index + 1, len);
            } else {
                localpart = rawname;
                this.checkLimit(XMLSecurityManager.Limit.MAX_NAME_LIMIT, this.fCurrentEntity, offset, length);
            }
            qname.setValues(prefix, localpart, rawname, null);
            return true;
        }
        return false;
    }

    @Override
    public int scanContent(XMLString content) throws IOException {
        int length;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.invokeListeners(1);
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false, false);
            this.fCurrentEntity.position = 0;
            this.fCurrentEntity.startPosition = 0;
        }
        int offset = this.fCurrentEntity.position;
        int c = this.fCurrentEntity.ch[offset];
        int newlines = 0;
        boolean external = this.fCurrentEntity.isExternal();
        if (c == 10 || (c == 13 || c == 133 || c == 8232) && external) {
            do {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && external) {
                    char cc;
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        offset = 0;
                        this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                        this.fCurrentEntity.position = newlines;
                        this.fCurrentEntity.startPosition = newlines;
                        if (this.load(newlines, false, true)) break;
                    }
                    if ((cc = this.fCurrentEntity.ch[this.fCurrentEntity.position]) == '\n' || cc == '\u0085') {
                        ++this.fCurrentEntity.position;
                        ++offset;
                        continue;
                    }
                    ++newlines;
                    continue;
                }
                if (c == 10 || (c == 133 || c == 8232) && external) {
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    offset = 0;
                    this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                    this.fCurrentEntity.position = newlines;
                    this.fCurrentEntity.startPosition = newlines;
                    if (!this.load(newlines, false, true)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (int i = offset; i < this.fCurrentEntity.position; ++i) {
                this.fCurrentEntity.ch[i] = 10;
            }
            length = this.fCurrentEntity.position - offset;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                content.setValues(this.fCurrentEntity.ch, offset, length);
                return -1;
            }
        }
        if (external) {
            while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
                if (XML11Char.isXML11Content(c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) && c != 133 && c != 8232) continue;
                --this.fCurrentEntity.position;
                break;
            }
        } else {
            while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
                if (XML11Char.isXML11InternalEntityContent(c = this.fCurrentEntity.ch[this.fCurrentEntity.position++])) continue;
                --this.fCurrentEntity.position;
                break;
            }
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length - newlines;
        if (this.fCurrentEntity.isGE) {
            this.checkLimit(XMLSecurityManager.Limit.TOTAL_ENTITY_SIZE_LIMIT, this.fCurrentEntity, offset, length);
        }
        content.setValues(this.fCurrentEntity.ch, offset, length);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if ((c == 13 || c == 133 || c == 8232) && external) {
                c = 10;
            }
        } else {
            c = -1;
        }
        return c;
    }

    @Override
    public int scanLiteral(int quote, XMLString content) throws IOException {
        int length;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.invokeListeners(1);
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false, false);
            this.fCurrentEntity.startPosition = 0;
            this.fCurrentEntity.position = 0;
        }
        int offset = this.fCurrentEntity.position;
        int c = this.fCurrentEntity.ch[offset];
        int newlines = 0;
        boolean external = this.fCurrentEntity.isExternal();
        if (c == 10 || (c == 13 || c == 133 || c == 8232) && external) {
            do {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && external) {
                    char cc;
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        offset = 0;
                        this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                        this.fCurrentEntity.position = newlines;
                        this.fCurrentEntity.startPosition = newlines;
                        if (this.load(newlines, false, true)) break;
                    }
                    if ((cc = this.fCurrentEntity.ch[this.fCurrentEntity.position]) == '\n' || cc == '\u0085') {
                        ++this.fCurrentEntity.position;
                        ++offset;
                        continue;
                    }
                    ++newlines;
                    continue;
                }
                if (c == 10 || (c == 133 || c == 8232) && external) {
                    ++newlines;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    offset = 0;
                    this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                    this.fCurrentEntity.position = newlines;
                    this.fCurrentEntity.startPosition = newlines;
                    if (!this.load(newlines, false, true)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (int i = offset; i < this.fCurrentEntity.position; ++i) {
                this.fCurrentEntity.ch[i] = 10;
            }
            length = this.fCurrentEntity.position - offset;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                content.setValues(this.fCurrentEntity.ch, offset, length);
                return -1;
            }
        }
        if (external) {
            while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != quote && c != 37 && XML11Char.isXML11Content(c) && c != 133 && c != 8232) continue;
                --this.fCurrentEntity.position;
                break;
            }
        } else {
            while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
                if (((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != quote || this.fCurrentEntity.literal) && c != 37 && XML11Char.isXML11InternalEntityContent(c)) continue;
                --this.fCurrentEntity.position;
                break;
            }
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length - newlines;
        if (this.fCurrentEntity.isGE) {
            this.checkLimit(XMLSecurityManager.Limit.TOTAL_ENTITY_SIZE_LIMIT, this.fCurrentEntity, offset, length);
        }
        content.setValues(this.fCurrentEntity.ch, offset, length);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (c == quote && this.fCurrentEntity.literal) {
                c = -1;
            }
        } else {
            c = -1;
        }
        return c;
    }

    @Override
    public boolean scanData(String delimiter, XMLStringBuffer buffer) throws IOException {
        boolean done = false;
        int delimLen = delimiter.length();
        char charAt0 = delimiter.charAt(0);
        boolean external = this.fCurrentEntity.isExternal();
        do {
            int length;
            int newlines;
            int offset;
            block25: {
                int i;
                int delimOffset;
                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                    this.load(0, true, false);
                }
                boolean bNextEntity = false;
                while (this.fCurrentEntity.position >= this.fCurrentEntity.count - delimLen && !bNextEntity) {
                    System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.position, this.fCurrentEntity.ch, 0, this.fCurrentEntity.count - this.fCurrentEntity.position);
                    bNextEntity = this.load(this.fCurrentEntity.count - this.fCurrentEntity.position, false, false);
                    this.fCurrentEntity.position = 0;
                    this.fCurrentEntity.startPosition = 0;
                }
                if (this.fCurrentEntity.position >= this.fCurrentEntity.count - delimLen) {
                    int length2 = this.fCurrentEntity.count - this.fCurrentEntity.position;
                    buffer.append(this.fCurrentEntity.ch, this.fCurrentEntity.position, length2);
                    this.fCurrentEntity.columnNumber += this.fCurrentEntity.count;
                    this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                    this.fCurrentEntity.position = this.fCurrentEntity.count;
                    this.fCurrentEntity.startPosition = this.fCurrentEntity.count;
                    this.load(0, true, false);
                    return false;
                }
                offset = this.fCurrentEntity.position;
                char c = this.fCurrentEntity.ch[offset];
                newlines = 0;
                if (c == '\n' || (c == '\r' || c == '\u0085' || c == '\u2028') && external) {
                    do {
                        if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == '\r' && external) {
                            char cc;
                            ++newlines;
                            ++this.fCurrentEntity.lineNumber;
                            this.fCurrentEntity.columnNumber = 1;
                            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                                offset = 0;
                                this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                                this.fCurrentEntity.position = newlines;
                                this.fCurrentEntity.startPosition = newlines;
                                if (this.load(newlines, false, true)) break;
                            }
                            if ((cc = this.fCurrentEntity.ch[this.fCurrentEntity.position]) == '\n' || cc == '\u0085') {
                                ++this.fCurrentEntity.position;
                                ++offset;
                                continue;
                            }
                            ++newlines;
                            continue;
                        }
                        if (c == '\n' || (c == '\u0085' || c == '\u2028') && external) {
                            ++newlines;
                            ++this.fCurrentEntity.lineNumber;
                            this.fCurrentEntity.columnNumber = 1;
                            if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                            offset = 0;
                            this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                            this.fCurrentEntity.position = newlines;
                            this.fCurrentEntity.startPosition = newlines;
                            this.fCurrentEntity.count = newlines;
                            if (!this.load(newlines, false, true)) continue;
                            break;
                        }
                        --this.fCurrentEntity.position;
                        break;
                    } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
                    for (int i2 = offset; i2 < this.fCurrentEntity.position; ++i2) {
                        this.fCurrentEntity.ch[i2] = 10;
                    }
                    length = this.fCurrentEntity.position - offset;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                        buffer.append(this.fCurrentEntity.ch, offset, length);
                        return true;
                    }
                }
                if (external) {
                    while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
                        if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == charAt0) {
                            delimOffset = this.fCurrentEntity.position - 1;
                            for (i = 1; i < delimLen; ++i) {
                                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                                    this.fCurrentEntity.position -= i;
                                    break block25;
                                }
                                c = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
                                if (delimiter.charAt(i) == c) continue;
                                --this.fCurrentEntity.position;
                                break;
                            }
                            if (this.fCurrentEntity.position != delimOffset + delimLen) continue;
                            done = true;
                            break;
                        }
                        if (c == '\n' || c == '\r' || c == '\u0085' || c == '\u2028') {
                            --this.fCurrentEntity.position;
                            break;
                        }
                        if (XML11Char.isXML11ValidLiteral(c)) continue;
                        --this.fCurrentEntity.position;
                        length = this.fCurrentEntity.position - offset;
                        this.fCurrentEntity.columnNumber += length - newlines;
                        buffer.append(this.fCurrentEntity.ch, offset, length);
                        return true;
                    }
                } else {
                    while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
                        if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == charAt0) {
                            delimOffset = this.fCurrentEntity.position - 1;
                            for (i = 1; i < delimLen; ++i) {
                                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                                    this.fCurrentEntity.position -= i;
                                    break block25;
                                }
                                c = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
                                if (delimiter.charAt(i) == c) continue;
                                --this.fCurrentEntity.position;
                                break;
                            }
                            if (this.fCurrentEntity.position != delimOffset + delimLen) continue;
                            done = true;
                            break;
                        }
                        if (c == '\n') {
                            --this.fCurrentEntity.position;
                            break;
                        }
                        if (XML11Char.isXML11Valid(c)) continue;
                        --this.fCurrentEntity.position;
                        length = this.fCurrentEntity.position - offset;
                        this.fCurrentEntity.columnNumber += length - newlines;
                        buffer.append(this.fCurrentEntity.ch, offset, length);
                        return true;
                    }
                }
            }
            length = this.fCurrentEntity.position - offset;
            this.fCurrentEntity.columnNumber += length - newlines;
            if (done) {
                length -= delimLen;
            }
            buffer.append(this.fCurrentEntity.ch, offset, length);
        } while (!done);
        return !done;
    }

    @Override
    public boolean skipChar(int c) throws IOException {
        char cc;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        }
        if ((cc = this.fCurrentEntity.ch[this.fCurrentEntity.position]) == c) {
            ++this.fCurrentEntity.position;
            if (c == 10) {
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
            } else {
                ++this.fCurrentEntity.columnNumber;
            }
            return true;
        }
        if (c == 10 && (cc == '\u2028' || cc == '\u0085') && this.fCurrentEntity.isExternal()) {
            ++this.fCurrentEntity.position;
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            return true;
        }
        if (c == 10 && cc == '\r' && this.fCurrentEntity.isExternal()) {
            char ccc;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = cc;
                this.load(1, false, false);
            }
            if ((ccc = this.fCurrentEntity.ch[++this.fCurrentEntity.position]) == '\n' || ccc == '\u0085') {
                ++this.fCurrentEntity.position;
            }
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean skipSpaces() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        }
        if (this.fCurrentEntity == null) {
            return false;
        }
        char c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
        if (this.fCurrentEntity.isExternal()) {
            if (XML11Char.isXML11Space(c)) {
                do {
                    boolean entityChanged = false;
                    if (c == '\n' || c == '\r' || c == '\u0085' || c == '\u2028') {
                        char cc;
                        ++this.fCurrentEntity.lineNumber;
                        this.fCurrentEntity.columnNumber = 1;
                        if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                            this.invokeListeners(1);
                            this.fCurrentEntity.ch[0] = c;
                            entityChanged = this.load(1, true, false);
                            if (!entityChanged) {
                                this.fCurrentEntity.startPosition = 0;
                                this.fCurrentEntity.position = 0;
                            } else if (this.fCurrentEntity == null) {
                                return true;
                            }
                        }
                        if (c == '\r' && (cc = this.fCurrentEntity.ch[++this.fCurrentEntity.position]) != '\n' && cc != '\u0085') {
                            --this.fCurrentEntity.position;
                        }
                    } else {
                        ++this.fCurrentEntity.columnNumber;
                    }
                    if (!entityChanged) {
                        ++this.fCurrentEntity.position;
                    }
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    this.load(0, true, true);
                    if (this.fCurrentEntity != null) continue;
                    return true;
                } while (XML11Char.isXML11Space(c = this.fCurrentEntity.ch[this.fCurrentEntity.position]));
                return true;
            }
        } else if (XMLChar.isSpace(c)) {
            do {
                boolean entityChanged = false;
                if (c == '\n') {
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                        this.invokeListeners(1);
                        this.fCurrentEntity.ch[0] = c;
                        entityChanged = this.load(1, true, false);
                        if (!entityChanged) {
                            this.fCurrentEntity.startPosition = 0;
                            this.fCurrentEntity.position = 0;
                        } else if (this.fCurrentEntity == null) {
                            return true;
                        }
                    }
                } else {
                    ++this.fCurrentEntity.columnNumber;
                }
                if (!entityChanged) {
                    ++this.fCurrentEntity.position;
                }
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                this.load(0, true, true);
                if (this.fCurrentEntity != null) continue;
                return true;
            } while (XMLChar.isSpace(c = this.fCurrentEntity.ch[this.fCurrentEntity.position]));
            return true;
        }
        return false;
    }

    @Override
    public boolean skipString(String s) throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true, true);
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c;
            if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != s.charAt(i)) {
                this.fCurrentEntity.position -= i + 1;
                return false;
            }
            if (i >= length - 1 || this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            this.invokeListeners(0);
            System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.count - i - 1, this.fCurrentEntity.ch, 0, i + 1);
            if (!this.load(i + 1, false, false)) continue;
            this.fCurrentEntity.startPosition -= i + 1;
            this.fCurrentEntity.position -= i + 1;
            return false;
        }
        this.fCurrentEntity.columnNumber += length;
        return true;
    }
}

