/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceBinaryContentRevision
extends PerforceContentRevision
implements BinaryContentRevision {
    private byte[] myContent;

    public PerforceBinaryContentRevision(Project project, FilePath path, long revision) {
        super(project, path, revision);
        this.myContent = null;
    }

    /*
     * WARNING - void declaration
     */
    public PerforceBinaryContentRevision(@NotNull Project project, @Nullable P4Connection connection, @Nullable String depotPath, @Nullable FilePath filePath, long revision, @NotNull String string) {
        void stringRevision;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/perforce/application/PerforceBinaryContentRevision", "<init>"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRevision", "org/jetbrains/idea/perforce/application/PerforceBinaryContentRevision", "<init>"));
        }
        super(project, connection, depotPath, filePath, revision, (String)stringRevision);
        this.myContent = null;
    }

    @Nullable
    public byte[] getBinaryContent() throws VcsException {
        if (this.myContent != null) {
            return this.myContent;
        }
        P4File p4File = P4File.create(this.myFilePath);
        PerforceSettings settings = PerforceSettings.getSettings(this.myProject);
        if (!settings.ENABLED) {
            return null;
        }
        String rev = this.myStringRevision.startsWith("@=") ? this.myStringRevision : "#" + (this.myRevision > 0L ? Long.valueOf(this.myRevision) : p4File.getFstat((Project)this.myProject, (boolean)false).haveRev);
        byte[] bytes = PerforceRunner.getInstance(this.myProject).getByteContent(p4File, rev);
        if (bytes != null) {
            this.myContent = bytes;
        }
        return this.myContent;
    }
}

