/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.ConnectionInfo;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;

public class PerforceInfoAndClient {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceInfoAndClient");
    public static final String CLIENT_UNKNOWN = "Client unknown";

    @NotNull
    static ConnectionInfo calcInfo(@NotNull P4Connection connection, PerforceRunner runner, ClientRootsCache clientRootsCache) {
        ConnectionInfo connectionInfo;
        block6: {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient", "calcInfo"));
            }
            try {
                Map<String, List<String>> infoMap = PerforceInfoAndClient.calcInfoMap(connection, runner);
                connectionInfo = new ConnectionInfo(infoMap, PerforceInfoAndClient.calcClientMap(connection, runner, PerforceInfoAndClient.extractClient(infoMap), clientRootsCache));
                if (connectionInfo != null) break block6;
            }
            catch (PerforceAuthenticationException e) {
                ConnectionInfo connectionInfo2 = new ConnectionInfo((VcsException)((Object)e));
                if (connectionInfo2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient", "calcInfo"));
                }
                return connectionInfo2;
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                ConnectionInfo connectionInfo3 = new ConnectionInfo(e);
                if (connectionInfo3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient", "calcInfo"));
                }
                return connectionInfo3;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient", "calcInfo"));
        }
        return connectionInfo;
    }

    private static String extractClient(Map<String, List<String>> infoMap) throws VcsException {
        List<String> clientValue = infoMap.get("Client name:");
        if (clientValue == null || clientValue.size() == 0) {
            throw new VcsException("No client name in info specification found");
        }
        return clientValue.get(0);
    }

    @NotNull
    private static Map<String, List<String>> calcClientMap(P4Connection connection, PerforceRunner runner, String client, ClientRootsCache clientRootsCache) throws VcsException {
        Map<String, List<String>> clientMap = runner.loadClient(client, connection);
        PerforceInfoAndClient.convertRoots(clientMap, "Root:", clientRootsCache);
        PerforceInfoAndClient.convertRoots(clientMap, "AltRoots:", clientRootsCache);
        Map<String, List<String>> map = clientMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient", "calcClientMap"));
        }
        return map;
    }

    @NotNull
    private static Map<String, List<String>> calcInfoMap(P4Connection connection, PerforceRunner runner) throws VcsException {
        Map<String, List<String>> infoMap = runner.getInfo(connection);
        if (infoMap.containsKey("Client unknown.")) {
            if (connection instanceof P4ParametersConnection && ((P4ParametersConnection)connection).getParameters().getConfigFileName() == null) {
                throw new VcsException("Client unknown. P4CONFIG environment variable is undefined.");
            }
            throw new VcsException(CLIENT_UNKNOWN);
        }
        infoMap.remove("Client address:");
        infoMap.remove("Server date:");
        infoMap.remove("Client address:");
        Map<String, List<String>> map = infoMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceInfoAndClient", "calcInfoMap"));
        }
        return map;
    }

    public static RefreshInfo recalculateInfos(Map<P4Connection, ConnectionInfo> old, Collection<P4Connection> allConnections, PerforceRunner runner, ClientRootsCache clientRootsCache) {
        Map<P4Connection, ConnectionInfo> newMap = PerforceInfoAndClient.calculateInfos(allConnections, runner, clientRootsCache);
        boolean hasErrors = newMap.values().stream().anyMatch(ConnectionInfo::hasErrorsBesidesAuthentication);
        HashMap<P4Connection, ConnectionInfo> info = new HashMap<P4Connection, ConnectionInfo>();
        if (hasErrors) {
            info.putAll(old);
        }
        info.putAll(newMap);
        return new RefreshInfo(Collections.unmodifiableMap(info), hasErrors);
    }

    public static Map<P4Connection, ConnectionInfo> calculateInfos(Collection<P4Connection> allConnections, PerforceRunner runner, ClientRootsCache clientRootsCache) {
        HashMap<ConnectionKey, ConnectionInfo> cache = new HashMap<ConnectionKey, ConnectionInfo>();
        HashMap<P4Connection, ConnectionInfo> newMap = new HashMap<P4Connection, ConnectionInfo>();
        for (P4Connection connection : allConnections) {
            ConnectionKey key = connection.getConnectionKey();
            ConnectionInfo info = (ConnectionInfo)cache.get(key);
            if (info == null) {
                info = PerforceInfoAndClient.calcInfo(connection, runner, clientRootsCache);
                cache.put(key, info);
            }
            newMap.put(connection, info);
        }
        return newMap;
    }

    private static void convertRoots(Map<String, List<String>> clientSpec, String key, ClientRootsCache clientRootsCache) {
        List<String> in = clientSpec.get(key);
        if (in == null) {
            return;
        }
        ArrayList<String> out = new ArrayList<String>(in.size());
        for (String s : in) {
            out.add(clientRootsCache.putGet(s));
        }
        clientSpec.put(key, out);
    }

    public static class RefreshInfo {
        public final Map<P4Connection, ConnectionInfo> newInfo;
        public final boolean hasAnyErrorsBesidesAuthentication;

        public RefreshInfo(Map<P4Connection, ConnectionInfo> newInfo, boolean hasAnyErrorsBesidesAuthentication) {
            this.newInfo = newInfo;
            this.hasAnyErrorsBesidesAuthentication = hasAnyErrorsBesidesAuthentication;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("hasAnyErrorsBesidesAuthentication", this.hasAnyErrorsBesidesAuthentication).add("newInfo", this.newInfo).toString();
        }
    }
}

