/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.merge;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.merge.BaseRevision;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceMergeProvider
implements MergeProvider {
    private final Project myProject;
    private final PerforceRunner myRunner;

    public PerforceMergeProvider(Project project) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(this.myProject);
    }

    @NotNull
    public MergeData loadRevisions(final @NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/merge/PerforceMergeProvider", "loadRevisions"));
        }
        final MergeData mergeData = new MergeData();
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                PerforceSettings settings = PerforceSettings.getSettings(PerforceMergeProvider.this.myProject);
                P4File p4File = P4File.create(file);
                BaseRevision baseRevision = PerforceMergeProvider.this.myRunner.getBaseRevision(p4File);
                if (baseRevision == null) {
                    throw new VcsException(PerforceBundle.message((String)"message.text.cannot.find.merge.info.for.file", (Object[])new Object[]{file.getPresentableUrl()}));
                }
                P4Connection connection = settings.getConnectionForFile(file);
                mergeData.ORIGINAL = PerforceMergeProvider.this.myRunner.getByteContent(baseRevision, connection);
                String sourceRevision = baseRevision.getSourceRevision();
                if (sourceRevision == null) {
                    FStat fStat = p4File.getFstat(PerforceMergeProvider.this.myProject, true);
                    mergeData.LAST_REVISION_NUMBER = new VcsRevisionNumber.Int(Integer.parseInt(fStat.haveRev));
                    mergeData.LAST = PerforceMergeProvider.this.myRunner.getByteContent(file.getPath(), null, connection);
                } else {
                    mergeData.LAST = PerforceMergeProvider.this.myRunner.getByteContent(baseRevision.getDepotPath(), sourceRevision, connection);
                    mergeData.LAST_REVISION_NUMBER = new TextRevisionNumber(sourceRevision);
                }
                try {
                    mergeData.CURRENT = file.contentsToByteArray();
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)VcsBundle.message((String)"multiple.file.merge.loading.progress.title", (Object[])new Object[0]), (boolean)false, (Project)this.myProject);
        MergeData mergeData2 = mergeData;
        if (mergeData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/merge/PerforceMergeProvider", "loadRevisions"));
        }
        return mergeData2;
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/merge/PerforceMergeProvider", "conflictResolvedForFile"));
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/merge/PerforceMergeProvider", "lambda$conflictResolvedForFile$0"));
            }
            try {
                this.myRunner.resolveToYours(P4File.create(file));
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
        }, PerforceBundle.message((String)"progress.marking.file.as.resolved", (Object[])new Object[0]), false, this.myProject);
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/merge/PerforceMergeProvider", "isBinary"));
        }
        return false;
    }

    public List<VirtualFile> showMergeDialog(List<VirtualFile> files) {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        PerforceMergeDialog fileMergeDialog = new PerforceMergeDialog(files);
        fileMergeDialog.show();
        return fileMergeDialog.getProcessedFiles();
    }

    private class PerforceMergeDialog
    extends MultipleFileMergeDialog {
        public PerforceMergeDialog(List<VirtualFile> files) {
            super(PerforceMergeProvider.this.myProject, files, (MergeProvider)PerforceMergeProvider.this, new MergeDialogCustomizer());
        }

        protected boolean beforeResolve(Collection<VirtualFile> files) {
            for (Map.Entry entry : FileGrouper.distributeFilesByConnection(files, PerforceMergeProvider.this.myProject).entrySet()) {
                if (this.openForEdit((P4Connection)entry.getKey(), (Collection)entry.getValue())) continue;
                return false;
            }
            return true;
        }

        private boolean openForEdit(P4Connection connection, Collection<VirtualFile> files) {
            List p4Files = ContainerUtil.map(files, virtualFile -> P4File.create(virtualFile));
            try {
                PerforceMergeProvider.this.myRunner.editAll(p4Files, -1L, false, connection);
            }
            catch (VcsException e) {
                AbstractVcsHelper.getInstance((Project)PerforceMergeProvider.this.myProject).showError(e, "Resolve");
                return false;
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])files.toArray(new VirtualFile[files.size()]));
            return true;
        }
    }
}

