/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.P4MoveRenameOperation;
import org.jetbrains.idea.perforce.operations.RefreshForVcs;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationOnPath;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

public class P4RevertOperation
extends VcsOperation {
    public String beforePath;
    public String afterPath;

    public P4RevertOperation() {
    }

    public P4RevertOperation(Change c) {
        FilePath beforePath = ChangesUtil.getBeforePath((Change)c);
        FilePath afterPath = ChangesUtil.getAfterPath((Change)c);
        this.beforePath = beforePath == null ? null : beforePath.getPath();
        this.afterPath = afterPath == null ? null : afterPath.getPath();
    }

    @Override
    public void execute(Project project, ProcessingContext context) throws VcsException {
        ArrayList<String> toRevert = new ArrayList<String>();
        ArrayList<File> toDelete = new ArrayList<File>();
        this.prepareRevert(toRevert, toDelete);
        for (String path : toRevert) {
            PerforceRunner.getInstance(project).revert(P4File.createInefficientFromLocalPath(path), true);
        }
        P4RevertOperation.refreshAfterRevert(toRevert, toDelete, project);
    }

    boolean isRenameOrMove() {
        return this.beforePath != null && this.afterPath != null && !FileUtil.pathsEqual((String)this.beforePath, (String)this.afterPath);
    }

    @Override
    public void fillReopenedPaths(Map<String, String> result) {
        if (this.beforePath != null) {
            result.put(this.beforePath, null);
        }
        if (!(this.afterPath == null || this.beforePath != null && FileUtil.pathsEqual((String)this.beforePath, (String)this.afterPath))) {
            result.put(this.afterPath, null);
        }
    }

    @Override
    @Nullable
    public VcsOperation checkMerge(VcsOperation oldOp) {
        if (!this.isRenameOrMove()) {
            VcsOperationOnPath opOnPath;
            if ((oldOp instanceof P4EditOperation || oldOp instanceof P4AddOperation) && FileUtil.pathsEqual((String)(opOnPath = (VcsOperationOnPath)oldOp).getPath(), (String)this.afterPath)) {
                return null;
            }
        } else if (oldOp instanceof P4MoveRenameOperation) {
            P4MoveRenameOperation renameOp = (P4MoveRenameOperation)oldOp;
            if (FileUtil.pathsEqual((String)renameOp.newPath, (String)this.afterPath)) {
                return null;
            }
        }
        return super.checkMerge(oldOp);
    }

    @Override
    public List<String> getAffectedPaths() {
        SmartList result = new SmartList();
        ContainerUtil.addIfNotNull((Collection)result, (Object)this.beforePath);
        ContainerUtil.addIfNotNull((Collection)result, (Object)this.afterPath);
        return result;
    }

    void prepareRevert(List<String> toRevert, List<File> toDelete) {
        if (this.isRenameOrMove()) {
            toRevert.add(this.afterPath);
            toRevert.add(this.beforePath);
            toDelete.add(new File(this.afterPath));
        } else {
            String path;
            String string = path = this.beforePath != null ? this.beforePath : this.afterPath;
            assert (path != null);
            toRevert.add(path);
        }
    }

    static void refreshAfterRevert(List<String> toRevert, List<File> toDelete, Project project) {
        RefreshForVcs refreshWorker = new RefreshForVcs();
        for (String string : toRevert) {
            refreshWorker.refreshFile(new File(string));
        }
        for (File file : toDelete) {
            FileUtil.delete((File)file);
            refreshWorker.addDeletedFile(file);
        }
        refreshWorker.run(project);
    }
}

