/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.OutputMessageParser;
import org.jetbrains.idea.perforce.perforce.PerforceAbstractChange;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.ResolvedFile;

public class PerforceOutputMessageParser
extends OutputMessageParser {
    @NonNls
    private static final String CHANGE_PREFIX = "change";

    private PerforceOutputMessageParser(String output) throws IOException {
        super(output);
    }

    public static List<PerforceChange> processOpenedOutput(String opened) throws IOException {
        PerforceChange change;
        ArrayList<PerforceChange> result = new ArrayList<PerforceChange>();
        PerforceOutputMessageParser parser = new PerforceOutputMessageParser(opened);
        while ((change = parser.readNextOpened()) != null) {
            result.add(change);
        }
        return result;
    }

    @Nullable
    private PerforceChange readNextOpened() {
        if (this.myLines.isEmpty()) {
            return null;
        }
        String originalLine = this.myCurrentLine = (String)this.myLines.remove(0);
        if (this.myCurrentLine != null) {
            String depotPath = this.readTo("#");
            this.skip("#");
            String revisionNumber = this.readTo(" - ");
            if (revisionNumber == null) {
                throw new RuntimeException("Invalid 'p4 opened' line format: " + originalLine);
            }
            this.skip("-");
            String changeType = this.readTo(" ");
            long changeListNumber = -1L;
            if (this.myCurrentLine.startsWith(CHANGE_PREFIX)) {
                this.skip(CHANGE_PREFIX);
                changeListNumber = Long.parseLong(this.readTo(" "));
            }
            return new PerforceChange(PerforceAbstractChange.convertToType((String)changeType), null, depotPath, Long.parseLong(revisionNumber), changeListNumber, null);
        }
        return null;
    }

    public static List<ResolvedFile> processResolvedOutput(String resolved, @NotNull Convertor<String, String> pathConvertor) throws IOException, VcsException {
        ResolvedFile file;
        if (pathConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathConvertor", "org/jetbrains/idea/perforce/perforce/PerforceOutputMessageParser", "processResolvedOutput"));
        }
        ArrayList<ResolvedFile> result = new ArrayList<ResolvedFile>();
        PerforceOutputMessageParser parser = new PerforceOutputMessageParser(resolved);
        while ((file = parser.readNextResolved(pathConvertor)) != null) {
            result.add(file);
        }
        return result;
    }

    @Nullable
    private ResolvedFile readNextResolved(@NotNull Convertor<String, String> pathConvertor) throws IOException, VcsException {
        if (pathConvertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathConvertor", "org/jetbrains/idea/perforce/perforce/PerforceOutputMessageParser", "readNextResolved"));
        }
        if (this.myLines.isEmpty()) {
            return null;
        }
        this.myCurrentLine = (String)this.myLines.remove(0);
        if (this.myCurrentLine != null) {
            long revision1;
            String wholeLine = this.myCurrentLine;
            String localPath = this.readTo(" - ");
            File localFile = new File((String)pathConvertor.convert((Object)localPath));
            this.skip("-");
            String operation = this.readTo("//");
            String depotPath = this.readTo("#");
            if (depotPath == null) {
                depotPath = this.readTo("@=");
                if (depotPath != null) {
                    return new ResolvedFile(localFile, operation, depotPath, -1L, -1L);
                }
                if (operation.startsWith("resolved ")) {
                    return null;
                }
            }
            this.skip("#");
            long revision2 = -1L;
            try {
                if (this.myCurrentLine.indexOf(44) >= 0) {
                    revision1 = Long.parseLong(this.readTo(","));
                    this.skip(",#");
                    revision2 = Long.parseLong(this.myCurrentLine);
                } else {
                    revision1 = Long.parseLong(this.myCurrentLine);
                }
            }
            catch (NumberFormatException e) {
                throw new VcsException("Cannot parse p4 resolved output:\n" + this.myOutput + "\n\n current=" + wholeLine);
            }
            return new ResolvedFile(localFile, operation, depotPath, revision1, revision2);
        }
        return null;
    }
}

