/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.csv.CsvFormat;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatsListComponent
implements Disposable {
    private final JBTable myTable;
    private List<CsvFormat> myOriginalFormats;
    private boolean myEditingAllowed;
    private Consumer<CsvFormat> myEditedFormatConsumer;
    private boolean myResetting;
    private final EventDispatcher<ChangeListener> myDispatcher;

    public CsvFormatsListComponent(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvFormatsListComponent", "<init>"));
        }
        this.myOriginalFormats = ContainerUtil.emptyList();
        this.myDispatcher = EventDispatcher.create(ChangeListener.class);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myTable = new MyTable();
        this.myTable.setStriped(true);
        this.myTable.setTableHeader(null);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(10, this.myTable.getRowHeight() * 5));
        this.installListeners();
    }

    @NotNull
    public JBTable getComponent() {
        JBTable jBTable = this.myTable;
        if (jBTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsListComponent", "getComponent"));
        }
        return jBTable;
    }

    public void setNameEditingAllowed(boolean allowed) {
        this.myEditingAllowed = allowed;
    }

    @NotNull
    public List<CsvFormat> getFormats() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.model().getFormats());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsListComponent", "getFormats"));
        }
        return arrayList;
    }

    @Nullable
    public CsvFormat getSelected() {
        FormatsListModel model = this.model();
        int idx = this.getSelectedIdx();
        return idx != -1 ? model.getFormat(idx) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(@NotNull List<CsvFormat> formats, @Nullable String nameToSelect) {
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/csv/ui/CsvFormatsListComponent", "reset"));
        }
        int toSelect = CsvFormat.indexOfFormatNamed(formats, nameToSelect);
        if (toSelect == -1) {
            CsvFormat selected = this.getSelected();
            toSelect = CsvFormat.indexOfFormatNamed(formats, selected != null ? selected.name : null);
        }
        toSelect = toSelect == -1 && !formats.isEmpty() ? 0 : toSelect;
        this.myResetting = true;
        try {
            FormatsListModel model = this.model();
            if (this.myTable.isEditing()) {
                this.myTable.getCellEditor().cancelCellEditing();
            }
            model.setFormats(formats);
            this.select(toSelect);
        }
        finally {
            this.myOriginalFormats = ContainerUtil.newArrayList(formats);
            this.myResetting = false;
            this.fireFormatsChanged();
        }
    }

    public boolean isModified(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/CsvFormatsListComponent", "isModified"));
        }
        int idx = CsvFormat.indexOfFormatNamed(this.myOriginalFormats, format.name);
        return idx != -1 && !this.myOriginalFormats.get(idx).equals(format);
    }

    public void markUnmodified(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/CsvFormatsListComponent", "markUnmodified"));
        }
        int idx = CsvFormat.indexOfFormatNamed(this.myOriginalFormats, format.name);
        if (idx != -1) {
            this.myOriginalFormats.set(idx, format);
        }
    }

    public void addChangeListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/csv/ui/CsvFormatsListComponent", "addChangeListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void updateSelectedFormat(@NotNull CsvFormat with) {
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "com/intellij/database/csv/ui/CsvFormatsListComponent", "updateSelectedFormat"));
        }
        int selectedIdx = this.getSelectedIdx();
        if (selectedIdx != -1) {
            this.model().setFormat(selectedIdx, with);
        }
    }

    public void resetFormat(@Nullable String formatName) {
        int formatIdx = CsvFormat.indexOfFormatNamed(this.model().getFormats(), formatName);
        if (formatIdx == -1) {
            return;
        }
        int originalFormatIdx = CsvFormat.indexOfFormatNamed(this.myOriginalFormats, formatName);
        if (originalFormatIdx == -1) {
            return;
        }
        this.model().setFormat(formatIdx, this.myOriginalFormats.get(originalFormatIdx));
    }

    @NotNull
    public CsvFormat newFormat(@NotNull CsvFormat template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/csv/ui/CsvFormatsListComponent", "newFormat"));
        }
        CsvFormat format = new CsvFormat(this.getNewFormatName(template), template.dataRecord, template.headerRecord, template.rowNumbers);
        this.model().addFormat(format);
        this.select(this.model().getRowCount() - 1);
        CsvFormat csvFormat = format;
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsListComponent", "newFormat"));
        }
        return csvFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editFormatName(@NotNull CsvFormat format, @Nullable Consumer<CsvFormat> doWhenEditingIsComplete) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/CsvFormatsListComponent", "editFormatName"));
        }
        int idx = CsvFormat.indexOfFormatNamed(this.model().getFormats(), format.name);
        if (idx == -1) {
            throw new AssertionError();
        }
        boolean editingAllowed = this.myEditingAllowed;
        this.myEditingAllowed = true;
        try {
            if (this.myTable.editCellAt(idx, 0)) {
                this.myEditedFormatConsumer = doWhenEditingIsComplete;
                TableUtil.scrollSelectionToVisible((JTable)this.myTable);
            }
        }
        finally {
            this.myEditingAllowed = editingAllowed;
        }
    }

    public void dispose() {
    }

    private void editingComplete(int rowIdx) {
        if (this.myEditedFormatConsumer != null && rowIdx != -1) {
            this.myEditedFormatConsumer.consume((Object)this.model().getFormat(rowIdx));
            this.myEditedFormatConsumer = null;
        }
    }

    @NotNull
    private String getNewFormatName(@NotNull CsvFormat templateFormat) {
        if (templateFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFormat", "com/intellij/database/csv/ui/CsvFormatsListComponent", "getNewFormatName"));
        }
        String base = templateFormat.name;
        if (this.isUnique(base)) {
            String string = base;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsListComponent", "getNewFormatName"));
            }
            return string;
        }
        int i2 = 1;
        while (true) {
            String name;
            if (this.isUnique(name = base + "_" + i2)) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsListComponent", "getNewFormatName"));
                }
                return string;
            }
            ++i2;
        }
    }

    private boolean isUnique(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/csv/ui/CsvFormatsListComponent", "isUnique"));
        }
        return CsvFormat.indexOfFormatNamed(this.model().getFormats(), name) == -1;
    }

    private int getSelectedIdx() {
        int idx = this.myTable.getSelectionModel().getMinSelectionIndex();
        return idx >= 0 && idx < this.myTable.getRowCount() ? idx : -1;
    }

    private void select(int idx) {
        if (idx == -1) {
            this.myTable.getSelectionModel().clearSelection();
        } else {
            this.myTable.getSelectionModel().setSelectionInterval(idx, idx);
        }
    }

    @NotNull
    private FormatsListModel model() {
        FormatsListModel formatsListModel = (FormatsListModel)this.myTable.getModel();
        if (formatsListModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsListComponent", "model"));
        }
        return formatsListModel;
    }

    private void fireFormatsChanged() {
        if (!this.myResetting) {
            ((ChangeListener)this.myDispatcher.getMulticaster()).formatsChanged(this);
        }
    }

    private void installListeners() {
        this.model().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                CsvFormatsListComponent.this.fireFormatsChanged();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CsvFormatsListComponent.this.fireFormatsChanged();
            }
        });
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Point mouse = new Point(x, y);
                final int row = CsvFormatsListComponent.this.myTable.rowAtPoint(mouse);
                if (row == -1 || CsvFormatsListComponent.this.myTable.isEditing() || !CsvFormatsListComponent.this.myEditingAllowed) {
                    return;
                }
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(null, new String[]{"Edit Name"}){

                    public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                        if (finalChoice) {
                            CsvFormatsListComponent.this.editFormatName(CsvFormatsListComponent.this.model().getFormat(row), null);
                        }
                        return super.onChosen((Object)selectedValue, finalChoice);
                    }
                }).show(new RelativePoint(comp, mouse));
            }
        });
    }

    private static class FormatsListModel
    extends AbstractTableModel
    implements EditableModel {
        private List<CsvFormat> myFormats = ContainerUtil.newArrayList();

        private FormatsListModel() {
        }

        @Override
        public int getRowCount() {
            return this.myFormats.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myFormats.get(rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.myFormats.set(rowIndex, (CsvFormat)aValue);
            this.fireTableCellUpdated(rowIndex, 0);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public void addRow() {
            throw new AssertionError((Object)"Should not be called");
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            CsvFormat atOld = this.myFormats.get(oldIndex);
            this.myFormats.set(oldIndex, this.myFormats.get(newIndex));
            this.fireTableCellUpdated(oldIndex, 0);
            this.myFormats.set(newIndex, atOld);
            this.fireTableCellUpdated(newIndex, 0);
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        public void removeRow(int idx) {
            this.myFormats.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        @NotNull
        public List<CsvFormat> getFormats() {
            ImmutableList immutableList = ContainerUtil.immutableList(this.myFormats);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsListComponent$FormatsListModel", "getFormats"));
            }
            return immutableList;
        }

        @NotNull
        public CsvFormat getFormat(int idx) {
            CsvFormat csvFormat = this.myFormats.get(idx);
            if (csvFormat == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsListComponent$FormatsListModel", "getFormat"));
            }
            return csvFormat;
        }

        public void setFormats(@NotNull List<CsvFormat> formats) {
            if (formats == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/csv/ui/CsvFormatsListComponent$FormatsListModel", "setFormats"));
            }
            this.myFormats.clear();
            this.myFormats.addAll(formats);
            this.fireTableDataChanged();
        }

        public void setFormat(int idx, @NotNull CsvFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/CsvFormatsListComponent$FormatsListModel", "setFormat"));
            }
            this.setValueAt(format, idx, 0);
        }

        public void addFormat(@NotNull CsvFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/CsvFormatsListComponent$FormatsListModel", "addFormat"));
            }
            this.myFormats.add(format);
            this.fireTableRowsInserted(this.myFormats.size() - 1, this.myFormats.size() - 1);
        }
    }

    private class MyTable
    extends JBTable {
        TableCellRenderer renderer;
        TableCellEditor editor;

        public MyTable() {
            super((TableModel)new FormatsListModel());
            this.renderer = new MyRenderer();
            this.editor = new MyEditor();
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return this.renderer;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            return this.editor;
        }

        public void editingStopped(ChangeEvent e) {
            int editedRowIdx = this.getEditingRow();
            super.editingStopped(e);
            CsvFormatsListComponent.this.editingComplete(editedRowIdx);
        }

        public void editingCanceled(ChangeEvent e) {
            int editedRowIdx = this.getEditingRow();
            super.editingCanceled(e);
            CsvFormatsListComponent.this.editingComplete(editedRowIdx);
        }

        public boolean isCellEditable(int row, int column) {
            return CsvFormatsListComponent.this.myEditingAllowed;
        }
    }

    private class MyEditor
    extends AbstractTableCellEditor
    implements Disposable {
        private final EditorTextField myTextField = new EditorTextField("");
        private CsvFormat myFormat;

        private MyEditor() {
            this.myTextField.setOneLineMode(true);
            this.myTextField.setFontInheritedFromLAF(true);
            this.myTextField.setSupplementary(true);
            this.myTextField.putClientProperty((Object)"JBListTable.isTableCellEditor", (Object)Boolean.TRUE);
            new DumbAwareAction("stopEditing"){

                public void actionPerformed(AnActionEvent e) {
                    MyEditor.this.stopCellEditing();
                }
            }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)this.myTextField, (Disposable)this);
            Disposer.register((Disposable)CsvFormatsListComponent.this, (Disposable)this);
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                return ((MouseEvent)e).getClickCount() >= 2;
            }
            return super.isCellEditable(e);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myFormat = (CsvFormat)value;
            this.myTextField.setText(this.myFormat.name);
            this.myTextField.selectAll();
            return this.myTextField;
        }

        public Object getCellEditorValue() {
            return new CsvFormat(this.myTextField.getText(), this.myFormat.dataRecord, this.myFormat.headerRecord, this.myFormat.rowNumbers);
        }

        public boolean stopCellEditing() {
            CsvFormat format;
            String formatName = this.myTextField.getText();
            if (StringUtil.isEmpty((String)formatName)) {
                return false;
            }
            int idx = CsvFormat.indexOfFormatNamed(CsvFormatsListComponent.this.model().getFormats(), formatName);
            CsvFormat csvFormat = format = idx != -1 ? CsvFormatsListComponent.this.model().getFormat(idx) : null;
            if (format != null && format != this.myFormat) {
                return false;
            }
            return super.stopCellEditing();
        }

        public void dispose() {
            this.myTextField.removeNotify();
        }
    }

    private class MyRenderer
    extends EditorTextFieldJBTableRowRenderer {
        public MyRenderer() {
            super(null, null, (Disposable)CsvFormatsListComponent.this);
        }

        protected String getText(JTable table, int row) {
            CsvFormat format = (CsvFormat)table.getValueAt(row, 0);
            String formatName = StringUtil.notNullize((String)StringUtil.nullize((String)format.name), (String)"<unnamed format>");
            boolean modified = CsvFormatsListComponent.this.isModified(format);
            return formatName + (modified ? "*" : "");
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void formatsChanged(@NotNull CsvFormatsListComponent var1);
    }
}

