/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.dialects.Db2Dialect;

public class Db2Domains
extends DomainRegistry {
    private static final short MAX_DB2_GRAPHIC = 127;
    private static final short MAX_VARGRAPHIC = 16336;
    private static final short MAX_DECIMAL_PRECISION = 31;
    private static final double MIN_DOUBLE = -7.2E75;
    private static final double MAX_DOUBLE = 7.2E75;
    private static final int DB2_MAX_TS_PRECISION = 12;
    private static final int MAX_VARCHAR_LENGTH = 32704;
    private static final int DBCLOB = 0x3FFFFFFF;

    public Db2Domains() {
        super(Db2Dialect.INSTANCE);
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new TextDomain("vargraphic", ConversionPoint.TEXT_GRAPHIC, 16336L, -1L, true));
        this.add(new TextDomain("graphic", ConversionPoint.TEXT_GRAPHIC, 127L, -1L, true));
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add(new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, 31, 31, true));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -7.2E75, 7.2E75));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 12, -1, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 32704L, -1L, true));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("dbclob", ConversionPoint.CLOB, 0x3FFFFFFFL, -1L, true));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 127L, -1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, 127L, -1L, true));
    }
}

