/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DatabaseDriverManager {
    public static DatabaseDriverManager getInstance() {
        return (DatabaseDriverManager)ServiceManager.getService(DatabaseDriverManager.class);
    }

    public abstract Collection<? extends DatabaseDriver> getDrivers();

    public abstract DatabaseDriver getDriver(String var1);

    public abstract void resetToPredefined(@NotNull DatabaseDriver var1);

    public abstract boolean isInPredefinedState(@NotNull DatabaseDriver var1);

    public abstract DatabaseDriver createDriver(String var1, String var2, UrlTemplate var3);

    public abstract void updateDriver(@NotNull DatabaseDriver var1);

    public abstract void removeDriver(@NotNull DatabaseDriver var1);

    public abstract void addDriverListener(@NotNull DatabaseDriverListener var1, @NotNull Disposable var2);

    public static DatabaseDriver createDefaultDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> drivers) {
        if (drivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drivers", "com/intellij/database/dataSource/DatabaseDriverManager", "createDefaultDatabaseDriver"));
        }
        return DatabaseDriverManager.getInstance().createDriver(DatabaseDriverManager.chooseNewDriverName(drivers, "Database Driver"), "java.sql.Driver", null);
    }

    @NotNull
    public static String chooseNewDriverName(@NotNull Collection<? extends DatabaseDriver> drivers, @NotNull String baseName) {
        if (drivers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drivers", "com/intellij/database/dataSource/DatabaseDriverManager", "chooseNewDriverName"));
        }
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/database/dataSource/DatabaseDriverManager", "chooseNewDriverName"));
        }
        HashSet names = ContainerUtil.newHashSet();
        for (DatabaseDriver databaseDriver : drivers) {
            names.add(databaseDriver.getName());
        }
        String string = DbUtil.createNewDataSourceName((String)baseName, (Set)names);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverManager", "chooseNewDriverName"));
        }
        return string;
    }
}

