/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModColumn;
import com.intellij.database.model.basic.BasicModConstraint;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.JdbcParameterType;
import com.intellij.database.model.properties.JdbcProcedureType;
import com.intellij.database.model.properties.JdbcTableType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class LegacyDeserializer {
    private static final String TABLE_ELEMENT_NAME = "table";
    private static final String COLUMN_ELEMENT_NAME = "column";
    private static final String PROCEDURE_ELEMENT_NAME = "procedure";
    private static final String PROCEDURE_PROTO_ELEMENT_NAME = "prototype";
    private static final String ARGUMENT_ELEMENT_NAME = "parameter";
    private static final Pattern COLUMN_SPLITTER_PATTERN = Pattern.compile("\\s*,\\s*");

    private static boolean isSchemaBased(@NotNull IntrospectionScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/LegacyDeserializer", "isSchemaBased"));
        }
        Set<String> dbs = scope.databases();
        Set<String> schemas = scope.allSchemas();
        return dbs.size() == 1 && dbs.contains("*") && (schemas.size() != 1 || !schemas.contains("*"));
    }

    @NotNull
    public static BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @NotNull ModelFactory modelFactory, @NotNull DatabaseDialectEx dialect, IntrospectionScope intro, IntrospectionScope res) {
        BasicModModel model;
        boolean schemaDbMode;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/LegacyDeserializer", "deserialize"));
        }
        if (modelFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelFactory", "com/intellij/database/dataSource/LegacyDeserializer", "deserialize"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dataSource/LegacyDeserializer", "deserialize"));
        }
        Rdbms rdbms = DataSourceUiUtil.getRdbmsForIntrospection(dialect.getFamilyId());
        if (rdbms == null) {
            rdbms = UnknownDatabase.RDBMS;
        }
        if ((schemaDbMode = GenericIntrospectorLegacyModelUtils.isSchemaDbMode(model = modelFactory.createModel(rdbms), dialect.getFamilyId())) && (LegacyDeserializer.isSchemaBased(intro) || LegacyDeserializer.isSchemaBased(res))) {
            schemaDbMode = false;
        }
        HashMap refCols = ContainerUtil.newHashMap();
        while (true) {
            String nodeName;
            if (TABLE_ELEMENT_NAME.equals(nodeName = reader.getNodeName())) {
                LegacyDeserializer.deserializeTable(reader, model, schemaDbMode, refCols);
            } else if (PROCEDURE_ELEMENT_NAME.equals(nodeName)) {
                LegacyDeserializer.deserializeProcedure(reader, model, schemaDbMode);
            } else if ("schema".equals(nodeName)) {
                LegacyDeserializer.getOrCreateSchema(model, reader.getAttribute("catalog"), reader.getAttribute("name"), schemaDbMode);
            }
            reader.moveUp();
            if (!reader.hasMoreChildren()) break;
            reader.moveDown();
        }
        for (BasicModForeignKey fkey : ((JBTreeTraverser)model.traverser().expand(Conditions.alwaysTrue())).filter(BasicModForeignKey.class)) {
            List refColNames = (List)refCols.get(fkey);
            if (refColNames == null) continue;
            GenericIntrospectorLegacyModelUtils.resolveKey(fkey, refColNames);
        }
        BasicModModel basicModModel = model;
        if (basicModModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacyDeserializer", "deserialize"));
        }
        return basicModModel;
    }

    @Nullable
    private static BasicModRoutine createRoutine(@NotNull ModNamingFamily<?> targetFamily, String name, DasRoutine.Kind kind, String comment) {
        if (targetFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFamily", "com/intellij/database/dataSource/LegacyDeserializer", "createRoutine"));
        }
        BasicModRoutine routine2 = (BasicModRoutine)ObjectUtils.tryCast(targetFamily.createNewOne(), BasicModRoutine.class);
        if (routine2 == null) {
            return null;
        }
        ((BasicModNamedElement)((Object)routine2)).setName(name);
        ((BasicModNamedElement)((Object)routine2)).setComment(comment);
        routine2.setRoutineKind(kind);
        return routine2;
    }

    private static void deserializeArgument(HierarchicalStreamReader xmlReader, @NotNull BasicModRoutine routine2, boolean ret, int idx) {
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/dataSource/LegacyDeserializer", "deserializeArgument"));
        }
        if (!ARGUMENT_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return;
        }
        ModNamingFamily arguments = GenericIntrospectorLegacyModelUtils.familyOf(routine2, ObjectKind.ARGUMENT);
        if (arguments == null) {
            return;
        }
        BasicModArgument arg = (BasicModArgument)arguments.createNewOne();
        arg.setName(DbUtil.intern((String)xmlReader.getAttribute("name")));
        arg.setDataType(LegacyDeserializer.deserializeDataType(xmlReader));
        arg.setDefaultExpression(LegacyDeserializer.deserializeAttribute(xmlReader, "def"));
        arg.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        DasArgument.Direction direction = JdbcParameterType.findByID(StringUtil.parseInt((String)xmlReader.getAttribute("type"), (int)JdbcParameterType.IN.getID())).getArgumentDirection();
        if (ret) {
            direction = DasArgument.Direction.RETURN;
        }
        arg.setArgumentDirection(direction);
        short pos = (short)StringUtil.parseInt((String)xmlReader.getAttribute("index"), (int)-1);
        arg.setPosition(pos);
    }

    @NotNull
    private static DataType deserializeDataType(HierarchicalStreamReader xmlReader) {
        int scale;
        int precision;
        String sqlType = DbUtil.intern((String)xmlReader.getAttribute("sqlType"));
        String lengthStr = xmlReader.getAttribute("length");
        if (lengthStr != null) {
            precision = StringUtil.parseInt((String)lengthStr, (int)-1);
            scale = StringUtil.parseInt((String)xmlReader.getAttribute("precision"), (int)-1);
        } else {
            precision = StringUtil.parseInt((String)xmlReader.getAttribute("precision"), (int)-1);
            scale = StringUtil.parseInt((String)xmlReader.getAttribute("scale"), (int)-1);
        }
        int jdbcType = StringUtil.parseInt((String)xmlReader.getAttribute("jdbcType"), (int)1111);
        DataType dataType = DataTypeFactory.of(null, DbUtil.intern((String)sqlType), precision, scale, null, null, false, false, jdbcType);
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacyDeserializer", "deserializeDataType"));
        }
        return dataType;
    }

    private static BasicModRoutine deserializeProcedure(HierarchicalStreamReader xmlReader, @NotNull BasicModModel model, boolean schemaDbMode) {
        ModNamingFamily pkgFamily;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/LegacyDeserializer", "deserializeProcedure"));
        }
        if (!PROCEDURE_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return null;
        }
        BasicModSchema schema = LegacyDeserializer.getOrCreateSchema(model, xmlReader.getAttribute("catalog"), xmlReader.getAttribute("schema"), schemaDbMode);
        String pkg = DbUtil.intern((String)xmlReader.getAttribute("package"), null);
        ModNamingFamily targetFamily = null;
        if (!StringUtil.isEmpty((String)pkg) && (pkgFamily = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.PACKAGE)) != null) {
            Object pkgObj = pkgFamily.createOrGet(pkg);
            targetFamily = GenericIntrospectorLegacyModelUtils.familyOf(pkgObj, ObjectKind.ROUTINE);
        }
        if (targetFamily == null) {
            targetFamily = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.ROUTINE);
        }
        if (targetFamily == null) {
            return null;
        }
        String name = DbUtil.intern((String)xmlReader.getAttribute("name"));
        DasRoutine.Kind kind = JdbcProcedureType.findByID(StringUtil.parseInt((String)xmlReader.getAttribute("type"), (int)0)).getKind();
        String comment = LegacyDeserializer.deserializeAttribute(xmlReader, "remarks");
        BasicModRoutine routine2 = null;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if (PROCEDURE_PROTO_ELEMENT_NAME.equals(nodeName) && (routine2 = LegacyDeserializer.createRoutine(targetFamily, name, kind, comment)) != null) {
                boolean hasReturn = "true".equals(xmlReader.getAttribute("return"));
                int idx = 0;
                while (xmlReader.hasMoreChildren()) {
                    xmlReader.moveDown();
                    if (ARGUMENT_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
                        LegacyDeserializer.deserializeArgument(xmlReader, routine2, hasReturn, ++idx);
                        if (hasReturn) {
                            hasReturn = false;
                        }
                    }
                    xmlReader.moveUp();
                }
                ModNamingFamily arguments = GenericIntrospectorLegacyModelUtils.familyOf(routine2, ObjectKind.ARGUMENT);
                if (arguments != null) {
                    arguments.sort();
                    for (BasicModArgument argument : JBIterable.from(arguments).filter(BasicModArgument.class)) {
                        argument.setPosition((short)0);
                    }
                }
            }
            xmlReader.moveUp();
        }
        if (routine2 == null) {
            routine2 = LegacyDeserializer.createRoutine(targetFamily, name, kind, comment);
        }
        return routine2;
    }

    @NotNull
    private static BasicModSchema getOrCreateSchema(@NotNull BasicModModel model, String cat, String schema, boolean schemaDbMode) {
        BasicModSchema res;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/LegacyDeserializer", "getOrCreateSchema"));
        }
        ModNamingFamily root2 = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)model.getRoot()), ObjectKind.DATABASE);
        if (root2 != null) {
            BasicModDatabase modCat = (BasicModDatabase)root2.createOrGet(StringUtil.notNullize((String)DbUtil.intern((String)cat)));
            modCat.setVisible(true);
            res = (BasicModSchema)modCat.getSchemas().createOrGet(StringUtil.notNullize((String)DbUtil.intern((String)schema)));
        } else {
            root2 = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)model.getRoot()), ObjectKind.SCHEMA);
            if (root2 != null) {
                res = (BasicModSchema)root2.createOrGet(StringUtil.notNullize((String)DbUtil.intern((String)(schemaDbMode ? cat : schema))));
            } else {
                throw new AssertionError((Object)"Root has no database or schema family");
            }
        }
        res.setVisible(true);
        BasicModSchema basicModSchema = res;
        if (basicModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacyDeserializer", "getOrCreateSchema"));
        }
        return basicModSchema;
    }

    private static void deserializeTable(HierarchicalStreamReader xmlReader, @NotNull BasicModModel model, boolean schemaDbMode, Map<BasicModForeignKey, List<String>> refCols) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/LegacyDeserializer", "deserializeTable"));
        }
        if (!TABLE_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return;
        }
        BasicModSchema schema = LegacyDeserializer.getOrCreateSchema(model, xmlReader.getAttribute("catalog"), xmlReader.getAttribute("schema"), schemaDbMode);
        String name = DbUtil.intern((String)xmlReader.getAttribute("name"));
        JdbcTableType tableType = JdbcTableType.findByName(xmlReader.getAttribute("type"));
        ModNamingFamily tables = GenericIntrospectorLegacyModelUtils.familyOf(schema, tableType.getKind());
        if (tables == null) {
            tables = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.TABLE);
        }
        if (tables == null) {
            return;
        }
        BasicModLikeTable table = (BasicModLikeTable)ObjectUtils.tryCast(tables.createOrGet(name), BasicModLikeTable.class);
        if (table == null) {
            return;
        }
        ((BasicModNamedElement)((Object)table)).setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        boolean count = false;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if (COLUMN_ELEMENT_NAME.equals(nodeName)) {
                BasicModColumn column = LegacyDeserializer.deserializeColumn(xmlReader, table);
                if (column != null && Boolean.parseBoolean(xmlReader.getAttribute("autoIncrement"))) {
                    column.setSequenceIdentity(GenericIntrospectorLegacyModelUtils.SEQUENCE_IDENTITY);
                }
            } else if ("primary-key".equals(nodeName)) {
                BasicModKey key = LegacyDeserializer.deserializeKey(xmlReader, table);
                if (key != null) {
                    key.setPrimary(true);
                }
            } else if ("foreign-key".equals(nodeName)) {
                LegacyDeserializer.deserializeFk(xmlReader, table, schemaDbMode, refCols);
            } else if ("index".equals(nodeName)) {
                LegacyDeserializer.deserializeIndex(xmlReader, table);
            }
            xmlReader.moveUp();
        }
    }

    @Nullable
    private static BasicModKey deserializeKey(HierarchicalStreamReader xmlReader, @NotNull BasicModLikeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TABLE_ELEMENT_NAME, "com/intellij/database/dataSource/LegacyDeserializer", "deserializeKey"));
        }
        ModNamingFamily keys = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.KEY);
        if (keys == null) {
            return null;
        }
        BasicModKey key = (BasicModKey)keys.createOrGet(DbUtil.intern((String)xmlReader.getAttribute("name")));
        LegacyDeserializer.deserializeConstraint(xmlReader, key);
        return key;
    }

    @Nullable
    private static BasicModIndex deserializeIndex(HierarchicalStreamReader xmlReader, @NotNull BasicModLikeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", TABLE_ELEMENT_NAME, "com/intellij/database/dataSource/LegacyDeserializer", "deserializeIndex"));
        }
        ModNamingFamily indices = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.INDEX);
        if (indices == null) {
            return null;
        }
        BasicModIndex index = (BasicModIndex)indices.createOrGet(DbUtil.intern((String)xmlReader.getAttribute("name")));
        index.setUnique(Boolean.valueOf(xmlReader.getAttribute("unique")));
        index.setColNames(COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("columns")), 0));
        return index;
    }

    private static void deserializeConstraint(HierarchicalStreamReader xmlReader, @NotNull BasicModConstraint constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "com/intellij/database/dataSource/LegacyDeserializer", "deserializeConstraint"));
        }
        constraint.setColNames(COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("columns")), 0));
    }

    @Nullable
    private static BasicModForeignKey deserializeFk(HierarchicalStreamReader xmlReader, BasicModLikeTable table, boolean schemaDbMode, Map<BasicModForeignKey, List<String>> refCols) {
        ModNamingFamily foreignKeys = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.FOREIGN_KEY);
        if (foreignKeys == null) {
            return null;
        }
        BasicModForeignKey fk = (BasicModForeignKey)foreignKeys.createOrGet(DbUtil.intern((String)xmlReader.getAttribute("name")));
        LegacyDeserializer.deserializeConstraint(xmlReader, fk);
        String tTab = DbUtil.intern((String)xmlReader.getAttribute("ref-table"));
        String tSchema = DbUtil.intern((String)xmlReader.getAttribute("ref-schema"));
        String tCat = DbUtil.intern((String)xmlReader.getAttribute("ref-catalog"));
        fk.setRefTableName(StringUtil.nullize((String)tTab));
        String refSchema = StringUtil.nullize((String)(schemaDbMode ? tCat : tSchema));
        if (!Comparing.equal((String)refSchema, (String)DasUtil.getName((DasObject)table.getDbParent()))) {
            fk.setRefSchemaName(refSchema);
        }
        List<String> refColNames = Arrays.asList(COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("ref-columns")), 0));
        fk.setRefColNames(refColNames);
        refCols.put(fk, refColNames);
        fk.setOnUpdate(GenericIntrospectorLegacyModelUtils.asCascadeRule(LegacyDeserializer.itemAt(StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("update-rule")), (int)-1), DasForeignKey.RuleAction.values()), true));
        fk.setOnDelete(GenericIntrospectorLegacyModelUtils.asCascadeRule(LegacyDeserializer.itemAt(StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("delete-rule")), (int)-1), DasForeignKey.RuleAction.values()), false));
        DasForeignKey.Deferrability deferrability = LegacyDeserializer.itemAt(StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("deferrability")), (int)-1), DasForeignKey.Deferrability.values());
        if (deferrability == null) {
            deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
        }
        fk.setDeferrable(deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE);
        fk.setInitiallyDeferred(deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED);
        return fk;
    }

    @Nullable
    private static BasicModColumn deserializeColumn(HierarchicalStreamReader xmlReader, BasicModLikeTable table) {
        ModNamingFamily columns = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.COLUMN);
        if (columns == null) {
            return null;
        }
        BasicModColumn column = (BasicModColumn)columns.createOrGet(DbUtil.intern((String)xmlReader.getAttribute("name")));
        column.setDataType(LegacyDeserializer.deserializeDataType(xmlReader));
        column.setNotNull(!Boolean.parseBoolean(xmlReader.getAttribute("nullable")));
        column.setDefaultExpression(LegacyDeserializer.deserializeAttribute(xmlReader, "def"));
        column.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        return column;
    }

    @Nullable
    static String deserializeAttribute(@NotNull HierarchicalStreamReader xmlReader, String name) {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/intellij/database/dataSource/LegacyDeserializer", "deserializeAttribute"));
        }
        String value = xmlReader.getAttribute(name);
        if (value != null) {
            return DbUtil.intern((String)new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8));
        }
        return null;
    }

    @Nullable
    private static <E> E itemAt(int ordinal, E[] values) {
        return ordinal >= 0 && ordinal < values.length ? (E)values[ordinal] : null;
    }
}

