/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorage
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbSrcStorage.class);
    public static boolean ourEnabledOverride = false;
    private final Project myProject;
    private final String myStorageRoot;
    protected final FsAccess myFsAccess;
    private final Map<String, DbDataSourceLayout> myDsLayouts;
    private boolean myDsChanged;

    public static boolean isEnabled() {
        if (ourEnabledOverride) {
            return true;
        }
        return LazyData.STORAGE_ENABLED;
    }

    public static boolean isWritable() {
        return DbSrcStorage.isEnabled();
    }

    @NotNull
    public static DbSrcStorage getInstance(@Nullable Project project) {
        DbSrcStorage service = project == null ? (DbSrcStorage)ServiceManager.getService(App.class) : (DbSrcStorage)ServiceManager.getService((Project)project, DbSrcStorage.class);
        DbSrcStorage dbSrcStorage = service == null ? new DbSrcStorage(project) : service;
        if (dbSrcStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getInstance"));
        }
        return dbSrcStorage;
    }

    @NotNull
    public static DbSrcStorage getInstance(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getInstance"));
        }
        Project project = dataSource.getProject();
        LocalDataSource localDataSource = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class));
        if (localDataSource != null && localDataSource.isGlobal()) {
            project = null;
        }
        DbSrcStorage dbSrcStorage = DbSrcStorage.getInstance(project);
        if (dbSrcStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getInstance"));
        }
        return dbSrcStorage;
    }

    public DbSrcStorage(@Nullable Project project) {
        this(project, FsAccess.INSTANCE);
    }

    public DbSrcStorage(final @Nullable Project project, @NotNull FsAccess fs) {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "<init>"));
        }
        this.myDsLayouts = ContainerUtil.newHashMap();
        this.myFsAccess = fs;
        this.myProject = project;
        this.myStorageRoot = DbSrcStorage.getStorageRoot(project);
        Disposer.register((Disposable)(project != null ? project : ApplicationManager.getApplication()), (Disposable)this);
        DataSourceListener listener = new DataSourceListener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$1", "dataSourceAdded"));
                }
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$1", "dataSourceRemoved"));
                }
                if (project == null != dataSource.isGlobal()) {
                    return;
                }
                DbSrcStorage.this.myDsChanged = true;
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
            }
        };
        if (project == null) {
            DataSourceStorage.getStorage().addDataSourceListener(listener, this);
        } else {
            DataSourceManagerEx.getInstanceEx(project).addDataSourceListener(listener, this);
        }
    }

    public void dispose() {
        this.myDsLayouts.values().forEach(Disposer::dispose);
    }

    @NotNull
    public FsAccess getFsAccess() {
        FsAccess fsAccess = this.myFsAccess;
        if (fsAccess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getFsAccess"));
        }
        return fsAccess;
    }

    @NotNull
    public List<String> getDataSources() {
        VirtualFile root2 = this.getStorageRoot();
        if (root2 == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getDataSources"));
            }
            return list;
        }
        ArrayList res = ContainerUtil.newArrayList();
        for (VirtualFile file : root2.getChildren()) {
            if (!file.isDirectory()) continue;
            res.add(file.getName());
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getDataSources"));
        }
        return arrayList;
    }

    public boolean exists(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "exists"));
        }
        return this.getRoot(dataSourceId) != null;
    }

    @Nullable
    public String getDataSourceId(@Nullable VirtualFile file) {
        VirtualFile folder = this.getDataSourceFolder(file);
        return folder == null ? null : folder.getName();
    }

    @Nullable
    public VirtualFile getDataSourceFolder(@Nullable VirtualFile file) {
        VirtualFile prev;
        VirtualFile root2;
        if (file != null && file.getFileSystem() instanceof ArchiveFileSystem) {
            file = VfsUtilCore.getVirtualFileForJar((VirtualFile)file);
        }
        if ((root2 = this.getStorageRoot()) == null || file == null || file.equals(root2)) {
            return null;
        }
        do {
            prev = file;
        } while ((file = file.getParent()) != null && !file.equals(root2));
        return file == null || !prev.isDirectory() ? null : prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DbDataSourceLayout getLayout(@NotNull String dataSourceId) {
        LocalDataSource source;
        DbDataSourceLayout layout;
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getLayout"));
        }
        Map<String, DbDataSourceLayout> map = this.myDsLayouts;
        synchronized (map) {
            List<? extends LocalDataSource> sources;
            layout = this.myDsLayouts.get(dataSourceId);
            if (layout == null) {
                layout = new DbDataSourceLayout(dataSourceId, this.buildPath(dataSourceId), this.myFsAccess);
                this.myDsLayouts.put(dataSourceId, layout);
            }
            if ((source = (LocalDataSource)((Object)ContainerUtil.find(sources = DbSrcUtils.getDataSources(this.myProject), s -> {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "lambda$getLayout$0"));
                }
                return s.getUniqueId().equals(dataSourceId);
            }))) != null && this.myProject == null != source.isGlobal()) {
                LOG.warn("Searching data source elsewhere");
            }
            if (!sources.isEmpty() && this.myDsChanged) {
                Set actualIds = JBIterable.from(sources).transform(AbstractDataSource::getUniqueId).append((Object)dataSourceId).toSet();
                Iterator<Map.Entry<String, DbDataSourceLayout>> it = this.myDsLayouts.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, DbDataSourceLayout> entry = it.next();
                    if (actualIds.contains(entry.getKey())) continue;
                    Disposer.dispose((Disposable)entry.getValue());
                    it.remove();
                }
            }
            this.myDsChanged = false;
        }
        if (source != null && source.getDefaultDialect() != null && layout.getLanguage().getID() != source.getDefaultDialect()) {
            SqlLanguageDialect lang;
            String defaultDialect = source.getDefaultDialect();
            SqlLanguageDialect sqlLanguageDialect = lang = StringUtil.isEmpty((String)defaultDialect) ? null : DbSqlUtil.findDialectById(defaultDialect);
            if (lang == null) {
                lang = DbSqlUtil.getGenericDialect();
            }
            layout.updateSettings(lang);
        }
        DbDataSourceLayout dbDataSourceLayout = layout;
        if (dbDataSourceLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getLayout"));
        }
        return dbDataSourceLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLayouts() {
        Map<String, DbDataSourceLayout> map = this.myDsLayouts;
        synchronized (map) {
            Iterator<Map.Entry<String, DbDataSourceLayout>> it = this.myDsLayouts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, DbDataSourceLayout> entry = it.next();
                Disposer.dispose((Disposable)entry.getValue());
                it.remove();
            }
        }
    }

    @Nullable(value="storage is empty")
    public @Nullable(value="storage is empty") VirtualFile getStorageRoot() {
        return this.myFsAccess.findFileByPath(this.myStorageRoot);
    }

    @Nullable
    public VirtualFile getRoot(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getRoot"));
        }
        return this.myFsAccess.findFileByPath(this.buildPath(dataSourceId));
    }

    @NotNull
    public String buildPath(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "buildPath"));
        }
        String string = this.myStorageRoot + "/" + dataSourceId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "buildPath"));
        }
        return string;
    }

    @NotNull
    public static String getStorageRoot(@Nullable Project project) {
        String storage = DataSourceStorage.getStoragePath(project);
        if (storage == null && project != null) {
            storage = project.getProjectFilePath();
        }
        if (storage == null) {
            storage = PathManager.getOptionsPath() + "/dummy";
        }
        String string = new File(new File(storage).getParentFile(), "dataSources").getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getStorageRoot"));
        }
        return string;
    }

    public static class App
    extends DbSrcStorage {
        public App(@NotNull FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$App", "<init>"));
            }
            super(null, fs);
        }

        public App() {
            super(null);
        }
    }

    public static class FsAccess {
        public static final FsAccess INSTANCE = new FsAccess();

        @Nullable
        public VirtualFile findFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "findFileByPath"));
            }
            return LocalFileSystem.getInstance().findFileByPath(path);
        }

        @Nullable
        public VirtualFile getJarRootForLocalFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getJarRootForLocalFile"));
            }
            return JarFileSystem.getInstance().getJarRootForLocalFile(file);
        }

        @Nullable
        public VirtualFile getLocalFileForJarEntry(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getLocalFileForJarEntry"));
            }
            return JarFileSystem.getInstance().getLocalByEntry(file);
        }

        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "refreshAndFindFileByPath"));
            }
            return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        }
    }

    private static class LazyData {
        public static final boolean STORAGE_ENABLED;

        private LazyData() {
        }

        static {
            ApplicationManager.getApplication().getComponent(RegistryState.class);
            STORAGE_ENABLED = Registry.is((String)"database.src_storage.enabled", (boolean)false);
        }
    }
}

