/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.zipfs;

import com.intellij.database.dataSource.srcStorage.zipfs.ZipDirectoryStream;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileAttributeView;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileAttributes;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ZipPath
implements Path {
    private final ZipFileSystem zfs;
    private final byte[] path;
    private volatile int[] offsets;
    private int hashcode = 0;
    private volatile byte[] resolved = null;

    ZipPath(ZipFileSystem zfs, byte[] path) {
        this(zfs, path, false);
    }

    ZipPath(ZipFileSystem zfs, byte[] path, boolean normalized) {
        this.zfs = zfs;
        this.path = normalized ? path : this.normalize(path);
    }

    @Override
    public ZipPath getRoot() {
        if (this.isAbsolute()) {
            return new ZipPath(this.zfs, new byte[]{this.path[0]});
        }
        return null;
    }

    @Override
    public Path getFileName() {
        this.initOffsets();
        int count = this.offsets.length;
        if (count == 0) {
            return null;
        }
        if (count == 1 && this.path[0] != 47) {
            return this;
        }
        int lastOffset = this.offsets[count - 1];
        int len = this.path.length - lastOffset;
        byte[] result = new byte[len];
        System.arraycopy(this.path, lastOffset, result, 0, len);
        return new ZipPath(this.zfs, result);
    }

    @Override
    public ZipPath getParent() {
        this.initOffsets();
        int count = this.offsets.length;
        if (count == 0) {
            return null;
        }
        int len = this.offsets[count - 1] - 1;
        if (len <= 0) {
            return this.getRoot();
        }
        byte[] result = new byte[len];
        System.arraycopy(this.path, 0, result, 0, len);
        return new ZipPath(this.zfs, result);
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public ZipPath getName(int index) {
        this.initOffsets();
        if (index < 0 || index >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        int begin = this.offsets[index];
        int len = index == this.offsets.length - 1 ? this.path.length - begin : this.offsets[index + 1] - begin - 1;
        byte[] result = new byte[len];
        System.arraycopy(this.path, begin, result, 0, len);
        return new ZipPath(this.zfs, result);
    }

    @Override
    public ZipPath subpath(int beginIndex, int endIndex) {
        this.initOffsets();
        if (beginIndex < 0 || beginIndex >= this.offsets.length || endIndex > this.offsets.length || beginIndex >= endIndex) {
            throw new IllegalArgumentException();
        }
        int begin = this.offsets[beginIndex];
        int len = endIndex == this.offsets.length ? this.path.length - begin : this.offsets[endIndex] - begin - 1;
        byte[] result = new byte[len];
        System.arraycopy(this.path, begin, result, 0, len);
        return new ZipPath(this.zfs, result);
    }

    @Override
    public ZipPath toRealPath(LinkOption ... options) throws IOException {
        ZipPath realPath = new ZipPath(this.zfs, this.getResolvedPath()).toAbsolutePath();
        realPath.checkAccess(new AccessMode[0]);
        return realPath;
    }

    boolean isHidden() {
        return false;
    }

    @Override
    public ZipPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        byte[] defaultdir = this.zfs.getDefaultDir().path;
        int defaultlen = defaultdir.length;
        boolean endsWith = defaultdir[defaultlen - 1] == 47;
        byte[] t = null;
        t = endsWith ? new byte[defaultlen + this.path.length] : new byte[defaultlen + 1 + this.path.length];
        System.arraycopy(defaultdir, 0, t, 0, defaultlen);
        if (!endsWith) {
            t[defaultlen++] = 47;
        }
        System.arraycopy(this.path, 0, t, defaultlen, this.path.length);
        return new ZipPath(this.zfs, t, true);
    }

    @Override
    public URI toUri() {
        try {
            return new URI("jar", this.zfs.getZipFile().toUri() + "!" + this.zfs.getString(this.toAbsolutePath().path), null);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private boolean equalsNameAt(ZipPath other, int index) {
        int mbegin = this.offsets[index];
        int mlen = 0;
        mlen = index == this.offsets.length - 1 ? this.path.length - mbegin : this.offsets[index + 1] - mbegin - 1;
        int obegin = other.offsets[index];
        int olen = 0;
        olen = index == other.offsets.length - 1 ? other.path.length - obegin : other.offsets[index + 1] - obegin - 1;
        if (mlen != olen) {
            return false;
        }
        for (int n = 0; n < mlen; ++n) {
            if (this.path[mbegin + n] == other.path[obegin + n]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path relativize(Path other) {
        int i2;
        ZipPath o = this.checkPath(other);
        if (o.equals(this)) {
            return new ZipPath(this.getFileSystem(), new byte[0], true);
        }
        if (this.isAbsolute() != o.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        int mc = this.getNameCount();
        int oc = o.getNameCount();
        int n = Math.min(mc, oc);
        for (i2 = 0; i2 < n && this.equalsNameAt(o, i2); ++i2) {
        }
        int dotdots = mc - i2;
        int len = dotdots * 3 - 1;
        if (i2 < oc) {
            len += o.path.length - o.offsets[i2] + 1;
        }
        byte[] result = new byte[len];
        int pos = 0;
        while (dotdots > 0) {
            result[pos++] = 46;
            result[pos++] = 46;
            if (pos < len) {
                result[pos++] = 47;
            }
            --dotdots;
        }
        if (i2 < oc) {
            System.arraycopy(o.path, o.offsets[i2], result, pos, o.path.length - o.offsets[i2]);
        }
        return new ZipPath(this.getFileSystem(), result);
    }

    @Override
    public ZipFileSystem getFileSystem() {
        return this.zfs;
    }

    @Override
    public boolean isAbsolute() {
        return this.path.length > 0 && this.path[0] == 47;
    }

    @Override
    public ZipPath resolve(Path other) {
        ZipPath o = this.checkPath(other);
        if (o.isAbsolute()) {
            return o;
        }
        byte[] resolved = null;
        if (this.path[this.path.length - 1] == 47) {
            resolved = new byte[this.path.length + o.path.length];
            System.arraycopy(this.path, 0, resolved, 0, this.path.length);
            System.arraycopy(o.path, 0, resolved, this.path.length, o.path.length);
        } else {
            resolved = new byte[this.path.length + 1 + o.path.length];
            System.arraycopy(this.path, 0, resolved, 0, this.path.length);
            resolved[this.path.length] = 47;
            System.arraycopy(o.path, 0, resolved, this.path.length + 1, o.path.length);
        }
        return new ZipPath(this.zfs, resolved);
    }

    @Override
    public Path resolveSibling(Path other) {
        if (other == null) {
            throw new NullPointerException();
        }
        ZipPath parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    @Override
    public boolean startsWith(Path other) {
        ZipPath o = this.checkPath(other);
        if (o.isAbsolute() != this.isAbsolute() || o.path.length > this.path.length) {
            return false;
        }
        int olast = o.path.length;
        for (int i2 = 0; i2 < olast; ++i2) {
            if (o.path[i2] == this.path[i2]) continue;
            return false;
        }
        return o.path.length == this.path.length || o.path[--olast] == 47 || this.path[olast + 1] == 47;
    }

    @Override
    public boolean endsWith(Path other) {
        int last;
        ZipPath o = this.checkPath(other);
        int olast = o.path.length - 1;
        if (olast > 0 && o.path[olast] == 47) {
            --olast;
        }
        if ((last = this.path.length - 1) > 0 && this.path[last] == 47) {
            --last;
        }
        if (olast == -1) {
            return last == -1;
        }
        if (o.isAbsolute() && (!this.isAbsolute() || olast != last) || last < olast) {
            return false;
        }
        while (olast >= 0) {
            if (o.path[olast] != this.path[last]) {
                return false;
            }
            --olast;
            --last;
        }
        return o.path[olast + 1] == 47 || last == -1 || this.path[last] == 47;
    }

    @Override
    public ZipPath resolve(String other) {
        return this.resolve(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final Path resolveSibling(String other) {
        return this.resolveSibling(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final boolean startsWith(String other) {
        return this.startsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final boolean endsWith(String other) {
        return this.endsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public Path normalize() {
        byte[] resolved = this.getResolved();
        if (resolved == this.path) {
            return this;
        }
        return new ZipPath(this.zfs, resolved, true);
    }

    private ZipPath checkPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof ZipPath)) {
            throw new ProviderMismatchException();
        }
        return (ZipPath)path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets == null) {
            int count = 0;
            int index = 0;
            while (index < this.path.length) {
                byte c;
                if ((c = this.path[index++]) == 47) continue;
                ++count;
                while (index < this.path.length && this.path[index] != 47) {
                    ++index;
                }
            }
            int[] result = new int[count];
            count = 0;
            index = 0;
            while (index < this.path.length) {
                byte c = this.path[index];
                if (c == 47) {
                    ++index;
                    continue;
                }
                result[count++] = index++;
                while (index < this.path.length && this.path[index] != 47) {
                    ++index;
                }
            }
            ZipPath zipPath = this;
            synchronized (zipPath) {
                if (this.offsets == null) {
                    this.offsets = result;
                }
            }
        }
    }

    byte[] getResolvedPath() {
        byte[] r = this.resolved;
        if (r == null) {
            r = this.isAbsolute() ? this.getResolved() : this.toAbsolutePath().getResolvedPath();
            if (r[0] == 47) {
                r = Arrays.copyOfRange(r, 1, r.length);
            }
            this.resolved = r;
        }
        return this.resolved;
    }

    private byte[] normalize(byte[] path) {
        if (path.length == 0) {
            return path;
        }
        int prevC = 0;
        for (int i2 = 0; i2 < path.length; ++i2) {
            int c = path[i2];
            if (c == 92) {
                return this.normalize(path, i2);
            }
            if (c == 47 && prevC == 47) {
                return this.normalize(path, i2 - 1);
            }
            if (c == 0) {
                throw new InvalidPathException(this.zfs.getString(path), "Path: nul character not allowed");
            }
            prevC = c;
        }
        return path;
    }

    private byte[] normalize(byte[] path, int off) {
        int n;
        byte[] to = new byte[path.length];
        for (n = 0; n < off; ++n) {
            to[n] = path[n];
        }
        int m = n;
        int prevC = 0;
        while (n < path.length) {
            int c;
            if ((c = path[n++]) == 92) {
                c = 47;
            }
            if (c == 47 && prevC == 47) continue;
            if (c == 0) {
                throw new InvalidPathException(this.zfs.getString(path), "Path: nul character not allowed");
            }
            to[m++] = c;
            prevC = c;
        }
        if (m > 1 && to[m - 1] == 47) {
            --m;
        }
        return m == to.length ? to : Arrays.copyOf(to, m);
    }

    private byte[] getResolved() {
        if (this.path.length == 0) {
            return this.path;
        }
        for (int i2 = 0; i2 < this.path.length; ++i2) {
            byte c = this.path[i2];
            if (c != 46) continue;
            return this.resolve0();
        }
        return this.path;
    }

    private byte[] resolve0() {
        byte[] to = new byte[this.path.length];
        int nc = this.getNameCount();
        int[] lastM = new int[nc];
        int lastMOff = -1;
        int m = 0;
        for (int i2 = 0; i2 < nc; ++i2) {
            int len;
            int n = this.offsets[i2];
            int n2 = len = i2 == this.offsets.length - 1 ? this.path.length - n : this.offsets[i2 + 1] - n - 1;
            if (len == 1 && this.path[n] == 46) {
                if (m != 0 || this.path[0] != 47) continue;
                to[m++] = 47;
                continue;
            }
            if (len == 2 && this.path[n] == 46 && this.path[n + 1] == 46) {
                if (lastMOff >= 0) {
                    m = lastM[lastMOff--];
                    continue;
                }
                if (this.path[0] == 47) {
                    if (m != 0) continue;
                    to[m++] = 47;
                    continue;
                }
                if (m != 0 && to[m - 1] != 47) {
                    to[m++] = 47;
                }
                while (len-- > 0) {
                    to[m++] = this.path[n++];
                }
                continue;
            }
            if (m == 0 && this.path[0] == 47 || m != 0 && to[m - 1] != 47) {
                to[m++] = 47;
            }
            lastM[++lastMOff] = m;
            while (len-- > 0) {
                to[m++] = this.path[n++];
            }
        }
        if (m > 1 && to[m - 1] == 47) {
            --m;
        }
        return m == to.length ? to : Arrays.copyOf(to, m);
    }

    @Override
    public String toString() {
        return this.zfs.getString(this.path);
    }

    @Override
    public int hashCode() {
        int h = this.hashcode;
        if (h == 0) {
            this.hashcode = h = Arrays.hashCode(this.path);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof ZipPath && this.zfs == ((ZipPath)obj).zfs && this.compareTo((Path)obj) == 0;
    }

    @Override
    public int compareTo(Path other) {
        ZipPath o = this.checkPath(other);
        int len1 = this.path.length;
        int len2 = o.path.length;
        int n = Math.min(len1, len2);
        byte[] v1 = this.path;
        byte[] v2 = o.path;
        for (int k = 0; k < n; ++k) {
            int c1 = v1[k] & 0xFF;
            int c2 = v2[k] & 0xFF;
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        if (watcher == null || events == null || modifiers == null) {
            throw new NullPointerException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) {
        return this.register(watcher, events, new WatchEvent.Modifier[0]);
    }

    @Override
    public final File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ZipPath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.i < ZipPath.this.getNameCount()) {
                    ZipPath result = ZipPath.this.getName(this.i);
                    ++this.i;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new ReadOnlyFileSystemException();
            }
        };
    }

    void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        this.zfs.createDirectory(this.getResolvedPath(), attrs);
    }

    InputStream newInputStream(OpenOption ... options) throws IOException {
        if (options.length > 0) {
            for (OpenOption opt : options) {
                if (opt == StandardOpenOption.READ) continue;
                throw new UnsupportedOperationException("'" + opt + "' not allowed");
            }
        }
        return this.zfs.newInputStream(this.getResolvedPath());
    }

    DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new ZipDirectoryStream(this, filter);
    }

    void delete() throws IOException {
        this.zfs.deleteFile(this.getResolvedPath(), true);
    }

    void deleteIfExists() throws IOException {
        this.zfs.deleteFile(this.getResolvedPath(), false);
    }

    ZipFileAttributes getAttributes() throws IOException {
        ZipFileAttributes zfas = this.zfs.getFileAttributes(this.getResolvedPath());
        if (zfas == null) {
            throw new NoSuchFileException(this.toString());
        }
        return zfas;
    }

    void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        String type = null;
        String attr = null;
        int colonPos = attribute.indexOf(58);
        if (colonPos == -1) {
            type = "basic";
            attr = attribute;
        } else {
            type = attribute.substring(0, colonPos++);
            attr = attribute.substring(colonPos);
        }
        ZipFileAttributeView view2 = ZipFileAttributeView.get(this, type);
        if (view2 == null) {
            throw new UnsupportedOperationException("view <" + view2 + "> is not supported");
        }
        view2.setAttribute(attr, value);
    }

    void setTimes(FileTime mtime, FileTime atime, FileTime ctime) throws IOException {
        this.zfs.setTimes(this.getResolvedPath(), mtime, atime, ctime);
    }

    Map<String, Object> readAttributes(String attributes, LinkOption ... options) throws IOException {
        String view2 = null;
        String attrs = null;
        int colonPos = attributes.indexOf(58);
        if (colonPos == -1) {
            view2 = "basic";
            attrs = attributes;
        } else {
            view2 = attributes.substring(0, colonPos++);
            attrs = attributes.substring(colonPos);
        }
        ZipFileAttributeView zfv = ZipFileAttributeView.get(this, view2);
        if (zfv == null) {
            throw new UnsupportedOperationException("view not supported");
        }
        return zfv.readAttributes(attrs);
    }

    FileStore getFileStore() throws IOException {
        if (this.exists()) {
            return this.zfs.getFileStore(this);
        }
        throw new NoSuchFileException(this.zfs.getString(this.path));
    }

    boolean isSameFile(Path other) throws IOException {
        if (this.equals(other)) {
            return true;
        }
        if (other == null || this.getFileSystem() != other.getFileSystem()) {
            return false;
        }
        this.checkAccess(new AccessMode[0]);
        ((ZipPath)other).checkAccess(new AccessMode[0]);
        return Arrays.equals(this.getResolvedPath(), ((ZipPath)other).getResolvedPath());
    }

    SeekableByteChannel newByteChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.zfs.newByteChannel(this.getResolvedPath(), options, attrs);
    }

    FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.zfs.newFileChannel(this.getResolvedPath(), options, attrs);
    }

    void checkAccess(AccessMode ... modes) throws IOException {
        boolean w = false;
        boolean x = false;
        block5: for (AccessMode mode : modes) {
            switch (mode) {
                case READ: {
                    continue block5;
                }
                case WRITE: {
                    w = true;
                    continue block5;
                }
                case EXECUTE: {
                    x = true;
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        ZipFileAttributes attrs = this.zfs.getFileAttributes(this.getResolvedPath());
        if (attrs == null && (this.path.length != 1 || this.path[0] != 47)) {
            throw new NoSuchFileException(this.toString());
        }
        if (w && this.zfs.isReadOnly()) {
            throw new AccessDeniedException(this.toString());
        }
        if (x) {
            throw new AccessDeniedException(this.toString());
        }
    }

    boolean exists() {
        if (this.path.length == 1 && this.path[0] == 47) {
            return true;
        }
        try {
            return this.zfs.exists(this.getResolvedPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    OutputStream newOutputStream(OpenOption ... options) throws IOException {
        if (options.length == 0) {
            return this.zfs.newOutputStream(this.getResolvedPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        return this.zfs.newOutputStream(this.getResolvedPath(), options);
    }

    void move(ZipPath target, CopyOption ... options) throws IOException {
        if (Files.isSameFile(this.zfs.getZipFile(), target.zfs.getZipFile())) {
            this.zfs.copyFile(true, this.getResolvedPath(), target.getResolvedPath(), options);
        } else {
            this.copyToTarget(target, options);
            this.delete();
        }
    }

    void copy(ZipPath target, CopyOption ... options) throws IOException {
        if (Files.isSameFile(this.zfs.getZipFile(), target.zfs.getZipFile())) {
            this.zfs.copyFile(false, this.getResolvedPath(), target.getResolvedPath(), options);
        } else {
            this.copyToTarget(target, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToTarget(ZipPath target, CopyOption ... options) throws IOException {
        boolean exists;
        boolean replaceExisting = false;
        boolean copyAttrs = false;
        for (CopyOption opt : options) {
            if (opt == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
                continue;
            }
            if (opt != StandardCopyOption.COPY_ATTRIBUTES) continue;
            copyAttrs = true;
        }
        ZipFileAttributes zfas = this.getAttributes();
        if (replaceExisting) {
            try {
                target.deleteIfExists();
                exists = false;
            }
            catch (DirectoryNotEmptyException x) {
                exists = true;
            }
        } else {
            exists = target.exists();
        }
        if (exists) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (zfas.isDirectory()) {
            target.createDirectory(new FileAttribute[0]);
        } else {
            try (InputStream is = this.zfs.newInputStream(this.getResolvedPath());
                 OutputStream os = target.newOutputStream(new OpenOption[0]);){
                byte[] buf = new byte[8192];
                int n = 0;
                while ((n = is.read(buf)) != -1) {
                    os.write(buf, 0, n);
                }
            }
        }
        if (copyAttrs) {
            BasicFileAttributeView view2 = ZipFileAttributeView.get(target, BasicFileAttributeView.class);
            try {
                view2.setTimes(zfas.lastModifiedTime(), zfas.lastAccessTime(), zfas.creationTime());
            }
            catch (IOException x) {
                try {
                    target.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw x;
            }
        }
    }
}

