/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.JpaGridDataHookUp;
import com.intellij.database.datagrid.SqlDocumentDataHookUp;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.database.vfs.fragment.SqlTableDataFragmentFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDataHookUpManager {
    private final Project myProject;
    private final Map<VirtualFile, HookUpReference> myVirtualFileBasedHookUps;
    private final Set<HookUpReference> myHookUps;
    private final Object myLock;

    public GridDataHookUpManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/GridDataHookUpManager", "<init>"));
        }
        this.myProject = project;
        this.myVirtualFileBasedHookUps = ContainerUtil.newHashMap();
        this.myHookUps = ContainerUtil.newHashSet();
        this.myLock = new Object();
    }

    public static GridDataHookUpManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/GridDataHookUpManager", "getInstance"));
        }
        return (GridDataHookUpManager)ServiceManager.getService((Project)project, GridDataHookUpManager.class);
    }

    @NotNull
    public DatabaseTableGridDataHookUp getHookUp(@NotNull VirtualFile file, @NotNull Disposable parent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        DatabaseTableGridDataHookUp databaseTableGridDataHookUp = (DatabaseTableGridDataHookUp)this.getOrCreateHookUp(file, file1 -> {
            DbDataSource dataSource = (DbDataSource)ObjectUtils.assertNotNull((Object)DbImplUtil.findDataSource(this.myProject, file1));
            SimpleRequestBroker broker = SimpleRequestBroker.newInstance(this.myProject, file1.getName());
            DatabaseTableGridDataHookUp hookUp = new DatabaseTableGridDataHookUp(this.myProject, broker, (VirtualFile)file1);
            hookUp.setCurrentTx(DataRequest.getInitialTxMarker(DbImplUtil.getLocalDataSource((DatabaseSystem)dataSource).isAutoCommit()));
            JdbcEngine engine = new JdbcEngine(this.myProject, broker, (LocalDataSource)dataSource.getDelegate(), null);
            Disposer.register((Disposable)hookUp, (Disposable)engine);
            return hookUp;
        }, parent);
        if (databaseTableGridDataHookUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        return databaseTableGridDataHookUp;
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull CsvTableDataFragmentFile file, @NotNull Disposable parent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new CsvDocumentDataHookUp(this.myProject, file1.getFormat(), GridDataHookUpManager.getDocument(file1.getOriginalFile()), file1.getRange()), parent);
        if (csvDocumentDataHookUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public SqlDocumentDataHookUp getHookUp(@NotNull SqlTableDataFragmentFile file, @NotNull Disposable parent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        SqlDocumentDataHookUp sqlDocumentDataHookUp = (SqlDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new SqlDocumentDataHookUp(this.myProject, file1.getDialect(), GridDataHookUpManager.getDocument(file1.getOriginalFile()), file1.getRange()), parent);
        if (sqlDocumentDataHookUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        return sqlDocumentDataHookUp;
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull VirtualFile file, @NotNull CsvFormat format, @NotNull Disposable parent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/GridDataHookUpManager", "lambda$getHookUp$3"));
            }
            return new CsvDocumentDataHookUp(this.myProject, format, GridDataHookUpManager.getDocument(file1), null);
        }, parent);
        if (csvDocumentDataHookUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public SqlDocumentDataHookUp getHookUp(@NotNull VirtualFile file, @NotNull SqlLanguageDialect dialect, @NotNull Disposable parent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        SqlDocumentDataHookUp sqlDocumentDataHookUp = (SqlDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/datagrid/GridDataHookUpManager", "lambda$getHookUp$4"));
            }
            return new SqlDocumentDataHookUp(this.myProject, dialect, GridDataHookUpManager.getDocument(file1), null);
        }, parent);
        if (sqlDocumentDataHookUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager", "getHookUp"));
        }
        return sqlDocumentDataHookUp;
    }

    @NotNull
    public DatabaseGridDataHookUp createDatabaseHookUp(@NotNull DataBus.Consuming messageBus, @NotNull Disposable parent) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/datagrid/GridDataHookUpManager", "createDatabaseHookUp"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "createDatabaseHookUp"));
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = this.registerHookUp(new DatabaseGridDataHookUp(this.myProject, messageBus), parent);
        if (databaseGridDataHookUp == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager", "createDatabaseHookUp"));
        }
        return databaseGridDataHookUp;
    }

    public JpaGridDataHookUp createJpaHookUp(@NotNull DataBus.Consuming messageBus, @NotNull Disposable parent) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/datagrid/GridDataHookUpManager", "createJpaHookUp"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "createJpaHookUp"));
        }
        return this.registerHookUp(new JpaGridDataHookUp(this.myProject, messageBus), parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> acquire(@NotNull HookUpHandle handle, @NotNull Disposable parent) {
        if (handle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handle", "com/intellij/database/datagrid/GridDataHookUpManager", "acquire"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "acquire"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (handle.myRef == null || handle.myRef.myReferenceCount <= 0) {
                return null;
            }
            Disposer.register((Disposable)parent, (Disposable)this.createHookUpReferenceDisposable(handle.myRef));
            handle.myRef.myReferenceCount++;
            return handle.myRef.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public HookUpHandle getHandle(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (hookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookUp", "com/intellij/database/datagrid/GridDataHookUpManager", "getHandle"));
        }
        Object object = this.myLock;
        // MONITORENTER : object
        HookUpReference res = null;
        for (HookUpReference ref : this.myHookUps) {
            if (ref.myHookUp != hookUp) continue;
            res = ref;
            break;
        }
        HookUpHandle hookUpHandle = new HookUpHandle(res);
        // MONITOREXIT : object
        if (hookUpHandle != null) return hookUpHandle;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager", "getHandle"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends VirtualFile, H extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> H getOrCreateHookUp(final @NotNull F file, @NotNull Function<F, H> hookUpFactory, @NotNull Disposable parent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/datagrid/GridDataHookUpManager", "getOrCreateHookUp"));
        }
        if (hookUpFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookUpFactory", "com/intellij/database/datagrid/GridDataHookUpManager", "getOrCreateHookUp"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "getOrCreateHookUp"));
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = this.myVirtualFileBasedHookUps.get(file);
            if (ref == null || ref.myReferenceCount <= 0) {
                GridDataHookUp hookUp = (GridDataHookUp)hookUpFactory.fun(file);
                ref = new HookUpReference(hookUp){

                    @Override
                    public void dispose() {
                        super.dispose();
                        GridDataHookUpManager.this.myVirtualFileBasedHookUps.remove(file);
                    }
                };
                this.myVirtualFileBasedHookUps.put(file, ref);
                this.myHookUps.add(ref);
            }
            Disposer.register((Disposable)parent, (Disposable)this.createHookUpReferenceDisposable(ref));
            ref.myReferenceCount++;
            return (H)ref.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> T registerHookUp(T hookUp, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/datagrid/GridDataHookUpManager", "registerHookUp"));
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = new HookUpReference(hookUp);
            this.myHookUps.add(ref);
            Disposer.register((Disposable)parent, (Disposable)this.createHookUpReferenceDisposable(ref));
            ref.myReferenceCount++;
            return hookUp;
        }
    }

    private Disposable createHookUpReferenceDisposable(final @NotNull HookUpReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/datagrid/GridDataHookUpManager", "createHookUpReferenceDisposable"));
        }
        return new Disposable(){
            private AtomicBoolean myDisposed = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                if (!this.myDisposed.compareAndSet(false, true)) {
                    return;
                }
                Object object = GridDataHookUpManager.this.myLock;
                synchronized (object) {
                    if (--ref.myReferenceCount <= 0) {
                        Disposer.dispose((Disposable)ref);
                        GridDataHookUpManager.this.myHookUps.remove(ref);
                    }
                }
            }
        };
    }

    @NotNull
    private static Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/datagrid/GridDataHookUpManager", "getDocument"));
        }
        Document document = (Document)ObjectUtils.assertNotNull((Object)FileDocumentManager.getInstance().getDocument(file));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager", "getDocument"));
        }
        return document;
    }

    private static class HookUpReference
    implements Disposable {
        private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myHookUp;
        private int myReferenceCount = 0;

        private HookUpReference(GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
            this.myHookUp = hookUp;
            if (this.myHookUp instanceof Disposable) {
                Disposer.register((Disposable)this, (Disposable)((Disposable)this.myHookUp));
            }
        }

        public void dispose() {
        }
    }

    public static class HookUpHandle {
        private final HookUpReference myRef;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HookUpHandle handle = (HookUpHandle)o;
            return !(this.myRef != null ? !this.myRef.equals(handle.myRef) : handle.myRef != null);
        }

        public int hashCode() {
            return this.myRef != null ? this.myRef.hashCode() : 0;
        }

        private HookUpHandle(@Nullable HookUpReference ref) {
            this.myRef = ref;
        }
    }
}

