/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.mutating;

import com.intellij.database.datagrid.mutating.RowUpdateData;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UpdateData
implements Iterable<RowUpdateData> {
    private final List<RowUpdateData> myInfos;

    public UpdateData(@NotNull List<RowUpdateData> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/database/datagrid/mutating/UpdateData", "<init>"));
        }
        this.myInfos = infos;
    }

    @Override
    public Iterator<RowUpdateData> iterator() {
        return this.myInfos.iterator();
    }

    public int size() {
        return this.myInfos.size();
    }

    @NotNull
    public String getFullSql() {
        StringBuilder sb = new StringBuilder();
        this.myInfos.stream().map(RowUpdateData::getSql).distinct().forEach(str -> sb.append((String)str).append(";").append(System.lineSeparator()));
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/UpdateData", "getFullSql"));
        }
        return string;
    }
}

