/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.DeColumnWithState;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportDeTable
extends DeTable {
    public ImportDeTable(@NotNull String name, @Nullable DeObject parent, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/ImportDeTable", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ImportDeTable", "<init>"));
        }
        super(name, parent, model);
    }

    @Override
    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dbimport/ImportDeTable", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dbimport/ImportDeTable", "getDbChildren"));
        }
        JBIterable jBIterable = super.getDbChildren(clazz, kind).filter(ImportDeTable::filter);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDeTable", "getDbChildren"));
        }
        return jBIterable;
    }

    private static boolean filter(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dbimport/ImportDeTable", "filter"));
        }
        if (object instanceof DeForeignKey) {
            return ImportDeTable.filterForeignKey((DeForeignKey)object);
        }
        if (object instanceof DeIndex) {
            return ImportDeTable.filterIndex((DeIndex)object);
        }
        if (object instanceof DeTableKey) {
            return ImportDeTable.filterKey((DeTableKey)object);
        }
        return ImportDeTable.isEnabled(object);
    }

    private static boolean filterIndex(@NotNull DeIndex index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dbimport/ImportDeTable", "filterIndex"));
        }
        return ImportDeTable.filterColumns(index.getColumns());
    }

    private static boolean filterKey(@NotNull DeTableKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dbimport/ImportDeTable", "filterKey"));
        }
        return ImportDeTable.filterColumns(key.getColumns());
    }

    private static boolean filterForeignKey(@NotNull DeForeignKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dbimport/ImportDeTable", "filterForeignKey"));
        }
        return ImportDeTable.filterColumns(key.getColumns());
    }

    private static boolean filterColumns(@NotNull Iterable<DeColumn> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ImportDeTable", "filterColumns"));
        }
        for (DeColumn column : columns) {
            if (ImportDeTable.isEnabled(column)) continue;
            return false;
        }
        return true;
    }

    static boolean isEnabled(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dbimport/ImportDeTable", "isEnabled"));
        }
        return !(object instanceof DeColumnWithState) || ((DeColumnWithState)object).isEnabled();
    }
}

